/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.SystemObject;
import oracle.olap.app.cubeddl.AttributeMapKey;
import oracle.olap.app.cubeddl.AttributeProperties;
import oracle.olap.app.cubeddl.DescriptionProperties;
import oracle.olap.app.cubeddl.DimensionMapProperties;
import oracle.olap.app.cubeddl.HierarchyProperties;
import oracle.olap.app.cubeddl.LangDescProp;
import oracle.olap.app.cubeddl.LevelProperties;
import oracle.olap.app.cubeddl.model.DimElement;
import oracle.olap.app.cubeddl.wrapper.AbstractClassificationSetter;
import oracle.olap.app.cubeddl.wrapper.BaseWrapper;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionAttributeMap;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.cubedimension.model.CubeDimensionSpreadedAttribute;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.LanguageDBSettings;
import oracle.olap.xmlbind.AWPrimaryDimensionOrganization;
import oracle.olap.xmlbind.Attribute;
import oracle.olap.xmlbind.AttributeMap;
import oracle.olap.xmlbind.AttributeOrganization;
import oracle.olap.xmlbind.BaseAttribute;
import oracle.olap.xmlbind.Classification;
import oracle.olap.xmlbind.Description;
import oracle.olap.xmlbind.DimensionLevel;
import oracle.olap.xmlbind.Hierarchy;
import oracle.olap.xmlbind.HierarchyLevel;
import oracle.olap.xmlbind.HierarchyLevelMap;
import oracle.olap.xmlbind.LevelHierarchy;
import oracle.olap.xmlbind.MemberListMap;
import oracle.olap.xmlbind.Organization;
import oracle.olap.xmlbind.SolvedValueHierarchyMap;
import oracle.olap.xmlbind.StandardDimension;
import oracle.olap.xmlbind.TimeDimension;
import oracle.olap.xmlbind.ValueHierarchy;
import oracle.olap.xmlbind.VisibleAttribute;

public class CubeDimensionWrapper
extends BaseWrapper {
    public static final String STAR_CONSISTENT = "STAR_CONSISTENT";
    public static final String CONSISTENT = "CONSISTENT";
    public static final String SOLVE_CONSISTENT = "SOLVE_CONSISTENT";
    private static final String STAR = "STAR";
    private static final String ORDER_BY = "ORDER BY %s %s NULLS %s";
    private static final String EMPTY_STRING = "";
    private static final int NOT_FOUND_INDICATOR = -1;
    private static final int LEVEL_HIERARCHY_TYPE = 0;
    private static final int VALUE_HIERARCHY_TYPE = 1;
    private static final String MULTI_LANGUAGE_ATTRIBUTE_NAME_FORMAT = "%s_%s";
    private boolean setDefaultHierarchyOn = false;
    private StandardDimension xmldim;

    public CubeDimensionWrapper(MetadataContext metadataContext) {
        super(metadataContext);
        this.xmldim = new StandardDimension();
    }

    public CubeDimensionWrapper() {
        this.xmldim = new StandardDimension();
    }

    public CubeDimensionWrapper(StandardDimension standardDimension) {
        this.xmldim = standardDimension;
    }

    public StandardDimension getDimension() {
        return this.xmldim;
    }

    @Override
    public String getName() {
        return this.xmldim.getName();
    }

    private boolean isEditing() {
        boolean bl = false;
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject != null) {
            bl = true;
        }
        return bl;
    }

    public void setTypeTime(boolean bl) {
        if (bl) {
            this.xmldim = new TimeDimension();
        }
    }

    public void setMeasureDimensionClassification(Map<String, String> map, boolean bl) {
        if (bl) {
            map = new HashMap<String, String>();
        }
        CubeDimensionClassificationSetter cubeDimensionClassificationSetter = new CubeDimensionClassificationSetter();
        cubeDimensionClassificationSetter.setClassifications(this.xmldim, map);
    }

    @Override
    public void setName(String string) {
        this.xmldim.setName(this.getName(string));
        String string2 = this.getOwner(string);
        if (string2 != null) {
            this.xmldim.setOwner(string2);
        }
    }

    public void setProperties(String string, boolean bl, String string2, String string3, String string4, boolean bl2, boolean bl3, Map<String, String> map) {
        Object object;
        CubeDimension cubeDimension = (CubeDimension)this.getUpdatedSystemObject();
        if (this.getOriginalSystemObject() != null) {
            cubeDimension = (CubeDimension)this.getOriginalSystemObject();
        }
        if (string3 != null) {
            this.xmldim.setDefaultHierarchy(this.processName(string3));
        }
        if (string4 != null) {
            String string5;
            String string6;
            object = null;
            IdentifierElement identifierElement = new IdentifierElement(string4);
            if (identifierElement.getCount() == 2) {
                string6 = ReservedWordsSyntaxHandler.QuoteIfReserved(identifierElement.getFirst());
                string5 = identifierElement.getSecond();
                object = string6 + "." + string5;
            } else {
                string6 = ReservedWordsSyntaxHandler.QuoteIfReserved(cubeDimension.getName());
                object = string6 + "." + string4;
            }
            string6 = bl2 ? "ASC" : "DESC";
            string5 = bl3 ? "FIRST" : "LAST";
            String string7 = String.format(ORDER_BY, object, string6, string5);
            this.xmldim.setCustomOrder(string7);
        }
        if (string != null) {
            object = this.getAWOrganization();
            ((AWPrimaryDimensionOrganization)object).setAW(this.processName(string));
            if (!bl) {
                ((AWPrimaryDimensionOrganization)object).setAddUniqueKeyPrefix("True");
            } else {
                ((AWPrimaryDimensionOrganization)object).setAddUniqueKeyPrefix("False");
            }
            ((AWPrimaryDimensionOrganization)object).setHierarchyConsistencyRule(string2);
        }
        if (map != null) {
            object = new CubeDimensionClassificationSetter();
            ((AbstractClassificationSetter)object).setClassifications(this.xmldim, map);
        }
    }

    public void setHierarchyDataConsistency(String string) {
        if (string != null) {
            AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = this.getAWOrganization();
            aWPrimaryDimensionOrganization.setHierarchyConsistencyRule(string);
        }
    }

    public void setDefaultOrderByAttribute(String string, boolean bl, boolean bl2) {
        String string2 = null;
        CubeDimension cubeDimension = (CubeDimension)this.getUpdatedSystemObject();
        if (this.getOriginalSystemObject() != null) {
            cubeDimension = (CubeDimension)this.getOriginalSystemObject();
        }
        if (string != null && !string.equalsIgnoreCase("null")) {
            String string3 = ReservedWordsSyntaxHandler.QuoteIfReserved(cubeDimension.getName());
            string2 = string3 + "." + string;
            String string4 = bl ? "ASC" : "DESC";
            String string5 = bl2 ? "FIRST" : "LAST";
            String string6 = String.format(ORDER_BY, string2, string4, string5);
            this.xmldim.setCustomOrder(string6);
        } else {
            this.xmldim.setCustomOrder(EMPTY_STRING);
        }
    }

    public void setDefaultHierarchy(String string) {
        if (string != null) {
            this.xmldim.setDefaultHierarchy(this.processName(string));
            this.setDefaultHierarchyOn = true;
        } else if (!this.setDefaultHierarchyOn) {
            this.xmldim.setDefaultHierarchy(null);
        }
    }

    public void setSourceKeysAreUnique(boolean bl) {
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = this.getAWOrganization();
        if (!bl) {
            aWPrimaryDimensionOrganization.setAddUniqueKeyPrefix("True");
        } else {
            aWPrimaryDimensionOrganization.setAddUniqueKeyPrefix("False");
        }
    }

    public void setAW(String string) {
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = this.getAWOrganization();
        new AWPrimaryDimensionOrganization();
        aWPrimaryDimensionOrganization.setAW(this.processName(string));
    }

    private AWPrimaryDimensionOrganization getAWOrganization() {
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = null;
        Organization organization = this.xmldim.getOrganization();
        if (organization == null) {
            organization = new Organization();
            aWPrimaryDimensionOrganization = new AWPrimaryDimensionOrganization();
            organization.setAWPrimaryDimensionOrganization(aWPrimaryDimensionOrganization);
            this.xmldim.setOrganization(organization);
        } else {
            aWPrimaryDimensionOrganization = organization.getAWPrimaryDimensionOrganization();
        }
        return aWPrimaryDimensionOrganization;
    }

    public void addSubDimension(String string, boolean bl, AttributeProperties attributeProperties, DimensionMapProperties dimensionMapProperties, List<DescriptionProperties> list, List<String> list2, List<LangDescProp> list3) {
        if (bl) {
            DimensionLevel dimensionLevel = new DimensionLevel();
            dimensionLevel.setName(this.processName(string));
            this.xmldim.getDimensionLevel().add(dimensionLevel);
            if (dimensionMapProperties != null) {
                Iterator<Object> iterator = new MemberListMap();
                if (dimensionMapProperties.query != null) {
                    ((MemberListMap)((Object)iterator)).setQuery(this.getProcessedSource(dimensionMapProperties.query));
                }
                if (dimensionMapProperties.keyExpr != null) {
                    ((MemberListMap)((Object)iterator)).setKeyExpression(this.processExpression(dimensionMapProperties.keyExpr));
                }
                if (dimensionMapProperties.whereClause != null) {
                    String list4 = CubeDimensionWrapper.stripQuotes(dimensionMapProperties.whereClause);
                    ((MemberListMap)((Object)iterator)).setWhereClause(list4);
                }
                List<AttributeMap> object3 = this.getAttributeMaps(((MemberListMap)((Object)iterator)).getContent(), dimensionMapProperties);
                ((MemberListMap)((Object)iterator)).getContent().addAll(object3);
                dimensionLevel.getContent().add(iterator);
            }
            if (list != null) {
                for (DescriptionProperties descriptionProperties : list) {
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    dimensionLevel.getContent().add(description);
                }
            }
            if (list3 != null && !list3.isEmpty()) {
                for (LangDescProp langDescProp : list3) {
                    List<DescriptionProperties> list4 = langDescProp.descs;
                    for (DescriptionProperties descriptionProperties : list4) {
                        Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                        description.setLanguage(CubeDimensionWrapper.stripQuotes(langDescProp.language));
                        dimensionLevel.getContent().add(description);
                    }
                }
            }
            if (list2 != null) {
                for (String string2 : list2) {
                    VisibleAttribute visibleAttribute = new VisibleAttribute();
                    visibleAttribute.setName(string2);
                    visibleAttribute.setAction("ADD");
                    dimensionLevel.getContent().add(visibleAttribute);
                }
            }
            this.generateSpreadedAttributesForNewLevel(dimensionLevel);
        } else {
            Object object;
            BaseAttribute baseAttribute = new BaseAttribute();
            baseAttribute.setName(this.processName(string));
            if (attributeProperties.autoDetectDataType) {
                baseAttribute.setAllowAutoDataTypeChange("True");
            } else {
                baseAttribute.setAllowAutoDataTypeChange("False");
            }
            if (attributeProperties.dataType != null) {
                baseAttribute.setSQLDataType(attributeProperties.dataType);
            }
            if (attributeProperties.visibleForAll) {
                baseAttribute.setIsVisibleForAll("True");
            }
            Attribute attribute = new Attribute();
            attribute.getContent().add(baseAttribute);
            this.xmldim.getAttribute().add(attribute);
            if (list != null) {
                for (DescriptionProperties descriptionProperties : list) {
                    object = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    baseAttribute.getContent().add(object);
                }
            }
            if (attributeProperties != null) {
                if (attributeProperties.languageDescriptions != null && !attributeProperties.languageDescriptions.isEmpty()) {
                    for (LangDescProp langDescProp : attributeProperties.languageDescriptions) {
                        object = langDescProp.descs;
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            DescriptionProperties descriptionProperties = (DescriptionProperties)iterator.next();
                            Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                            description.setLanguage(CubeDimensionWrapper.stripQuotes(langDescProp.language));
                            baseAttribute.getContent().add(description);
                        }
                    }
                }
                if (attributeProperties.nls) {
                    baseAttribute.setIsMultiLingual("True");
                }
                if (attributeProperties.indexed) {
                    AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = this.getAWOrganization();
                    AttributeOrganization attributeOrganization = new AttributeOrganization();
                    attributeOrganization.setAttribute(baseAttribute.getName());
                    attributeOrganization.setCreateIndex("True");
                    aWPrimaryDimensionOrganization.getContent().add(attributeOrganization);
                }
                if (attributeProperties.endDate && this.xmldim instanceof TimeDimension) {
                    TimeDimension timeDimension = (TimeDimension)this.xmldim;
                    timeDimension.setEndDateAttribute(baseAttribute.getName());
                }
                if (attributeProperties.timeSpan && this.xmldim instanceof TimeDimension) {
                    TimeDimension timeDimension = (TimeDimension)this.xmldim;
                    timeDimension.setTimeSpanAttribute(baseAttribute.getName());
                }
                if (attributeProperties.long_description) {
                    this.xmldim.setValueDescriptionAttribute(baseAttribute.getName());
                }
                if (attributeProperties.short_description) {
                    this.xmldim.setShortValueDescriptionAttribute(baseAttribute.getName());
                }
                if (attributeProperties.star) {
                    Classification classification = new Classification();
                    classification.setAction("ADD");
                    classification.setValueToFixError2(STAR);
                    baseAttribute.getContent().add(classification);
                    if (this.isEditing()) {
                        this.generateSpreadedAttributesForNewAttribute(this.processName(string), attributeProperties.dataType);
                    }
                }
            }
        }
    }

    public void addLevelHierarchy(LevelHierarchy levelHierarchy) {
        List<Hierarchy> list = this.xmldim.getHierarchy();
        Hierarchy hierarchy = new Hierarchy();
        list.add(hierarchy);
        hierarchy.setLevelHierarchy(levelHierarchy);
    }

    public void removeDimElement(DimElement dimElement) {
        if (dimElement.isLevel()) {
            List<DimensionLevel> list = this.xmldim.getDimensionLevel();
            DimensionLevel dimensionLevel = new DimensionLevel();
            dimensionLevel.setName(this.processName(dimElement.getName()));
            List<Attribute> list2 = this.xmldim.getAttribute();
            this.removeSpreadedAttributesAtLevel(list2, dimElement.getName());
            dimensionLevel.setAction("REMOVE");
            list.add(dimensionLevel);
        } else if (dimElement.isHierarchy()) {
            List<Hierarchy> list = this.xmldim.getHierarchy();
            Hierarchy hierarchy = new Hierarchy();
            list.add(hierarchy);
            hierarchy.setAction("REMOVE");
            LevelHierarchy levelHierarchy = new LevelHierarchy();
            levelHierarchy.setName(this.processName(dimElement.getName()));
            hierarchy.setLevelHierarchy(levelHierarchy);
        } else if (dimElement.isLanguageDescription()) {
            String string = CubeDimensionWrapper.stripQuotes(dimElement.getName());
            Description description = new Description();
            description.setAction("REMOVE");
            description.setLanguage(string);
            description.setType("ShortDescription");
            this.xmldim.getDescription().add(description);
            description = new Description();
            description.setAction("REMOVE");
            description.setLanguage(string);
            description.setType("LongDescription");
            this.xmldim.getDescription().add(description);
            description = new Description();
            description.setAction("REMOVE");
            description.setLanguage(string);
            description.setType("Description");
            this.xmldim.getDescription().add(description);
        } else {
            List<Attribute> list = this.xmldim.getAttribute();
            Attribute attribute = new Attribute();
            attribute.setAction("REMOVE");
            list.add(attribute);
            BaseAttribute baseAttribute = new BaseAttribute();
            attribute.getContent().add(baseAttribute);
            baseAttribute.setName(this.processName(dimElement.getName()));
            this.removeSpreadedAttributes(list, baseAttribute.getName());
        }
    }

    public void removeHierarchyLevels(String string, List<String> list) {
        List<Hierarchy> list2 = this.xmldim.getHierarchy();
        Hierarchy hierarchy = new Hierarchy();
        list2.add(hierarchy);
        LevelHierarchy levelHierarchy = new LevelHierarchy();
        levelHierarchy.setName(this.processName(string));
        hierarchy.setLevelHierarchy(levelHierarchy);
        for (String string2 : list) {
            HierarchyLevel hierarchyLevel = new HierarchyLevel();
            levelHierarchy.getHierarchyLevel().add(hierarchyLevel);
            hierarchyLevel.setAction("REMOVE");
            hierarchyLevel.setDimensionLevel(this.processName(string2));
        }
    }

    public LevelHierarchy addLevelHierarchy(String string, List<LevelProperties> list, List<DescriptionProperties> list2, boolean bl, List<LangDescProp> list3) {
        List<DescriptionProperties> list4;
        LevelHierarchy levelHierarchy = new LevelHierarchy();
        levelHierarchy.setName(this.processName(string));
        Collections.reverse(list);
        String string2 = null;
        for (LevelProperties object2 : list) {
            Iterator<DescriptionProperties> iterator;
            Iterator<LangDescProp> iterator2 = new HierarchyLevel();
            String string3 = object2.name;
            ((HierarchyLevel)((Object)iterator2)).setDimensionLevel(string3.toUpperCase());
            if (object2.visibleAttributes != null && object2.visibleAttributes.size() > 0) {
                list4 = object2.visibleAttributes.iterator();
                while (list4.hasNext()) {
                    iterator = (String)list4.next();
                    VisibleAttribute visibleAttribute = new VisibleAttribute();
                    visibleAttribute.setName((String)((Object)iterator));
                    visibleAttribute.setAction("ADD");
                    ((HierarchyLevel)((Object)iterator2)).getContent().add(visibleAttribute);
                }
            }
            if ((list4 = object2.dimMapProps) != null) {
                iterator = this.setHierarchyLevelMapProps((DimensionMapProperties)((Object)list4), string2);
                ((HierarchyLevel)((Object)iterator2)).getContent().add(iterator);
                string2 = ((DimensionMapProperties)((Object)list4)).keyExpr;
            } else {
                string2 = null;
            }
            levelHierarchy.getHierarchyLevel().add((HierarchyLevel)((Object)iterator2));
        }
        List<Hierarchy> list5 = this.xmldim.getHierarchy();
        Hierarchy hierarchy = new Hierarchy();
        list5.add(hierarchy);
        hierarchy.setLevelHierarchy(levelHierarchy);
        if (bl) {
            this.xmldim.setDefaultHierarchy(this.processName(string));
        }
        if (list2 != null) {
            for (DescriptionProperties descriptionProperties : list2) {
                list4 = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                levelHierarchy.getDescription().add((Description)((Object)list4));
            }
        }
        if (list3 != null && !list3.isEmpty()) {
            for (LangDescProp langDescProp : list3) {
                list4 = langDescProp.descs;
                for (DescriptionProperties descriptionProperties : list4) {
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    description.setLanguage(CubeDimensionWrapper.stripQuotes(langDescProp.language));
                    levelHierarchy.getDescription().add(description);
                }
            }
        }
        return levelHierarchy;
    }

    private HierarchyLevelMap setHierarchyLevelMapProps(DimensionMapProperties dimensionMapProperties, String string) {
        Object object;
        HierarchyLevelMap hierarchyLevelMap = new HierarchyLevelMap();
        if (dimensionMapProperties.query != null) {
            hierarchyLevelMap.setQuery(this.getProcessedSource(dimensionMapProperties.query));
        }
        if (dimensionMapProperties.keyExpr != null) {
            hierarchyLevelMap.setKeyExpression(this.processExpression(dimensionMapProperties.keyExpr));
        }
        if (dimensionMapProperties.parentKeyExpr != null && string != null && !((String)(object = CubeDimensionWrapper.stripQuotes(String.format("%s=%s", this.processExpression(dimensionMapProperties.parentKeyExpr), this.processExpression(string))))).startsWith("=")) {
            hierarchyLevelMap.setJoinCondition((String)object);
        }
        if (dimensionMapProperties.whereClause != null) {
            object = CubeDimensionWrapper.stripQuotes(dimensionMapProperties.whereClause);
            hierarchyLevelMap.setWhereClause((String)object);
        }
        object = this.getAttributeMaps(hierarchyLevelMap.getContent(), dimensionMapProperties);
        boolean bl = true;
        String string2 = hierarchyLevelMap.getKeyExpression();
        if (string2.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AttributeMap attributeMap = (AttributeMap)iterator.next();
                if (attributeMap.getAction() != null && attributeMap.getAction().equals("REMOVE")) continue;
                bl = false;
                break;
            }
            if (bl) {
                hierarchyLevelMap.setAction("REMOVE");
            }
        } else {
            bl = false;
        }
        if (!bl) {
            hierarchyLevelMap.getContent().addAll((Collection<Object>)object);
        }
        return hierarchyLevelMap;
    }

    private String getProcessedSource(String string) {
        String string2 = EMPTY_STRING;
        IdentifierElement identifierElement = new IdentifierElement(string);
        if (identifierElement.getCount() == 2) {
            string2 = identifierElement.getFirst();
            string = identifierElement.getSecond();
        }
        string = this.processSource(string);
        if (!string2.isEmpty()) {
            string = String.format("%s.%s", string2, string);
        }
        return string;
    }

    public ValueHierarchy addValueHierarchy(String string, DimensionMapProperties dimensionMapProperties, List<DescriptionProperties> list, List<String> list2, boolean bl, List<LangDescProp> list3) {
        Object object;
        ValueHierarchy valueHierarchy = new ValueHierarchy();
        valueHierarchy.setName(this.processName(string));
        List<Hierarchy> list4 = this.xmldim.getHierarchy();
        Hierarchy hierarchy = new Hierarchy();
        list4.add(hierarchy);
        hierarchy.setValueHierarchy(valueHierarchy);
        if (list != null) {
            for (DescriptionProperties object2 : list) {
                object = this.createDescriptionObject(object2.type, object2.value);
                valueHierarchy.getDescription().add((Description)object);
            }
        }
        if (list3 != null && !list3.isEmpty()) {
            for (LangDescProp langDescProp : list3) {
                object = langDescProp.descs;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    DescriptionProperties descriptionProperties = (DescriptionProperties)iterator.next();
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    description.setLanguage(CubeDimensionWrapper.stripQuotes(langDescProp.language));
                    valueHierarchy.getDescription().add(description);
                }
            }
        }
        if (list2 != null && list2.size() > 0) {
            for (String string2 : list2) {
                object = new VisibleAttribute();
                ((VisibleAttribute)object).setName(string2);
                valueHierarchy.getVisibleAttribute().add((VisibleAttribute)object);
            }
        }
        if (bl) {
            this.xmldim.setDefaultHierarchy(this.processName(string));
        }
        if (dimensionMapProperties != null) {
            SolvedValueHierarchyMap solvedValueHierarchyMap = this.createSolveValueHierarchyMap(dimensionMapProperties);
            valueHierarchy.setSolvedValueHierarchyMap(solvedValueHierarchyMap);
        }
        return valueHierarchy;
    }

    private SolvedValueHierarchyMap createSolveValueHierarchyMap(DimensionMapProperties dimensionMapProperties) {
        boolean bl;
        Object object;
        SolvedValueHierarchyMap solvedValueHierarchyMap = new SolvedValueHierarchyMap();
        if (dimensionMapProperties.query != null) {
            solvedValueHierarchyMap.setQuery(this.getProcessedSource(dimensionMapProperties.query));
        }
        if (dimensionMapProperties.keyExpr != null) {
            solvedValueHierarchyMap.setKeyExpression(this.processExpression(dimensionMapProperties.keyExpr));
        }
        if (dimensionMapProperties.parentKeyExpr != null) {
            solvedValueHierarchyMap.setParentKeyExpression(this.processExpression(dimensionMapProperties.parentKeyExpr));
        }
        if (dimensionMapProperties.whereClause != null) {
            object = CubeDimensionWrapper.stripQuotes(dimensionMapProperties.whereClause);
            solvedValueHierarchyMap.setWhereClause((String)object);
        }
        if (!(bl = this.isAttributeMapRemoveAll((List<AttributeMap>)(object = this.getAttributeMaps(solvedValueHierarchyMap.getAttributeMap(), dimensionMapProperties))))) {
            solvedValueHierarchyMap.getAttributeMap().addAll((Collection<AttributeMap>)object);
        }
        if (bl && CubeDimensionWrapper.stripQuotes(dimensionMapProperties.keyExpr).isEmpty()) {
            solvedValueHierarchyMap.setAction("REMOVE");
        }
        return solvedValueHierarchyMap;
    }

    public void setHierarchyConstraints(LevelHierarchy levelHierarchy, HierarchyProperties hierarchyProperties) {
        if (hierarchyProperties != null) {
            this.setHierarchyConstraints(levelHierarchy, hierarchyProperties.isSkipLevel, hierarchyProperties.isRagged);
        }
    }

    public void setHierarchyConstraints(LevelHierarchy levelHierarchy, boolean bl, boolean bl2) {
        if (levelHierarchy != null) {
            if (bl2) {
                levelHierarchy.setIsRagged("True");
            } else {
                levelHierarchy.setIsRagged("False");
            }
            if (bl) {
                levelHierarchy.setIsSkipLevel("True");
            } else {
                levelHierarchy.setIsSkipLevel("False");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHierarchyList(String string, List<LevelProperties> list, List<LevelProperties> list2) {
        Object object;
        Object object4;
        List<Hierarchy> list3 = this.xmldim.getHierarchy();
        Collections.reverse(list);
        Collections.reverse(list2);
        boolean bl = false;
        if (list.size() != list2.size()) {
            bl = true;
        }
        if (!bl) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                object4 = list.get(i);
                LevelProperties object32 = list2.get(i);
                object = ((LevelProperties)object4).name;
                String string2 = object32.name;
                if (((String)object).equalsIgnoreCase(string2)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            LevelHierarchy levelHierarchy = new LevelHierarchy();
            Hierarchy hierarchy = new Hierarchy();
            list3.add(hierarchy);
            levelHierarchy.setName(this.processName(string));
            hierarchy.setLevelHierarchy(levelHierarchy);
            for (LevelProperties levelProperties : list) {
                object = new HierarchyLevel();
                ((HierarchyLevel)object).setAction("REMOVE");
                String string3 = levelProperties.name;
                ((HierarchyLevel)object).setDimensionLevel(this.processName(string3));
                levelHierarchy.getHierarchyLevel().add((HierarchyLevel)object);
            }
            object4 = new LevelHierarchy();
            ((LevelHierarchy)object4).setName(this.processName(string));
            Object var9_14 = null;
            for (LevelProperties levelProperties : list2) {
                HierarchyLevel hierarchyLevel = new HierarchyLevel();
                hierarchyLevel.setAction("ADD");
                String string4 = levelProperties.name;
                hierarchyLevel.setDimensionLevel(this.processName(string4));
                ((LevelHierarchy)object4).getHierarchyLevel().add(hierarchyLevel);
                DimensionMapProperties dimensionMapProperties = levelProperties.dimMapProps;
                if (dimensionMapProperties != null) {
                    void var9_15;
                    HierarchyLevelMap hierarchyLevelMap = this.setHierarchyLevelMapProps(dimensionMapProperties, (String)var9_15);
                    hierarchyLevel.getContent().add(hierarchyLevelMap);
                    String string5 = dimensionMapProperties.keyExpr;
                    continue;
                }
                Object var9_17 = null;
            }
            object = new Hierarchy();
            list3.add((Hierarchy)object);
            ((Hierarchy)object).setLevelHierarchy((LevelHierarchy)object4);
        }
    }

    public void setHierarchyProperties(String string, HierarchyProperties hierarchyProperties, List<LevelProperties> list, DimensionMapProperties dimensionMapProperties, List<DescriptionProperties> list2, List<LangDescProp> list3, List<String> list4) {
        Object object;
        Object object5;
        Object object6;
        CubeDimension cubeDimension = (CubeDimension)this.getUpdatedSystemObject();
        List<Hierarchy> list5 = this.xmldim.getHierarchy();
        if (hierarchyProperties == null && list == null && dimensionMapProperties == null && list2 == null && list3 == null && list4 == null) {
            return;
        }
        if (list != null) {
            Collections.reverse(list);
        }
        int n = 0;
        n = cubeDimension.getHierarchyTypeStatus(string);
        if (n == -1 && (n = ((CubeDimension)(object6 = (CubeDimension)this.getOriginalSystemObject())).getHierarchyTypeStatus(string)) == -1) {
            n = 0;
        }
        object6 = new ValueHierarchy();
        ((ValueHierarchy)object6).setName(this.processName(string));
        LevelHierarchy levelHierarchy = new LevelHierarchy();
        levelHierarchy.setName(this.processName(string));
        if (n == 0) {
            this.setHierarchyConstraints(levelHierarchy, hierarchyProperties);
        }
        if (list != null) {
            object5 = null;
            for (LevelProperties levelProperties : list) {
                HierarchyLevel hierarchyLevel = new HierarchyLevel();
                Object object2 = levelProperties.name;
                hierarchyLevel.setDimensionLevel(this.processName((String)object2));
                levelHierarchy.getHierarchyLevel().add(hierarchyLevel);
                object = levelProperties.dimMapProps;
                if (object != null) {
                    CubeDimensionHierarchy cubeDimensionHierarchy = cubeDimension.findHierarchy(string);
                    boolean bl = true;
                    for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevelsReverse()) {
                        String string2 = cubeDimensionHierarchyLevel.getLevelName();
                        if (string2.equals(object2)) {
                            bl = true;
                            break;
                        }
                        object5 = null;
                        CubeDimensionMap cubeDimensionMap = cubeDimensionHierarchyLevel.getMap();
                        if (cubeDimensionMap == null) continue;
                        object5 = cubeDimensionMap.getKeyExpression();
                    }
                    HierarchyLevelMap hierarchyLevelMap = this.setHierarchyLevelMapProps((DimensionMapProperties)object, (String)object5);
                    hierarchyLevel.getContent().add(hierarchyLevelMap);
                    object5 = ((DimensionMapProperties)object).keyExpr;
                    continue;
                }
                object5 = null;
            }
        }
        if (dimensionMapProperties != null && n == 1) {
            object5 = this.createSolveValueHierarchyMap(dimensionMapProperties);
            ((ValueHierarchy)object6).setSolvedValueHierarchyMap((SolvedValueHierarchyMap)object5);
        }
        if (list2 != null) {
            for (DescriptionProperties descriptionProperties : list2) {
                Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                if (n == 1) {
                    ((ValueHierarchy)object6).getDescription().add(description);
                    continue;
                }
                levelHierarchy.getDescription().add(description);
            }
        }
        if (list3 != null) {
            for (LangDescProp langDescProp : list3) {
                List<DescriptionProperties> list6 = langDescProp.descs;
                for (Object object2 : list6) {
                    object = this.createDescriptionObject(((DescriptionProperties)object2).type, ((DescriptionProperties)object2).value);
                    ((Description)object).setLanguage(CubeDimensionWrapper.stripQuotes(langDescProp.language));
                    if (n == 1) {
                        ((ValueHierarchy)object6).getDescription().add((Description)object);
                        continue;
                    }
                    levelHierarchy.getDescription().add((Description)object);
                }
            }
        }
        if (list4 != null) {
            for (String string3 : list4) {
                String string4 = CubeDimensionWrapper.stripQuotes(string3);
                Description description = new Description();
                description.setAction("REMOVE");
                description.setLanguage(string4);
                description.setType("ShortDescription");
                if (n == 1) {
                    ((ValueHierarchy)object6).getDescription().add(description);
                } else {
                    levelHierarchy.getDescription().add(description);
                }
                Description description2 = new Description();
                description2.setAction("REMOVE");
                description2.setLanguage(string4);
                description2.setType("LongDescription");
                if (n == 1) {
                    ((ValueHierarchy)object6).getDescription().add(description2);
                } else {
                    levelHierarchy.getDescription().add(description2);
                }
                Description description3 = new Description();
                description3.setAction("REMOVE");
                description3.setLanguage(string4);
                description3.setType("Description");
                if (n == 1) {
                    ((ValueHierarchy)object6).getDescription().add(description3);
                    continue;
                }
                levelHierarchy.getDescription().add(description3);
            }
        }
        object5 = new Hierarchy();
        list5.add((Hierarchy)object5);
        if (n == 1) {
            ((Hierarchy)object5).setValueHierarchy((ValueHierarchy)object6);
        } else {
            ((Hierarchy)object5).setLevelHierarchy(levelHierarchy);
        }
    }

    private boolean isAttributeMapRemoveAll(List<AttributeMap> list) {
        boolean bl = true;
        for (AttributeMap attributeMap : list) {
            if (attributeMap.getAction() != null && attributeMap.getAction().equals("REMOVE")) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setMap(DimensionMapProperties dimensionMapProperties) {
        List<AttributeMap> list;
        boolean bl;
        MemberListMap memberListMap = new MemberListMap();
        this.xmldim.setMemberListMap(memberListMap);
        dimensionMapProperties.query = CubeDimensionWrapper.stripQuotes(dimensionMapProperties.query);
        memberListMap.setQuery(this.getProcessedSource(dimensionMapProperties.query));
        if (dimensionMapProperties.keyExpr != null) {
            dimensionMapProperties.keyExpr = this.processSource(dimensionMapProperties.keyExpr);
            memberListMap.setKeyExpression(this.processExpression(dimensionMapProperties.keyExpr));
        }
        if (!(bl = this.isAttributeMapRemoveAll(list = this.getAttributeMaps(memberListMap.getContent(), dimensionMapProperties)))) {
            memberListMap.getContent().addAll(list);
        }
        if (bl && dimensionMapProperties.keyExpr.isEmpty()) {
            memberListMap.setAction("REMOVE");
        }
    }

    private List<AttributeMap> getAttributeMaps(List list, DimensionMapProperties dimensionMapProperties) {
        ArrayList<AttributeMap> arrayList = new ArrayList<AttributeMap>();
        for (AttributeMapKey attributeMapKey : dimensionMapProperties.attrMapKeys) {
            String string = EMPTY_STRING;
            String string2 = attributeMapKey.expr;
            if (attributeMapKey.language != null) {
                string = CubeDimensionWrapper.stripQuotes(attributeMapKey.language);
            }
            if (string2 != null && string2.equals("\"\"")) {
                string2 = EMPTY_STRING;
            }
            AttributeMap attributeMap = new AttributeMap();
            if (!string.isEmpty()) {
                Object object;
                String string3 = LanguageDBSettings.getLanguageCodeForLanguage(string);
                attributeMap.setLanguage(string);
                String string4 = String.format(MULTI_LANGUAGE_ATTRIBUTE_NAME_FORMAT, attributeMapKey.attribute, string3);
                if (string4.length() > 30) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(string4.substring(0, string4.length() - string3.length() - 10));
                    ((StringBuilder)object).append(String.format("_%s", string3));
                    int n = this.findAttrMapNameIndex(((StringBuilder)object).toString(), arrayList);
                    ((StringBuilder)object).append(String.format("_%s", n));
                    string4 = ((StringBuilder)object).toString();
                }
                attributeMap.setName(string4);
                object = (CubeDimension)this.getUpdatedSystemObject();
            } else {
                attributeMap.setName(attributeMapKey.attribute);
            }
            attributeMap.setAttribute(attributeMapKey.attribute);
            if (attributeMapKey.remove || string2.isEmpty()) {
                if (this.getOriginalObject() == null) continue;
                attributeMap.setAction("REMOVE");
            } else if (attributeMapKey.expr != null) {
                attributeMap.setExpression(this.processExpression(string2));
            }
            arrayList.add(attributeMap);
        }
        return arrayList;
    }

    private int findAttrMapNameIndex(String string, List<AttributeMap> list) {
        int n = 1;
        while (this.attrMapNameExists(String.format(MULTI_LANGUAGE_ATTRIBUTE_NAME_FORMAT, string, n), list)) {
            ++n;
        }
        return n;
    }

    private boolean attrMapNameExists(String string, List<AttributeMap> list) {
        for (AttributeMap attributeMap : list) {
            if (!attributeMap.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void setDescriptions(List<DescriptionProperties> list) {
        if (list != null) {
            for (DescriptionProperties descriptionProperties : list) {
                Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                this.xmldim.getDescription().add(description);
            }
        }
    }

    public void addLanguageDescriptions(List<LangDescProp> list) {
        this.setLanguageDescriptions(list);
    }

    public void setLanguageDescriptions(List<LangDescProp> list) {
        if (list != null) {
            for (LangDescProp langDescProp : list) {
                List<DescriptionProperties> list2 = langDescProp.descs;
                for (DescriptionProperties descriptionProperties : list2) {
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    description.setLanguage(CubeDimensionWrapper.stripQuotes(langDescProp.language));
                    this.xmldim.getDescription().add(description);
                }
            }
        }
    }

    public void modifyLevel(String string, DimensionMapProperties dimensionMapProperties, List<DescriptionProperties> list, List<LangDescProp> list2, List<String> list3) {
        Object object;
        List<DimensionLevel> list4 = this.xmldim.getDimensionLevel();
        DimensionLevel dimensionLevel = new DimensionLevel();
        dimensionLevel.setName(this.processName(string));
        list4.add(dimensionLevel);
        if (list != null) {
            for (DescriptionProperties object2 : list) {
                object = this.createDescriptionObject(object2.type, object2.value);
                dimensionLevel.getContent().add(object);
            }
        }
        if (list2 != null) {
            for (LangDescProp langDescProp : list2) {
                object = langDescProp.descs;
                Iterator<DescriptionProperties> iterator = object.iterator();
                while (iterator.hasNext()) {
                    DescriptionProperties descriptionProperties = iterator.next();
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    description.setLanguage(CubeDimensionWrapper.stripQuotes(langDescProp.language));
                    dimensionLevel.getContent().add(description);
                }
            }
        }
        if (list3 != null) {
            for (String string2 : list3) {
                String string3 = CubeDimensionWrapper.stripQuotes(string2);
                object = new Description();
                ((Description)object).setAction("REMOVE");
                ((Description)object).setLanguage(string3);
                ((Description)object).setType("ShortDescription");
                dimensionLevel.getContent().add(object);
                object = new Description();
                ((Description)object).setAction("REMOVE");
                ((Description)object).setLanguage(string3);
                ((Description)object).setType("LongDescription");
                dimensionLevel.getContent().add(object);
                object = new Description();
                ((Description)object).setAction("REMOVE");
                ((Description)object).setLanguage(string3);
                ((Description)object).setType("Description");
                dimensionLevel.getContent().add(object);
            }
        }
    }

    public void modifyAttribute(String string, AttributeProperties attributeProperties, List<DescriptionProperties> list, List<LangDescProp> list2, List<String> list3) {
        Object object;
        Object object2;
        Object object3;
        List<Attribute> list5 = this.xmldim.getAttribute();
        Attribute attribute = new Attribute();
        list5.add(attribute);
        BaseAttribute baseAttribute = new BaseAttribute();
        attribute.getContent().add(baseAttribute);
        baseAttribute.setName(this.processName(string));
        if (attributeProperties != null && attributeProperties.dataType != null && attributeProperties.dataType.length() > 0) {
            baseAttribute.setSQLDataType(attributeProperties.dataType);
            this.synchronizeSpreadedAttributesForDataType(string, attributeProperties.dataType);
        }
        if (list != null) {
            for (DescriptionProperties list42 : list) {
                object3 = this.createDescriptionObject(list42.type, list42.value);
                baseAttribute.getContent().add(object3);
            }
        }
        if (list2 != null) {
            for (LangDescProp langDescProp : list2) {
                object3 = langDescProp.descs;
                Iterator<Object> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Object object4 = iterator.next();
                    object2 = this.createDescriptionObject(((DescriptionProperties)object4).type, ((DescriptionProperties)object4).value);
                    ((Description)object2).setLanguage(CubeDimensionWrapper.stripQuotes(langDescProp.language));
                    baseAttribute.getContent().add(object2);
                }
            }
        }
        if (list3 != null) {
            for (String string2 : list3) {
                String string3 = CubeDimensionWrapper.stripQuotes(string2);
                object3 = new Description();
                ((Description)object3).setAction("REMOVE");
                ((Description)object3).setLanguage(string3);
                ((Description)object3).setType("ShortDescription");
                baseAttribute.getContent().add(object3);
                object3 = new Description();
                ((Description)object3).setAction("REMOVE");
                ((Description)object3).setLanguage(string3);
                ((Description)object3).setType("LongDescription");
                baseAttribute.getContent().add(object3);
                object3 = new Description();
                ((Description)object3).setAction("REMOVE");
                ((Description)object3).setLanguage(string3);
                ((Description)object3).setType("Description");
                baseAttribute.getContent().add(object3);
            }
        }
        if (attributeProperties != null && attributeProperties.autoDetectDataType && attributeProperties.autoDetectDataTypeAdded) {
            baseAttribute.setAllowAutoDataTypeChange("True");
            this.synchronizeSpreadedAttributesForDetectDataType(string, true);
        } else if (attributeProperties != null && attributeProperties.autoDetectDataTypeDeleted) {
            baseAttribute.setAllowAutoDataTypeChange("False");
            this.synchronizeSpreadedAttributesForDetectDataType(string, false);
        }
        if (attributeProperties != null && attributeProperties.star && attributeProperties.starAdded) {
            object = new Classification();
            ((Classification)object).setValueToFixError2(STAR);
            ((Classification)object).setAction("ADD");
            List<Object> list4 = baseAttribute.getContent();
            boolean bl = false;
            for (Object object4 : list4) {
                if (!(object4 instanceof Classification) || !((Classification)(object2 = (Classification)object4)).getValueToFixError2().equalsIgnoreCase(STAR)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                baseAttribute.getContent().add(object);
                this.generateSpreadedAttributesForNewAttribute(this.processName(string), null);
            }
        } else if (attributeProperties != null && !attributeProperties.star && attributeProperties.starDeleted) {
            object = new Classification();
            ((Classification)object).setValueToFixError2(STAR);
            ((Classification)object).setAction("REMOVE");
            baseAttribute.getContent().add(object);
            this.removeSpreadedAttributesForNoStarAttribute(list5, this.processName(string));
        }
        if (attributeProperties != null && attributeProperties.indexed && attributeProperties.indexedAdded) {
            object = this.getAWOrganization();
            AttributeOrganization attributeOrganization = new AttributeOrganization();
            attributeOrganization.setAttribute(baseAttribute.getName());
            attributeOrganization.setCreateIndex("True");
            ((AWPrimaryDimensionOrganization)object).getContent().add(attributeOrganization);
        } else if (attributeProperties != null && !attributeProperties.indexed && attributeProperties.indexedDeleted) {
            object = this.getAWOrganization();
            AttributeOrganization attributeOrganization = new AttributeOrganization();
            attributeOrganization.setAttribute(baseAttribute.getName());
            attributeOrganization.setCreateIndex("False");
            ((AWPrimaryDimensionOrganization)object).getContent().add(attributeOrganization);
        }
        if (attributeProperties != null && attributeProperties.nls && attributeProperties.nlsAdded) {
            baseAttribute.setIsMultiLingual("True");
        } else if (attributeProperties != null && !attributeProperties.nls && attributeProperties.nlsDeleted) {
            baseAttribute.setIsMultiLingual("False");
        }
        if (attributeProperties != null && attributeProperties.visibleForAll && attributeProperties.visibleForAllAdded) {
            baseAttribute.setIsVisibleForAll("True");
            this.generateSpreadedAttributesForVisibleToAll(list5, this.processName(string));
        } else if (attributeProperties != null && !attributeProperties.visibleForAll && attributeProperties.visibleForAllDeleted) {
            baseAttribute.setIsVisibleForAll("False");
            this.cleanupSpreadedAttributes(this.processName(string), list5);
        }
    }

    @Override
    public void drop() {
        this.xmldim.setAction("REMOVE");
    }

    public void rename(String string) {
        this.xmldim.setNewName(this.processName(string));
        this.xmldim.setETViewName(EMPTY_STRING);
    }

    public void renameLevel(String string, String string2) {
        List<DimensionLevel> list = this.xmldim.getDimensionLevel();
        DimensionLevel dimensionLevel = new DimensionLevel();
        dimensionLevel.setName(this.processName(string));
        dimensionLevel.setNewName(this.processName(string2));
        dimensionLevel.setETKeyColumnName(EMPTY_STRING);
        list.add(dimensionLevel);
        this.renameSpreadedAttributesForLevel(string2);
    }

    public void renameSpreadedAttributesForLevel(String string) {
        SystemObject systemObject = this.getOriginalSystemObject();
        CubeDimension cubeDimension = (CubeDimension)systemObject;
        SystemObject systemObject2 = this.getUpdatedSystemObject();
        List<Attribute> list = this.xmldim.getAttribute();
        if (systemObject2 instanceof CubeDimension) {
            CubeDimension cubeDimension2 = (CubeDimension)systemObject2;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension2.getAttributes()) {
                CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
                String string2;
                String string3;
                if (!this.isAttributePersisted(cubeDimensionAttribute.getOriginalAttributeName()) || !cubeDimensionAttribute.isStar() || this.isAttributeNewStarAttribute(cubeDimension, cubeDimensionAttribute) || !(string3 = cubeDimensionAttribute.getName()).equalsIgnoreCase(string2 = cubeDimensionAttribute.getOriginalAttributeName())) continue;
                for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                    if (!cubeDimensionSpreadedAttribute.getLevelName().equalsIgnoreCase(string) || !this.isAttributeVisibleCheck(cubeDimension2, cubeDimensionAttribute, cubeDimensionSpreadedAttribute.getLevelOriginalName())) continue;
                    Attribute attribute = new Attribute();
                    BaseAttribute baseAttribute = new BaseAttribute();
                    String string4 = cubeDimensionSpreadedAttribute.getName();
                    String string5 = this.generateLevelAttrName(cubeDimension2, cubeDimensionSpreadedAttribute.getLevelName(), string3);
                    baseAttribute.setName(string4);
                    baseAttribute.setNewName(this.processName(string5));
                    if (cubeDimensionAttribute.isAttributeAllowAutoDataTypeChange()) {
                        baseAttribute.setAllowAutoDataTypeChange("True");
                    } else {
                        baseAttribute.setAllowAutoDataTypeChange("False");
                    }
                    baseAttribute.setPopulateLineage("True");
                    baseAttribute.setAttributeGroupName(string3);
                    baseAttribute.setETAttributeColumnName(EMPTY_STRING);
                    attribute.getContent().add(baseAttribute);
                    list.add(attribute);
                    this.renameSpreadedAttributeMap(string3, string, string4, string5);
                }
            }
        }
    }

    public void renameAttributeMap(String string, String string2) {
        SystemObject systemObject = this.getUpdatedSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension.getHierarchies()) {
                LevelHierarchy levelHierarchy = new LevelHierarchy();
                levelHierarchy.setName(cubeDimensionHierarchy.getName());
                boolean bl = false;
                for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                    String string3 = cubeDimensionHierarchyLevel.getLevel().getName();
                    String string4 = cubeDimensionHierarchyLevel.getLevel().getOriginalLevelName();
                    CubeDimensionMap cubeDimensionMap = cubeDimensionHierarchyLevel.getMap();
                    if (cubeDimensionMap == null) continue;
                    HierarchyLevel hierarchyLevel = new HierarchyLevel();
                    hierarchyLevel.setDimensionLevel(string4);
                    levelHierarchy.getHierarchyLevel().add(hierarchyLevel);
                    HierarchyLevelMap hierarchyLevelMap = new HierarchyLevelMap();
                    hierarchyLevel.getContent().add(hierarchyLevelMap);
                    for (CubeDimensionAttributeMap cubeDimensionAttributeMap : cubeDimensionMap.getAttributeMaps()) {
                        String string5 = cubeDimensionAttributeMap.getAttribute().getName();
                        if (!string2.equals(string5)) continue;
                        AttributeMap attributeMap = new AttributeMap();
                        if (cubeDimensionAttributeMap.getLanguage() != null && !cubeDimensionAttributeMap.getLanguage().isEmpty()) {
                            String string6 = LanguageDBSettings.getLanguageCodeForLanguage(cubeDimensionAttributeMap.getLanguage());
                            attributeMap.setName(String.format(MULTI_LANGUAGE_ATTRIBUTE_NAME_FORMAT, string, string6));
                            attributeMap.setNewName(String.format(MULTI_LANGUAGE_ATTRIBUTE_NAME_FORMAT, this.processName(string2), string6));
                        } else {
                            attributeMap.setName(string);
                            attributeMap.setNewName(this.processName(string2));
                        }
                        hierarchyLevelMap.getContent().add(attributeMap);
                        bl = true;
                    }
                }
                if (!bl) continue;
                Hierarchy hierarchy = new Hierarchy();
                hierarchy.setLevelHierarchy(levelHierarchy);
                this.xmldim.getHierarchy().add(hierarchy);
            }
        }
    }

    public void renameSpreadedAttributeMap(String string, String string2, String string3, String string4) {
        SystemObject systemObject = this.getUpdatedSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension.getHierarchies()) {
                LevelHierarchy levelHierarchy = new LevelHierarchy();
                levelHierarchy.setName(cubeDimensionHierarchy.getName());
                boolean bl = false;
                for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                    CubeDimensionMap cubeDimensionMap;
                    String string5 = cubeDimensionHierarchyLevel.getLevel().getName();
                    String string6 = cubeDimensionHierarchyLevel.getLevel().getOriginalLevelName();
                    if (!string5.equals(string2) || (cubeDimensionMap = cubeDimensionHierarchyLevel.getMap()) == null) continue;
                    HierarchyLevel hierarchyLevel = new HierarchyLevel();
                    hierarchyLevel.setDimensionLevel(string6);
                    levelHierarchy.getHierarchyLevel().add(hierarchyLevel);
                    HierarchyLevelMap hierarchyLevelMap = new HierarchyLevelMap();
                    hierarchyLevel.getContent().add(hierarchyLevelMap);
                    for (CubeDimensionAttributeMap cubeDimensionAttributeMap : cubeDimensionMap.getAttributeMaps()) {
                        String string7 = cubeDimensionAttributeMap.getAttribute().getName();
                        if (!string.equals(string7)) continue;
                        AttributeMap attributeMap = new AttributeMap();
                        if (string3.equals(string4)) continue;
                        attributeMap.setName(string3);
                        attributeMap.setNewName(this.processName(string4));
                        hierarchyLevelMap.getContent().add(attributeMap);
                        bl = true;
                    }
                }
                if (!bl) continue;
                Hierarchy hierarchy = new Hierarchy();
                hierarchy.setLevelHierarchy(levelHierarchy);
                this.xmldim.getHierarchy().add(hierarchy);
            }
        }
    }

    public void renameAttribute(String string, String string2) {
        List<Attribute> list = this.xmldim.getAttribute();
        Attribute attribute = new Attribute();
        BaseAttribute baseAttribute = new BaseAttribute();
        baseAttribute.setName(this.processName(string));
        baseAttribute.setNewName(this.processName(string2));
        baseAttribute.setETAttributeColumnName(EMPTY_STRING);
        attribute.getContent().add(baseAttribute);
        list.add(attribute);
        this.renameAttributeMap(string, string2);
        this.renameSpreadedAttributes(string2);
    }

    /*
     * WARNING - void declaration
     */
    public void renameSpreadedAttributes(String string) {
        SystemObject systemObject = this.getOriginalSystemObject();
        CubeDimension cubeDimension = (CubeDimension)systemObject;
        SystemObject systemObject2 = this.getUpdatedSystemObject();
        List<Attribute> list = this.xmldim.getAttribute();
        if (systemObject2 instanceof CubeDimension) {
            CubeDimension cubeDimension2 = (CubeDimension)systemObject2;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension2.getAttributes()) {
                String string2 = cubeDimensionAttribute.getName();
                String string3 = cubeDimensionAttribute.getOriginalAttributeName();
                if (!this.isAttributePersisted(string3) || !cubeDimensionAttribute.getName().equalsIgnoreCase(string)) continue;
                if (!cubeDimensionAttribute.isStar() || this.isAttributeNewStarAttribute(cubeDimension, cubeDimensionAttribute)) break;
                for (CubeDimensionLevel cubeDimensionLevel : cubeDimension2.getLevels()) {
                    void object3;
                    String string4 = cubeDimensionLevel.getName();
                    String string5 = cubeDimensionLevel.getOriginalLevelName();
                    CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeDimensionLevel.getVisibleAttributes();
                    boolean bl = false;
                    for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray) {
                        if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        bl = this.isAttributeVisibleCheck(cubeDimension2, cubeDimensionAttribute, string5);
                    }
                    if (!bl) continue;
                    Attribute attribute = new Attribute();
                    BaseAttribute baseAttribute = new BaseAttribute();
                    CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes();
                    boolean bl2 = false;
                    for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray) {
                        if (!cubeDimensionSpreadedAttribute.getLevelName().equalsIgnoreCase(string4)) continue;
                        bl2 = true;
                        break;
                    }
                    String string6 = string4;
                    if (bl2) {
                        String string7 = cubeDimensionLevel.getOriginalLevelName();
                    }
                    String string8 = this.generateLevelAttrName(cubeDimension2, (String)object3, cubeDimensionAttribute.getOriginalAttributeName());
                    String string9 = this.generateLevelAttrName(cubeDimension2, string4, string);
                    baseAttribute.setName(string8);
                    baseAttribute.setNewName(this.processName(string9));
                    if (cubeDimensionAttribute.isAttributeAllowAutoDataTypeChange()) {
                        baseAttribute.setAllowAutoDataTypeChange("True");
                    } else {
                        baseAttribute.setAllowAutoDataTypeChange("False");
                    }
                    baseAttribute.setPopulateLineage("True");
                    baseAttribute.setAttributeGroupName(string);
                    baseAttribute.setETAttributeColumnName(EMPTY_STRING);
                    attribute.getContent().add(baseAttribute);
                    list.add(attribute);
                    String string10 = this.generateLevelAttrName(cubeDimension2, cubeDimensionLevel.getOriginalLevelName(), cubeDimensionAttribute.getOriginalAttributeName());
                    String string11 = this.generateLevelAttrName(cubeDimension2, string4, string);
                    this.renameSpreadedAttributeMap(string2, string4, string10, string11);
                }
            }
        }
    }

    public void renameHierarchy(String string, String string2) {
        CubeDimensionHierarchy cubeDimensionHierarchy = this.findHierarchy(string);
        if (cubeDimensionHierarchy == null) {
            cubeDimensionHierarchy = this.findHierarchy(string2);
        }
        if (cubeDimensionHierarchy == null) {
            return;
        }
        boolean bl = cubeDimensionHierarchy.getHierarchyLevelType();
        if (bl) {
            List<Hierarchy> list = this.xmldim.getHierarchy();
            Hierarchy hierarchy = new Hierarchy();
            list.add(hierarchy);
            LevelHierarchy levelHierarchy = new LevelHierarchy();
            levelHierarchy.setName(this.processName(string));
            levelHierarchy.setNewName(this.processName(string2));
            levelHierarchy.setETViewName(EMPTY_STRING);
            hierarchy.setLevelHierarchy(levelHierarchy);
        } else {
            this.renameValueHierarchy(string, string2);
        }
    }

    public void renameLevelHierarchy2(String string, String string2) {
        List<Hierarchy> list = this.xmldim.getHierarchy();
        Hierarchy hierarchy = new Hierarchy();
        list.add(hierarchy);
        LevelHierarchy levelHierarchy = new LevelHierarchy();
        levelHierarchy.setName(this.processName(string));
        levelHierarchy.setNewName(this.processName(string2));
        levelHierarchy.setETViewName(EMPTY_STRING);
        hierarchy.setLevelHierarchy(levelHierarchy);
        CubeDimensionHierarchy cubeDimensionHierarchy = this.findHierarchy(string);
        if (cubeDimensionHierarchy != null) {
            HierarchyLevel hierarchyLevel;
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevelsReverse()) {
                hierarchyLevel = new HierarchyLevel();
                hierarchyLevel.setAction("REMOVE");
                hierarchyLevel.setDimensionLevel(cubeDimensionHierarchyLevel.getLevel().getName());
                levelHierarchy.getHierarchyLevel().add(hierarchyLevel);
            }
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevelsReverse()) {
                hierarchyLevel = new HierarchyLevel();
                hierarchyLevel.setAction("ADD");
                hierarchyLevel.setDimensionLevel(cubeDimensionHierarchyLevel.getLevel().getName());
                levelHierarchy.getHierarchyLevel().add(hierarchyLevel);
            }
        }
    }

    public void renameValueHierarchy(String string, String string2) {
        List<Hierarchy> list = this.xmldim.getHierarchy();
        Hierarchy hierarchy = new Hierarchy();
        list.add(hierarchy);
        ValueHierarchy valueHierarchy = new ValueHierarchy();
        valueHierarchy.setName(this.processName(string));
        valueHierarchy.setNewName(this.processName(string2));
        hierarchy.setValueHierarchy(valueHierarchy);
    }

    public void modifyLevelVisibleAttribute(String string, boolean bl, List<String> list) {
        List<DimensionLevel> list2 = this.xmldim.getDimensionLevel();
        DimensionLevel dimensionLevel = new DimensionLevel();
        list2.add(dimensionLevel);
        dimensionLevel.setName(this.processName(string));
        if (!bl) {
            for (String string2 : list) {
                VisibleAttribute visibleAttribute = new VisibleAttribute();
                visibleAttribute.setName(string2);
                visibleAttribute.setAction("ADD");
                dimensionLevel.getContent().add(visibleAttribute);
                this.generateSpreadedAttributeForAttributeVisibleLevel(string2, dimensionLevel);
            }
        } else {
            List<Attribute> list3 = this.xmldim.getAttribute();
            for (String string3 : list) {
                VisibleAttribute visibleAttribute = new VisibleAttribute();
                visibleAttribute.setName(string3);
                visibleAttribute.setAction("REMOVE");
                dimensionLevel.getContent().add(visibleAttribute);
                this.removeSpreadedAttributeForAttributeVisibleLevel(list3, string3, string);
            }
        }
    }

    private void generateSpreadedAttributeForAttributeVisibleHierarchyLevel(String string, HierarchyLevel hierarchyLevel) {
        CubeDimension cubeDimension = null;
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject != null) {
            cubeDimension = (CubeDimension)systemObject;
        }
        CubeDimension cubeDimension2 = null;
        SystemObject systemObject2 = this.getSystemObject();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (systemObject2 instanceof CubeDimension) {
            cubeDimension2 = (CubeDimension)systemObject2;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension2.getAttributes()) {
                if (!cubeDimensionAttribute.isStar() || !cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(string)) continue;
                if (this.isAttributeNewStarAttribute(cubeDimension, cubeDimensionAttribute)) break;
                for (CubeDimensionLevel cubeDimensionLevel : cubeDimension2.getLevels()) {
                    if (!cubeDimensionLevel.getOriginalLevelName().equalsIgnoreCase(hierarchyLevel.getDimensionLevel())) continue;
                    boolean bl = false;
                    if (cubeDimensionAttribute.isAttributeVisibleForAll() || this.isAttributeVisibleAtLevel(cubeDimensionLevel, cubeDimensionAttribute)) {
                        bl = true;
                    }
                    if (bl || !(bl = this.isAttributeVisibleCheck(cubeDimension2, cubeDimensionAttribute, cubeDimensionLevel.getOriginalLevelName()))) continue;
                    boolean bl2 = false;
                    for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionAttribute.getSpreadedAttributes()) {
                        if (!cubeDimensionSpreadedAttribute.getLevelOriginalName().equalsIgnoreCase(hierarchyLevel.getDimensionLevel())) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    Attribute attribute = new Attribute();
                    DimensionLevel dimensionLevel = new DimensionLevel();
                    dimensionLevel.setName(this.processName(cubeDimensionLevel.getOriginalLevelName()));
                    this.xmldim.getDimensionLevel().add(dimensionLevel);
                    Attribute attribute2 = this.createSpreadAttributeForLevel(cubeDimension2, dimensionLevel, cubeDimensionLevel.getName(), cubeDimensionAttribute.getOriginalAttributeName(), cubeDimensionAttribute.isAttributeAllowAutoDataTypeChange(), cubeDimensionAttribute.getDataType());
                    arrayList.add(attribute2);
                }
            }
        }
        this.xmldim.getAttribute().addAll(arrayList);
    }

    private void removeSpreadedAttributeForAttributeVisibleHierarchyLevel(List<Attribute> list, String string, String string2) {
        String string3 = this.processName(string2);
        String string4 = null;
        SystemObject systemObject = this.getSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            boolean bl = false;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension.getAttributes()) {
                if (!cubeDimensionAttribute.isStar() || !cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(string)) continue;
                CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes();
                for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray) {
                    String string5 = cubeDimensionSpreadedAttribute.getLevelOriginalName();
                    if (!string3.equalsIgnoreCase(string5)) continue;
                    string4 = cubeDimensionSpreadedAttribute.getName();
                    bl = this.isAttributeVisibleCheck(cubeDimension, cubeDimensionAttribute, string5);
                    break;
                }
                if (bl || string4 == null) continue;
                Attribute attribute = new Attribute();
                attribute.setAction("REMOVE");
                list.add(attribute);
                BaseAttribute baseAttribute = new BaseAttribute();
                attribute.getContent().add(baseAttribute);
                baseAttribute.setName(this.processName(string4));
            }
        }
    }

    private void generateSpreadedAttributeForAttributeVisibleLevel(String string, DimensionLevel dimensionLevel) {
        CubeDimension cubeDimension = null;
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject != null) {
            cubeDimension = (CubeDimension)systemObject;
        }
        CubeDimension cubeDimension2 = null;
        SystemObject systemObject2 = this.getSystemObject();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (systemObject2 instanceof CubeDimension) {
            cubeDimension2 = (CubeDimension)systemObject2;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension2.getAttributes()) {
                if (!cubeDimensionAttribute.isStar() || !cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(string)) continue;
                if (this.isAttributeNewStarAttribute(cubeDimension, cubeDimensionAttribute)) break;
                for (CubeDimensionLevel cubeDimensionLevel : cubeDimension2.getLevels()) {
                    if (!cubeDimensionLevel.getOriginalLevelName().equalsIgnoreCase(dimensionLevel.getName()) || !cubeDimensionAttribute.isAttributeVisibleForAll() && !this.isAttributeVisibleAtLevel(cubeDimensionLevel, cubeDimensionAttribute)) continue;
                    boolean bl = false;
                    for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionAttribute.getSpreadedAttributes()) {
                        if (!cubeDimensionSpreadedAttribute.getLevelOriginalName().equalsIgnoreCase(dimensionLevel.getName())) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    Attribute attribute2 = new Attribute();
                    attribute2 = this.createSpreadAttributeForLevel(cubeDimension2, dimensionLevel, cubeDimensionLevel.getName(), cubeDimensionAttribute.getOriginalAttributeName(), cubeDimensionAttribute.isAttributeAllowAutoDataTypeChange(), cubeDimensionAttribute.getDataType());
                    arrayList.add(attribute2);
                }
            }
        }
        this.xmldim.getAttribute().addAll(arrayList);
    }

    private void removeSpreadedAttributeForAttributeVisibleLevel(List<Attribute> list, String string, String string2) {
        String string3 = this.processName(string2);
        SystemObject systemObject = this.getSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension.getAttributes()) {
                CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
                if (!cubeDimensionAttribute.isStar() || !cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(string)) continue;
                for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                    String string4 = cubeDimensionSpreadedAttribute.getLevelOriginalName();
                    if (!string3.equalsIgnoreCase(string4)) continue;
                    boolean bl = false;
                    bl = this.isAttributeVisibleCheck(cubeDimension, cubeDimensionAttribute, string3);
                    if (bl) continue;
                    Attribute attribute = new Attribute();
                    attribute.setAction("REMOVE");
                    list.add(attribute);
                    BaseAttribute baseAttribute = new BaseAttribute();
                    attribute.getContent().add(baseAttribute);
                    baseAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    VisibleAttribute visibleAttribute = new VisibleAttribute();
                    visibleAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    visibleAttribute.setAction("REMOVE");
                    DimensionLevel dimensionLevel = new DimensionLevel();
                    dimensionLevel.setName(this.processName(string2));
                    this.xmldim.getDimensionLevel().add(dimensionLevel);
                    dimensionLevel.getContent().add(visibleAttribute);
                }
            }
        }
    }

    public void modifyHierLevelVisibleAttribute(String string, String string2, boolean bl, List<String> list) {
        LevelHierarchy levelHierarchy = new LevelHierarchy();
        levelHierarchy.setName(this.processName(string));
        HierarchyLevel hierarchyLevel = new HierarchyLevel();
        hierarchyLevel.setDimensionLevel(string2.toUpperCase());
        for (String object2 : list) {
            VisibleAttribute visibleAttribute = new VisibleAttribute();
            visibleAttribute.setName(object2);
            if (!bl) {
                visibleAttribute.setAction("ADD");
                this.generateSpreadedAttributeForAttributeVisibleHierarchyLevel(object2, hierarchyLevel);
            } else {
                List<Attribute> list2 = this.xmldim.getAttribute();
                visibleAttribute.setAction("REMOVE");
                this.removeSpreadedAttributeForAttributeVisibleHierarchyLevel(list2, object2, string2);
            }
            hierarchyLevel.getContent().add(visibleAttribute);
        }
        levelHierarchy.getHierarchyLevel().add(hierarchyLevel);
        List<Hierarchy> list3 = this.xmldim.getHierarchy();
        Hierarchy hierarchy = new Hierarchy();
        list3.add(hierarchy);
        hierarchy.setLevelHierarchy(levelHierarchy);
    }

    public void modifyValueHierVisibleAttribute(String string, boolean bl, List<String> list) {
        ValueHierarchy valueHierarchy = new ValueHierarchy();
        valueHierarchy.setName(this.processName(string));
        for (String object2 : list) {
            VisibleAttribute visibleAttribute = new VisibleAttribute();
            visibleAttribute.setName(object2);
            if (!bl) {
                visibleAttribute.setAction("ADD");
            } else {
                visibleAttribute.setAction("REMOVE");
            }
            valueHierarchy.getVisibleAttribute().add(visibleAttribute);
        }
        List<Hierarchy> list2 = this.xmldim.getHierarchy();
        Hierarchy hierarchy = new Hierarchy();
        list2.add(hierarchy);
        hierarchy.setValueHierarchy(valueHierarchy);
    }

    private CubeDimensionHierarchy findHierarchy(String string) {
        String string2;
        CubeDimension cubeDimension;
        String string3 = this.processName(string);
        SystemObject systemObject = this.getSystemObject();
        if (systemObject instanceof CubeDimension) {
            cubeDimension = (CubeDimension)systemObject;
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension.getHierarchies()) {
                string2 = cubeDimensionHierarchy.getName();
                if (!string2.equals(string3)) continue;
                return cubeDimensionHierarchy;
            }
        }
        if ((systemObject = this.getUpdatedSystemObject()) instanceof CubeDimension) {
            cubeDimension = (CubeDimension)systemObject;
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension.getHierarchies()) {
                string2 = cubeDimensionHierarchy.getName();
                if (!string2.equals(string3)) continue;
                return cubeDimensionHierarchy;
            }
        }
        return null;
    }

    private void generateSpreadedAttributesForNewAttribute(String string, String string2) {
        CubeDimensionAttribute cubeDimensionAttribute;
        CubeDimension cubeDimension = null;
        SystemObject systemObject = this.getSystemObject();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (systemObject instanceof CubeDimension && (cubeDimensionAttribute = (cubeDimension = (CubeDimension)systemObject).findAttributeFromOriginalName(string)) != null && cubeDimensionAttribute.isStar()) {
            if (string2 == null) {
                string2 = cubeDimensionAttribute.getDataType();
            }
            for (CubeDimensionLevel cubeDimensionLevel : cubeDimension.getLevels()) {
                boolean bl = false;
                if (cubeDimensionAttribute.isAttributeVisibleForAll() || this.isAttributeVisibleAtLevel(cubeDimensionLevel, cubeDimensionAttribute)) {
                    bl = true;
                }
                if (!bl) {
                    bl = this.isAttributeVisibleCheck(cubeDimension, cubeDimensionAttribute, cubeDimensionLevel.getOriginalLevelName());
                }
                if (!bl) continue;
                DimensionLevel dimensionLevel = new DimensionLevel();
                dimensionLevel.setName(this.processName(cubeDimensionLevel.getOriginalLevelName()));
                this.xmldim.getDimensionLevel().add(dimensionLevel);
                Attribute attribute = new Attribute();
                attribute = this.createSpreadAttributeForLevel(cubeDimension, dimensionLevel, cubeDimensionLevel.getName(), cubeDimensionAttribute.getName(), cubeDimensionAttribute.isAttributeAllowAutoDataTypeChange(), cubeDimensionAttribute.getDataType());
                arrayList.add(attribute);
            }
            this.xmldim.getAttribute().addAll(arrayList);
        }
    }

    private void generateSpreadedAttributesForNewLevel(DimensionLevel dimensionLevel) {
        CubeDimension cubeDimension = null;
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject != null) {
            cubeDimension = (CubeDimension)systemObject;
        }
        CubeDimension cubeDimension2 = null;
        SystemObject systemObject2 = this.getSystemObject();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (systemObject2 instanceof CubeDimension) {
            cubeDimension2 = (CubeDimension)systemObject2;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension2.getAttributes()) {
                if (!cubeDimensionAttribute.isStar() || this.isAttributeNewStarAttribute(cubeDimension, cubeDimensionAttribute)) continue;
                for (CubeDimensionLevel cubeDimensionLevel : cubeDimension2.getLevels()) {
                    if (!cubeDimensionLevel.getName().equalsIgnoreCase(dimensionLevel.getName())) continue;
                    boolean bl = false;
                    if (cubeDimensionAttribute.isAttributeVisibleForAll() || this.isAttributeVisibleAtLevel(cubeDimensionLevel, cubeDimensionAttribute)) {
                        bl = true;
                    }
                    if (!bl) {
                        bl = this.isAttributeVisibleCheck(cubeDimension2, cubeDimensionAttribute, cubeDimensionLevel.getName());
                    }
                    if (!bl) continue;
                    Attribute attribute = new Attribute();
                    attribute = this.isEditing() ? this.createSpreadAttributeForLevel(cubeDimension2, dimensionLevel, dimensionLevel.getName(), cubeDimensionAttribute.getOriginalAttributeName(), cubeDimensionAttribute.isAttributeAllowAutoDataTypeChange(), cubeDimensionAttribute.getDataType()) : this.createSpreadAttributeForLevel(cubeDimension2, dimensionLevel, dimensionLevel.getName(), cubeDimensionAttribute.getName(), cubeDimensionAttribute.isAttributeAllowAutoDataTypeChange(), cubeDimensionAttribute.getDataType());
                    arrayList.add(attribute);
                }
            }
            this.xmldim.getAttribute().addAll(arrayList);
        }
    }

    private void synchronizeSpreadedAttributesForDetectDataType(String string, boolean bl) {
        CubeDimensionAttribute cubeDimensionAttribute;
        CubeDimension cubeDimension = null;
        SystemObject systemObject = this.getSystemObject();
        List<Attribute> list = this.xmldim.getAttribute();
        if (systemObject instanceof CubeDimension && (cubeDimensionAttribute = (cubeDimension = (CubeDimension)systemObject).findAttribute(string)) != null && cubeDimensionAttribute.isStar()) {
            CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
            for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                Attribute attribute = new Attribute();
                list.add(attribute);
                BaseAttribute baseAttribute = new BaseAttribute();
                attribute.getContent().add(baseAttribute);
                baseAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                if (bl) {
                    baseAttribute.setAllowAutoDataTypeChange("True");
                    continue;
                }
                baseAttribute.setAllowAutoDataTypeChange("False");
            }
        }
    }

    private void synchronizeSpreadedAttributesForDataType(String string, String string2) {
        CubeDimensionAttribute cubeDimensionAttribute;
        CubeDimension cubeDimension = null;
        SystemObject systemObject = this.getSystemObject();
        List<Attribute> list = this.xmldim.getAttribute();
        if (systemObject instanceof CubeDimension && (cubeDimensionAttribute = (cubeDimension = (CubeDimension)systemObject).findAttribute(string)) != null && cubeDimensionAttribute.isStar()) {
            CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
            for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                Attribute attribute = new Attribute();
                list.add(attribute);
                BaseAttribute baseAttribute = new BaseAttribute();
                attribute.getContent().add(baseAttribute);
                baseAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                baseAttribute.setSQLDataType(string2);
            }
        }
    }

    private Attribute createSpreadAttributeForLevel(CubeDimension cubeDimension, DimensionLevel dimensionLevel, String string, String string2, boolean bl, String string3) {
        Attribute attribute = new Attribute();
        BaseAttribute baseAttribute = new BaseAttribute();
        String string4 = this.generateLevelAttrName(cubeDimension, string, string2);
        baseAttribute.setName(string4);
        if (bl) {
            baseAttribute.setAllowAutoDataTypeChange("True");
        } else {
            baseAttribute.setAllowAutoDataTypeChange("False");
        }
        baseAttribute.setPopulateLineage("True");
        baseAttribute.setAttributeGroupName(string2);
        attribute.setAction("ADD");
        if (string3 != null) {
            baseAttribute.setSQLDataType(string3);
        }
        attribute.getContent().add(baseAttribute);
        VisibleAttribute visibleAttribute = new VisibleAttribute();
        visibleAttribute.setName(baseAttribute.getName());
        visibleAttribute.setAction("ADD");
        dimensionLevel.getContent().add(visibleAttribute);
        return attribute;
    }

    private boolean isAttributeVisibleCheck(CubeDimension cubeDimension, CubeDimensionAttribute cubeDimensionAttribute, String string) {
        boolean bl = false;
        if (cubeDimensionAttribute.isAttributeVisibleForAll()) {
            return true;
        }
        block0: for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension.getHierarchies()) {
            if (!cubeDimensionHierarchy.getHierarchyLevelType() || bl) continue;
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                if (!string.equalsIgnoreCase(cubeDimensionHierarchyLevel.getLevel().getOriginalLevelName()) || !this.isAttributeVisibleAtHierarchyLevel(cubeDimensionHierarchyLevel, cubeDimensionAttribute)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    private boolean isAttributeVisibleAtLevel(CubeDimensionLevel cubeDimensionLevel, CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        boolean bl = false;
        for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray = cubeDimensionLevel.getVisibleAttributes()) {
            if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isAttributeVisibleAtHierarchyLevel(CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel, CubeDimensionAttribute cubeDimensionAttribute) {
        boolean bl = false;
        CubeDimensionLevel cubeDimensionLevel = cubeDimensionHierarchyLevel.getLevel();
        if (this.isAttributeVisibleAtLevel(cubeDimensionLevel, cubeDimensionAttribute)) {
            bl = true;
        } else {
            CubeDimensionAttribute[] cubeDimensionAttributeArray;
            for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray = cubeDimensionHierarchyLevel.getVisibleAttributes()) {
                if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void generateSpreadedAttributesForVisibleToAll(List<Attribute> list, String string) {
        String string2 = this.processName(string);
        SystemObject systemObject = this.getOriginalSystemObject();
        SystemObject systemObject2 = this.getSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            CubeDimension cubeDimension2 = (CubeDimension)systemObject2;
            CubeDimensionAttribute cubeDimensionAttribute = cubeDimension2.findAttributeFromOriginalName(string);
            if (this.isAttributeNewStarAttribute(cubeDimension, cubeDimensionAttribute) && cubeDimensionAttribute.isStar()) {
                return;
            }
            if (cubeDimensionAttribute != null && cubeDimensionAttribute.isStar()) {
                for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimension.getAttributes()) {
                    if (!cubeDimensionAttribute2.getName().equalsIgnoreCase(string2)) continue;
                    CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute2.getSpreadedAttributes();
                    for (CubeDimensionLevel cubeDimensionLevel : cubeDimension.getLevels()) {
                        boolean bl = false;
                        for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray) {
                            if (!cubeDimensionLevel.getName().equalsIgnoreCase(cubeDimensionSpreadedAttribute.getLevelName())) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        DimensionLevel dimensionLevel = new DimensionLevel();
                        dimensionLevel.setName(cubeDimensionLevel.getName());
                        this.xmldim.getDimensionLevel().add(dimensionLevel);
                        CubeDimensionLevel cubeDimensionLevel2 = cubeDimension2.findLevelFromOriginalName(cubeDimensionLevel.getName());
                        String string3 = cubeDimensionLevel.getName();
                        if (cubeDimensionLevel2 != null) {
                            string3 = cubeDimensionLevel2.getName();
                        }
                        Attribute attribute = this.createSpreadAttributeForLevel(cubeDimension, dimensionLevel, string3, string2, cubeDimensionAttribute2.isAttributeAllowAutoDataTypeChange(), cubeDimensionAttribute2.getDataType());
                        list.add(attribute);
                    }
                }
            }
        }
    }

    private void removeSpreadedAttributesForNoStarAttribute(List<Attribute> list, String string) {
        String string2 = this.processName(string);
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension.getAttributes()) {
                CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
                if (!cubeDimensionAttribute.getName().equalsIgnoreCase(string2)) continue;
                for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                    Attribute attribute = new Attribute();
                    attribute.setAction("REMOVE");
                    list.add(attribute);
                    BaseAttribute baseAttribute = new BaseAttribute();
                    attribute.getContent().add(baseAttribute);
                    baseAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    VisibleAttribute visibleAttribute = new VisibleAttribute();
                    visibleAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    visibleAttribute.setAction("REMOVE");
                    DimensionLevel dimensionLevel = new DimensionLevel();
                    dimensionLevel.setName(this.processName(cubeDimensionSpreadedAttribute.getLevelOriginalName()));
                    this.xmldim.getDimensionLevel().add(dimensionLevel);
                    dimensionLevel.getContent().add(visibleAttribute);
                }
            }
        }
    }

    private void removeSpreadedAttributes(List<Attribute> list, String string) {
        String string2 = this.processName(string);
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension.getAttributes()) {
                CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
                if (!cubeDimensionAttribute.isStar() || !cubeDimensionAttribute.getName().equalsIgnoreCase(string2)) continue;
                for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                    Attribute attribute = new Attribute();
                    attribute.setAction("REMOVE");
                    list.add(attribute);
                    BaseAttribute baseAttribute = new BaseAttribute();
                    attribute.getContent().add(baseAttribute);
                    baseAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    VisibleAttribute visibleAttribute = new VisibleAttribute();
                    visibleAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    visibleAttribute.setAction("REMOVE");
                    DimensionLevel dimensionLevel = new DimensionLevel();
                    dimensionLevel.setName(this.processName(cubeDimensionSpreadedAttribute.getLevelOriginalName()));
                    this.xmldim.getDimensionLevel().add(dimensionLevel);
                    dimensionLevel.getContent().add(visibleAttribute);
                }
            }
        }
    }

    private void removeSpreadedAttributesAtLevel(List<Attribute> list, String string) {
        String string2 = this.processName(string);
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension.getAttributes()) {
                CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
                if (!cubeDimensionAttribute.isStar()) continue;
                for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                    String string3 = cubeDimensionSpreadedAttribute.getLevelName();
                    if (!string2.equalsIgnoreCase(string3)) continue;
                    Attribute attribute = new Attribute();
                    attribute.setAction("REMOVE");
                    list.add(attribute);
                    BaseAttribute baseAttribute = new BaseAttribute();
                    attribute.getContent().add(baseAttribute);
                    baseAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    VisibleAttribute visibleAttribute = new VisibleAttribute();
                    visibleAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    visibleAttribute.setAction("REMOVE");
                    DimensionLevel dimensionLevel = new DimensionLevel();
                    dimensionLevel.setName(this.processName(cubeDimensionSpreadedAttribute.getLevelName()));
                    this.xmldim.getDimensionLevel().add(dimensionLevel);
                    dimensionLevel.getContent().add(visibleAttribute);
                }
            }
        }
    }

    private void cleanupSpreadedAttributes(String string, List<Attribute> list) {
        SystemObject systemObject = this.getOriginalSystemObject();
        SystemObject systemObject2 = this.getSystemObject();
        if (systemObject instanceof CubeDimension) {
            CubeDimension cubeDimension = (CubeDimension)systemObject;
            CubeDimension cubeDimension2 = (CubeDimension)systemObject2;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension.getAttributes()) {
                CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
                CubeDimensionAttribute cubeDimensionAttribute2;
                if (!cubeDimensionAttribute.getName().equalsIgnoreCase(string) || !cubeDimensionAttribute.isStar() || (cubeDimensionAttribute2 = cubeDimension2.findAttributeFromOriginalName(string)) == null) continue;
                for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                    String string2 = cubeDimensionSpreadedAttribute.getLevelOriginalName();
                    boolean bl = this.isAttributeVisibleCheck(cubeDimension2, cubeDimensionAttribute2, string2);
                    if (bl) continue;
                    Attribute attribute = new Attribute();
                    attribute.setAction("REMOVE");
                    list.add(attribute);
                    BaseAttribute baseAttribute = new BaseAttribute();
                    attribute.getContent().add(baseAttribute);
                    baseAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    VisibleAttribute visibleAttribute = new VisibleAttribute();
                    visibleAttribute.setName(this.processName(cubeDimensionSpreadedAttribute.getName()));
                    visibleAttribute.setAction("REMOVE");
                    DimensionLevel dimensionLevel = new DimensionLevel();
                    dimensionLevel.setName(this.processName(cubeDimensionSpreadedAttribute.getLevelOriginalName()));
                    this.xmldim.getDimensionLevel().add(dimensionLevel);
                    dimensionLevel.getContent().add(visibleAttribute);
                }
            }
        }
    }

    private boolean isAttributeNewStarAttribute(CubeDimension cubeDimension, CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute cubeDimensionAttribute2;
        boolean bl = false;
        if (cubeDimension != null && cubeDimensionAttribute != null && (cubeDimensionAttribute2 = cubeDimension.findAttribute(cubeDimensionAttribute.getOriginalAttributeName())) != null && !cubeDimensionAttribute2.isStar()) {
            bl = true;
        }
        return bl;
    }

    private String generateLevelAttrName(CubeDimension cubeDimension, String string, String string2) {
        String string3 = string + "_" + string2;
        int n = string3.getBytes().length;
        int n2 = string3.length();
        while (n > 29) {
            string3 = string3.substring(0, --n2);
            n = string3.getBytes().length;
        }
        String string4 = string3;
        int n3 = 1;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            bl = false;
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension.getAttributes()) {
                if (!cubeDimensionAttribute.getName().equalsIgnoreCase(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                bl2 = true;
                break;
            }
            string4 = string3 + Integer.toString(n3++);
        }
        return string4;
    }

    private boolean isAttributePersisted(String string) {
        boolean bl = false;
        if (!this.isEditing()) {
            bl = false;
        } else {
            CubeDimensionAttribute[] cubeDimensionAttributeArray;
            CubeDimension cubeDimension = (CubeDimension)this.getOriginalSystemObject();
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray = cubeDimension.getAttributes()) {
                if (!cubeDimensionAttribute.getName().equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    class CubeDimensionClassificationSetter
    extends AbstractClassificationSetter {
        CubeDimensionClassificationSetter() {
        }

        @Override
        public void addClassification(Object object, Classification classification) {
            if (object instanceof TimeDimension) {
                TimeDimension timeDimension = (TimeDimension)object;
                timeDimension.getClassification().add(classification);
            } else if (object instanceof StandardDimension) {
                StandardDimension standardDimension = (StandardDimension)object;
                standardDimension.getClassification().add(classification);
            }
        }
    }
}

