/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamHierarchy
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamHierarchy.class.getName());
    private Dimension dimension;
    private static final String DEFAULT_VALUE = "dimension.hierarchy";
    private boolean isValid;
    private static final ParseNode pattern = new ParseNode("hierarchy", Type.HIERARCHY.toString(), ParseNode.PatternType.NONE);

    public TemplateHyperParamHierarchy() {
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, TemplateHyperParamHierarchy.this.uiValue(object), n, bl, bl2);
            }
        });
    }

    private String uiValue(Object object) {
        if (object != null) {
            DimensionHierarchy dimensionHierarchy = (DimensionHierarchy)object;
            return dimensionHierarchy.getName();
        }
        return null;
    }

    @Override
    public int getPixelSize(int n) {
        if (this.getSelectedElement() != null) {
            return this.hyperCombo.getFontMetrics(this.hyperCombo.getFont()).stringWidth(this.uiValue(this.getSelectedElement()));
        }
        return 100;
    }

    @Override
    public String getErrorMessage() {
        return OLAPArb.getString("EXPRESSION_EDITOR_ERROR_NO_HIERARCHY");
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Dimension dimension;
        Object object = propertyChangeEvent.getNewValue();
        if (!"VALID_PROPERTY".equals(propertyChangeEvent.getPropertyName()) && object instanceof Dimension && !(dimension = (Dimension)object).equals(this.dimension)) {
            this.setDimension(dimension);
        }
    }

    @Override
    public void init() {
        String string;
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    private void setDimension(Dimension dimension) {
        if (!dimension.equals(this.dimension)) {
            boolean bl = this.isValid;
            Dimension dimension2 = this.dimension;
            this.removeAllElements();
            this.dimension = dimension;
            List<DimensionHierarchy> list = dimension.getHierarchies();
            DimensionHierarchy dimensionHierarchy = dimension.getDefaultHierarchy();
            if (dimensionHierarchy != null && dimensionHierarchy.getName().length() > 0) {
                this.addElement(dimensionHierarchy);
                this.isValid = true;
                for (DimensionHierarchy dimensionHierarchy2 : list) {
                    if (dimensionHierarchy2.equals(dimensionHierarchy)) continue;
                    this.addElement(dimensionHierarchy2);
                }
            } else {
                for (DimensionHierarchy dimensionHierarchy3 : list) {
                    this.addElement(dimensionHierarchy3);
                    this.isValid = true;
                }
            }
            if (dimension2 != null && bl != this.isValid || !this.isValid) {
                this.firePropertyChangeEvent(new PropertyChangeEvent(this, "VALID_PROPERTY", bl, this.isValid));
            }
        }
    }

    private DimensionHierarchy getHierarchy() {
        return (DimensionHierarchy)this.getSelectedElement();
    }

    @Override
    public Object getValue() {
        return this.getHierarchy();
    }

    @Override
    public String getExpression() {
        if (this.getHierarchy() != null) {
            return this.getHierarchy().getID();
        }
        return "";
    }

    @Override
    public String getDefault() {
        return DEFAULT_VALUE;
    }

    @Override
    public boolean setValue(Object object) {
        Object object2;
        if (object instanceof ParseNode && this.dimension != null) {
            object2 = (ParseNode)object;
            String string = this.dimension.getSchema().getName();
            IdentifierElement identifierElement = new IdentifierElement(((ParseNode)object2).getValue());
            int n = 0;
            int n2 = 1;
            if (identifierElement.getFirst().equals(string)) {
                ++n2;
                ++n;
            }
            String string2 = identifierElement.get(n);
            String string3 = identifierElement.get(n2);
            Dimension dimension = this.dimension.getSchema().findDimension(string2);
            if (dimension != null) {
                this.setDimension(dimension);
                return super.setValue(dimension.findHierarchy(string3));
            }
        }
        if (this.dimension != null) {
            object2 = this.dimension.findHierarchy(String.valueOf(object));
            return super.setValue(object2);
        }
        return false;
    }
}

