/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.MultiSelectShuttlePanel;
import oracle.olap.app.templates.templateview.TemplateHyperParamMultiSelect;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamHierarchyLevels
extends TemplateHyperParamMultiSelect
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamHierarchyLevels.class.getName());
    private DimensionHierarchy hierarchy;
    private static final ParseNode pattern = new ParseNode("hierarchy_levels", null, ParseNode.PatternType.LOOP);

    public TemplateHyperParamHierarchyLevels() {
        this.addPropertyChangeListener(this);
        this.selectionJOptionPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (TemplateHyperParamHierarchyLevels.this.selectionDialog.isVisible() && propertyChangeEvent.getSource() == TemplateHyperParamHierarchyLevels.this.pane && string.equals("value")) {
                    Object object = TemplateHyperParamHierarchyLevels.this.pane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if ((Integer)object == 0) {
                        List<String> list = TemplateHyperParamHierarchyLevels.this.multiSelectEditor.getSelectedItems();
                        if (list.size() > 0) {
                            TemplateHyperParamHierarchyLevels.this.selectionDialog.setVisible(false);
                        } else {
                            String string2 = OLAPArb.get("CUBE_DIMENSION_LEVEL_SELECTION_NONE_SELECTED_ERROR_MSG");
                            String string3 = OLAPArb.get("CUBE_DIMENSION_LEVEL_SELECTION_ERROR_TITLE");
                            String string4 = null;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
                            TemplateHyperParamHierarchyLevels.this.pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        }
                    } else {
                        TemplateHyperParamHierarchyLevels.this.selectionDialog.setVisible(false);
                    }
                }
            }
        };
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    private void setHierarchy(DimensionHierarchy dimensionHierarchy) {
        if (this.hierarchy == dimensionHierarchy) {
            return;
        }
        List<Object> list = new ArrayList();
        if (dimensionHierarchy != null) {
            this.hierarchy = dimensionHierarchy;
            this.helpID = null;
            this.editorTitle = OLAPArb.getString("CUBE_DIMENSION_LEVELS");
            List<DimensionHierarchyLevel> list2 = dimensionHierarchy.getHierarchyLevels();
            if (list2.size() > 0) {
                this.setVisible(true);
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_AVAIL_LEVELS");
                String string2 = OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_SELECTED_LEVELS");
                for (DimensionHierarchyLevel dimensionHierarchyLevel : list2) {
                    String string3 = dimensionHierarchyLevel.getLevelName();
                    arrayList.add(string3);
                }
                this.multiSelectEditor = new MultiSelectShuttlePanel(arrayList, string, string2);
                list = this.getDefaultLevelSelection(dimensionHierarchy);
            } else {
                this.setVisible(false);
            }
        }
        this.setValue(list);
    }

    private List<String> getDefaultLevelSelection(DimensionHierarchy dimensionHierarchy) {
        List<DimensionHierarchyLevel> list = dimensionHierarchy.getHierarchyLevels();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list.size() > 0) {
            arrayList.add(list.get(0).getLevelName());
        }
        return arrayList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof DimensionHierarchy) {
            DimensionHierarchy dimensionHierarchy = (DimensionHierarchy)propertyChangeEvent.getNewValue();
            this.setHierarchy(dimensionHierarchy);
        }
    }

    @Override
    public void setDefault(String string) {
        if (string == null) {
            super.setDefault(string);
        }
    }

    @Override
    public String getExpression(String string) {
        if (string.equalsIgnoreCase("quoted")) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.selections.iterator();
            if (iterator.hasNext()) {
                stringBuilder.append("'" + (String)iterator.next() + "'");
                while (iterator.hasNext()) {
                    stringBuilder.append(',');
                    stringBuilder.append("'" + (String)iterator.next() + "'");
                }
            }
            return stringBuilder.toString();
        }
        return super.getExpression();
    }

    @Override
    public void init() {
        String string;
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    static {
        pattern.add(new ParseNode("hierarchy_levels", Type.LEVEL.toString(), ParseNode.PatternType.NONE));
    }
}

