/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import oracle.olap.OLAPArb;
import oracle.olap.build.BuildObject;

public class BuildObjectsTableModel
extends DefaultTableModel {
    public static final int NAME = 0;
    public static final int TYPE = 1;
    public static final int LOADOPTION = 2;
    public static final int SORT = 3;
    public static final int METHOD = 4;
    public static final int SCRIPT = 5;
    private List<BuildObject> buildObjects = new ArrayList<BuildObject>();
    private static final String[] COL_NAMES = new String[]{OLAPArb.get("BUILD_WIZARD_REF_METHODS_OBJ_NAME_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_OBJ_TYPE_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADOPTIONS_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_SORT_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_METHOD_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_SCRIPT_LABEL")};

    public BuildObjectsTableModel() {
        super(COL_NAMES, 0);
    }

    public void setBuildObjectsList(List<BuildObject> list) {
        if (!this.buildObjects.isEmpty()) {
            super.setRowCount(0);
            this.buildObjects = new ArrayList<BuildObject>();
        }
        this.buildObjects.addAll(list);
        for (BuildObject buildObject : list) {
            String string = buildObject.getName();
            String string2 = buildObject.getInlineBuildSpecification();
            if (!string2.isEmpty()) {
                string = string + " USING(" + string2 + ")";
            }
            String string3 = this.getBuildType(buildObject);
            String string4 = this.getBuildLoadOption(buildObject);
            String string5 = this.getBuildRefreshMethod(buildObject);
            Object[] objectArray = new Object[]{string, string3, string4, buildObject.isSortOn(), string5, buildObject.getCubeScriptName()};
            this.addRow(objectArray);
        }
        this.fireTableDataChanged();
    }

    private String getBuildType(BuildObject buildObject) {
        String string = buildObject.getType();
        boolean bl = buildObject.isMVOn();
        if (bl) {
            if (string.equalsIgnoreCase("CUBE")) {
                string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBEMV_LABEL");
            } else if (string.equalsIgnoreCase("CUBE DIMENSION")) {
                string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIMMV_LABEL");
            }
        } else if (string.equalsIgnoreCase("CUBE")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_LABEL");
        } else if (string.equalsIgnoreCase("CUBE DIMENSION")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIM_LABEL");
        }
        return string;
    }

    private String getBuildLoadOption(BuildObject buildObject) {
        String string = buildObject.getLoadOption();
        if (string.equalsIgnoreCase("SYNCH")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL");
        } else if (string.equalsIgnoreCase("NOSYNCH")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL");
        } else if (string.equalsIgnoreCase("RETAIN")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL");
        }
        return string;
    }

    private String getBuildRefreshMethod(BuildObject buildObject) {
        String string = buildObject.getRefreshMethod();
        if (string.equalsIgnoreCase("C")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL");
        } else if (string.equalsIgnoreCase("F")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_FAST_LABEL");
        } else if (string.equalsIgnoreCase("?")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL");
        } else if (string.equalsIgnoreCase("P")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_PCT_LABEL");
        } else if (string.equalsIgnoreCase("S")) {
            string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL");
        }
        return string;
    }

    @Override
    public void moveRow(int n, int n2, int n3) {
        if (n == n2) {
            BuildObject buildObject = this.buildObjects.get(n);
            BuildObject buildObject2 = this.buildObjects.get(n3);
            if (buildObject.getType().equalsIgnoreCase(buildObject2.getType())) {
                Collections.swap(this.buildObjects, n, n3);
                this.fireTableDataChanged();
            } else {
                JOptionPane.showMessageDialog(null, OLAPArb.getString("BUILD_WIZARD_PAGE_SELECT_OBJECTS_ORDER_ERROR"), OLAPArb.getString("BUILD_WIZARD_DLG_TITLE"), 0);
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.buildObjects != null) {
            BuildObject buildObject = this.buildObjects.get(n);
            String string = buildObject.getType();
            String string2 = buildObject.getInlineBuildSpecification();
            switch (n2) {
                case 0: {
                    return false;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return string.equalsIgnoreCase("CUBE DIMENSION") && string2.isEmpty();
                }
                case 3: {
                    return string.equalsIgnoreCase("CUBE DIMENSION") && string2.isEmpty();
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return string.equalsIgnoreCase("CUBE") && string2.isEmpty();
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.buildObjects != null) {
            BuildObject buildObject = this.buildObjects.get(n);
            switch (n2) {
                case 0: {
                    String string = buildObject.getName();
                    String string2 = buildObject.getInlineBuildSpecification();
                    if (!string2.isEmpty()) {
                        string = string + " USING(" + string2 + ")";
                    }
                    return string;
                }
                case 1: {
                    String string = this.getBuildType(buildObject);
                    return string;
                }
                case 2: {
                    String string = this.getBuildLoadOption(buildObject);
                    return string;
                }
                case 3: {
                    boolean bl = buildObject.isSortOn();
                    return bl;
                }
                case 4: {
                    String string = this.getBuildRefreshMethod(buildObject);
                    return string;
                }
                case 5: {
                    String string = buildObject.getCubeScriptName();
                    if (string == null) {
                        string = "";
                    }
                    return string;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.buildObjects != null) {
            BuildObject buildObject = this.buildObjects.get(n);
            switch (n2) {
                case 0: {
                    buildObject.setName((String)object);
                    break;
                }
                case 1: {
                    buildObject.setType((String)object);
                    break;
                }
                case 2: {
                    String string = ((String)object).trim();
                    if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL"))) {
                        string = "SYNCH";
                    } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL"))) {
                        string = "NOSYNCH";
                    } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL"))) {
                        string = "RETAIN";
                    }
                    buildObject.setLoadOption(string);
                    break;
                }
                case 3: {
                    buildObject.setSort((Boolean)object);
                    break;
                }
                case 4: {
                    String string = ((String)object).trim();
                    string = string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL")) ? "C" : (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FAST_LABEL")) ? "F" : (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL")) ? "?" : (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL")) ? "S" : (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_PCT_LABEL")) ? "P" : "C"))));
                    buildObject.setRefreshMethod(string);
                    break;
                }
                case 5: {
                    buildObject.setCubeScriptName((String)object);
                    break;
                }
            }
        }
    }

    public Class getColumnClass(int n) {
        if (n == 3) {
            return Boolean.class;
        }
        return String.class;
    }

    public List<BuildObject> getRowList() {
        return this.buildObjects;
    }
}

