/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.view.ChildNameObjectEditorContext;
import oracle.olap.db.view.ChildObjectEditorPanel2;
import oracle.olap.measureexpression.MeasureExpressionBuilder;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;

public class CubeCalculatedMeasureEditorPanel
extends ChildObjectEditorPanel2<CubeCalculatedMeasure, Cube> {
    private static final Logger LOG = Logger.getLogger(CubeCalculatedMeasureEditorPanel.class.getName());
    private static final String DEFAULT_TYPE = "ADD";
    private JLabel lblName = new JLabel();
    private String calcType = "ADD";
    private JLabel exprLabel = new JLabel(OLAPArb.get("CUBE_CALCULATED_MEASURE_EXPRESSION"));
    private JTextPane exprTextEditor;
    private JButton btnExpEditor;
    private transient DBObjectProvider prov;
    private transient TreeSet<CubeCalculatedMeasure> invalidMeasures = new TreeSet(new DBObjectComparator());

    public CubeCalculatedMeasureEditorPanel() {
        super("CubeCalculatedMeasureEditorPanel", "CALCULATED_MEASURE");
        this.lblName.setName("lblName");
        this.exprLabel.setName("exprLabel");
        this.layoutComponents();
    }

    private void initMeasureData() {
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.lblName.setEnabled(false);
            this.getNameField().setEnabled(false);
            this.enableDescriptions(false);
            this.enableExpressEditor(false);
        } else {
            String string = ((CubeCalculatedMeasure)this.getChildObject()).getName();
            if (!this.invalidMeasures.contains(this.getChildObject())) {
                // empty if block
            }
            ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
            childNameObjectEditorContext.setEditingState(1);
            this.getNameField().setText(string);
            this.getNameField().setEnabled(true);
            this.enableDescriptions(true);
            childNameObjectEditorContext.setEditingState(0);
            this.enableExpressEditor(true);
            this.calcType = ((CubeCalculatedMeasure)this.getChildObject()).getCalculatedMeasureType();
            String string2 = ((CubeCalculatedMeasure)this.getChildObject()).getMeasureExpression();
            if (string2 == null) {
                CubeMeasure[] cubeMeasureArray = ((Cube)this.getUpdatedObject()).getMeasures();
                if (cubeMeasureArray.length > 0) {
                    string2 = String.format("%s.%s", this.getUpdatedObject(), cubeMeasureArray[0].getName());
                }
                string2 = cubeMeasureArray.length == 1 ? string2 + String.format(" + %s.%s", this.getUpdatedObject(), cubeMeasureArray[0].getName()) : string2 + String.format(" + %s.%s", this.getUpdatedObject(), cubeMeasureArray[1].getName());
                this.calcType = DEFAULT_TYPE;
            }
            this.exprTextEditor.setText(string2);
        }
        this.validate();
        this.repaint();
    }

    private void enableExpressEditor(boolean bl) {
        this.btnExpEditor.setEnabled(bl);
        this.exprLabel.setEnabled(bl);
        this.exprTextEditor.setEnabled(bl);
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.initMeasure((CubeCalculatedMeasure)this.getChildObject());
    }

    public void commit(CubeCalculatedMeasure cubeCalculatedMeasure) throws TraversalException {
        try {
            this.prov.validateName("CALCULATED_MEASURE", this.getNameField().getText());
        }
        catch (InvalidNameException invalidNameException) {
            this.invalidMeasures.add(cubeCalculatedMeasure);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.invalidMeasures.contains(cubeCalculatedMeasure)) {
            this.invalidMeasures.remove(cubeCalculatedMeasure);
        }
        String string = this.prov.getInternalName(this.getNameField().getText());
        cubeCalculatedMeasure.setName(string);
        String string2 = this.exprTextEditor.getText();
        cubeCalculatedMeasure.setMeasureExpression(string2);
        cubeCalculatedMeasure.setCalculatedMeasureType(this.calcType);
        cubeCalculatedMeasure.setShortDescription(this.getShortDescriptionFld().getText());
        cubeCalculatedMeasure.setLongDescription(this.getLongDescriptionFld().getText());
        cubeCalculatedMeasure.setDescription(this.getDescriptionFld().getText());
    }

    public void initMeasure(CubeCalculatedMeasure cubeCalculatedMeasure) {
        this.initMeasureData();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        CubeCalculatedMeasure cubeCalculatedMeasure = (CubeCalculatedMeasure)this.getChildObject();
        String string = cubeCalculatedMeasure.getName();
        this.commit(cubeCalculatedMeasure);
        Cube cube = cubeCalculatedMeasure.getCube();
        String string2 = cubeCalculatedMeasure.getName();
        if (cube.findCalculatedMeasure(cubeCalculatedMeasure.getName()) == null) {
            cube.addCalculatedMeasure(cubeCalculatedMeasure);
        } else if (!string.equals(string2)) {
            cube.propagateRenameToExpressions(string, string2, true);
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"calculatedMeasures"});
        componentFactory.registerComponent(this.lblName, (Component)this.getNameField(), UIBundle.get((String)"COLUMN_INFO_LABEL_NAME"), "Name", "name");
        this.registerDescriptionFields();
        this.getNameField().setColumns(30);
        this.exprTextEditor = new JTextPane();
        this.exprTextEditor.setName("exprTextEditor");
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(OLAPArb.get("CUBE_CALCULATED_MEASURE_PROPERTIES")));
        int n = 0;
        this.add(this.lblName, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.getNameField(), new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        n = this.layoutDescriptionFields(1);
        this.add(this.exprLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.btnExpEditor = new JButton(new AbstractAction(OLAPArb.get("EXPRESSION_EDITOR_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CubeCalculatedMeasureEditorPanel.this.exprTextEditor.getText();
                Cube cube = (Cube)CubeCalculatedMeasureEditorPanel.this.getUpdatedObject();
                OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)CubeCalculatedMeasureEditorPanel.this.getProvider();
                Connection connection = oracleDatabaseImpl.getConnection();
                try {
                    SyntaxBuilderPanel syntaxBuilderPanel = MeasureExpressionBuilder.createBuilder(cube, string, connection);
                    string = SyntaxBuilderLauncher.spawnDialog(syntaxBuilderPanel);
                    if (string != null) {
                        CubeCalculatedMeasureEditorPanel.this.exprTextEditor.setText(string);
                        Template template = syntaxBuilderPanel.getMatchingTemplate();
                        if (template != null) {
                            CubeCalculatedMeasureEditorPanel.this.calcType = template.getType();
                        } else {
                            CubeCalculatedMeasureEditorPanel.this.calcType = "FREE_FORM";
                        }
                    }
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        });
        this.btnExpEditor.setName("btnExpEditor");
        this.add(this.btnExpEditor, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.exprTextEditor);
        jScrollPane.setName("sp");
        this.add(jScrollPane, new GridBagConstraints(0, ++n, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        ++n;
    }
}

