/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor.folding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.util.Service;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.javatools.editor.language.NumberRange;
import oracle.olap.dml.editor.folding.TypedFoldingBlock;
import oracle.olap.dml.editor.insight.OLAPDMLAutoformat;
import oracle.olap.dml.parser.OLAPDMLBackgroundParser;
import oracle.olap.dml.parser.OLAPDMLLazyNode;
import oracle.olap.dml.parser.OLAPDMLLexerToken;
import oracle.olap.dml.parser.OLAPDMLParserEventListener;
import oracle.olap.dml.parser.OLAPDMLStackParser;

public class OLAPDMLFoldingModel
extends DefaultCodeFoldingModel
implements OLAPDMLParserEventListener {
    private static final int threshold = 2;

    public OLAPDMLFoldingModel(BasicDocument basicDocument, OLAPDMLBackgroundParser oLAPDMLBackgroundParser) {
        super(basicDocument);
        oLAPDMLBackgroundParser.addParserEventListener(this);
        oLAPDMLBackgroundParser.addParserEventListener(new OLAPDMLAutoformat());
        BasicDocument basicDocument2 = this.getDocument();
        TextBuffer textBuffer = basicDocument2.getTextBuffer();
        textBuffer.readLock();
        this.setRoot(new TypedFoldingBlock(0, textBuffer.getLength(), "", null));
        textBuffer.readUnlock();
    }

    public void reload(int n, int n2) {
        TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)this.getRoot();
        OLAPDMLFoldingModel.updateFoldingBlock(typedFoldingBlock, n, n2);
        super.reload();
    }

    private static void updateFoldingBlock(TypedFoldingBlock typedFoldingBlock, int n, int n2) {
        if (typedFoldingBlock.getStartOffset() >= n) {
            typedFoldingBlock.setStartOffset(typedFoldingBlock.getStartOffset() + n2);
        }
        if (typedFoldingBlock.getEndOffset() >= n) {
            typedFoldingBlock.setEndOffset(typedFoldingBlock.getEndOffset() + n2);
        }
        LinkedList<TypedFoldingBlock> linkedList = new LinkedList<TypedFoldingBlock>();
        Iterator iterator = typedFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            TypedFoldingBlock typedFoldingBlock2 = (TypedFoldingBlock)iterator.next();
            if (n2 < 0 && n <= typedFoldingBlock2.getStartOffset() && typedFoldingBlock2.getStartOffset() < n - n2) {
                linkedList.add(typedFoldingBlock2);
                continue;
            }
            OLAPDMLFoldingModel.updateFoldingBlock(typedFoldingBlock2, n, n2);
        }
        for (TypedFoldingBlock typedFoldingBlock2 : linkedList) {
            typedFoldingBlock.remove((FoldingBlock)typedFoldingBlock2);
        }
    }

    static void walkParseTree(String string, LineMap lineMap, OLAPDMLLazyNode oLAPDMLLazyNode, List<LexerToken> list, TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, OLAPDMLLazyNode oLAPDMLLazyNode2, ArrayList<NumberRange> arrayList, int n) {
        TypedFoldingBlock typedFoldingBlock3 = typedFoldingBlock;
        if (oLAPDMLLazyNode == null) {
            return;
        }
        if (oLAPDMLLazyNode.isStmt(oLAPDMLLazyNode2) || oLAPDMLLazyNode.isProcedure()) {
            int n2;
            int n3;
            Object object = list.get(oLAPDMLLazyNode.from);
            int n4 = n3 = ((LexerToken)object).begin;
            object = list.get(oLAPDMLLazyNode.to - 1);
            int n5 = n2 = ((LexerToken)object).end;
            for (NumberRange numberRange : arrayList) {
                if (n4 >= numberRange.start) {
                    n4 += numberRange.end - numberRange.start;
                }
                if (n5 < numberRange.start) continue;
                n5 += numberRange.end - numberRange.start;
            }
            int n6 = OLAPDMLFoldingModel.lineDiff(lineMap, n4, n5);
            if (n6 > 2) {
                TypedFoldingBlock typedFoldingBlock4;
                int n7 = string.length() - n3 < 127 ? string.length() : n3 + 128;
                String string2 = string.substring(n3, n7);
                int n8 = string2.indexOf(10);
                if (n8 > 0) {
                    string2 = string2.substring(0, n8);
                }
                typedFoldingBlock3 = new TypedFoldingBlock(n4, n5, string2 + "...", oLAPDMLLazyNode);
                typedFoldingBlock.add((FoldingBlock)typedFoldingBlock3);
                if (typedFoldingBlock2 != null && (typedFoldingBlock4 = OLAPDMLFoldingModel.searchShiftedBlock(typedFoldingBlock2, typedFoldingBlock3, n)) != null) {
                    typedFoldingBlock3.setExpanded(typedFoldingBlock4.isExpanded());
                }
            }
        }
        for (ParseNode parseNode : oLAPDMLLazyNode.shallowChildren()) {
            OLAPDMLFoldingModel.walkParseTree(string, lineMap, (OLAPDMLLazyNode)parseNode, list, typedFoldingBlock3, typedFoldingBlock2, oLAPDMLLazyNode2, arrayList, n);
        }
    }

    private static void walkParseTree(String string, LineMap lineMap, ParseNode parseNode, List<LexerToken> list, TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, ArrayList<NumberRange> arrayList, int n) {
        TypedFoldingBlock typedFoldingBlock3 = typedFoldingBlock;
        if (parseNode == null) {
            return;
        }
        if (parseNode.contains(IdentifiersDb.instance.subquery)) {
            int n2;
            int n3;
            LexerToken lexerToken = list.get(parseNode.from);
            int n4 = n3 = lexerToken.begin;
            lexerToken = list.get(parseNode.to - 1);
            int n5 = n2 = lexerToken.end;
            for (NumberRange numberRange : arrayList) {
                if (n4 >= numberRange.start) {
                    n4 += numberRange.end - numberRange.start;
                }
                if (n5 < numberRange.start) continue;
                n5 += numberRange.end - numberRange.start;
            }
            int n6 = OLAPDMLFoldingModel.lineDiff(lineMap, n4, n5);
            if (n6 > 2) {
                TypedFoldingBlock typedFoldingBlock4;
                int n7 = string.length() - n3 < 127 ? string.length() : n3 + 128;
                String string2 = string.substring(n3, n7);
                int n8 = string2.indexOf(10);
                if (n8 > 0) {
                    string2 = string2.substring(0, n8);
                }
                typedFoldingBlock3 = new TypedFoldingBlock(n4, n5, string2 + "...", parseNode);
                typedFoldingBlock.add((FoldingBlock)typedFoldingBlock3);
                if (typedFoldingBlock2 != null && (typedFoldingBlock4 = OLAPDMLFoldingModel.searchShiftedBlock(typedFoldingBlock2, typedFoldingBlock3, n)) != null) {
                    typedFoldingBlock3.setExpanded(typedFoldingBlock4.isExpanded());
                }
            }
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            OLAPDMLFoldingModel.walkParseTree(string, lineMap, parseNode2, list, typedFoldingBlock3, typedFoldingBlock2, arrayList, n);
        }
    }

    private static int lineDiff(LineMap lineMap, int n, int n2) {
        int n3 = lineMap.getLineFromOffset(n);
        int n4 = lineMap.getLineFromOffset(n2);
        return n4 - n3;
    }

    public static void print(DefaultFoldingBlock defaultFoldingBlock, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println("[" + defaultFoldingBlock.getStartOffset() + "," + defaultFoldingBlock.getEndOffset() + ") " + defaultFoldingBlock.getClass().getName());
        Iterator iterator = defaultFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            OLAPDMLFoldingModel.print((TypedFoldingBlock)iterator.next(), n + 1);
        }
    }

    private static boolean isShifted(TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, int n) {
        if (typedFoldingBlock2.getStartOffset() - typedFoldingBlock.getStartOffset() == n && typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset() == n) {
            return true;
        }
        return typedFoldingBlock2.getStartOffset() - typedFoldingBlock.getStartOffset() == 0 && typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset() == 0;
    }

    public static TypedFoldingBlock searchShiftedBlock(TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, int n) {
        if (OLAPDMLFoldingModel.isShifted(typedFoldingBlock, typedFoldingBlock2, n)) {
            return typedFoldingBlock;
        }
        Iterator iterator = typedFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            TypedFoldingBlock typedFoldingBlock3 = (TypedFoldingBlock)iterator.next();
            TypedFoldingBlock typedFoldingBlock4 = OLAPDMLFoldingModel.searchShiftedBlock(typedFoldingBlock3, typedFoldingBlock2, n);
            if (typedFoldingBlock4 == null) continue;
            return typedFoldingBlock4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(OLAPDMLBackgroundParser oLAPDMLBackgroundParser) {
        TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)this.getRoot();
        TypedFoldingBlock typedFoldingBlock2 = new TypedFoldingBlock(0, oLAPDMLBackgroundParser.text != null ? oLAPDMLBackgroundParser.text.length() : 0, "", null);
        int n = typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset();
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.readLock();
        LineMap lineMap = null;
        try {
            lineMap = textBuffer.getLineMap();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            return;
        }
        finally {
            textBuffer.readUnlock();
        }
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        for (LexerToken lexerToken : oLAPDMLBackgroundParser.src) {
            arrayList.add(lexerToken);
        }
        OLAPDMLFoldingModel.walkParseTree(oLAPDMLBackgroundParser.text, lineMap, oLAPDMLBackgroundParser.output, arrayList, typedFoldingBlock2, typedFoldingBlock, oLAPDMLBackgroundParser.output, oLAPDMLBackgroundParser.increments, n);
        this.setRoot(typedFoldingBlock2);
        OLAPDMLFoldingModel.super.reload();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(OLAPDMLStackParser.class, (String)"test.sql");
        long l = System.currentTimeMillis();
        List<LexerToken> list = OLAPDMLLexerToken.parse(string);
        long l2 = System.currentTimeMillis();
        System.out.println("time = " + (l2 - l));
        OLAPDMLLazyNode oLAPDMLLazyNode = OLAPDMLStackParser.parse(list);
    }
}

