/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.syntaxparser.SyntaxTokenListener;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.syntaxbuilder.olapihelpers.test.SyntaxFormat;
import oracle.olap.syntaxbuilder.olapihelpers.test.SyntaxTest;
import oracle.olap.util.LogFileHandler;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXException;

public class OLAPSyntaxFormatter
implements SyntaxTokenListener {
    private static final Logger LOG = Logger.getLogger(OLAPSyntaxFormatter.class.getName());
    private static final int LINE_LENGTH = 80;
    private static final String INDENT_STRING = "   ";
    private static final String INDENT_HTML_STRING = "&nbsp;&nbsp;&nbsp;";
    private String indentString = "   ";
    private String lineBreak = "\n";
    private String newExpression;
    private boolean tokenHandled;
    private int indent;
    private LinkedList<String> tokens = new LinkedList();
    private LinkedList<State> states = new LinkedList();
    private boolean newLineInserted;
    private int length;
    private int lineLength;
    private Properties props;

    private void pushState(int n, int n2, S s) {
        this.states.push(new State(n, n2, s));
    }

    private void pushState(int n, S s) {
        this.pushState(this.indent, n, s);
    }

    private void insertIndent(State state) {
        StringBuilder stringBuilder = new StringBuilder(this.indentString.length() * state.indent + 1);
        stringBuilder.append(this.lineBreak);
        this.newLineInserted = true;
        for (int i = 0; i < state.indent; ++i) {
            stringBuilder.append(this.indentString);
        }
        this.tokens.add(state.token, stringBuilder.toString());
        this.lineLength = stringBuilder.length();
    }

    @Override
    public void processToken(String string, String string2, int n) {
        this.lineLength += string.length();
        this.process(string, string2, n);
    }

    private void process(String string, String string2, int n) {
        S s = S.NONE;
        this.newLineInserted = false;
        Type type = Type.valueFrom(string2);
        if (!this.states.isEmpty()) {
            s = this.states.peek().s;
        }
        StringBuilder stringBuilder = new StringBuilder(this.states.size() * 12);
        for (State state : this.states) {
            stringBuilder.append(state);
            stringBuilder.append(' ');
        }
        LOG.finest(String.format("'%s',tp=%s,st=%d,i=%d,lL=%d,tk=%d,%s%n", new Object[]{string, type, this.states.size(), this.indent, this.lineLength, this.tokens.size(), stringBuilder.toString()}));
        this.tokenHandled = false;
        if (string.equalsIgnoreCase("OVER")) {
            if (s == S.NEWLINE) {
                this.states.pop();
                this.process(string, string2, n);
            } else {
                if (s == S.CLOSEPAREN) {
                    this.closeParen();
                }
                int n2 = this.append(" ", string, " ");
                this.pushState(this.indent + 1, n2, S.LLINDENT);
                this.pushState(n2, S.OVER);
            }
        } else if (string.equalsIgnoreCase("CASE")) {
            if (s == S.NEWLINE) {
                this.states.pop();
                this.process(string, string2, n);
            } else {
                this.pushState(this.append(string, " "), S.CASE);
            }
        } else {
            if (type == Type.NEWLINE) {
                if (s != S.NEWLINE) {
                    this.pushState(-1, S.NEWLINE);
                }
                this.tokenHandled = true;
                return;
            }
            if (this.isCloseParen(string)) {
                if (this.tokens.getLast().equals(" ")) {
                    this.tokens.removeLast();
                    --this.lineLength;
                }
                this.pushState(this.append(string), S.CLOSEPAREN);
                if ("]".equals(string)) {
                    this.closeParen();
                }
            } else {
                State state;
                switch (s) {
                    case OVER: {
                        this.states.pop();
                        this.process(string, string2, n);
                        break;
                    }
                    case NEWLINE: {
                        this.states.pop();
                        if (type == Type.LINE_COMMENT) {
                            this.lineLength = 0;
                            this.append(this.lineBreak);
                        }
                        this.process(string, string2, n);
                        this.tokenHandled = true;
                        break;
                    }
                    case FLIP: {
                        if (!this.isOpenParen(string)) break;
                        int n3 = this.states.peek().token;
                        this.tokens.add(n3, string);
                        this.states.pop();
                        this.tokenHandled = true;
                        this.pushState(this.tokens.size(), S.PAREN1);
                        break;
                    }
                    case CLOSEPAREN: {
                        if (this.isOpenParen(string)) {
                            this.pushState(this.append(string), S.PAREN1);
                            break;
                        }
                        this.closeParen();
                        this.pushState(this.indent(string, " "), S.OPERATOR);
                        break;
                    }
                    case PAREN1: {
                        Object object;
                        if (type == Type.FUNCTION) {
                            object = this.states.pop();
                            this.pushState(-1, S.DEINDENT);
                            ++this.indent;
                            this.pushState(this.indent(string), S.PAREN);
                            break;
                        }
                        object = this.states.pop();
                        this.pushState(((State)object).token, S.PAREN);
                        this.append(string, " ");
                        break;
                    }
                    case PAREN: 
                    case WITHIN: {
                        Object object;
                        if (this.isOpenParen(string)) {
                            this.pushState(this.append(string), S.PAREN1);
                            break;
                        }
                        if (!this.isOpenParen(string) && type == Type.FUNCTION) {
                            object = this.states.pop();
                            this.pushState(-1, S.DEINDENT);
                            ++this.indent;
                            this.pushState(this.indent(string), S.PAREN);
                            break;
                        }
                        if (!string.equalsIgnoreCase("BETWEEN") && !string.equalsIgnoreCase("WITHIN") && !string.equalsIgnoreCase("POSITION")) break;
                        this.pushState(-1, S.DEINDENT);
                        int n4 = this.append(string, " ");
                        this.pushState(this.indent, n4, S.WITHIN);
                        this.pushState(this.indent + 2, n4, S.LLINDENT2);
                        break;
                    }
                    case LLINDENT: {
                        if (this.lineLength > 80) {
                            this.insertIndent(this.states.pop());
                            this.process(string, string2, n);
                            this.pushState(this.indent + 2, -1, S.LLINDENT3);
                            break;
                        }
                        if (!this.isOpenParen(string)) break;
                        this.pushState(this.append(string), S.PAREN1);
                        break;
                    }
                    case LLINDENT2: {
                        Object object;
                        if (this.lineLength > 80) {
                            object = new LinkedList();
                            while (!this.states.isEmpty()) {
                                state = this.states.pop();
                                if (state.s == S.LLINDENT) {
                                    this.insertIndent(state);
                                    break;
                                }
                                if (state.s == S.LLINDENT2) {
                                    this.insertIndent(state);
                                    continue;
                                }
                                ((LinkedList)object).addFirst(state);
                            }
                            Iterator iterator = ((AbstractSequentialList)object).iterator();
                            while (iterator.hasNext()) {
                                State state2 = (State)iterator.next();
                                this.states.push(state2);
                            }
                            this.pushState(this.indent + 2, -1, S.LLINDENT3);
                            this.process(string, string2, n);
                            break;
                        }
                        object = this.states.pop();
                        this.process(string, string2, n);
                        if (this.newLineInserted) break;
                        this.states.push((State)object);
                        break;
                    }
                    case LLINDENT3: {
                        Object object = this.states.pop();
                        if (string.equalsIgnoreCase("BETWEEN") || string.equalsIgnoreCase("WITHIN") || string.equalsIgnoreCase("POSITION")) {
                            this.indent(((State)object).indent, string, " ");
                        } else {
                            this.process(string, string2, n);
                        }
                        this.states.push((State)object);
                        break;
                    }
                    case DEINDENT: {
                        if (this.isOpenParen(string)) {
                            state = this.states.pop();
                            this.indent = state.indent;
                            this.pushState(this.indent(string), S.PAREN1);
                            break;
                        }
                        state = this.states.pop();
                        this.indent = state.indent;
                        this.indent(string, " ");
                        break;
                    }
                    case CASE: {
                        if (string.equalsIgnoreCase("WHEN")) {
                            ++this.indent;
                            this.pushState(this.indent(string, " "), S.WHEN);
                            break;
                        }
                        if (!string.equalsIgnoreCase("END")) break;
                        this.popUntil(S.CASE, true, string, " ");
                        break;
                    }
                    case WHEN: {
                        if (string.equalsIgnoreCase("THEN")) {
                            ++this.indent;
                            this.pushState(this.indent(string, " "), S.THEN);
                            break;
                        }
                        if (!string.equalsIgnoreCase("END")) break;
                        this.popUntil(S.CASE, true, string, " ");
                        break;
                    }
                    case THEN: {
                        if (string.equalsIgnoreCase("WHEN") || string.equalsIgnoreCase("ELSE")) {
                            this.popUntil(S.WHEN, false, string);
                            this.append(" ");
                            break;
                        }
                        if (!string.equalsIgnoreCase("END")) break;
                        this.popUntil(S.CASE, true, string);
                        this.append(" ");
                        break;
                    }
                    case OPERATOR: {
                        this.states.pop();
                        if (type == Type.FUNCTION || this.lineLength > 80) {
                            this.indent(string);
                            break;
                        }
                        this.process(string, string2, n);
                        this.tokenHandled = true;
                        break;
                    }
                    default: {
                        if (this.isOpenParen(string)) {
                            this.pushState(this.append(string), S.PAREN1);
                            break;
                        }
                        if (type != Type.OPERATOR) break;
                        this.pushState(this.append(string, " "), S.OPERATOR);
                    }
                }
            }
        }
        if (!this.tokenHandled) {
            if (type == Type.LINE_COMMENT) {
                this.append(string);
                this.lineLength = 0;
                this.spaces(this.indent);
            } else {
                this.append(string, " ");
            }
        }
    }

    private boolean isOpenParen(String string) {
        return "(".equals(string) || "[".equals(string);
    }

    private boolean isCloseParen(String string) {
        return ")".equals(string) || "]".equals(string);
    }

    private void closeParen() {
        if (this.states.isEmpty()) {
            return;
        }
        State state = this.states.pop();
        LinkedList linkedList = new LinkedList();
        int n = 0;
        int n2 = 0;
        while (!this.states.isEmpty()) {
            switch (state.s) {
                case CLOSEPAREN: {
                    ++n2;
                    break;
                }
                case PAREN1: 
                case PAREN: {
                    ++n;
                    break;
                }
                case DEINDENT: {
                    this.indent = state.indent;
                }
            }
            if (n == n2) break;
            state = this.states.pop();
        }
        if (this.states.size() != 0 && this.states.peek().s == S.LLINDENT) {
            this.states.pop();
        }
        while (this.states.size() != 0 && this.states.peek().s == S.DEINDENT) {
            state = this.states.pop();
        }
        this.indent = state.indent;
    }

    private void popUntil(S s, boolean bl, String ... stringArray) {
        if (this.states.isEmpty()) {
            return;
        }
        State state = this.states.peek();
        while (this.states.size() != 0) {
            if (state.s == s) {
                this.indent = state.indent;
                this.indent(stringArray);
                if (!bl) break;
                this.states.pop();
                break;
            }
            this.states.pop();
            state = this.states.peek();
        }
    }

    public void setProps(Properties properties) {
        this.props = properties;
        if (properties != null) {
            Boolean bl = (Boolean)properties.get("HTML");
            this.indentString = INDENT_STRING;
            if (bl != null && bl.booleanValue()) {
                this.indentString = INDENT_HTML_STRING;
                this.lineBreak = "<br>";
            }
        }
    }

    public void clear() {
        this.indent = 0;
        this.tokens.clear();
        this.newLineInserted = false;
        this.length = 0;
        this.lineLength = 0;
        this.states.clear();
    }

    public String getFormattedSyntax() {
        Boolean bl;
        if (this.tokens.isEmpty()) {
            return this.newExpression;
        }
        StringBuilder stringBuilder = new StringBuilder(this.length);
        while (!this.tokens.isEmpty()) {
            stringBuilder.append(this.tokens.poll());
        }
        this.newExpression = stringBuilder.toString();
        this.clear();
        if (this.props != null && (bl = (Boolean)this.props.get("HTML")) != null && bl.booleanValue()) {
            this.newExpression = "<html>" + this.newExpression + "</html>";
        }
        return this.newExpression;
    }

    private int append(String ... stringArray) {
        this.tokenHandled = true;
        int n = this.tokens.size();
        for (String string : stringArray) {
            this.tokens.add(string);
            this.length += string.length();
        }
        return n;
    }

    private int indent(String ... stringArray) {
        return this.indent(this.indent, stringArray);
    }

    private int indent(int n, String ... stringArray) {
        this.append(this.lineBreak);
        this.newLineInserted = true;
        this.lineLength = 0;
        this.spaces(n);
        return this.append(stringArray);
    }

    private void spaces(int n) {
        for (int i = 0; i < n; ++i) {
            this.append(this.indentString);
            this.lineLength += this.indentString.length();
        }
    }

    private void discardLLINDENT() {
        Iterator iterator = this.states.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            if (state.s != S.LLINDENT && state.s != S.LLINDENT2 && state.s != S.LLINDENT3) continue;
            iterator.remove();
            ++n;
        }
    }

    public static void test1(String string) throws FileNotFoundException, IOException, SQLException, XMLParseException, SAXException, ParserConfigurationException, Exception {
        OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(null, new Properties());
        InputStream inputStream = OLAPSyntaxFormatter.class.getResourceAsStream("test/calcsyntax.xml");
        SyntaxTest syntaxTest = (SyntaxTest)JavaXMLBind.BindToJava(new InputStreamReader(inputStream), "oracle.olap.syntaxbuilder.olapihelpers.test", (Object)oLAPISyntaxParser);
        int n = 0;
        for (SyntaxFormat syntaxFormat : syntaxTest.getSyntaxFormats()) {
            String string2;
            String string3 = syntaxFormat.getUnformatted().getText();
            String string4 = syntaxFormat.getFormatted().getText().trim();
            if (!string4.equals(string2 = oLAPISyntaxParser.formatSyntax(string3).trim())) {
                System.out.println(String.format("** Failed on %d ** ", n));
                System.out.println(String.format("################### Should be ############# ", n));
                System.out.println(string4);
                System.out.println(String.format("\n\n\n################### was ############# ", n));
                System.out.println(string2);
            } else {
                System.out.println(String.format("** Success on %d ** ", n));
            }
            FileWriter fileWriter = new FileWriter(string + n);
            fileWriter.write(string2);
            fileWriter.close();
            ++n;
        }
        inputStream.close();
        System.out.println("Finished Tests");
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, SQLException, XMLParseException, SAXException, ParserConfigurationException, Exception {
        String string;
        String string2;
        String string3 = System.getProperty("user.home");
        if (string3 == null) {
            string2 = "calcsyntax.out";
            string = "calcsyntax.log";
        } else {
            string2 = string3 + "/calcsyntax.out";
            string = string3 + "/calcsyntax.log";
        }
        LogFileHandler logFileHandler = new LogFileHandler(string);
        LOG.addHandler(logFileHandler);
        LOG.setLevel(Level.ALL);
        OLAPSyntaxFormatter.test1(string2);
        ((Handler)logFileHandler).close();
    }

    static enum S {
        NONE,
        OVER,
        LLINDENT,
        LLINDENT2,
        LLINDENT3,
        DEINDENT,
        OPERATOR,
        PAREN1,
        PAREN,
        CLOSEPAREN,
        WITHIN,
        CASE,
        THEN,
        WHEN,
        FLIP,
        NEWLINE;

    }

    private static class State {
        int indent;
        int token;
        S s;

        State(int n, int n2, S s) {
            this.indent = n;
            this.token = n2;
            this.s = s;
        }

        public String toString() {
            return this.s.toString();
        }
    }
}

