/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration.ant.task;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.TaskUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;

public abstract class PathCollection {
    private final Union resources = new Union();

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public Set<File> getResources() throws BuildException {
        HashSet<File> set = new HashSet<File>(this.resources.size());
        for (ResourceCollection rc : this.resources) {
            String msg = this.validateResource(rc);
            if (msg != null) {
                throw new BuildException(msg);
            }
            set.add(this._getFile(rc));
        }
        return set;
    }

    protected String validateResource(ResourceCollection rc) {
        if (!(rc instanceof FileResource)) {
            return rc.toString() + " " + "not a valid file resource type!";
        }
        File f = this._getFile(rc);
        String url = f.getAbsolutePath();
        String msg = TaskUtils.validateResource(url, this.isDirectory());
        if (msg != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Issue validating resource");
            sb.append(" ");
            sb.append(url);
            sb.append(" ");
            sb.append("in");
            sb.append(" ");
            sb.append(this.getElementName());
            sb.append(":");
            sb.append(" ");
            sb.append(msg);
            return sb.toString();
        }
        return null;
    }

    protected boolean isDirectory() {
        return false;
    }

    protected final String getElementName() {
        return "<" + this.getElementNameImpl() + ">";
    }

    protected abstract String getElementNameImpl();

    private File _getFile(ResourceCollection rc) {
        FileResource fr = (FileResource)rc;
        return fr.getFile();
    }
}

