/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Node;

public final class DynamicProxyContext {
    private boolean _expired;
    private final XmlModel _model;
    private final Node _node;
    private final XmlKey _key;
    private final ClassLoader _loader;
    private final List<DynamicProxyContext> _associatedContexts = new ArrayList<DynamicProxyContext>();

    public DynamicProxyContext(XmlModel model, Node node, XmlKey key, ClassLoader loader) {
        if (model == null || node == null || key == null || loader == null) {
            throw new IllegalArgumentException("DynamicProxyContext passed a null argument");
        }
        this._expired = false;
        this._model = model;
        this._node = node;
        this._key = key;
        this._loader = loader;
    }

    public void addAssociatedContext(DynamicProxyContext context) {
        this._associatedContexts.add(context);
    }

    public boolean isExpired() {
        return this._expired;
    }

    public void setExpired() {
        this._expired = true;
        for (DynamicProxyContext context : this._associatedContexts) {
            context.setExpired();
        }
    }

    public XmlModel getXmlModel() {
        return this._model;
    }

    public Node getNode() {
        return this._node;
    }

    public XmlKey getXmlKey() {
        return this._key;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public GrammarResolver getGrammarResolver() {
        return this._model.getContext().getGrammarResolver();
    }
}

