/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MapNamedNodeMap
implements NamedNodeMap {
    private short _allowedNodeType;
    private Node _owner;
    private Map _storage;

    public MapNamedNodeMap(Element owner, Map storage) {
        this(owner, 2, storage);
    }

    public MapNamedNodeMap(Node owner, short allowedNodeType, Map storage) {
        if (owner == null) {
            throw new IllegalArgumentException("No owner node specified");
        }
        short nodeType = owner.getNodeType();
        if (nodeType == 1) {
            if (allowedNodeType != 2) {
                throw new IllegalArgumentException("Element nodes such as " + owner + " can only have Attribute NamedNodeMaps");
            }
        } else if (nodeType == 10) {
            if (allowedNodeType != 6 && allowedNodeType != 12) {
                throw new IllegalArgumentException("DocumentType nodes such as " + owner + " can only have Entity or Notation NamedNodeMaps");
            }
        } else {
            throw new IllegalArgumentException("Owning node " + owner + " can't have a NamedNodeMape");
        }
        if (storage == null) {
            throw new IllegalArgumentException("No storage Map provided");
        }
        this._owner = owner;
        this._allowedNodeType = allowedNodeType;
        this._storage = storage;
    }

    @Override
    public Node getNamedItem(String name) {
        return this.getKeyedItem(this.getKey(name));
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        String namespaceURI = node.getNamespaceURI();
        Object key = namespaceURI != null ? QualifiedName.getQualifiedName((String)namespaceURI, (String)DomUtils.getLocalName((Node)node)) : this.getKey(node.getNodeName());
        return this.setKeyedItem(key, node);
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        return this.removeKeyedItem(this.getKey(name));
    }

    @Override
    public Node item(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        for (Object currKey : this._storage.keySet()) {
            if (index == 0) {
                return (Node)this._storage.get(currKey);
            }
            --index;
        }
        throw new IllegalStateException("This should never happen");
    }

    @Override
    public int getLength() {
        return this._storage.size();
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) {
        QualifiedName qName = QualifiedName.getQualifiedName((String)namespaceURI, (String)localName);
        return this.getKeyedItem(qName);
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        QualifiedName qName = QualifiedName.getQualifiedName((String)node.getNamespaceURI(), (String)DomUtils.getLocalName((Node)node));
        return this.setKeyedItem(qName, node);
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        QualifiedName qName = QualifiedName.getQualifiedName((String)namespaceURI, (String)localName);
        return this.removeKeyedItem(qName);
    }

    protected Node getKeyedItem(Object key) {
        return (Node)this._storage.get(key);
    }

    protected Node removeKeyedItem(Object key) {
        Object removedNode;
        try {
            removedNode = this._storage.remove(key);
        }
        catch (UnsupportedOperationException e) {
            throw new DOMException(7, "Can't remove " + key + " from " + this);
        }
        if (removedNode == null) {
            throw new DOMException(8, key + " not found in " + this);
        }
        return (Node)removedNode;
    }

    protected Node setKeyedItem(Object key, Node node) {
        Element owningElement;
        if (node.getOwnerDocument() != this._owner.getOwnerDocument()) {
            throw new DOMException(4, node + " is not in " + this._owner + "'s document");
        }
        if (this._owner.getNodeType() == 1 && (owningElement = ((Attr)node).getOwnerElement()) != null && owningElement != this._owner) {
            throw new DOMException(10, node + " can not be added to " + this._owner + " because it already belongs to " + owningElement);
        }
        if (node.getNodeType() != this._allowedNodeType) {
            throw new DOMException(3, node + "s not allowed in " + this._owner + "'s NamedNodeMap");
        }
        try {
            return this._storage.put(key, node);
        }
        catch (UnsupportedOperationException e) {
            throw new DOMException(7, "Can't set " + node + " on " + this);
        }
    }

    protected boolean hasKeyedItem(Object key) {
        return this._storage.containsKey(key);
    }

    protected final Object getKey(String name) {
        String key = name;
        if (this._allowedNodeType == 2) {
            key = QualifiedName.getQualifiedName((String)name);
        }
        return key;
    }

    protected final Map getStorage() {
        return this._storage;
    }

    protected final Node getOwner() {
        return this._owner;
    }
}

