/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.Collections;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.AbstractPositionTargetingOperation;
import oracle.bali.xml.model.task.NoNameTransactionTask;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.Node;

class CreateFromXmlKeyOperation
extends AbstractPositionTargetingOperation {
    CreateFromXmlKeyOperation() {
    }

    @Override
    public boolean apply(AbstractModel model, final DomPosition pos, TransferDataInfo data, final TransactionToken token) throws IOException, XmlCommitException {
        final XmlKey key = (XmlKey)data.getData(FetchMode.STANDARD, false);
        if (key != null) {
            new NoNameTransactionTask(){

                @Override
                protected void performTask(AbstractModel model) throws XmlCommitException {
                    model.getContext().setTransactionToken(token);
                    Node node = model.insertXmlKey(key, pos);
                    if (node == null) {
                        this.cancelTask();
                    }
                }
            }.runThrowingXCE(model);
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragCreate");
        }
        return model.getTranslatedString("DragCreate_Data", infoDesc);
    }

    @Override
    public float getSuitabilityRank() {
        return 0.9f;
    }

    @Override
    public int getSupportedActions() {
        return 1;
    }

    @Override
    protected boolean isValidData(AbstractModel model, TransferDataInfo info, Object datum) {
        return super.isValidData(model, info, datum) && (datum == null || datum instanceof XmlKey);
    }

    @Override
    protected boolean isValidPosition(AbstractModel model, DomPosition pos, TransferDataInfo info, Object datum) {
        if (!super.isValidPosition(model, pos, info, datum)) {
            return false;
        }
        if (pos == null) {
            return false;
        }
        if (!model.getXmlMetadataResolver().canAddChild(pos)) {
            return false;
        }
        if (datum == null) {
            return true;
        }
        return model.getXmlMetadataResolver().isValidInsertion(pos, Collections.singletonList(datum));
    }

    @Override
    protected DomPosition convertPosition(AbstractModel model, DomPosition originalPos, Object datum) {
        return model.convertInsertionPosition(originalPos);
    }

    @Override
    protected DataFlavor getRequiredDataFlavor() {
        return XmlTransferUtils.FLAVOR_XMLKEY;
    }
}

