/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.xpath;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.util.xpath.XPathEvaluator;
import oracle.bali.xml.util.xpath.XPathNamespaceContext;
import oracle.bali.xml.util.xpath.XPathUtils;
import org.w3c.dom.Node;

public class XPathProvider
implements XPathEvaluator {
    public static final String X_PATH_1_0 = "1.0";
    public static final String X_PATH_2_0 = "2.0";
    private final XPathEvaluator _xPathEvaluator;
    protected final XmlContext _context;

    public XPathProvider(XmlContext context, XPathEvaluator xPathEvaluator) {
        this._context = context;
        this._xPathEvaluator = xPathEvaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNSPrefixesInDoc() {
        XmlModel model = this._context.getModel();
        model.acquireReadLock();
        try {
            Map<String, Set<String>> nsMap = model.getNamespacesInDoc();
            for (Map.Entry<String, Set<String>> entry : nsMap.entrySet()) {
                String namespace = entry.getKey();
                Set<String> set = entry.getValue();
                if (set.isEmpty()) {
                    XmlKey nsKey = ImmutableXmlKey.createNamespaceKey((String)namespace);
                    String prefix = model.getXmlMetadataResolver().getPreferredPrefix(nsKey);
                    if (prefix == null || "".equals(prefix)) {
                        prefix = XPathUtils.getPrefix((String)namespace, (XPathEvaluator)this.getXPathEvaluator());
                    }
                    this.getXPathNamespaceContext().addNamespacePrefix(prefix, namespace);
                    continue;
                }
                for (String prefix : set) {
                    this.getXPathNamespaceContext().addNamespacePrefix(prefix, namespace);
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateXPath(String expression, QName returnType) throws XPathExpressionException {
        XmlModel model = this._context.getModel();
        model.acquireReadLock();
        try {
            Object object = this._xPathEvaluator.evaluateXPath(expression, (Node)model.getDocument(), returnType);
            return object;
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateXPath(String expression, Node subtreeRoot, QName returnType) throws XPathExpressionException {
        XmlModel model = this._context.getModel();
        model.acquireReadLock();
        try {
            Object object = this._xPathEvaluator.evaluateXPath(expression, subtreeRoot, returnType);
            return object;
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCanonicalXPathForNode(Node node) {
        XmlModel model = this._context.getModel();
        model.acquireReadLock();
        try {
            String string = XPathUtils.getCanonicalXPathForNode((Node)node, (XPathEvaluator)this.getXPathEvaluator());
            return string;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public XPathNamespaceContext getXPathNamespaceContext() {
        return this.getXPathEvaluator().getXPathNamespaceContext();
    }

    public void addNamespacePrefix(String prefix, String namespace) {
        this.getXPathEvaluator().addNamespacePrefix(prefix, namespace);
    }

    public void removeNamespacePrefix(String prefix) {
        this.getXPathEvaluator().removeNamespacePrefix(prefix);
    }

    public Map<String, String> getPrefixNamespaceMap() {
        return this.getXPathEvaluator().getPrefixNamespaceMap();
    }

    public void setPrefixNamespaceMap(Map<String, String> prefixNamespaceMap) {
        this.getXPathEvaluator().setPrefixNamespaceMap(prefixNamespaceMap);
    }

    public XPathEvaluator getXPathEvaluator() {
        return this._xPathEvaluator;
    }
}

