/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlBaseItemMapper;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlMapMapperEntry;

public class SqlMapMapper
extends SqlBaseItemMapper<Map<String, Object>> {
    private List<SqlMapMapperEntry> entries;
    private Map<String, Object> resultMap;

    public SqlMapMapper(SqlMapMapperEntry[] sqlMapMapperEntryArray) {
        this.entries = new ArrayList<SqlMapMapperEntry>(Arrays.asList(sqlMapMapperEntryArray));
        this.resultMap = new HashMap<String, Object>();
    }

    @Override
    public Map<String, Object> mapOne(ResultSet resultSet) throws Exception {
        return this.map(resultSet);
    }

    @Override
    public Map<String, Object> map(ResultSet resultSet) throws Exception {
        while (resultSet.next()) {
            this.checkRow(resultSet);
        }
        return this.resultMap;
    }

    private void checkRow(ResultSet resultSet) throws SQLException {
        Iterator<SqlMapMapperEntry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            SqlMapMapperEntry sqlMapMapperEntry = iterator.next();
            String string = resultSet.getString(1);
            if (!sqlMapMapperEntry.getResultSetName().equals(string)) continue;
            Object object = this.getValue(resultSet, sqlMapMapperEntry);
            this.resultMap.put(sqlMapMapperEntry.getMapName(), object);
            iterator.remove();
        }
    }

    private Object getValue(ResultSet resultSet, SqlMapMapperEntry sqlMapMapperEntry) throws SQLException {
        Object object = null;
        if (Integer.class.equals((Object)sqlMapMapperEntry.getDataType())) {
            object = resultSet.getInt(2);
        } else if (Double.class.equals((Object)sqlMapMapperEntry.getDataType())) {
            object = resultSet.getDouble(2);
        } else if (String.class.equals((Object)sqlMapMapperEntry.getDataType())) {
            object = resultSet.getString(2);
        }
        return object;
    }
}

