/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.common.build;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlMapper;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.common.build.MiningAttributeInfo;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;

public class GetMiningModelAttributesMapper
extends SqlMapper<MiningAttributeInfo> {
    private ISqlMapper<MiningAttributeInfo> mapper;
    private Boolean partitionKeyFound;

    public GetMiningModelAttributesMapper(Version version) {
        super(version);
        this.mapper = DbVersionHelper.isDB122Up(version) ? new Mapper122() : new MapperOriginal();
    }

    @Override
    public MiningAttributeInfo map(ResultSet resultSet) throws Exception {
        MiningAttributeInfo miningAttributeInfo = this.mapper.map(resultSet);
        miningAttributeInfo.setAttributeName(resultSet.getString("ATTRIBUTE_NAME"));
        miningAttributeInfo.setAttributeType(resultSet.getString("ATTRIBUTE_TYPE"));
        miningAttributeInfo.setDataType(resultSet.getString("DATA_TYPE"));
        miningAttributeInfo.setDataLength(resultSet.getBigDecimal("DATA_LENGTH"));
        miningAttributeInfo.setDataPrecision(resultSet.getBigDecimal("DATA_PRECISION"));
        miningAttributeInfo.setDataScale(resultSet.getBigDecimal("DATA_SCALE"));
        miningAttributeInfo.setUsageType(resultSet.getString("USAGE_TYPE"));
        miningAttributeInfo.setTarget(resultSet.getString("TARGET"));
        return miningAttributeInfo;
    }

    private class Mapper122
    implements ISqlMapper<MiningAttributeInfo> {
        private Mapper122() {
        }

        @Override
        public MiningAttributeInfo map(ResultSet resultSet) throws Exception {
            MiningAttributeInfo miningAttributeInfo = new MiningAttributeInfo();
            miningAttributeInfo.setAttributeSubName(resultSet.getString("ATTRIBUTE_SUBNAME"));
            miningAttributeInfo.setExpression(DbMetadataUtils.clobToStringBuilder(resultSet.getClob("EXPRESSION")));
            miningAttributeInfo.setRevExpression(DbMetadataUtils.clobToStringBuilder(resultSet.getClob("REVERSE_EXPRESSION")));
            if (this.partitionKeyFound(resultSet)) {
                miningAttributeInfo.setPartitionKey(resultSet.getString("PARTITION_KEY"));
            }
            return miningAttributeInfo;
        }

        private boolean partitionKeyFound(ResultSet resultSet) throws SQLException {
            if (GetMiningModelAttributesMapper.this.partitionKeyFound == null) {
                GetMiningModelAttributesMapper.this.partitionKeyFound = false;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    if (!"PARTITION_KEY".equals(resultSetMetaData.getColumnName(i))) continue;
                    GetMiningModelAttributesMapper.this.partitionKeyFound = true;
                    break;
                }
            }
            return GetMiningModelAttributesMapper.this.partitionKeyFound;
        }
    }

    private class MapperOriginal
    implements ISqlMapper<MiningAttributeInfo> {
        private MapperOriginal() {
        }

        @Override
        public MiningAttributeInfo map(ResultSet resultSet) throws Exception {
            MiningAttributeInfo miningAttributeInfo = new MiningAttributeInfo();
            return miningAttributeInfo;
        }
    }
}

