/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.ar.ap;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.Order;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.ar.filter.ModelARAddFilterItem;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetDistinctItemsQuery
extends SqlBaseModelQuery<ModelARAddFilterItem, OraclePreparedStatement> {
    private String filter;
    private String orderBy;
    private SortDirection order;
    private ISqlQuery<OraclePreparedStatement> queryGenerator;

    public GetDistinctItemsQuery(Version version, ModelDescriptor modelDescriptor, String string) {
        super(version, new SqlDefaultMapper<ModelARAddFilterItem>(ModelARAddFilterItem.class), modelDescriptor);
        this.filter = string.toUpperCase();
        this.orderBy = "NAME";
        this.order = SortDirection.ASCENDING;
        this.queryGenerator = DbVersionHelper.isDB122Up(version) ? new DB12_12Query() : new DBOriginalQuery();
    }

    public GetDistinctItemsQuery orderByName(SortDirection sortDirection) {
        this.orderBy = "NAME";
        this.order = sortDirection;
        return this;
    }

    public GetDistinctItemsQuery orderBySupport(SortDirection sortDirection) {
        this.orderBy = "SUPPORT";
        this.order = sortDirection;
        return this;
    }

    @Override
    public String getSQLCommand() {
        String string = this.queryGenerator.getSQLCommand();
        return string;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class DB12_12Query
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String BASE_QUERY = "SELECT ITEM as NAME, SUPPORT \nFROM {$ITEMSET_VIEW}, \n     XMLTABLE('/itemset/item' PASSING ITEMSET\n       COLUMNS ITEM varchar2(255) PATH 'item_name')\nWHERE NUMBER_OF_ITEMS = 1 \n{$FILTER} \nORDER BY {$ORDER_BY} {$ORDER_DIRECTION}";

        private DB12_12Query() {
        }

        @Override
        public String getSQLCommand() {
            String string = Conditional.like("UPPER(ITEM)", "ITEM", GetDistinctItemsQuery.this.filter);
            String string2 = StringUtils.isEmpty(string) ? "" : " AND " + string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("ITEMSET_VIEW", GetDistinctItemsQuery.this.getViewName("DM$VI"));
            hashMap.put("FILTER", string2);
            hashMap.put("ORDER_BY", GetDistinctItemsQuery.this.orderBy);
            hashMap.put("ORDER_DIRECTION", GetDistinctItemsQuery.this.order.getSqlKeyword());
            String string3 = StringUtils.getReplacedString(BASE_QUERY, hashMap);
            return string3.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setLikeParameter(oraclePreparedStatement, "ITEM", GetDistinctItemsQuery.this.filter, SqlUtils.LikeMode.CONTAINS);
        }
    }

    private class DBOriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private DBOriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("NAME", "SUPPORT").from("(   SELECT (select attribute_subname from table(ITEMS)) as NAME, SUPPORT \n  FROM \n  TABLE( DBMS_DATA_MINING.GET_FREQUENT_ITEMSETS( :model, NULL, 1 ) ))").where(Conditional.like("UPPER(NAME)", "filter", GetDistinctItemsQuery.this.filter));
            if (SortDirection.ASCENDING.equals((Object)GetDistinctItemsQuery.this.order)) {
                sqlBuilder.orderBy(Order.ASC(GetDistinctItemsQuery.this.orderBy));
            } else {
                sqlBuilder.orderBy(Order.DESC(GetDistinctItemsQuery.this.orderBy));
            }
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "model", GetDistinctItemsQuery.this.getQualifiedName());
            SqlUtils.setLikeParameter(oraclePreparedStatement, "filter", GetDistinctItemsQuery.this.filter, SqlUtils.LikeMode.CONTAINS);
        }
    }
}

