/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.glm;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDoubleArrayMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetMinMaxCoefficientQuery
extends SqlBaseModelQuery<Double[], OraclePreparedStatement> {
    public GetMinMaxCoefficientQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlDoubleArrayMapper(), modelDescriptor);
    }

    @Override
    public String getSQLCommand() {
        String string = "WITH base_query AS\n  (SELECT attribute_name, nvl(t.std_coefficient, t.coefficient) coefficient\n   FROM {$TABLE} t \n   {$PARTITION})\nSELECT MIN(coefficient) minimum_coefficient, MAX(coefficient) maximum_coefficient \nFROM base_query\nWHERE attribute_name is not null";
        String string2 = DbVersionHelper.isDB122Up(this.dbVersion) ? this.getSqlCommand122Up(string) : this.getSqlCommandOriginal(string);
        return string2;
    }

    private String getSqlCommandOriginal(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE", "TABLE(dbms_data_mining.get_model_details_glm( :model ))");
        hashMap.put("PARTITION", "");
        String string2 = StringUtils.getReplacedString(string, hashMap);
        return string2;
    }

    private String getSqlCommand122Up(String string) {
        String string2 = this.getViewName("DM$VD");
        String string3 = this.isPartitioned() ? "WHERE PARTITION_NAME = :pname" : "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE", string2);
        hashMap.put("PARTITION", string3);
        String string4 = StringUtils.getReplacedString(string, hashMap);
        return string4;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            SqlUtils.setStringAtName(oraclePreparedStatement, "pname", this.getPartitionId());
        } else {
            SqlUtils.setStringAtName(oraclePreparedStatement, "model", this.getQualifiedName());
        }
    }
}

