/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.build.GetMiningModelAttributesMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.MiningAttributeInfo;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetMiningModelAttributesQuery
extends SqlBaseModelQuery<MiningAttributeInfo, OraclePreparedStatement> {
    public static final String PARTITION_KEY = "PARTITION_KEY";
    private ISqlQuery<OraclePreparedStatement> queryGenerator;

    public GetMiningModelAttributesQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new GetMiningModelAttributesMapper(version), modelDescriptor);
        this.queryGenerator = DbVersionHelper.isDB122Up(version) ? new Db122Query() : new DBOriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        return this.queryGenerator.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String QUERY = "WITH \n  T1 AS (\n    SELECT * FROM ALL_MINING_MODEL_ATTRIBUTES WHERE OWNER = :owner AND MODEL_NAME = :model_name) ,\n  T2 AS (\n    SELECT ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME, ATTR_NON_NULL, EXPRESSION, REVERSE_EXPRESSION \n    FROM (\n      SELECT ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME,\n             nvl(ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME) ATTR_NON_NULL,\n             EXPRESSION, REVERSE_EXPRESSION, ROW_NUMBER() \n             OVER ( PARTITION BY nvl(ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME) ORDER BY attribute_subname NULLS FIRST ) rn \n      FROM TABLE(DBMS_DATA_MINING.GET_MODEL_TRANSFORMATIONS(:model {$PARTITION_QUOTED})) \n    ) WHERE rn = 1 \n  )\n\nSELECT T1.*, T2.ATTRIBUTE_SUBNAME, T2.EXPRESSION, T2.REVERSE_EXPRESSION \n{$PARTITION_QUERY}FROM  T1, T2 \nWHERE T1.ATTRIBUTE_NAME = ATTR_NON_NULL(+)\n";
        private static final String SUB_QUERY_PARTITION = "       , decode ((select COUNT(*) from ALL_MINING_MODEL_PARTITIONS p \n                WHERE p.OWNER = T1.OWNER \n                AND p.MODEL_NAME = T1.MODEL_NAME \n                AND p.COLUMN_NAME = T1.ATTRIBUTE_NAME \n                AND p.PARTITION_NAME = :partition), 1,'YES','NO') AS PARTITION_KEY ";

        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetMiningModelAttributesQuery.this.isPartitioned() ? ", :partition_quoted" : "";
            String string2 = GetMiningModelAttributesQuery.this.isPartitioned() ? SUB_QUERY_PARTITION : "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("PARTITION_QUOTED", string);
            hashMap.put("PARTITION_QUERY", string2);
            String string3 = StringUtils.getReplacedString(QUERY, hashMap);
            return string3;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("owner", GetMiningModelAttributesQuery.this.getSchema());
            oraclePreparedStatement.setStringAtName("model_name", GetMiningModelAttributesQuery.this.getModelName());
            oraclePreparedStatement.setStringAtName("model", GetMiningModelAttributesQuery.this.getQualifiedName());
            if (GetMiningModelAttributesQuery.this.isPartitioned()) {
                SqlUtils.setStringAtName(oraclePreparedStatement, "partition_quoted", StringUtils.addDoubleQuotes(GetMiningModelAttributesQuery.this.getPartitionId()));
                SqlUtils.setStringAtName(oraclePreparedStatement, "partition", GetMiningModelAttributesQuery.this.getPartitionId());
            }
        }
    }

    private class DBOriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String QUERY = "SELECT \nATTRIBUTE_NAME, ATTRIBUTE_TYPE, DATA_TYPE, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, USAGE_TYPE, TARGET FROM ALL_MINING_MODEL_ATTRIBUTES WHERE OWNER = :owner and MODEL_NAME = :model";

        private DBOriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            return QUERY;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("owner", GetMiningModelAttributesQuery.this.getSchema());
            oraclePreparedStatement.setStringAtName("model", GetMiningModelAttributesQuery.this.getModelName());
        }
    }
}

