/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.PreparedStatement;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.javatools.util.Version;

public abstract class AbstractCoefficientQuery<T, V extends PreparedStatement>
extends SqlBaseModelQuery<T, V> {
    protected Class<? extends ModelType> modelType;
    protected String coefficientColumn;

    public AbstractCoefficientQuery(Version version, SqlMapper<T> sqlMapper, ModelDescriptor modelDescriptor, Class<? extends ModelType> clazz) {
        super(version, sqlMapper, modelDescriptor);
        assert (clazz != null) : "Model Type Cannot be Null";
        this.modelType = clazz;
        this.coefficientColumn = this.getCoefficientColumn();
    }

    protected String getCoefficientColumn() {
        String string = null;
        if (ExplicitSemanticAnalysisModelType.class.equals(this.modelType) || NonNegativeMatrixFactorModelType.class.equals(this.modelType)) {
            string = "COEFFICIENT";
        } else if (PCAModelType.class.equals(this.modelType) || SVDModelType.class.equals(this.modelType)) {
            string = "VALUE";
        }
        return string;
    }

    protected String getCoefficientsSource() {
        assert (ExplicitSemanticAnalysisModelType.class.equals(this.modelType) || PCAModelType.class.equals(this.modelType) || SVDModelType.class.equals(this.modelType) || NonNegativeMatrixFactorModelType.class.equals(this.modelType)) : "Invalid Model Type";
        String string = null;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            if (ExplicitSemanticAnalysisModelType.class.equals(this.modelType)) {
                string = "{$SCHEMA}.DM$VA{$MODEL_NAME}";
            } else if (PCAModelType.class.equals(this.modelType) || SVDModelType.class.equals(this.modelType)) {
                string = "{$SCHEMA}.DM$VV{$MODEL_NAME}";
            } else if (NonNegativeMatrixFactorModelType.class.equals(this.modelType)) {
                string = "{$SCHEMA}.DM$VE{$MODEL_NAME}";
            }
        } else if (PCAModelType.class.equals(this.modelType) || SVDModelType.class.equals(this.modelType)) {
            string = String.format("(\n    SELECT NULL PARTITION_NAME, T.MAPPED_FEATURE_ID FEATURE_ID, T.ATTRIBUTE_NAME, T.ATTRIBUTE_SUBNAME, NULL ATTRIBUTE_VALUE, T.VALUE\n    FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_SVD('%s')) T\n)\n", this.getQualifiedName());
        } else if (NonNegativeMatrixFactorModelType.class.equals(this.modelType)) {
            string = String.format("(\n    SELECT NULL PARTITION_NAME, T.MAPPED_FEATURE_ID FEATURE_ID, S.*\n    FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_NMF('%s')) T,\n    TABLE (T.ATTRIBUTE_SET) S\n)\n", this.getQualifiedName());
        }
        return string;
    }
}

