/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.AbstractCoefficientQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ColumnFilter;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.javatools.util.Version;

public abstract class AbstractFeatureCoefficientsQuery<T, V extends PreparedStatement>
extends AbstractCoefficientQuery<T, V> {
    private static final String LIKE_FORMAT = "UPPER(%s) LIKE '%s'";
    private static final String EQUALS_FORMAT = "%s = %s";
    protected static final String ATTRIBUTE_SUBNAME = "ATTRIBUTE_SUBNAME";
    protected static final String ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    protected static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    protected static final String FEATURE_ID_TAG = "<FEATURE ID>";
    protected static final String FEATURE_ID = "FEATURE_ID";
    protected static final String TAG = "TAG";
    protected List<ColumnFilter> attributeFilters;
    protected long distinctAttributeCount;
    protected String featureColumn = this.getFeatureColumn();
    protected ColumnFilter.Match matchingType;
    protected Integer fetchSize;

    public AbstractFeatureCoefficientsQuery(Version version, SqlMapper<T> sqlMapper, Class<? extends ModelType> clazz, ModelDescriptor modelDescriptor) {
        super(version, sqlMapper, modelDescriptor, clazz);
    }

    protected String getAttributeFilterCondition(String string) {
        String string2 = "";
        List list = this.attributeFilters.stream().filter(columnFilter -> !FEATURE_ID_TAG.equals(columnFilter.getTargetColumn().getColumnName())).collect(Collectors.toList());
        this.distinctAttributeCount = list.stream().map(ColumnFilter::getTargetColumn).distinct().count();
        if (this.distinctAttributeCount == 0L) {
            return "";
        }
        if (this.distinctAttributeCount == 1L) {
            string2 = list.stream().map(columnFilter -> {
                String string2 = String.format(EQUALS_FORMAT, ATTRIBUTE_NAME, StringUtils.addSingleQuotes(columnFilter.getTargetColumn().getColumnName()));
                String string3 = this.getFilterConditional((ColumnFilter)columnFilter, string);
                return StringUtils.isNotEmpty(string3) ? StringUtils.addParentheses(string2 + " AND " + string3) : "";
            }).filter(StringUtils::isNotEmpty).collect(Collectors.joining(ColumnFilter.Match.ALL.equals((Object)this.matchingType) ? " AND " : " OR "));
        } else {
            Map<String, List<ColumnFilter>> map = list.stream().collect(Collectors.groupingBy(columnFilter -> columnFilter.getTargetColumn().getColumnName()));
            string2 = map.entrySet().stream().map(entry -> {
                String string2 = String.format(EQUALS_FORMAT, ATTRIBUTE_NAME, StringUtils.addSingleQuotes((String)entry.getKey()));
                String string3 = ((List)entry.getValue()).stream().map(columnFilter -> this.getFilterConditional((ColumnFilter)columnFilter, string)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(ColumnFilter.Match.ALL.equals((Object)this.matchingType) ? " AND " : " OR "));
                return StringUtils.isNotEmpty(string3) ? StringUtils.addParentheses(string2 + " AND " + string3) : "";
            }).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" OR "));
        }
        return string2;
    }

    protected String getFeatureFilterCondition() {
        String string = this.attributeFilters.stream().filter(columnFilter -> FEATURE_ID_TAG.equals(columnFilter.getTargetColumn().getColumnName())).map(columnFilter -> this.getFilterConditional((ColumnFilter)columnFilter, "{$FEATURE_ID}")).filter(StringUtils::isNotEmpty).collect(Collectors.joining(ColumnFilter.Match.ALL.equals((Object)this.matchingType) ? " AND " : " OR "));
        return string;
    }

    protected String getFilterConditional(ColumnFilter columnFilter, String string) {
        String string3 = ColumnFilter.Operator.EXIST.equals((Object)columnFilter.getOperator()) ? String.format("%s IS NOT NULL", string) : Arrays.stream(columnFilter.getValue().split(";")).filter(StringUtils::isNotEmpty).map(string2 -> {
            switch (columnFilter.getOperator()) {
                case CONTAINS: {
                    return String.format(LIKE_FORMAT, string, Conditional.getLikeParameter(string2.toUpperCase(), SqlUtils.LikeMode.CONTAINS));
                }
                case STARTS: {
                    return String.format(LIKE_FORMAT, string, Conditional.getLikeParameter(string2.toUpperCase(), SqlUtils.LikeMode.STARTS));
                }
                case EQUALS: {
                    return String.format(EQUALS_FORMAT, string, StringUtils.addSingleQuotes(string2));
                }
            }
            assert (false) : "Illegal operator";
            return "";
        }).collect(Collectors.joining(" OR "));
        return StringUtils.addParentheses(string3);
    }

    protected String getFeatureColumn() {
        String string = FEATURE_ID;
        if (DbVersionHelper.isDB122Up(this.dbVersion) && (PCAModelType.class.equals((Object)this.modelType) || SVDModelType.class.equals((Object)this.modelType) || NonNegativeMatrixFactorModelType.class.equals((Object)this.modelType))) {
            string = "FEATURE_NAME";
        }
        return string;
    }

    protected String getFeatureIdSource() {
        String string = null;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            if (ExplicitSemanticAnalysisModelType.class.equals((Object)this.modelType)) {
                string = "SELECT FEATURE_ID\n      FROM {$SCHEMA}.DM$VF{$MODEL_NAME}";
            } else if (PCAModelType.class.equals((Object)this.modelType) || SVDModelType.class.equals((Object)this.modelType)) {
                string = "SELECT DISTINCT FEATURE_NAME FEATURE_ID\n      FROM {$SCHEMA}.DM$VV{$MODEL_NAME}";
            } else if (NonNegativeMatrixFactorModelType.class.equals((Object)this.modelType)) {
                string = "SELECT DISTINCT FEATURE_NAME FEATURE_ID\n      FROM {$SCHEMA}.DM$VE{$MODEL_NAME}";
            }
        } else if (PCAModelType.class.equals((Object)this.modelType) || SVDModelType.class.equals((Object)this.modelType)) {
            string = String.format("SELECT DISTINCT MAPPED_FEATURE_ID FEATURE_ID\n      FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_SVD('%s'))", this.getQualifiedName());
        } else if (NonNegativeMatrixFactorModelType.class.equals((Object)this.modelType)) {
            string = String.format("SELECT DISTINCT MAPPED_FEATURE_ID FEATURE_ID\n      FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_NMF('%s'))", this.getQualifiedName());
        }
        return string;
    }

    protected static enum Filtering {
        NONE,
        BY_FEATURE,
        BY_SINGLE_ATTRIBUTE,
        BY_MULTIPLE_ATTRIBUTE;

    }
}

