/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class ClusterFullTreeQuery
extends ModelDetailsQuery {
    private static final String DISPERSION = "DISPERSION";
    private static final String PARENT = "PARENT";
    private static final String TREE_LEVEL = "TREE_LEVEL";
    private static final String IS_LEAF = "IS_LEAF";

    public ClusterFullTreeQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public ClusterFullTreeQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"CLUSTER_ID", "VARCHAR2"}, {"RECORD_COUNT", "NUMBER"}, {DISPERSION, "NUMBER"}, {PARENT, "NUMBER"}, {TREE_LEVEL, "NUMBER"}, {IS_LEAF, "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"OPERATOR", "VARCHAR2"}, {"VALUE", "VARCHAR2"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"CLUSTER_ID", "VARCHAR2"}, {"RECORD_COUNT", "NUMBER"}, {DISPERSION, "NUMBER"}, {PARENT, "NUMBER"}, {TREE_LEVEL, "NUMBER"}, {IS_LEAF, "VARCHAR2"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n     PARTITION_NAME as \"{$PARTITION_NAME}\",\n     CLUSTER_ID as \"{$ID}\",\n     CAST(CLUSTER_NAME AS VARCHAR2(4000)) as \"{$CLUSTER_ID}\",\n     RECORD_COUNT as \"{$RECORD_COUNT}\",\n     PARENT as \"{$PARENT}\",\n     TREE_LEVEL as \"{$TREE_LEVEL}\",\n     CAST(CASE WHEN LEFT_CHILD_ID IS NULL AND RIGHT_CHILD_ID IS NULL \n         THEN '1'  \n         ELSE '0' END AS VARCHAR2(1)) as \"{$IS_LEAF}\",\n     {$SPECIFIC_DISPERSION} as \"{$DISPERSION}\",\n     {$SPECIFIC_ATTRIBUTE_NAME} as \"{$ATTRIBUTE_NAME}\",\n     {$SPECIFIC_ATTRIBUTE_SUBNAME} as \"{$ATTRIBUTE_SUBNAME}\",\n     {$SPECIFIC_OPERATOR} as \"{$OPERATOR}\",\n     {$SPECIFIC_VALUE} as \"{$VALUE}\"\n   FROM {$MODEL_SCHEMA_VALUE}.{$ALGO_SOURCE}{$MODEL_NAME_VALUE}" : "SELECT DISTINCT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\n     t.id as \"{$ID}\",\n     t.cluster_id as \"{$CLUSTER_ID}\",\n     t.record_count as \"{$RECORD_COUNT}\",\n     t.dispersion as \"{$DISPERSION}\",\n     t.parent as \"{$PARENT}\",\n     t.tree_level as \"{$TREE_LEVEL}\",\n     CAST(CASE WHEN chl.id IS NULL \n         THEN '1'  \n         ELSE '0' END AS VARCHAR2(1)) as \"{$IS_LEAF}\" \n    FROM (SELECT * FROM TABLE(dbms_data_mining.{$ALGO_SOURCE}('{$GET_MODEL_NAME}'))) t, \n         table(t.child)(+) chl";
        return string;
    }

    @Override
    protected String getActualSource(MiningAlgorithmType miningAlgorithmType) {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "DM$VD";
        }
        switch (miningAlgorithmType) {
            case KMEANS: {
                return "GET_MODEL_DETAILS_KM";
            }
            case O_CLUSTER: {
                return "GET_MODEL_DETAILS_OC";
            }
            case EXPECTATION_MAXIMIZATION: {
                return "GET_MODEL_DETAILS_EM";
            }
        }
        assert (false) : "Incompatible Algorithm";
        return null;
    }

    @Override
    protected Map<String, String> getSpecificColumns(MiningAlgorithmType miningAlgorithmType) {
        HashMap<String, String> hashMap;
        block7: {
            block6: {
                if (!DbVersionHelper.isDB122Up(this.dbVersion)) break block6;
                hashMap = new HashMap<String, String>();
                switch (miningAlgorithmType) {
                    case KMEANS: {
                        hashMap.put("SPECIFIC_DISPERSION", "TO_CHAR(DISPERSION, 'TM')");
                        hashMap.put("SPECIFIC_ATTRIBUTE_NAME", "null");
                        hashMap.put("SPECIFIC_ATTRIBUTE_SUBNAME", "null");
                        hashMap.put("SPECIFIC_OPERATOR", "null");
                        hashMap.put("SPECIFIC_VALUE", "null");
                        break block7;
                    }
                    case O_CLUSTER: {
                        hashMap.put("SPECIFIC_DISPERSION", "null");
                        hashMap.put("SPECIFIC_ATTRIBUTE_NAME", "ATTRIBUTE_NAME");
                        hashMap.put("SPECIFIC_ATTRIBUTE_SUBNAME", "ATTRIBUTE_SUBNAME");
                        hashMap.put("SPECIFIC_OPERATOR", "OPERATOR");
                        hashMap.put("SPECIFIC_VALUE", "CAST(XMLQUERY('string-join(//Element,\", \")' PASSING VALUE RETURNING CONTENT) AS VARCHAR2(4000))");
                        break block7;
                    }
                    case EXPECTATION_MAXIMIZATION: {
                        hashMap.put("SPECIFIC_DISPERSION", "null");
                        hashMap.put("SPECIFIC_ATTRIBUTE_NAME", "null");
                        hashMap.put("SPECIFIC_ATTRIBUTE_SUBNAME", "null");
                        hashMap.put("SPECIFIC_OPERATOR", "null");
                        hashMap.put("SPECIFIC_VALUE", "null");
                        break block7;
                    }
                    default: {
                        assert (false) : "Incompatible Algorithm";
                        break block7;
                    }
                }
            }
            return Collections.emptyMap();
        }
        return hashMap;
    }

    @Override
    public String getUnionOrderBy() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "\nORDER BY MODEL_NAME, PARTITION_NAME, ID";
        }
        return "";
    }
}

