/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.clus;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.model.generated.server.DmCentroid;
import oracle.dmt.dataminer.core.model.generated.server.DmCentroids;
import oracle.dmt.dataminer.core.utils.ObjectUtils;

public class CentroidRowData
implements Comparable<CentroidRowData> {
    private String attributeName;
    private String attributeSubname;
    private Double mean;
    private Double variance;
    private String mode;

    public CentroidRowData() {
        this.attributeName = "";
        this.attributeSubname = "";
        this.mean = 0.0;
        this.mode = "";
        this.variance = 0.0;
    }

    public CentroidRowData(String string, String string2, Double d, Double d2, String string3) {
        this.attributeName = string;
        this.attributeSubname = string2;
        this.mean = d;
        this.mode = string3;
        this.variance = d2;
    }

    public CentroidRowData(DmCentroid dmCentroid) throws SQLException {
        this.attributeName = dmCentroid.getAttributeName();
        this.attributeSubname = dmCentroid.getAttributeSubname() != null ? dmCentroid.getAttributeSubname() : null;
        this.mean = dmCentroid.getMean() != null ? Double.valueOf(dmCentroid.getMean().doubleValue()) : null;
        this.variance = dmCentroid.getVariance() != null ? Double.valueOf(dmCentroid.getVariance().doubleValue()) : null;
        this.mode = dmCentroid.getModeValue() != null ? dmCentroid.getModeValue() : null;
    }

    public void setAttributeName(String string) {
        this.attributeName = string;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeSubname(String string) {
        this.attributeSubname = string;
    }

    public String getAttributeSubname() {
        return this.attributeSubname;
    }

    public void setMean(Double d) {
        this.mean = d;
    }

    public Double getMean() {
        return this.mean;
    }

    public void setVariance(Double d) {
        this.variance = d;
    }

    public Double getVariance() {
        return this.variance;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public String getMode() {
        return this.mode;
    }

    public Object getCentroidValue() {
        Object object = null;
        if (this.mean != null) {
            object = this.mean;
        } else if (this.mode != null) {
            object = this.mode;
        }
        return object;
    }

    public static List<CentroidRowData> createCentroidsFromDmCentroids(DmCentroids dmCentroids) throws SQLException {
        ArrayList<CentroidRowData> arrayList = new ArrayList<CentroidRowData>();
        if (dmCentroids != null) {
            for (int i = 0; i < dmCentroids.length(); ++i) {
                DmCentroid dmCentroid = dmCentroids.getElement(i);
                CentroidRowData centroidRowData = new CentroidRowData(dmCentroid);
                arrayList.add(centroidRowData);
            }
        }
        return arrayList;
    }

    public String toString() {
        Object object;
        String string = null;
        if (this.variance != null) {
            object = new BigDecimal(this.variance);
            object = ((BigDecimal)object).setScale(12, 1);
            string = ((BigDecimal)object).toString();
        }
        object = "[ Name = " + this.attributeName + ", Subname = " + this.attributeSubname + ", Mean = " + this.mean + ", Mode = " + this.mode + ", Variance = " + string + "]";
        return object;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (!(object instanceof CentroidRowData)) {
            return false;
        }
        CentroidRowData centroidRowData = (CentroidRowData)object;
        boolean bl2 = bl = ObjectUtils.areEqual(this.attributeName, centroidRowData.getAttributeName()) && ObjectUtils.areEqual(this.attributeSubname, centroidRowData.getAttributeSubname()) && ObjectUtils.areEqual(this.mean, centroidRowData.getMean()) && ObjectUtils.areEqual(this.mode, centroidRowData.getMode());
        if (bl && this.variance != null && centroidRowData.getVariance() != null) {
            BigDecimal bigDecimal = new BigDecimal(this.variance);
            BigDecimal bigDecimal2 = new BigDecimal(centroidRowData.getVariance());
            if (!(bigDecimal = bigDecimal.setScale(12, 1)).equals(bigDecimal2 = bigDecimal2.setScale(12, 1))) {
                bl = false;
            }
        } else if (bl && (this.variance != null || centroidRowData.getVariance() != null)) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n += ObjectUtils.hashCode(this.attributeName);
        n += ObjectUtils.hashCode(this.attributeSubname);
        n += ObjectUtils.hashCode(this.mean);
        n += ObjectUtils.hashCode(this.mode);
        return n += ObjectUtils.hashCode(this.variance);
    }

    @Override
    public int compareTo(CentroidRowData centroidRowData) {
        int n = ObjectUtils.compare(this.attributeName, centroidRowData.getAttributeName());
        if (n == 0 && (n = ObjectUtils.compare(this.attributeSubname, centroidRowData.getAttributeSubname())) == 0 && (n = ObjectUtils.compare(this.mean, centroidRowData.getMean())) == 0 && (n = ObjectUtils.compare(this.mode, centroidRowData.getMode())) == 0) {
            n = ObjectUtils.compare(this.variance, centroidRowData.getVariance());
        }
        return n;
    }
}

