/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.IdeStorageMap;
import oracle.ojc.interfaces.Storage;

class IdeStorageWrapper
implements Storage {
    private Storage storage;
    private IdeStorageMap map;
    private HashMap properties = null;

    public IdeStorageWrapper(Storage storage, IdeStorageMap map) {
        this.storage = storage;
        this.map = map;
    }

    public long modDate() {
        return this.storage.modDate();
    }

    public String getName() {
        return this.storage.getName();
    }

    public String getPath() {
        return this.storage.getPath();
    }

    public String getCanonicalPath() {
        return this.storage.getCanonicalPath();
    }

    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public boolean isDirectory() {
        return this.storage.isDirectory();
    }

    public boolean isInJar() {
        return this.storage.isInJar();
    }

    public byte[] read() throws IOException {
        return this.storage.read();
    }

    public int read(byte[] buf) throws IOException {
        return this.storage.read(buf);
    }

    public void write(byte[] xs, int start, int len) throws IOException {
        this.storage.write(xs, start, len);
    }

    public String[] list() {
        URL url;
        ArrayList ideFiles;
        String[] storageFiles = this.storage.list();
        if (this.map != null && Helpers.isFileStorage(this.storage) && (ideFiles = this.map.get(url = URLFactory.newDirURL((String)this.storage.getPath()))) != null) {
            String[] merged;
            if (storageFiles == null || storageFiles.length == 0) {
                merged = ideFiles.toArray(new String[ideFiles.size()]);
            } else {
                int i;
                for (i = 0; i < storageFiles.length; ++i) {
                    int index = ideFiles.indexOf(storageFiles[i]);
                    if (index == -1) continue;
                    ideFiles.remove(index);
                }
                merged = new String[storageFiles.length + ideFiles.size()];
                System.arraycopy(storageFiles, 0, merged, 0, storageFiles.length);
                for (i = 0; i < ideFiles.size(); ++i) {
                    merged[storageFiles.length + i] = (String)ideFiles.get(i);
                }
            }
            return merged;
        }
        return storageFiles;
    }

    public int size() throws IOException {
        assert (false);
        return 0;
    }

    public ArrayList listStorage() {
        assert (false);
        return null;
    }

    public void open() throws IOException {
        assert (false);
    }

    public Storage open(String name) {
        File f;
        URL url;
        Node node;
        if (Helpers.isFileStorage(this.storage) && (node = NodeFactory.find((URL)(url = URLFactory.newFileURL((File)(f = new File(this.storage.getPath(), name)))))) != null && node.isDirty()) {
            return new IdeStorage(node);
        }
        return this.storage.open(name);
    }

    public Storage create(String name) throws IOException {
        Storage s = this.storage.create(name);
        if (s != null) {
            return new IdeStorageWrapper(s, this.map);
        }
        return null;
    }

    public Storage createDir(String name) throws IOException {
        Storage s = this.storage.createDir(name);
        if (s != null) {
            return new IdeStorageWrapper(s, this.map);
        }
        return null;
    }

    public void close() {
        this.storage.close();
    }

    public String toString() {
        return this.storage.toString();
    }

    public int hashCode() {
        return this.storage.hashCode();
    }

    public boolean equals(Object obj) {
        return this.storage.equals(obj);
    }
}

