/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.util.Iterator;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DependableFactory;
import oracle.jdeveloper.deploy.DependencyStorage;
import oracle.jdeveloper.deploy.DeployElement;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdevimpl.deploy.common.DependableContainer;

public class Profile
extends DeployElement
implements Interdependency,
DependencyStorage {
    public static String PROFILE_NAME = "profileName";
    public static String PROFILE_CLASS_NAME = "profileClass";
    private final DependableContainer _dependableContainer = new DependableContainer();
    protected DataContainer _dataContainer;

    public Profile() {
    }

    public Profile(HashStructure hash) {
        super(hash);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((Profile)o);
    }

    protected final boolean equalsImpl(Profile profile) {
        if (this._dataContainer == null && profile._dataContainer == null) {
            return super.equalsImpl((HashStructureAdapter)profile);
        }
        return super.equalsImpl((HashStructureAdapter)profile) && this._dataContainer.equals((Object)profile._dataContainer);
    }

    public String getName() {
        return this._hash.getString(PROFILE_NAME);
    }

    public void setName(String name) {
        this._hash.putString(PROFILE_NAME, name);
    }

    public static <T extends Profile> void setProfileClass(Profile profile, Class<T> profileClass) {
        profile.getHashStructure().putString(PROFILE_CLASS_NAME, profileClass.getName());
    }

    public static <T extends Profile> Class<T> getProfileClass(HashStructure hash, ClassLoader loader) throws ClassNotFoundException {
        String className;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (!ModelUtil.hasLength((String)(className = hash.getString(PROFILE_CLASS_NAME)))) {
            throw new ClassNotFoundException("Profile class value is empty");
        }
        Class<?> anyClass = loader.loadClass(className);
        try {
            Class<?> clazz = anyClass;
            return clazz;
        }
        catch (ClassCastException e) {
            throw new ClassNotFoundException(anyClass.getName() + " does not extend Profile");
        }
    }

    public Object copyTo(Object object) {
        if (object != null && !(object instanceof Profile)) {
            throw new IllegalArgumentException("Attempt to copy " + this.getClass() + " to " + object.getClass());
        }
        Object copy = object;
        if (copy == null) {
            try {
                copy = this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot call default constructor for copying object", e);
            }
        }
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(Object object) {
        Profile copy = (Profile)object;
        this._hash.copyTo(copy._hash);
        copy._dataContainer = this._dataContainer;
        this._dependableContainer.copyTo(copy._dependableContainer);
    }

    @Override
    public HashStructure getHashStructure() {
        return this._hash;
    }

    public DataContainer getDataContainer() {
        return this._dataContainer;
    }

    public void setDataContainer(DataContainer dataContainer) {
        this._dataContainer = dataContainer;
    }

    @Override
    public Iterator<Dependable> getDependencies() {
        return this._dependableContainer.iterator(this);
    }

    @Deprecated
    public void addDependency(Profile profile) {
        Dependable[] dependables;
        DependableFactory factory = DependableFactory.getInstance();
        for (Dependable d : dependables = factory.create((Element)profile, (Element)profile.getDataContainer())) {
            this.addDependency(d);
        }
    }

    @Deprecated
    public Dependable removeDependency(Profile profile) {
        assert (profile != null);
        DependableFactory factory = DependableFactory.getInstance();
        Dependable[] dependables = factory.create((Element)profile, (Element)profile.getDataContainer());
        Dependable ret = null;
        for (Dependable d : dependables) {
            ret = ret == null ? d : ret;
            this.removeDependency(d);
        }
        return ret;
    }

    @Deprecated
    public void addDependency(Node node, DataContainer container) {
        Dependable[] dependables;
        DependableFactory factory = DependableFactory.getInstance();
        for (Dependable d : dependables = factory.create((Element)node, (Element)container)) {
            this.addDependency(d);
        }
    }

    @Override
    public void addDependency(Dependable dependable) {
        this._dependableContainer.addDependency(this, dependable);
    }

    @Override
    public Dependable removeDependency(Dependable dependable) {
        return this._dependableContainer.removeDependency(this, dependable);
    }

    @Override
    public String getShortLabel() {
        return this.getName();
    }

    @Deprecated
    public void setContainedProfile(boolean containedProfile) {
        this._hash.putBoolean("containedProfile", containedProfile);
    }

    @Deprecated
    public boolean isContainedProfile() {
        return this._hash.getBoolean("containedProfile", false);
    }

    @Deprecated
    public String getParentProfileName() {
        if (this.isContainedProfile() && this.getName().indexOf("_") != -1) {
            return this.getName().substring(0, this.getName().indexOf("_"));
        }
        return "";
    }

    @Deprecated
    public void migrate(TraversableContext context) {
        throw new AssertionError((Object)"Migration error");
    }
}

