/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta.pattern.builder;

import oracle.jdeveloper.deploy.meta.pattern.builder.OBContext;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBException;

public abstract class OBBuilder<R, O, C> {
    protected final Class objectClass_;
    protected final OBContext<R, O, C> context_;
    private O object_;

    public OBBuilder(Class objectClass, OBContext<R, O, C> context) {
        this.objectClass_ = objectClass;
        this.context_ = context;
    }

    public Class getObjectClass() {
        return this.objectClass_;
    }

    public Class getTypeForNarrow() {
        return this.getObjectClass();
    }

    public final synchronized O getObject() {
        if (this.object_ == null) {
            this.buildObject();
        }
        return this.object_;
    }

    private void buildObject() {
        Class objectClass = this.getObjectClass();
        if (objectClass == null) {
            throw new OBException("Null Profile class");
        }
        this.buildEvent(false, objectClass, null);
        this.object_ = this.build();
        if (this.object_ == null) {
            throw new OBException("Null Object built");
        }
        if (!objectClass.isAssignableFrom(this.object_.getClass())) {
            throw new IllegalStateException(String.format("Returned object %s is not a type of %s", this.object_.getClass().getName(), objectClass.getName()));
        }
        this.buildEvent(true, objectClass, this.object_);
    }

    private void buildEvent(boolean built, Class objectClassClass, O object) {
    }

    public OBContext<R, O, C> getContext() {
        return this.context_;
    }

    protected abstract O build();
}

