/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.tk.spi;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBContext;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBRecognizer;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdeveloper.deploy.tk.spi.ToolkitProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitProviders;

public class ToolkitProvidersImpl
extends ToolkitProviders {
    private Map<String, List<TkProviderAdapter>> toolkitKeyMap_ = new HashMap<String, List<TkProviderAdapter>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String intf, ToolkitProvider provider) {
        Map<String, List<TkProviderAdapter>> map = this.toolkitKeyMap_;
        synchronized (map) {
            List<TkProviderAdapter> providers = this.toolkitKeyMap_.get(intf);
            if (providers == null) {
                providers = new CopyOnWriteArrayList<TkProviderAdapter>();
                this.toolkitKeyMap_.put(intf, providers);
            }
            TkProviderAdapter tkProvider = new TkProviderAdapter(provider);
            assert (!providers.contains(tkProvider));
            providers.add(tkProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unregister(ToolkitProvider provider) {
        Map<String, List<TkProviderAdapter>> map = this.toolkitKeyMap_;
        synchronized (map) {
            for (String key : this.toolkitKeyMap_.keySet()) {
                this.unregister(key, provider);
            }
        }
    }

    public List<OBRecognizer<Element, Toolkit, Context>> getRecognizers(Class classOrIntf) {
        assert (Toolkit.class.isAssignableFrom(classOrIntf));
        List<TkProviderAdapter> ret = this.toolkitKeyMap_.get(classOrIntf.getName());
        return ret == null ? Collections.emptyList() : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(String intf, ToolkitProvider provider) {
        Map<String, List<TkProviderAdapter>> map = this.toolkitKeyMap_;
        synchronized (map) {
            List<TkProviderAdapter> providers = this.toolkitKeyMap_.get(intf);
            int i = 0;
            while (i < providers.size()) {
                if (providers.get((int)i).provider_.equals(provider)) {
                    providers.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    private static class TkProviderAdapter
    implements OBRecognizer<Element, Toolkit, Context> {
        final ToolkitProvider provider_;
        WeakReference<ToolkitProvider> ref_;

        TkProviderAdapter(ToolkitProvider provider) {
            this.provider_ = provider;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof TkProviderAdapter)) {
                return false;
            }
            TkProviderAdapter other = (TkProviderAdapter)o;
            if (this.provider_ != null && other.provider_ != null) {
                return this.provider_.equals(other.provider_);
            }
            return false;
        }

        public AbstractToolkitBuilder recognize(Element recognize, OBContext<Element, Toolkit, Context> context, Class classOrIntf) {
            return this.provider_.create((ToolkitContext)((Object)context));
        }

        public String toString() {
            return super.toString() + "(" + this.provider_ + " )";
        }
    }
}

