/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.classfile.ClassFileWriter;
import ice.mozilla.javascript.ClassNameHelper;
import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.FunctionNode;
import ice.mozilla.javascript.GeneratedClassLoader;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeGlobal;
import ice.mozilla.javascript.NativeJavaClass;
import ice.mozilla.javascript.NativeJavaObject;
import ice.mozilla.javascript.ObjToIntMap;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.SecurityController;
import ice.mozilla.javascript.Undefined;
import ice.mozilla.javascript.WrappedException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class JavaAdapter
extends ScriptableObject {
    private static int serial;
    private static Hashtable generatedClasses;

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getClassName() {
        return "JavaAdapter";
    }

    public static Object convertResult(Object result, Class c) {
        if (result == Undefined.instance && c != ScriptRuntime.ObjectClass && c != ScriptRuntime.StringClass) {
            return null;
        }
        return NativeJavaObject.coerceType(c, result, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scriptable setAdapterProto(Scriptable obj, Object adapter) {
        Context cx = Context.enter();
        try {
            Scriptable topLevel = ScriptableObject.getTopLevelScope(obj);
            Scriptable res = ScriptRuntime.toObject(topLevel, adapter);
            res.setPrototype(obj);
            Scriptable scriptable = res;
            return scriptable;
        }
        finally {
            cx.exit();
        }
    }

    public static Object getAdapterSelf(Class adapterClass, Object adapter) throws NoSuchFieldException, IllegalAccessException {
        Field self = adapterClass.getDeclaredField("self");
        return self.get(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException {
        Class superClass = null;
        Class[] intfs = new Class[args.length - 1];
        int interfaceCount = 0;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!(args[i] instanceof NativeJavaClass)) {
                throw NativeGlobal.constructError(cx, "TypeError", "expected java class object", ctorObj);
            }
            Class c = ((NativeJavaClass)args[i]).getClassObject();
            if (!c.isInterface()) {
                if (superClass != null) {
                    String msg = "Only one class may be extended by a JavaAdapter. Had " + superClass.getName() + " and " + c.getName();
                    throw NativeGlobal.constructError(cx, "TypeError", msg, ctorObj);
                }
                superClass = c;
                continue;
            }
            intfs[interfaceCount++] = c;
        }
        if (superClass == null) {
            superClass = Object.class;
        }
        Class[] interfaces = new Class[interfaceCount];
        System.arraycopy(intfs, 0, interfaces, 0, interfaceCount);
        Scriptable obj = (Scriptable)args[args.length - 1];
        ClassSignature sig = new ClassSignature(superClass, interfaces, obj);
        Class adapterClass = (Class)generatedClasses.get(sig);
        if (adapterClass == null) {
            String adapterName;
            Hashtable hashtable = generatedClasses;
            synchronized (hashtable) {
                adapterName = "adapter" + serial++;
            }
            adapterClass = JavaAdapter.createAdapterClass(cx, obj, adapterName, superClass, interfaces, null, null);
            generatedClasses.put(sig, adapterClass);
        }
        Class[] ctorParms = new Class[]{Scriptable.class};
        Object[] ctorArgs = new Object[]{obj};
        Object adapter = adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
        return JavaAdapter.getAdapterSelf(adapterClass, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createAdapterClass(Class superClass, Class[] interfaces, Scriptable obj, Scriptable self) throws ClassNotFoundException {
        ClassSignature sig = new ClassSignature(superClass, interfaces, obj);
        Class adapterClass = (Class)generatedClasses.get(sig);
        if (adapterClass == null) {
            String adapterName;
            Hashtable hashtable = generatedClasses;
            synchronized (hashtable) {
                adapterName = "adapter" + serial++;
            }
            Context cx = Context.enter();
            try {
                adapterClass = JavaAdapter.createAdapterClass(cx, obj, adapterName, superClass, interfaces, null, null);
                generatedClasses.put(sig, adapterClass);
            }
            finally {
                Context.exit();
            }
        }
        try {
            Class[] ctorParms = new Class[]{Scriptable.class, Scriptable.class};
            Object[] ctorArgs = new Object[]{obj, self};
            return adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        throw new ClassNotFoundException("adapter");
    }

    public static Class createAdapterClass(Context cx, Scriptable jsObj, String adapterName, Class superClass, Class[] interfaces, String scriptClassName, ClassNameHelper nameHelper) throws ClassNotFoundException {
        GeneratedClassLoader loader;
        String methodName;
        ClassFileWriter cfw = new ClassFileWriter(adapterName, superClass.getName(), "<adapter>");
        cfw.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        cfw.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int interfacesCount = interfaces == null ? 0 : interfaces.length;
        for (int i = 0; i < interfacesCount; ++i) {
            if (interfaces[i] == null) continue;
            cfw.addInterface(interfaces[i].getName());
        }
        String superName = superClass.getName().replace('.', '/');
        JavaAdapter.generateCtor(cfw, adapterName, superName);
        JavaAdapter.generateSerialCtor(cfw, adapterName, superName);
        if (scriptClassName != null) {
            JavaAdapter.generateEmptyCtor(cfw, adapterName, superName, scriptClassName);
        }
        ObjToIntMap generatedOverrides = new ObjToIntMap();
        ObjToIntMap generatedMethods = new ObjToIntMap();
        for (int i = 0; i < interfacesCount; ++i) {
            Method[] methods = interfaces[i].getMethods();
            for (int j = 0; j < methods.length; ++j) {
                String methodKey;
                Method method = methods[j];
                int mods = method.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || jsObj == null) continue;
                if (!ScriptableObject.hasProperty(jsObj, method.getName())) {
                    try {
                        superClass.getMethod(method.getName(), method.getParameterTypes());
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                if (generatedOverrides.has(methodKey = (methodName = method.getName()) + JavaAdapter.getMethodSignature(method))) continue;
                JavaAdapter.generateMethod(cfw, adapterName, methodName, method.getParameterTypes(), method.getReturnType());
                generatedOverrides.put(methodKey, 0);
                generatedMethods.put(methodName, 0);
            }
        }
        Method[] methods = superClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            boolean isAbstractMethod;
            Method method = methods[j];
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || !(isAbstractMethod = Modifier.isAbstract(mods)) && (jsObj == null || !ScriptableObject.hasProperty(jsObj, method.getName()))) continue;
            methodName = method.getName();
            String methodSignature = JavaAdapter.getMethodSignature(method);
            String methodKey = methodName + methodSignature;
            if (!generatedOverrides.has(methodKey)) {
                JavaAdapter.generateMethod(cfw, adapterName, methodName, method.getParameterTypes(), method.getReturnType());
                generatedOverrides.put(methodKey, 0);
                generatedMethods.put(methodName, 0);
            }
            if (isAbstractMethod) continue;
            JavaAdapter.generateSuper(cfw, adapterName, superName, methodName, methodSignature, method.getParameterTypes(), method.getReturnType());
        }
        for (Scriptable o = jsObj; o != null; o = o.getPrototype()) {
            Object[] ids = jsObj.getIds();
            for (int j = 0; j < ids.length; ++j) {
                int length;
                String id;
                if (!(ids[j] instanceof String) || generatedMethods.has(id = (String)ids[j])) continue;
                Object f = o.get(id, o);
                if (f instanceof Function) {
                    Function p = (Function)f;
                    length = (int)Context.toNumber(ScriptableObject.getProperty((Scriptable)p, "length"));
                } else {
                    if (!(f instanceof FunctionNode)) continue;
                    length = ((FunctionNode)f).getVariableTable().getParameterCount();
                }
                Class[] parms = new Class[length];
                for (int k = 0; k < length; ++k) {
                    parms[k] = Object.class;
                }
                JavaAdapter.generateMethod(cfw, adapterName, id, parms, Object.class);
            }
        }
        byte[] bytes = cfw.toByteArray();
        if (nameHelper != null) {
            try {
                if (!nameHelper.getClassRepository().storeClass(adapterName, bytes, true)) {
                    return null;
                }
            }
            catch (IOException iox) {
                throw WrappedException.wrapException(iox);
            }
        }
        ClassLoader parentLoader = cx.getClass().getClassLoader();
        SecurityController sc = cx.getSecurityController();
        if (sc == null) {
            loader = cx.createClassLoader(parentLoader);
        } else {
            Object securityDomain = sc.getDynamicSecurityDomain(null);
            loader = sc.createClassLoader(parentLoader, securityDomain);
        }
        Class result = loader.defineClass(adapterName, bytes);
        loader.linkClass(result);
        return result;
    }

    public static Object callMethod(Scriptable object, Object thisObj, String methodId, Object[] args) {
        Context cx = Context.enter();
        try {
            Object fun = ScriptableObject.getProperty(object, methodId);
            if (fun == Scriptable.NOT_FOUND) {
                Scriptable scriptable = Undefined.instance;
                return scriptable;
            }
            Object object2 = ScriptRuntime.call(cx, fun, thisObj, args, object);
            return object2;
        }
        catch (JavaScriptException ex) {
            throw WrappedException.wrapException(ex);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scriptable toObject(Object value, Scriptable scope, Class staticType) {
        Context cx = Context.enter();
        try {
            Scriptable scriptable = ScriptRuntime.toObject(cx, scope, value, staticType);
            return scriptable;
        }
        finally {
            Context.exit();
        }
    }

    private static void generateCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        cfw.add((byte)42);
        cfw.add((byte)-73, superName, "<init>", "()", "V");
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)43);
        cfw.add((byte)42);
        cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "setAdapterProto", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)76);
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)20, null);
    }

    private static void generateSerialCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        cfw.add((byte)42);
        cfw.add((byte)-73, superName, "<init>", "()", "V");
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)42);
        cfw.add((byte)44);
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)20, null);
    }

    private static void generateEmptyCtor(ClassFileWriter cfw, String adapterName, String superName, String scriptClassName) {
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add((byte)42);
        cfw.add((byte)-73, superName, "<init>", "()", "V");
        cfw.add((byte)-69, scriptClassName);
        cfw.add((byte)89);
        cfw.add((byte)-73, scriptClassName, "<init>", "()", "V");
        cfw.add((byte)-72, "org/mozilla/javascript/ScriptRuntime", "runScript", "(Lorg/mozilla/javascript/Script;)", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)76);
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)43);
        cfw.add((byte)42);
        cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "setAdapterProto", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)76);
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)20, null);
    }

    private static int generateWrapParam(ClassFileWriter cfw, int paramOffset, Class paramType) {
        if (paramType.equals(Boolean.TYPE)) {
            cfw.add((byte)-69, "java/lang/Boolean");
            cfw.add((byte)89);
            cfw.add((byte)21, paramOffset++);
            cfw.add((byte)-73, "java/lang/Boolean", "<init>", "(Z)", "V");
        } else if (paramType.equals(Character.TYPE)) {
            cfw.add((byte)-69, "java/lang/String");
            cfw.add((byte)89);
            cfw.add((byte)4);
            cfw.add((byte)-68, 5);
            cfw.add((byte)89);
            cfw.add((byte)3);
            cfw.add((byte)21, paramOffset++);
            cfw.add((byte)85);
            cfw.add((byte)-73, "java/lang/String", "<init>", "([C)", "V");
        } else {
            cfw.add((byte)-69, "java/lang/Double");
            cfw.add((byte)89);
            String typeName = paramType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add((byte)21, paramOffset++);
                    cfw.add((byte)-121);
                    break;
                }
                case 'l': {
                    cfw.add((byte)22, paramOffset);
                    cfw.add((byte)-118);
                    paramOffset += 2;
                    break;
                }
                case 'f': {
                    cfw.add((byte)23, paramOffset++);
                    cfw.add((byte)-115);
                    break;
                }
                case 'd': {
                    cfw.add((byte)24, paramOffset);
                    paramOffset += 2;
                }
            }
            cfw.add((byte)-73, "java/lang/Double", "<init>", "(D)", "V");
        }
        return paramOffset;
    }

    private static void generateReturnResult(ClassFileWriter cfw, Class retType) {
        if (retType.equals(Boolean.TYPE)) {
            cfw.add((byte)-72, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)", "Z");
            cfw.add((byte)-84);
        } else if (retType.equals(Character.TYPE)) {
            cfw.add((byte)-72, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            cfw.add((byte)3);
            cfw.add((byte)-74, "java/lang/String", "charAt", "(I)", "C");
            cfw.add((byte)-84);
        } else if (retType.isPrimitive()) {
            cfw.add((byte)-72, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)", "D");
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add((byte)-114);
                    cfw.add((byte)-84);
                    break;
                }
                case 'l': {
                    cfw.add((byte)-113);
                    cfw.add((byte)-83);
                    break;
                }
                case 'f': {
                    cfw.add((byte)-112);
                    cfw.add((byte)-82);
                    break;
                }
                case 'd': {
                    cfw.add((byte)-81);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + retType.toString());
                }
            }
        } else {
            String retTypeStr = retType.getName();
            cfw.addLoadConstant(retTypeStr);
            cfw.add((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
            cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)", "Ljava/lang/Object;");
            cfw.add((byte)-64, retTypeStr.replace('.', '/'));
            cfw.add((byte)-80);
        }
    }

    private static void generateMethod(ClassFileWriter cfw, String genName, String methodName, Class[] parms, Class returnType) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int arrayLocal = 1;
        for (int i = 0; i < parms.length; ++i) {
            Class type = parms[i];
            JavaAdapter.appendTypeString(sb, type);
            arrayLocal = type.equals(Long.TYPE) || type.equals(Double.TYPE) ? (int)((short)(arrayLocal + 2)) : (int)((short)(arrayLocal + 1));
        }
        sb.append(')');
        JavaAdapter.appendTypeString(sb, returnType);
        String methodSignature = sb.toString();
        cfw.startMethod(methodName, methodSignature, (short)1);
        cfw.add((byte)16, (byte)parms.length);
        cfw.add((byte)-67, "java/lang/Object");
        cfw.add((byte)58, arrayLocal);
        short scopeLocal = (short)(arrayLocal + 1);
        boolean loadedScope = false;
        int paramOffset = 1;
        for (int i = 0; i < parms.length; ++i) {
            cfw.add((byte)25, arrayLocal);
            cfw.add((byte)16, i);
            if (parms[i].isPrimitive()) {
                paramOffset = JavaAdapter.generateWrapParam(cfw, paramOffset, parms[i]);
            } else {
                cfw.add((byte)25, paramOffset++);
                if (!loadedScope) {
                    cfw.add((byte)42);
                    cfw.add((byte)-76, genName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
                    cfw.add((byte)58, scopeLocal);
                    loadedScope = true;
                }
                cfw.add((byte)25, scopeLocal);
                cfw.addLoadConstant(parms[i].getName());
                cfw.add((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
                cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "toObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Class;)", "Lorg/mozilla/javascript/Scriptable;");
            }
            cfw.add((byte)83);
        }
        cfw.add((byte)42);
        cfw.add((byte)-76, genName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)42);
        cfw.add((byte)-76, genName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.addLoadConstant(methodName);
        cfw.add((byte)25, arrayLocal);
        cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        if (returnType.equals(Void.TYPE)) {
            cfw.add((byte)87);
            cfw.add((byte)-79);
        } else {
            JavaAdapter.generateReturnResult(cfw, returnType);
        }
        cfw.stopMethod((short)(scopeLocal + 3), null);
    }

    private static int generatePushParam(ClassFileWriter cfw, int paramOffset, Class paramType) {
        String typeName = paramType.getName();
        switch (typeName.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                cfw.add((byte)21, paramOffset++);
                break;
            }
            case 'l': {
                cfw.add((byte)22, paramOffset);
                paramOffset += 2;
                break;
            }
            case 'f': {
                cfw.add((byte)23, paramOffset++);
                break;
            }
            case 'd': {
                cfw.add((byte)24, paramOffset);
                paramOffset += 2;
            }
        }
        return paramOffset;
    }

    private static void generatePopResult(ClassFileWriter cfw, Class retType) {
        if (retType.isPrimitive()) {
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    cfw.add((byte)-84);
                    break;
                }
                case 'l': {
                    cfw.add((byte)-83);
                    break;
                }
                case 'f': {
                    cfw.add((byte)-82);
                    break;
                }
                case 'd': {
                    cfw.add((byte)-81);
                }
            }
        } else {
            cfw.add((byte)-80);
        }
    }

    private static void generateSuper(ClassFileWriter cfw, String genName, String superName, String methodName, String methodSignature, Class[] parms, Class returnType) {
        cfw.startMethod("super$" + methodName, methodSignature, (short)1);
        cfw.add((byte)25, 0);
        int paramOffset = 1;
        for (int i = 0; i < parms.length; ++i) {
            if (parms[i].isPrimitive()) {
                paramOffset = JavaAdapter.generatePushParam(cfw, paramOffset, parms[i]);
                continue;
            }
            cfw.add((byte)25, paramOffset++);
        }
        int rightParen = methodSignature.indexOf(41);
        cfw.add((byte)-73, superName, methodName, methodSignature.substring(0, rightParen + 1), methodSignature.substring(rightParen + 1));
        Class retType = returnType;
        if (!retType.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(cfw, retType);
        } else {
            cfw.add((byte)-79);
        }
        cfw.stopMethod((short)(paramOffset + 1), null);
    }

    private static String getMethodSignature(Method method) {
        Class<?>[] parms = method.getParameterTypes();
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < parms.length; ++i) {
            Class<?> type = parms[i];
            JavaAdapter.appendTypeString(sb, type);
        }
        sb.append(')');
        JavaAdapter.appendTypeString(sb, method.getReturnType());
        return sb.toString();
    }

    private static StringBuffer appendTypeString(StringBuffer sb, Class type) {
        while (type.isArray()) {
            sb.append('[');
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                sb.append('Z');
            } else if (type.equals(Long.TYPE)) {
                sb.append('J');
            } else {
                String typeName = type.getName();
                sb.append(Character.toUpperCase(typeName.charAt(0)));
            }
        } else {
            sb.append('L');
            sb.append(type.getName().replace('.', '/'));
            sb.append(';');
        }
        return sb;
    }

    static {
        generatedClasses = new Hashtable(7);
    }

    static class ClassSignature {
        Class mSuperClass;
        Class[] mInterfaces;
        Object[] mProperties;

        ClassSignature(Class superClass, Class[] interfaces, Scriptable jsObj) {
            this.mSuperClass = superClass;
            this.mInterfaces = interfaces;
            this.mProperties = ScriptableObject.getPropertyIds(jsObj);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassSignature) {
                ClassSignature sig = (ClassSignature)obj;
                if (this.mSuperClass == sig.mSuperClass) {
                    int i;
                    Class[] interfaces = sig.mInterfaces;
                    if (this.mInterfaces != interfaces) {
                        if (this.mInterfaces == null || interfaces == null) {
                            return false;
                        }
                        if (this.mInterfaces.length != interfaces.length) {
                            return false;
                        }
                        for (i = 0; i < interfaces.length; ++i) {
                            if (this.mInterfaces[i] == interfaces[i]) continue;
                            return false;
                        }
                    }
                    if (this.mProperties.length != sig.mProperties.length) {
                        return false;
                    }
                    for (i = 0; i < this.mProperties.length; ++i) {
                        if (this.mProperties[i].equals(sig.mProperties[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.mSuperClass.hashCode();
        }
    }
}

