/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.NoninvertibleTransformException;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.util.GeometryUtils;

public class ItemUtils {
    private ItemUtils() {
    }

    public static Rectangle2D itemToParent(LayoutItem item, Rectangle2D rect) {
        if (item == null || rect == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils.transformRect(itemT, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), false);
    }

    public static Rectangle2D itemToParent(LayoutItem item, double x, double y, double width, double height) {
        if (item == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils.transformRect(itemT, x, y, width, height, false);
    }

    public static Rectangle itemToDevice(LayoutItem item, Rectangle2D rect) {
        return GeometryUtils.toRectangle(ItemUtils.itemToDeviceDouble(item, rect));
    }

    public static Rectangle2D itemToDeviceDouble(LayoutItem item, Rectangle2D rect) {
        if (item == null || rect == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return ItemUtils.transformRect(deviceT, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), false);
    }

    public static Dimension2D itemToDeviceDouble(LayoutItem item, Dimension2D dim) {
        if (item == null || dim == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return ItemUtils._transformDimension(deviceT, dim, false);
    }

    public static Rectangle2D itemToContent(LayoutItem item, double x, double y, double width, double height) {
        JLECanvas canvas = item.getCanvas();
        if (item == null || canvas == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        Rectangle2D device = ItemUtils.transformRect(deviceT, x, y, width, height, false);
        return canvas.deviceToContent(device.getX(), device.getY(), device.getWidth(), device.getHeight());
    }

    public static Rectangle2D itemToContent(LayoutItem item, Rectangle2D rect) {
        if (rect == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        return ItemUtils.itemToContent(item, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static Rectangle itemToDevice(LayoutItem item, double x, double y, double width, double height) {
        if (item == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return GeometryUtils.toRectangle(ItemUtils.transformRect(deviceT, x, y, width, height, false));
    }

    public static Rectangle parentToDevice(LayoutItem item, Rectangle2D rect) {
        LayoutItem parent = item.getItemParent();
        return ItemUtils.itemToDevice(parent == null ? item : parent, rect);
    }

    public static Rectangle parentToDevice(LayoutItem item, double x, double y, double width, double height) {
        LayoutItem parent = item.getItemParent();
        return ItemUtils.itemToDevice(parent == null ? item : parent, x, y, width, height);
    }

    public static Rectangle2D parentToContent(LayoutItem item, double x, double y, double width, double height) {
        LayoutItem parent = item.getItemParent();
        return ItemUtils.itemToContent(parent == null ? item : parent, x, y, width, height);
    }

    public static Rectangle2D parentToContent(LayoutItem item, Rectangle2D bounds) {
        if (item == null || bounds == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        return ItemUtils.parentToContent(item, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public static Rectangle2D parentToItem(LayoutItem item, Rectangle2D rect) {
        if (item == null || rect == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils.transformRect(itemT, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), true);
    }

    public static Rectangle2D parentToItem(LayoutItem item, double x, double y, double width, double height) {
        if (item == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils.transformRect(itemT, x, y, width, height, true);
    }

    public static Rectangle2D deviceToItem(LayoutItem item, Rectangle2D rect) {
        if (item == null || rect == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return ItemUtils.transformRect(deviceT, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), true);
    }

    public static Rectangle2D deviceToItem(LayoutItem item, double x, double y, double width, double height) {
        if (item == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return ItemUtils.transformRect(deviceT, x, y, width, height, true);
    }

    public static Rectangle2D deviceToItem(LayoutItem item, Rectangle rect) {
        return ItemUtils.deviceToItem(item, new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height));
    }

    public static Point2D itemToParent(LayoutItem item, Point2D point) {
        if (item == null || point == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils.transformPoint(itemT, point, false);
    }

    public static Point2D itemToParent(LayoutItem item, double x, double y) {
        if (item == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils.transformPoint(itemT, new Point2D.Double(x, y), false);
    }

    public static Point itemToDevice(LayoutItem item, Point2D point) {
        if (item == null || point == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return GeometryUtils.toPoint(ItemUtils.transformPoint(deviceT, point, false));
    }

    public static Point2D itemToDevice(LayoutItem item, double x, double y) {
        if (item == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return ItemUtils.transformPoint(deviceT, new Point2D.Double(x, y), false);
    }

    public static Point parentToDevice(LayoutItem item, Point2D point) {
        LayoutItem parent = item.getItemParent();
        return ItemUtils.itemToDevice(parent == null ? item : parent, point);
    }

    public static Point2D parentToItem(LayoutItem item, Point2D point) {
        if (item == null || point == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils.transformPoint(itemT, point, true);
    }

    public static Point2D parentToItem(LayoutItem item, double x, double y) {
        if (item == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils.transformPoint(itemT, new Point2D.Double(x, y), true);
    }

    public static Point2D deviceToItem(LayoutItem item, Point2D point) {
        if (item == null || point == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return ItemUtils.transformPoint(deviceT, point, true);
    }

    public static Point2D deviceToItem(LayoutItem item, double x, double y) {
        if (item == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return ItemUtils.transformPoint(deviceT, new Point2D.Double(x, y), true);
    }

    public static Dimension2D deviceToItem(LayoutItem item, Dimension2D dim) {
        if (item == null || dim == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return ItemUtils._transformDimension(deviceT, dim, true);
    }

    public static Dimension2D deviceToItem(LayoutItem item, Dimension dim) {
        return ItemUtils.deviceToItem(item, new Dimension2D.Double(dim.width, dim.height));
    }

    public static Dimension parentToDevice(LayoutItem item, Dimension2D dim) {
        LayoutItem parent = item.getItemParent();
        return ItemUtils.itemToDevice(parent == null ? item : parent, dim);
    }

    public static Dimension itemToDevice(LayoutItem item, Dimension2D dim) {
        if (item == null || dim == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform deviceT = item.getDeviceTransform();
        return GeometryUtils.toDimension(ItemUtils._transformDimension(deviceT, dim, false));
    }

    public static Dimension2D itemToParent(LayoutItem item, Dimension2D dim) {
        if (item == null || dim == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getItemTransform();
        return ItemUtils._transformDimension(itemT, dim, false);
    }

    public static Dimension2D parentToItem(LayoutItem item, Dimension2D dim) {
        if (item == null || dim == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform itemT = item.getDeviceTransform();
        return ItemUtils._transformDimension(itemT, dim, true);
    }

    public static Rectangle2D transformRect(AffineTransform trans, double x, double y, double width, double height, boolean inverse) {
        double[] pts;
        pts = new double[]{x, y, pts[0] + width, pts[1] + height};
        if (inverse) {
            try {
                trans.inverseTransform(pts, 0, pts, 0, 2);
            }
            catch (NoninvertibleTransformException e) {
                return null;
            }
        } else {
            trans.transform(pts, 0, pts, 0, 2);
        }
        Rectangle2D.Double newRect = new Rectangle2D.Double(pts[0], pts[1], pts[2] - pts[0], pts[3] - pts[1]);
        return newRect;
    }

    public static Point2D transformPoint(AffineTransform trans, Point2D point, boolean inverse) {
        if (inverse) {
            try {
                trans.inverseTransform(point, point);
            }
            catch (NoninvertibleTransformException e) {
                return null;
            }
        } else {
            trans.transform(point, point);
        }
        return point;
    }

    private static Dimension2D _transformDimension(AffineTransform trans, Dimension2D dim, boolean inverse) {
        return ItemUtils._transformDimension(trans, dim.getWidth(), dim.getHeight(), inverse);
    }

    private static Dimension2D _transformDimension(AffineTransform trans, double width, double height, boolean inverse) {
        double scaleX = trans.getScaleX();
        double scaleY = trans.getScaleY();
        double newWidth = inverse ? width / scaleX : width * scaleX;
        double newHeight = inverse ? height / scaleY : height * scaleY;
        return new Dimension2D.Double(newWidth, newHeight);
    }

    public static LayoutItem getParentAt(LayoutItem item, double x, double y) {
        LayoutItem found;
        if (item == null) {
            return null;
        }
        for (found = item.getItemAt(x, y); found != null && !found.allowsChildren(); found = found.getItemParent()) {
            if (found != item) continue;
            return null;
        }
        return found;
    }

    public static int getItemIndex(LayoutItem item, LayoutItem parent) {
        if (parent == null) {
            return -1;
        }
        for (int i = parent.getItemCount() - 1; i >= 0; --i) {
            if (parent.getItem(i) != item) continue;
            return i;
        }
        return -1;
    }

    public static Vector getAllItems(LayoutItem item) {
        if (item == null) {
            return new Vector(0);
        }
        Vector itemVector = new Vector();
        ItemUtils._addChildren(itemVector, item);
        return itemVector;
    }

    public static LayoutItem[] removeChildren(JLECanvas canvas, LayoutItem[] items) {
        if (canvas == null || items == null) {
            throw new IllegalArgumentException();
        }
        Vector<LayoutItem> candidates = new Vector<LayoutItem>(items.length);
        for (int i = 0; i < items.length; ++i) {
            candidates.addElement(items[i]);
        }
        Vector result = new Vector(items.length);
        BaseContainer content = canvas.getContentItem();
        ItemUtils._removePreOrder(content, candidates, result);
        Object[] returnMe = new LayoutItem[result.size()];
        result.copyInto(returnMe);
        return returnMe;
    }

    public static Image getItemImage(LayoutItem item) {
        JLECanvas canvas = item.getCanvas();
        if (canvas == null) {
            return null;
        }
        Dimension2D size = item.getItemSize();
        Dimension2D units = canvas.getEngineUnitsPerPixel();
        Image newIm = canvas.createImage((int)(size.getWidth() / units.getWidth()), (int)(size.getHeight() / units.getHeight()));
        return newIm;
    }

    public static LayoutItem getSharedAncestor(LayoutItem first, LayoutItem second) {
        for (first = first.getItemParent(); first != null; first = first.getItemParent()) {
            if (!ItemUtils.isAncestor(first, second)) continue;
            return first;
        }
        return null;
    }

    public static boolean isAncestor(LayoutItem ancestor, LayoutItem child) {
        if (ancestor == null) {
            return false;
        }
        while (child != null) {
            if (child == ancestor) {
                return true;
            }
            child = child.getItemParent();
        }
        return false;
    }

    private static void _removePreOrder(LayoutItem curr, Vector candidates, Vector result) {
        if (candidates.contains(curr)) {
            result.addElement(curr);
            candidates.removeElement(curr);
        } else if (curr.getItemCount() > 0) {
            LayoutItem[] children = curr.getItems();
            for (int i = 0; i < children.length; ++i) {
                ItemUtils._removePreOrder(children[i], candidates, result);
            }
        }
    }

    private static void _addChildren(Vector items, LayoutItem root) {
        items.addElement(root);
        int childCount = root.getItemCount();
        if (childCount > 0) {
            LayoutItem[] children = root.getItems();
            for (int i = 0; i < childCount; ++i) {
                ItemUtils._addChildren(items, children[i]);
            }
        }
    }
}

