/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.util.concurrent.TimeUnit;
import oracle.kv.Durability;
import oracle.kv.table.WriteOptions;

public class BulkWriteOptions
extends WriteOptions {
    private static final int MIN_REQUEST_SIZE = 65536;
    private int bulkHeapPercent = 40;
    private int maxRequestSize = 524288;
    private int perShardParallelism = 3;
    private int streamParallelism = 1;

    public BulkWriteOptions(Durability durability, long timeout, TimeUnit timeoutUnit) {
        super(durability, timeout, timeoutUnit);
    }

    public BulkWriteOptions(BulkWriteOptions options) {
        super(options);
        this.bulkHeapPercent = options.bulkHeapPercent;
        this.maxRequestSize = options.maxRequestSize;
        this.perShardParallelism = options.perShardParallelism;
        this.streamParallelism = options.streamParallelism;
    }

    public BulkWriteOptions() {
    }

    public int getBulkHeapPercent() {
        return this.bulkHeapPercent;
    }

    public void setBulkHeapPercent(int bulkHeapPercent) {
        if (bulkHeapPercent > 100) {
            throw new IllegalArgumentException("Percentage:" + bulkHeapPercent + " cannot exceed 100");
        }
        if (bulkHeapPercent < 1) {
            throw new IllegalArgumentException("Percentage:" + bulkHeapPercent + " cannot be less than 1");
        }
        this.bulkHeapPercent = bulkHeapPercent;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        if (maxRequestSize < 65536) {
            throw new IllegalArgumentException("Max request size:" + maxRequestSize + " cannot be less " + "than " + 65536);
        }
        this.maxRequestSize = maxRequestSize;
    }

    public int getPerShardParallelism() {
        return this.perShardParallelism;
    }

    public void setPerShardParallelism(int perShardParallelism) {
        if (perShardParallelism < 1) {
            throw new IllegalArgumentException("Maximum number of threads per shard:" + perShardParallelism + " cannot be less than 1");
        }
        this.perShardParallelism = perShardParallelism;
    }

    public int getStreamParallelism() {
        return this.streamParallelism;
    }

    public void setStreamParallelism(int streamParallelism) {
        if (streamParallelism < 1) {
            throw new IllegalArgumentException("Maximum number of streams concurrently read:" + streamParallelism + " cannot be less than 1");
        }
        this.streamParallelism = streamParallelism;
    }
}

