/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Consistency;
import oracle.kv.FaultException;
import oracle.kv.impl.util.ObjectUtil;

public class ConsistencyException
extends FaultException {
    private static final long serialVersionUID = 1L;
    private final Consistency consistency;

    public ConsistencyException(Throwable cause, Consistency consistency) {
        super(cause, true);
        this.consistency = consistency;
        this.checkValidFields();
    }

    private void checkValidFields() {
        ObjectUtil.checkNull("consistency", this.consistency);
    }

    public ConsistencyException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.consistency = Consistency.readFastExternal(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.consistency.writeFastExternal(out, serialVersion);
    }

    public Consistency getConsistency() {
        return this.consistency;
    }
}

