/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.kv.FastExternalizableException;
import oracle.kv.KVVersion;
import oracle.kv.impl.util.SerializationUtil;

public class FaultException
extends FastExternalizableException {
    private static final long serialVersionUID = 1L;
    private final boolean occurredRemotely;
    private final String faultClassName;
    private final String remoteStackTrace;

    public FaultException(String msg, boolean isRemote) {
        this(msg, null, isRemote);
    }

    public FaultException(Throwable cause, boolean isRemote) {
        this(cause.getMessage(), cause, isRemote);
    }

    public FaultException(String msg, Throwable cause, boolean isRemote) {
        super(msg + " (" + KVVersion.CURRENT_VERSION.getNumericVersionString() + ")", isRemote ? null : cause);
        this.occurredRemotely = isRemote;
        if (isRemote) {
            StringWriter sw = new StringWriter(500);
            if (cause == null) {
                new RuntimeException().printStackTrace(new PrintWriter(sw));
                this.faultClassName = this.getClass().getName();
            } else {
                cause.printStackTrace(new PrintWriter(sw));
                this.faultClassName = cause.getClass().getName();
            }
            this.remoteStackTrace = sw.toString();
        } else {
            this.remoteStackTrace = null;
            this.faultClassName = cause != null && this.getClass() == FaultException.class ? cause.getClass().getName() : this.getClass().getName();
        }
    }

    public FaultException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.occurredRemotely = true;
        this.faultClassName = SerializationUtil.readString(in, serialVersion);
        this.remoteStackTrace = SerializationUtil.readString(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.writeFastExternal(out, serialVersion, this.getMessage());
    }

    @Override
    protected void writeFastExternal(DataOutput out, short serialVersion, String message) throws IOException {
        if (!this.occurredRemotely) {
            throw new IllegalStateException("Only exceptions intended to be supplied remotely can be serialized");
        }
        super.writeFastExternal(out, serialVersion, message);
        SerializationUtil.writeString(out, serialVersion, this.faultClassName);
        SerializationUtil.writeString(out, serialVersion, this.remoteStackTrace);
    }

    public boolean wasLoggedRemotely() {
        return this.occurredRemotely;
    }

    public String getFaultClassName() {
        return this.faultClassName;
    }

    public String getRemoteStackTrace() {
        return this.remoteStackTrace;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(super.toString());
        sb.append("\nFault class name: ");
        sb.append(this.faultClassName);
        if (this.remoteStackTrace != null) {
            sb.append("\nRemote stack trace: ");
            sb.append(this.remoteStackTrace);
        }
        return sb.toString();
    }
}

