/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.kv.hadoop.hive.table.TableArrayObjectInspector;
import oracle.kv.hadoop.hive.table.TableBinaryObjectInspector;
import oracle.kv.hadoop.hive.table.TableBooleanObjectInspector;
import oracle.kv.hadoop.hive.table.TableDoubleObjectInspector;
import oracle.kv.hadoop.hive.table.TableEnumObjectInspector;
import oracle.kv.hadoop.hive.table.TableFieldTypeEnum;
import oracle.kv.hadoop.hive.table.TableFloatObjectInspector;
import oracle.kv.hadoop.hive.table.TableIntObjectInspector;
import oracle.kv.hadoop.hive.table.TableLongObjectInspector;
import oracle.kv.hadoop.hive.table.TableMapObjectInspector;
import oracle.kv.hadoop.hive.table.TableRecordObjectInspector;
import oracle.kv.hadoop.hive.table.TableSerDeBase;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.RecordDef;
import oracle.kv.table.Row;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class TableSerDe
extends TableSerDeBase {
    private static final String thisClassName = TableSerDe.class.getName();
    private static final Log LOG = LogFactory.getLog((String)thisClassName);

    @Override
    protected void validateParams(Properties tbl) throws SerDeException {
        Object msg;
        LOG.debug((Object)("KV Store Table Name = " + this.getKvTableName()));
        List<String> fieldNames = this.getKvFieldNames();
        if (fieldNames == null || fieldNames.size() == 0) {
            String msg2 = "No fields defined in KV Store table [name=" + this.getKvTableName() + "]";
            LOG.error((Object)msg2);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg2));
        }
        LOG.debug((Object)("KV Store Field Names = " + fieldNames));
        List<FieldDef.Type> fieldTypes = this.getKvFieldTypes();
        if (fieldTypes == null || fieldTypes.size() == 0) {
            String msg3 = "No types defined for fields in KV Store table [name=" + this.getKvTableName() + ", fields=" + fieldNames + "]";
            LOG.error((Object)msg3);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg3));
        }
        LOG.debug((Object)("KV Store Field Types = " + fieldTypes));
        LOG.debug((Object)("HIVE Table Name = " + this.getHiveTableName()));
        LazySerDeParameters params = this.getSerdeParams();
        if (params == null) {
            String msg4 = "No SerDeParameters specified for Hive table [name=" + this.getHiveTableName() + "]";
            LOG.error((Object)msg4);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg4));
        }
        List rawColumnNames = params.getColumnNames();
        if (rawColumnNames == null || rawColumnNames.size() == 0) {
            String msg5 = "No columns defined in Hive table [name=" + this.getHiveTableName() + "]";
            LOG.error((Object)msg5);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg5));
        }
        ArrayList<String> columnNames = new ArrayList<String>(rawColumnNames.size());
        for (String rawColumnName : rawColumnNames) {
            columnNames.add(rawColumnName.toLowerCase());
        }
        LOG.debug((Object)("HIVE Column Names = " + columnNames));
        List columnTypes = params.getColumnTypes();
        if (columnTypes == null || columnTypes.size() == 0) {
            msg = "No types defined for columns in Hive table [name=" + this.getHiveTableName() + ", columns=" + columnNames + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException((String)msg));
        }
        LOG.debug((Object)("HIVE Column Types = " + columnTypes));
        if (fieldNames.size() != fieldTypes.size()) {
            msg = "For the KV Store table [name=" + this.getKvTableName() + "], " + "the number of field names [" + fieldNames.size() + "] != number of field types [" + fieldTypes.size() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException((String)msg));
        }
        if (columnNames.size() != columnTypes.size()) {
            msg = "For the created Hive table [name=" + this.getHiveTableName() + "], the number of column names [" + columnNames.size() + "] != number of column types [" + columnTypes.size() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException((String)msg));
        }
        if (fieldNames.size() != columnNames.size()) {
            msg = "Number of fields [" + fieldNames.size() + "] in the " + "KV Store table [name=" + this.getKvTableName() + "] != " + "number of columns [" + columnNames.size() + "] specified for the created Hive table [name=" + this.getHiveTableName() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException((String)msg));
        }
        for (String fieldName : fieldNames) {
            if (columnNames.contains(fieldName.toLowerCase())) continue;
            String msg6 = "Field names from the KV Store table [name=" + this.getKvTableName() + "] does not match the column names " + "from the created Hive table [name=" + this.getHiveTableName() + "] - " + fieldNames + " != " + columnNames;
            LOG.error((Object)msg6);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg6));
        }
        List<FieldDef> fieldDefs = this.getKvFieldDefs();
        for (int i = 0; i < fieldDefs.size(); ++i) {
            if (TableFieldTypeEnum.kvHiveTypesMatch(fieldDefs.get(i), (TypeInfo)columnTypes.get(i))) continue;
            String msg7 = "Field types from the KV Store table [name=" + this.getKvTableName() + "] do not match the column types " + "from the created Hive table [name=" + this.getHiveTableName() + "] - " + fieldTypes + " != " + columnTypes;
            LOG.error((Object)msg7);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg7));
        }
    }

    @Override
    protected ObjectInspector createObjectInspector() throws SerDeException {
        ArrayList<ObjectInspector> fieldObjInspectors = new ArrayList<ObjectInspector>();
        List hiveColumnNames = this.getSerdeParams().getColumnNames();
        List<FieldDef> fieldDefs = this.getKvFieldDefs();
        for (FieldDef fieldDef : fieldDefs) {
            fieldObjInspectors.add(this.objectInspector(fieldDef));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector((List)hiveColumnNames, fieldObjInspectors);
    }

    @Override
    public Object deserialize(Writable field) throws SerDeException {
        this.hiveRow.clear();
        LOG.debug((Object)("deserialize field = " + field));
        Row kvRow = this.getKvTable().createRowFromJson(field.toString(), true);
        RecordDef recDef = kvRow.getDefinition();
        LOG.debug((Object)("Row to deserialize:\n" + kvRow));
        LOG.debug((Object)("RecordDef of Row to deserialize:\n" + recDef));
        for (String fieldName : kvRow.getFieldNames()) {
            LOG.debug((Object)("fieldName = " + fieldName));
            FieldValue fieldValue = kvRow.get(fieldName);
            ObjectInspector oi = this.objectInspector(recDef, fieldName);
            if (oi instanceof StringObjectInspector) {
                this.hiveRow.add(((StringObjectInspector)oi).getPrimitiveJavaObject((Object)fieldValue));
                continue;
            }
            if (oi instanceof BinaryObjectInspector) {
                this.hiveRow.add(((BinaryObjectInspector)oi).getPrimitiveJavaObject((Object)fieldValue));
                continue;
            }
            if (oi instanceof BooleanObjectInspector) {
                this.hiveRow.add(((BooleanObjectInspector)oi).get((Object)fieldValue));
                continue;
            }
            if (oi instanceof DoubleObjectInspector) {
                this.hiveRow.add(((DoubleObjectInspector)oi).get((Object)fieldValue));
                continue;
            }
            if (oi instanceof FloatObjectInspector) {
                this.hiveRow.add(Float.valueOf(((FloatObjectInspector)oi).get((Object)fieldValue)));
                continue;
            }
            if (oi instanceof IntObjectInspector) {
                this.hiveRow.add(((IntObjectInspector)oi).get((Object)fieldValue));
                continue;
            }
            if (oi instanceof LongObjectInspector) {
                this.hiveRow.add(((LongObjectInspector)oi).get((Object)fieldValue));
                continue;
            }
            if (oi instanceof TableEnumObjectInspector) {
                this.hiveRow.add(((TableEnumObjectInspector)oi).getPrimitiveJavaObject(fieldValue));
                continue;
            }
            if (oi instanceof ListObjectInspector) {
                this.hiveRow.add(((ListObjectInspector)oi).getList((Object)fieldValue));
                continue;
            }
            if (oi instanceof MapObjectInspector) {
                this.hiveRow.add(((TableMapObjectInspector)oi).getMap(fieldValue));
                continue;
            }
            if (!(oi instanceof StructObjectInspector)) continue;
            this.hiveRow.add(((StructObjectInspector)oi).getStructFieldsDataAsList((Object)fieldValue));
        }
        return this.hiveRow;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objectInspector) throws SerDeException {
        LOG.debug((Object)("obj = " + obj + ", objectInspector = " + objectInspector.getClass().getSimpleName()));
        StructObjectInspector structInspector = (StructObjectInspector)objectInspector;
        List structFields = structInspector.getAllStructFieldRefs();
        List hiveColumnNames = this.getSerdeParams().getColumnNames();
        if (structFields.size() != hiveColumnNames.size()) {
            String msg = "Number of Hive columns to serialize " + structFields.size() + "] does not equal number of columns [" + hiveColumnNames.size() + "] specified in the created Hive " + "table [name=" + this.getHiveTableName() + "]";
            LOG.error((Object)msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        this.kvMapWritable.clear();
        for (int i = 0; i < structFields.size(); ++i) {
            Object fieldData;
            StructField structField = (StructField)structFields.get(i);
            String hiveColumnName = (String)hiveColumnNames.get(i);
            if (structField == null) continue;
            AbstractPrimitiveObjectInspector fieldObjInspector = (AbstractPrimitiveObjectInspector)structField.getFieldObjectInspector();
            Object fieldValue = (Writable)fieldObjInspector.getPrimitiveWritableObject(fieldData = structInspector.getStructFieldData(obj, structField));
            if (fieldValue == null) {
                fieldValue = PrimitiveObjectInspector.PrimitiveCategory.STRING.equals((Object)fieldObjInspector.getPrimitiveCategory()) ? NullWritable.get() : new IntWritable(0);
            }
            this.kvMapWritable.put((Writable)new Text(hiveColumnName), fieldValue);
        }
        return this.kvMapWritable;
    }

    private ObjectInspector objectInspector(RecordDef recDef, String fieldName) {
        FieldDef.Type fieldType = recDef.getFieldDef(fieldName).getType();
        switch (fieldType) {
            case STRING: {
                return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
            }
            case BOOLEAN: {
                return new TableBooleanObjectInspector();
            }
            case INTEGER: {
                return new TableIntObjectInspector();
            }
            case LONG: {
                return new TableLongObjectInspector();
            }
            case FLOAT: {
                return new TableFloatObjectInspector();
            }
            case DOUBLE: {
                return new TableDoubleObjectInspector();
            }
            case BINARY: 
            case FIXED_BINARY: {
                return new TableBinaryObjectInspector();
            }
            case ENUM: {
                return new TableEnumObjectInspector();
            }
            case MAP: {
                FieldDef mapElementDef = ((MapDef)recDef.getFieldDef(fieldName)).getElement();
                ObjectInspector mapElementObjectInspector = this.objectInspector(mapElementDef);
                return new TableMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, mapElementObjectInspector);
            }
            case ARRAY: {
                FieldDef arrayElementDef = ((ArrayDef)recDef.getFieldDef(fieldName)).getElement();
                ObjectInspector listElementObjectInspector = this.objectInspector(arrayElementDef);
                return new TableArrayObjectInspector(listElementObjectInspector);
            }
            case RECORD: {
                RecordDef recTypeDef = (RecordDef)recDef.getFieldDef(fieldName);
                List<String> structFieldNames = recTypeDef.getFieldNames();
                ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
                for (String structFieldName : structFieldNames) {
                    FieldDef structFieldDef = recTypeDef.getFieldDef(structFieldName);
                    structFieldObjectInspectors.add(this.objectInspector(structFieldDef));
                }
                return new TableRecordObjectInspector(structFieldNames, structFieldObjectInspectors);
            }
        }
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    private ObjectInspector objectInspector(FieldDef fieldDef) {
        if (fieldDef == null) {
            return null;
        }
        FieldDef.Type fieldType = fieldDef.getType();
        LOG.debug((Object)("fieldDef = " + fieldDef.getClass().getSimpleName() + ", fieldType = " + fieldType));
        switch (fieldType) {
            case STRING: {
                return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
            }
            case BOOLEAN: {
                return new TableBooleanObjectInspector();
            }
            case INTEGER: {
                return new TableIntObjectInspector();
            }
            case LONG: {
                return new TableLongObjectInspector();
            }
            case FLOAT: {
                return new TableFloatObjectInspector();
            }
            case DOUBLE: {
                return new TableDoubleObjectInspector();
            }
            case BINARY: 
            case FIXED_BINARY: {
                return new TableBinaryObjectInspector();
            }
            case ENUM: {
                return new TableEnumObjectInspector();
            }
            case MAP: {
                FieldDef mapElementDef = ((MapDef)fieldDef).getElement();
                return new TableMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, this.objectInspector(mapElementDef));
            }
            case ARRAY: {
                ArrayDef arrayDef = (ArrayDef)fieldDef;
                FieldDef arrayElementDef = arrayDef.getElement();
                ObjectInspector listElementObjectInspector = this.objectInspector(arrayElementDef);
                return new TableArrayObjectInspector(listElementObjectInspector);
            }
            case RECORD: {
                RecordDef recordDef = (RecordDef)fieldDef;
                List<String> structFieldNames = recordDef.getFieldNames();
                ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
                for (String structFieldName : structFieldNames) {
                    FieldDef structFieldDef = recordDef.getFieldDef(structFieldName);
                    structFieldObjectInspectors.add(this.objectInspector(structFieldDef));
                }
                return new TableRecordObjectInspector(structFieldNames, structFieldObjectInspectors);
            }
        }
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }
}

