/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.kv.Value;
import oracle.kv.avro.JsonAvroBinding;
import oracle.kv.avro.JsonRecord;
import oracle.kv.avro.RawAvroBinding;
import oracle.kv.avro.RawRecord;
import oracle.kv.avro.SchemaNotAllowedException;
import oracle.kv.avro.UndefinedSchemaException;
import oracle.kv.impl.api.avro.AvroCatalogImpl;
import oracle.kv.impl.api.avro.GenericBinding;
import oracle.kv.impl.api.avro.RawBinding;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.UnresolvedUnionException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ResolvingDecoder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

class JsonBinding
implements JsonAvroBinding {
    private final RawAvroBinding rawBinding;
    private final Map<String, Schema> allowedSchemas;

    JsonBinding(AvroCatalogImpl catalog, Map<String, Schema> allowedSchemas) throws UndefinedSchemaException {
        this.rawBinding = catalog.getRawBinding();
        this.allowedSchemas = new HashMap<String, Schema>(allowedSchemas);
        catalog.checkDefinedSchemas(allowedSchemas);
    }

    @Override
    public JsonRecord toObject(Value value) throws SchemaNotAllowedException, IllegalArgumentException {
        JsonNode node;
        RawRecord raw = this.rawBinding.toObject(value);
        Schema writerSchema = raw.getSchema();
        Schema readerSchema = AvroCatalogImpl.checkToObjectSchema(writerSchema, this.allowedSchemas);
        JsonDatumReader reader = new JsonDatumReader(writerSchema, readerSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(raw.getRawData(), null);
        try {
            node = reader.read(null, decoder);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to deserialize JsonNode", e);
        }
        return new JsonRecord(node, readerSchema);
    }

    @Override
    public JsonRecord toObjectForImport(Value value, Schema schema) throws SchemaNotAllowedException, IllegalArgumentException {
        JsonNode node;
        RawBinding rBinding = (RawBinding)this.rawBinding;
        RawRecord raw = rBinding.toObjectForImport(value, schema);
        Schema writerSchema = raw.getSchema();
        Schema readerSchema = AvroCatalogImpl.checkToObjectSchema(writerSchema, this.allowedSchemas);
        JsonDatumReader reader = new JsonDatumReader(writerSchema, readerSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(raw.getRawData(), null);
        try {
            node = reader.read(null, decoder);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to deserialize JsonNode", e);
        }
        return new JsonRecord(node, readerSchema);
    }

    @Override
    public Value toValue(JsonRecord object) throws SchemaNotAllowedException, UndefinedSchemaException, IllegalArgumentException {
        Schema writerSchema = object.getSchema();
        AvroCatalogImpl.checkToValueSchema(writerSchema, this.allowedSchemas);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonDatumWriter writer = new JsonDatumWriter(writerSchema);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(out, null);
        try {
            writer.write(object.getJsonNode(), encoder);
            encoder.flush();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to serialize JsonNode", e);
        }
        RawRecord raw = new RawRecord(out.toByteArray(), writerSchema);
        return this.rawBinding.toValue(raw);
    }

    private static AvroTypeException wrapTypeError(RuntimeException cause, String addMsg) {
        return new AvroTypeException(cause.getMessage() + addMsg, cause.getCause() != null ? cause.getCause() : cause);
    }

    private static AvroTypeException jsonTypeError(Schema.Type type, JsonNode node) {
        return new AvroTypeException("Expected Avro type " + (Object)((Object)type) + " but got JSON value: " + node);
    }

    private static String bytesToString(byte[] buf, int offset, int len) {
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            builder.append((char)(buf[offset + i] & 0xFF));
        }
        return builder.toString();
    }

    private static byte[] stringToBytes(Schema schema, String str, boolean isFixedType) {
        byte[] buf = new byte[str.length()];
        for (int i = 0; i < buf.length; ++i) {
            char c = str.charAt(i);
            if (c > '\u00ff') {
                String fieldDesc = isFixedType ? "A 'fixed' field of type: " + schema.getName() : "A 'bytes' field";
                throw new AvroTypeException(fieldDesc + " contains illegal char: 0x" + Integer.toHexString(c) + "; all char values must be <= 0xFF");
            }
            buf[i] = (byte)c;
        }
        return buf;
    }

    private static JsonNode genericToJson(Object value) {
        if (value == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        if (value instanceof CharSequence) {
            return JsonNodeFactory.instance.textNode(value.toString());
        }
        if (value instanceof Integer) {
            return JsonNodeFactory.instance.numberNode((Integer)value);
        }
        if (value instanceof Long) {
            return JsonNodeFactory.instance.numberNode((Long)value);
        }
        if (value instanceof Float) {
            return JsonNodeFactory.instance.numberNode((Float)value);
        }
        if (value instanceof Double) {
            return JsonNodeFactory.instance.numberNode((Double)value);
        }
        if (value instanceof Boolean) {
            return JsonNodeFactory.instance.booleanNode((Boolean)value);
        }
        throw new IllegalStateException("Unknown generic datum class: " + value.getClass().getName());
    }

    private static class JsonDatumReader
    extends GenericDatumReader<JsonNode> {
        JsonDatumReader(Schema writer, Schema reader) {
            super(writer, reader, JsonData.INSTANCE);
        }

        @Override
        protected Object readBytes(Object old, Decoder in) throws IOException {
            ByteBuffer buf = in.readBytes(null);
            return JsonBinding.bytesToString(buf.array(), buf.arrayOffset(), buf.remaining());
        }

        @Override
        protected Object createBytes(byte[] value) {
            return JsonBinding.bytesToString(value, 0, value.length);
        }

        @Override
        protected Object readFixed(Object old, Schema expected, Decoder in) throws IOException {
            byte[] b = new byte[expected.getFixedSize()];
            in.readFixed(b, 0, b.length);
            return JsonData.INSTANCE.createFixed(old, b, expected);
        }

        @Override
        protected Object createEnum(String symbol, Schema schema) {
            return symbol;
        }

        @Override
        protected Object newArray(Object old, int size, Schema schema) {
            return JsonNodeFactory.instance.arrayNode();
        }

        @Override
        protected void addToArray(Object array, long pos, Object value) {
            ((ArrayNode)array).add(JsonBinding.genericToJson(value));
        }

        @Override
        protected Object newMap(Object old, int size) {
            return JsonNodeFactory.instance.objectNode();
        }

        @Override
        protected void addToMap(Object map, Object key, Object value) {
            ((ObjectNode)map).put(key.toString(), JsonBinding.genericToJson(value));
        }

        @Override
        protected Object read(Object old, Schema expected, ResolvingDecoder in) throws IOException {
            if (expected.getType() != Schema.Type.UNION) {
                return super.read(old, expected, in);
            }
            int index = in.readIndex();
            Schema datumSchema = expected.getTypes().get(index);
            Object datum = this.read(old, datumSchema, in);
            if (datum == null) {
                return null;
            }
            Object record = JsonData.INSTANCE.newRecord(old, expected);
            JsonData.INSTANCE.setField(record, datumSchema.getFullName(), 0, datum);
            return record;
        }
    }

    static class JsonDatumWriter
    extends GenericDatumWriter<JsonNode> {
        private final boolean applyDefaultValues;

        JsonDatumWriter(Schema schema) {
            this(schema, false);
        }

        JsonDatumWriter(Schema schema, boolean applyDefaultValues) {
            super(schema, JsonData.INSTANCE);
            this.applyDefaultValues = applyDefaultValues;
        }

        @Override
        protected void writeFixed(Schema schema, Object datum, Encoder out) throws IOException {
            byte[] bytes = JsonBinding.stringToBytes(schema, (String)datum, true);
            GenericBinding.writeFixed(schema, bytes, out);
        }

        @Override
        protected long getArraySize(Object array) {
            return ((ArrayNode)array).size();
        }

        @Override
        protected Iterator<? extends Object> getArrayElements(Object array) {
            return ((ArrayNode)array).iterator();
        }

        @Override
        protected int getMapSize(Object map) {
            return ((ObjectNode)map).size();
        }

        @Override
        protected Iterable<Map.Entry<Object, Object>> getMapEntries(Object map) {
            final ObjectNode objectNode = (ObjectNode)map;
            return new Iterable<Map.Entry<Object, Object>>(){

                @Override
                public Iterator<Map.Entry<Object, Object>> iterator() {
                    final Iterator<Map.Entry<String, JsonNode>> iter = objectNode.getFields();
                    return new Iterator<Map.Entry<Object, Object>>(){

                        @Override
                        public boolean hasNext() {
                            return iter.hasNext();
                        }

                        @Override
                        public Map.Entry<Object, Object> next() {
                            Map.Entry entry = (Map.Entry)iter.next();
                            return new AbstractMap.SimpleEntry<Object, Object>(entry.getKey(), entry.getValue());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        @Override
        protected void write(Schema schema, Object datum, Encoder out) throws IOException {
            JsonNode node = (JsonNode)datum;
            Schema.Type type = schema.getType();
            switch (type) {
                case RECORD: {
                    if (!node.isObject()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    this.writeRecord(schema, node, out);
                    break;
                }
                case ENUM: {
                    if (!node.isTextual()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    this.writeEnum(schema, node.getTextValue(), out);
                    break;
                }
                case ARRAY: {
                    if (!node.isArray()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    this.writeArray(schema, node, out);
                    break;
                }
                case MAP: {
                    if (!node.isObject()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    this.writeMap(schema, node, out);
                    break;
                }
                case UNION: {
                    if (this.applyDefaultValues) {
                        this.write(schema.getTypes().get(0), datum, out);
                        break;
                    }
                    int index = this.resolveUnion(schema, node);
                    Schema datumSchema = schema.getTypes().get(index);
                    if (!node.isNull() && (datum = this.getData().getField(node, datumSchema.getFullName(), 0)) == null) {
                        throw new RuntimeException("Unexpected missing union field: " + datumSchema.getFullName() + " union: " + schema.getFullName() + " value: " + node);
                    }
                    out.writeIndex(index);
                    this.write(datumSchema, datum, out);
                    break;
                }
                case FIXED: {
                    if (!node.isTextual()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    this.writeFixed(schema, node.getTextValue(), out);
                    break;
                }
                case STRING: {
                    if (!node.isTextual()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    this.writeString(schema, node.getTextValue(), out);
                    break;
                }
                case BYTES: {
                    if (!node.isTextual()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    out.writeBytes(JsonBinding.stringToBytes(schema, node.getTextValue(), false));
                    break;
                }
                case INT: {
                    if (!node.isInt() && !node.isLong()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    int intVal = node.getIntValue();
                    if ((long)intVal != node.getLongValue()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    out.writeInt(intVal);
                    break;
                }
                case LONG: {
                    if (!node.isInt() && !node.isLong()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    out.writeLong(node.getLongValue());
                    break;
                }
                case FLOAT: {
                    if (!node.isNumber()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    out.writeFloat((float)node.getDoubleValue());
                    break;
                }
                case DOUBLE: {
                    if (!node.isNumber()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    out.writeDouble(node.getDoubleValue());
                    break;
                }
                case BOOLEAN: {
                    if (!node.isBoolean()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    out.writeBoolean(node.getBooleanValue());
                    break;
                }
                case NULL: {
                    if (!node.isNull()) {
                        throw JsonBinding.jsonTypeError(type, node);
                    }
                    out.writeNull();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type: " + (Object)((Object)type));
                }
            }
        }

        @Override
        protected void writeRecord(Schema schema, Object datum, Encoder out) throws IOException {
            for (Schema.Field f : schema.getFields()) {
                Object value = this.getData().getField(datum, f.name(), f.pos());
                if (value == null && this.applyDefaultValues) {
                    value = f.defaultValue();
                }
                if (value == null) {
                    value = JsonNodeFactory.instance.nullNode();
                }
                try {
                    this.write(f.schema(), value, out);
                }
                catch (RuntimeException e) {
                    throw JsonBinding.wrapTypeError(e, " in field " + f.name() + " of " + schema.getFullName());
                }
            }
        }
    }

    private static class JsonData
    extends GenericData {
        static final JsonData INSTANCE = new JsonData();

        private JsonData() {
        }

        @Override
        public JsonDatumReader createDatumReader(Schema schema) {
            return new JsonDatumReader(schema, schema);
        }

        @Override
        public Object newRecord(Object old, Schema schema) {
            return JsonNodeFactory.instance.objectNode();
        }

        @Override
        public void setField(Object r, String name, int pos, Object value) {
            ObjectNode parent = (ObjectNode)r;
            JsonNode child = JsonBinding.genericToJson(value);
            parent.put(name, child);
        }

        @Override
        public Object getField(Object r, String name, int pos) {
            return ((JsonNode)r).get(name);
        }

        @Override
        public Object createFixed(Object old, Schema schema) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object createFixed(Object old, byte[] bytes, Schema schema) {
            return JsonBinding.bytesToString(bytes, 0, schema.getFixedSize());
        }

        @Override
        public int resolveUnion(Schema unionSchema, Object datum) {
            String schemaName;
            JsonNode node = (JsonNode)datum;
            if (node.isNull()) {
                schemaName = "null";
            } else {
                if (!node.isObject()) {
                    throw new UnresolvedUnionException(unionSchema, datum);
                }
                Iterator<String> names = node.getFieldNames();
                if (!names.hasNext()) {
                    throw new UnresolvedUnionException(unionSchema, datum);
                }
                schemaName = names.next();
                if (names.hasNext()) {
                    throw new UnresolvedUnionException(unionSchema, datum);
                }
            }
            Integer index = unionSchema.getIndexNamed(schemaName);
            if (index == null) {
                throw new UnresolvedUnionException(unionSchema, datum);
            }
            return index;
        }
    }
}

