/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.bulk;

import com.sleepycat.je.utilint.JVMSystemUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.BulkWriteOptions;
import oracle.kv.EntryStream;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.TopologyUtil;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.TimeToLive;

public abstract class BulkPut<T> {
    private final KVStoreImpl store;
    private final Topology topology;
    private final KeySerializer serializer;
    private final EntryStream<T>[] streams;
    private final List<StreamReader<T>> readers;
    private final PartitionValues[] pMap;
    public static final Comparator<byte[]> KEY_BYTES_COMPARATOR = new Key.BytesComparator();
    private final BulkWriteOptions options;
    private final long partitionThresholdBytes;
    private static final int partitionHeapMinBytes = 102400;
    final AggregateStatistics statistics = new AggregateStatistics();
    private final Logger logger;
    private final AtomicReference<Exception> terminateException = new AtomicReference();
    private ExecutorService shardExecutor = null;
    private ExecutorService streamExecutor = null;
    private static PartitionBatch partitionBatchEOF = new PartitionBatch();

    public BulkPut(KVStoreImpl store, BulkWriteOptions options, List<EntryStream<T>> streams, Logger logger) {
        this.logger = logger;
        this.store = store;
        this.topology = store.getTopology();
        this.serializer = store.getKeySerializer();
        this.options = options;
        EntryStream[] array = streams.toArray(new EntryStream[streams.size()]);
        this.streams = array;
        this.readers = new ArrayList<StreamReader<T>>();
        int nPartitions = this.topology.getPartitionMap().size();
        this.partitionThresholdBytes = this.computeThresholdBytes(nPartitions);
        PartitionValues[] partitionValues = new PartitionValues[nPartitions + 1];
        this.pMap = partitionValues;
        for (int i = 0; i <= nPartitions; ++i) {
            this.pMap[i] = new PartitionValues(i);
        }
    }

    private long computeThresholdBytes(int nPartitions) {
        long maxHeapBytes = JVMSystemUtils.getRuntimeMaxMemory();
        if (maxHeapBytes == Long.MAX_VALUE) {
            String msg = "Could not determine a max heap size. This is unusual. Please specify the -Xmx argument to the jvm invocation as a workaround";
            throw new IllegalArgumentException("Could not determine a max heap size. This is unusual. Please specify the -Xmx argument to the jvm invocation as a workaround");
        }
        int bulkHeapPercent = this.options.getBulkHeapPercent();
        long maxLoadHeapBytes = maxHeapBytes * (long)bulkHeapPercent / 100L;
        long thresholdBytes = maxLoadHeapBytes / 2L / (long)nPartitions;
        if (thresholdBytes < 102400L) {
            long minHeapBytes = nPartitions * 102400 * 2 * 100 / bulkHeapPercent;
            this.logger.warning("Insufficient heap:" + maxHeapBytes + ". For best " + "performance increase -Xmx on jvm invocation " + "to a min of " + minHeapBytes / 0x100000L + "mb");
        }
        String fmt = "Buffer bytes per partition:%,d Max heap memory:%,d Bulk heap %% %,d";
        this.logger.info(String.format("Buffer bytes per partition:%,d Max heap memory:%,d Bulk heap %% %,d", thresholdBytes, maxHeapBytes, bulkHeapPercent));
        return thresholdBytes;
    }

    public abstract StreamReader<T> createReader(int var1, EntryStream<T> var2);

    protected abstract T convertToEntry(Key var1, Value var2);

    public void execute() throws InterruptedException {
        this.shardExecutor = this.startShardExecutor();
        KVThreadFactory threadFactory = new KVThreadFactory("BulkStreamReader", this.logger);
        this.streamExecutor = Executors.newFixedThreadPool(this.options.getStreamParallelism(), threadFactory);
        int streamId = 0;
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>(this.streams.length);
        try {
            for (EntryStream<T> s : this.streams) {
                StreamReader<T> streamReader;
                if (!futures.add(this.streamExecutor.submit(streamReader = this.createReader(++streamId, s)))) {
                    throw new IllegalStateException("failed to add new future for stream:" + s.name());
                }
                this.readers.add(streamReader);
            }
        }
        catch (RejectedExecutionException ree) {
            this.terminateWithException(ree);
        }
        this.streamExecutor.shutdown();
        this.logProgress(this.streamExecutor);
        this.finishStreams(futures, this.statistics);
        this.flushPartitions();
        this.shutdownShardExecutor(this.shardExecutor);
        this.logger.log(Level.INFO, this.statistics.toString());
        if (this.terminateException.get() != null) {
            throw new FaultException(this.terminateException.get(), false);
        }
    }

    private void logProgress(ExecutorService readerExecutor) throws InterruptedException {
        long startMs = System.currentTimeMillis();
        long prevTotalRead = 0L;
        while (!readerExecutor.awaitTermination(1L, TimeUnit.MINUTES)) {
            String fmt = "Loading continues. %,d values read. Throughput:%,d values/sec";
            long totalRead = this.totalRead();
            long throughput = totalRead * 1000L / (System.currentTimeMillis() - startMs);
            this.logger.log(totalRead > prevTotalRead ? Level.INFO : Level.WARNING, String.format("Loading continues. %,d values read. Throughput:%,d values/sec", totalRead, throughput));
            prevTotalRead = totalRead;
        }
    }

    private void shutdownShardExecutor(ExecutorService putExecutor) throws InterruptedException {
        HashSet<ShardPutTask> rgTasks = new HashSet<ShardPutTask>();
        for (PartitionValues pv : this.pMap) {
            if (pv.partitionId == 0) continue;
            rgTasks.add(pv.shardPutTask);
            pv.shardPutTask.add(partitionBatchEOF);
        }
        putExecutor.shutdown();
        while (!putExecutor.awaitTermination(1L, TimeUnit.MINUTES)) {
            String fmt = "Flushing puts";
            this.logger.info("Flushing puts");
        }
        for (ShardPutTask rgp : rgTasks) {
            AggregateStatistics aggregateStatistics = this.statistics;
            aggregateStatistics.batchCount = aggregateStatistics.batchCount + rgp.batchCount;
            aggregateStatistics = this.statistics;
            aggregateStatistics.batchQueueUnderflow = aggregateStatistics.batchQueueUnderflow + rgp.batchQueueUnderflow;
            aggregateStatistics = this.statistics;
            aggregateStatistics.batchQueueOverflow = aggregateStatistics.batchQueueOverflow + rgp.batchQueueOverflow;
            aggregateStatistics = this.statistics;
            aggregateStatistics.existingKeys = aggregateStatistics.existingKeys + rgp.existingKeyCount;
            aggregateStatistics = this.statistics;
            aggregateStatistics.putCount = aggregateStatistics.putCount + rgp.putCount;
        }
    }

    private ExecutorService startShardExecutor() {
        int perShardParallelism = this.options.getPerShardParallelism();
        int numShardTasks = this.topology.getRepGroupMap().size() * perShardParallelism;
        ExecutorService putExecutor = Executors.newFixedThreadPool(numShardTasks, new KVThreadFactory("RGWriter", this.logger));
        Map<RepGroupId, List<PartitionId>> map = TopologyUtil.getRGIdPartMap(this.topology);
        block0: for (RepGroupId rgId : this.topology.getRepGroupIds()) {
            int partitionsThisTask;
            List<PartitionId> list = map.get(rgId);
            int basePartitionsPerTask = list.size() / perShardParallelism;
            int residualPartitions = list.size() % perShardParallelism;
            for (int i = 0; i < list.size(); i += partitionsThisTask) {
                partitionsThisTask = basePartitionsPerTask;
                if (residualPartitions > 0) {
                    --residualPartitions;
                    ++partitionsThisTask;
                }
                if (partitionsThisTask == 0) continue block0;
                List<PartitionId> taskPartitions = list.subList(i, i + partitionsThisTask);
                this.logger.info("Partitions:" + Arrays.toString(taskPartitions.toArray()) + " assigned to RG task");
                ShardPutTask putTask = new ShardPutTask(rgId, taskPartitions.size());
                for (PartitionId pid : taskPartitions) {
                    PartitionValues pv = this.pMap[pid.getPartitionId()];
                    pv.setShardPutTask(putTask);
                }
                putExecutor.submit(putTask);
            }
        }
        return putExecutor;
    }

    private void terminateWithException(Exception exception) {
        int nRemainingTasks;
        if (!this.terminateException.compareAndSet(null, exception)) {
            return;
        }
        List<Runnable> unfinishedBusiness = this.streamExecutor.shutdownNow();
        if (!unfinishedBusiness.isEmpty()) {
            nRemainingTasks = unfinishedBusiness.size();
            this.logger.log(Level.FINE, "Bulk put reader stream executor didn't shutdown cleanly. {0} tasks remaining.", nRemainingTasks);
        }
        if (!(unfinishedBusiness = this.shardExecutor.shutdownNow()).isEmpty()) {
            nRemainingTasks = unfinishedBusiness.size();
            this.logger.log(Level.FINE, "Bulk put shard executor didn't shutdown cleanly. {0} tasks remaining.", nRemainingTasks);
        }
    }

    private boolean isTerminated() {
        return this.terminateException.get() != null;
    }

    private void tallyEntryCount(Integer[] streamIds, PartitionBatch pbatch) {
        for (Integer streamId : streamIds) {
            int count = pbatch.getStreamEntryCount(streamId);
            StreamReader<T> reader = this.readers.get(streamId - 1);
            reader.tallyOpCount(count);
            if (!reader.isDone()) continue;
            reader.getEntryStream().completed();
        }
    }

    private void handleRuntimeException(PartitionBatch pbatch, RuntimeException re) {
        for (KVPair kv : pbatch.kvPairs) {
            int streamId = kv.getStreamId();
            T entry = this.convertKVPairToEntry(kv);
            try {
                this.streams[streamId - 1].catchException(re, entry);
            }
            catch (Exception ex) {
                this.terminateWithException(ex);
                break;
            }
        }
    }

    private T convertKVPairToEntry(KVPair kv) {
        Key key = this.serializer.fromByteArray(kv.getKey());
        Value value = Value.fromByteArray(kv.getValue());
        return this.convertToEntry(key, value);
    }

    private void flushPartitions() throws InterruptedException {
        for (PartitionValues pv : this.pMap) {
            pv.flush(true);
        }
        this.logger.info("Flushed all partitions");
    }

    private void finishStreams(ArrayList<Future<Long>> futures, AggregateStatistics putResult) throws InterruptedException {
        for (Future<Long> f : futures) {
            if (this.isTerminated()) {
                f.cancel(true);
                continue;
            }
            try {
                long readCount = f.get();
                putResult.aggregate(readCount);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IllegalStateException(t);
            }
        }
    }

    private long totalRead() {
        long totalRead = 0L;
        for (StreamReader<T> reader : this.readers) {
            totalRead += reader.getReadCount();
        }
        return totalRead;
    }

    static /* synthetic */ PartitionBatch access$1400() {
        return partitionBatchEOF;
    }

    static /* synthetic */ KVStoreImpl access$1600(BulkPut x0) {
        return x0.store;
    }

    static /* synthetic */ Object access$1700(BulkPut x0, KVPair x1) {
        return x0.convertKVPairToEntry(x1);
    }

    static /* synthetic */ EntryStream[] access$1800(BulkPut x0) {
        return x0.streams;
    }

    static /* synthetic */ void access$1900(BulkPut x0, PartitionBatch x1, RuntimeException x2) {
        x0.handleRuntimeException(x1, x2);
    }

    static /* synthetic */ void access$2000(BulkPut x0, Integer[] x1, PartitionBatch x2) {
        x0.tallyEntryCount(x1, x2);
    }

    public static class KVPair
    implements FastExternalizable {
        final byte[] key;
        final byte[] value;
        final int ttlVal;
        final TimeUnit ttlUnit;
        final int streamId;

        public KVPair(byte[] key, byte[] value, int ttlVal, byte ttlUnitOrdinal, int streamId) {
            this.key = key;
            this.value = value;
            this.ttlVal = ttlVal;
            this.ttlUnit = TimeToLive.convertTimeToLiveUnit(ttlVal, ttlUnitOrdinal);
            this.streamId = streamId;
        }

        public KVPair(DataInput in, short serialVersion) throws IOException {
            if (serialVersion >= 14) {
                this.key = SerializationUtil.readNonNullByteArray(in);
                this.value = SerializationUtil.readNonNullByteArray(in);
            } else {
                int keySize = in.readInt();
                this.key = new byte[keySize];
                in.readFully(this.key);
                int valueSize = in.readInt();
                this.value = new byte[valueSize];
                in.readFully(this.value);
            }
            if (serialVersion >= 10) {
                this.ttlVal = TimeToLive.readTTLValue(in);
                this.ttlUnit = TimeToLive.readTTLUnit(in, this.ttlVal);
            } else {
                this.ttlVal = 0;
                this.ttlUnit = TimeUnit.DAYS;
            }
            this.streamId = -1;
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullByteArray(out, this.key);
                SerializationUtil.writeNonNullByteArray(out, this.value);
            } else {
                out.writeInt(this.key.length);
                out.write(this.key);
                out.writeInt(this.value.length);
                out.write(this.value);
            }
            if (serialVersion >= 10) {
                InternalOperation.writeTimeToLive(out, serialVersion, this.ttlVal, this.ttlUnit, "bulk put");
            }
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public int getStreamId() {
            return this.streamId;
        }

        public int getTTLVal() {
            return this.ttlVal;
        }

        public TimeUnit getTTLUnit() {
            return this.ttlUnit;
        }
    }

    private static class WrappedValue {
        private final byte[] value;
        private final int streamId;
        private final long tableId;
        private final int ttlVal;
        private final byte ttlUnitOrdinal;

        WrappedValue(byte[] value, int streamId, long tableId, TimeToLive ttl) {
            this.value = value;
            this.streamId = streamId;
            this.tableId = tableId;
            if (ttl != null) {
                this.ttlVal = (int)ttl.getValue();
                this.ttlUnitOrdinal = (byte)ttl.getUnit().ordinal();
            } else {
                this.ttlVal = 0;
                this.ttlUnitOrdinal = 0;
            }
        }

        int getStreamId() {
            return this.streamId;
        }

        long getTableId() {
            return this.tableId;
        }

        byte[] getValue() {
            return this.value;
        }

        int getTTLVal() {
            return this.ttlVal;
        }

        byte getTTLUnitOrdinal() {
            return this.ttlUnitOrdinal;
        }

        int getBytesSize() {
            return this.value.length + 4 + 8 + 4 + 1;
        }
    }

    private class PartitionValues {
        private final int partitionId;
        private ShardPutTask shardPutTask;
        private long putCount = 0L;
        private final SortedMap<byte[], Object> kvPairs = new TreeMap<byte[], Object>(KEY_BYTES_COMPARATOR);
        private long treeBytes = 0L;

        public void setShardPutTask(ShardPutTask rgPutThread) {
            this.shardPutTask = rgPutThread;
        }

        PartitionValues(int pid) {
            this.partitionId = pid;
        }

        synchronized void put(byte[] key, byte[] value, int streamId, long tableId, TimeToLive ttl) throws InterruptedException {
            WrappedValue wv = new WrappedValue(value, streamId, tableId, ttl);
            Object old = this.kvPairs.put(key, wv);
            if (old != null) {
                ArrayList<WrappedValue> list;
                if (old instanceof List) {
                    list = (ArrayList<WrappedValue>)old;
                    list.add(wv);
                } else {
                    list = new ArrayList<WrappedValue>();
                    list.add((WrappedValue)old);
                    list.add(wv);
                }
                this.kvPairs.put(key, list);
            }
            this.treeBytes += (long)(key.length + wv.getBytesSize());
            this.flush(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush(boolean force) throws InterruptedException {
            int maxRequestSize = BulkPut.this.options.getMaxRequestSize();
            String fmt = "Queued Partition %d flushed. Batch size %,d; Total:%,d; Tree bytes:%,d; request size:%,d";
            while (force && this.kvPairs.size() > 0 || this.treeBytes > BulkPut.this.partitionThresholdBytes) {
                int putBatchCount = 0;
                int requestSize = 0;
                ArrayList<KVPair> le = new ArrayList<KVPair>();
                HashMap<Integer, Integer> streamIdCountMap = new HashMap<Integer, Integer>();
                HashSet<Long> tableIds = new HashSet<Long>();
                PartitionValues partitionValues = this;
                synchronized (partitionValues) {
                    Iterator<Map.Entry<byte[], Object>> iter = this.kvPairs.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<byte[], Object> e = iter.next();
                        iter.remove();
                        byte[] key = e.getKey();
                        Object obj = e.getValue();
                        int size = 0;
                        if (obj instanceof List) {
                            List wvs = (List)obj;
                            for (WrappedValue wv : wvs) {
                                size += this.addEntry(key, wv, le, tableIds, streamIdCountMap);
                            }
                            putBatchCount += wvs.size();
                        } else {
                            assert (obj instanceof WrappedValue);
                            size = this.addEntry(key, (WrappedValue)obj, le, tableIds, streamIdCountMap);
                            ++putBatchCount;
                        }
                        this.treeBytes -= (long)size;
                        if ((requestSize += size) <= maxRequestSize) continue;
                        break;
                    }
                    this.putCount += (long)putBatchCount;
                }
                this.shardPutTask.add(new PartitionBatch(new PartitionId(this.partitionId), le, tableIds.isEmpty() ? null : tableIds, streamIdCountMap));
                BulkPut.this.logger.fine(String.format("Queued Partition %d flushed. Batch size %,d; Total:%,d; Tree bytes:%,d; request size:%,d", this.partitionId, putBatchCount, this.putCount, this.treeBytes, requestSize));
            }
        }

        private int addEntry(byte[] key, WrappedValue wv, List<KVPair> kvpairs, Set<Long> tableIds, Map<Integer, Integer> streamCountMap) {
            byte[] value = wv.getValue();
            int streamId = wv.getStreamId();
            long tableId = wv.getTableId();
            kvpairs.add(new KVPair(key, value, wv.getTTLVal(), wv.getTTLUnitOrdinal(), streamId));
            if (tableId != 0L) {
                tableIds.add(wv.getTableId());
            }
            this.tallyEntryCount(streamCountMap, wv.getStreamId());
            return key.length + wv.getBytesSize();
        }

        private void tallyEntryCount(Map<Integer, Integer> streamCountMap, int streamId) {
            if (streamCountMap.containsKey(streamId)) {
                int count = streamCountMap.get(streamId) + 1;
                streamCountMap.put(streamId, count);
            } else {
                streamCountMap.put(streamId, 1);
            }
        }
    }

    public abstract class StreamReader<E>
    implements Callable<Long> {
        private final int streamId;
        private final EntryStream<E> entryStream;
        private volatile long readCount = 0L;
        private volatile long dupCount = 0L;
        private volatile boolean noMoreElement = false;
        private final AtomicLong putCount;

        public StreamReader(int streamId, EntryStream<E> entryStream) {
            this.streamId = streamId;
            this.entryStream = entryStream;
            this.putCount = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public Long call() throws Exception {
            String sfmt = "Started stream reader for %s(%d)";
            BulkPut.this.logger.info(String.format("Started stream reader for %s(%d)", this.entryStream.name(), this.streamId));
            try {
                E e = this.entryStream.getNext();
                while (e != null) {
                    ++this.readCount;
                    Key pk = this.getKey(e);
                    Value value = this.getValue(e);
                    long tableId = this.getTableId(e);
                    byte[] keyBytes = BulkPut.this.serializer.toByteArray(pk);
                    PartitionId pid = BulkPut.this.topology.getPartitionId(keyBytes);
                    TimeToLive ttl = this.getTTL(e);
                    BulkPut.this.pMap[pid.getPartitionId()].put(keyBytes, value.toByteArray(), this.streamId, tableId, ttl);
                    e = this.entryStream.getNext();
                }
                this.noMoreElement = true;
                if (this.readCount == 0L) {
                    this.entryStream.completed();
                }
                String fmt = "Finished stream reader for %s(%d)";
            }
            catch (RuntimeException re) {
                BulkPut.this.terminateWithException(re);
                String fmt = "Finished stream reader for %s(%d)";
                BulkPut.this.logger.info(String.format("Finished stream reader for %s(%d)", this.entryStream.name(), this.streamId));
            }
            catch (InterruptedException ie) {
                BulkPut.this.terminateWithException(new RuntimeException(ie));
                String fmt = "Finished stream reader for %s(%d)";
                {
                    catch (Throwable throwable) {
                        String fmt2 = "Finished stream reader for %s(%d)";
                        BulkPut.this.logger.info(String.format("Finished stream reader for %s(%d)", this.entryStream.name(), this.streamId));
                        throw throwable;
                    }
                }
                BulkPut.this.logger.info(String.format("Finished stream reader for %s(%d)", this.entryStream.name(), this.streamId));
            }
            BulkPut.this.logger.info(String.format("Finished stream reader for %s(%d)", this.entryStream.name(), this.streamId));
            return this.readCount;
        }

        void keyExists(E entry) {
            ++this.dupCount;
            this.entryStream.keyExists(entry);
        }

        EntryStream<E> getEntryStream() {
            return this.entryStream;
        }

        long getReadCount() {
            return this.readCount;
        }

        void tallyOpCount(int count) {
            this.putCount.addAndGet(count);
        }

        boolean isDone() {
            return this.noMoreElement && this.putCount.get() == this.readCount - this.dupCount;
        }

        protected abstract Key getKey(E var1);

        protected abstract Value getValue(E var1);

        protected long getTableId(E entry) {
            return 0L;
        }

        protected TimeToLive getTTL(E entry) {
            return null;
        }
    }

    private static class AggregateStatistics {
        private long batchCount;
        private long batchQueueUnderflow;
        private long batchQueueOverflow;
        private long readCount;
        private long putCount;
        private long existingKeys;

        private AggregateStatistics() {
        }

        public void aggregate(long entriesRead) {
            this.readCount += entriesRead;
        }

        public String toString() {
            String fmt = "%,d rows read, %,d inserted, %,d pre-existing. %,d batches; %,d batch queue underflows; %,d batch queue overflows;%,d av batch size;";
            return String.format("%,d rows read, %,d inserted, %,d pre-existing. %,d batches; %,d batch queue underflows; %,d batch queue overflows;%,d av batch size;", this.readCount, this.putCount, this.existingKeys, this.batchCount, this.batchQueueUnderflow, this.batchQueueOverflow, this.batchCount > 0L ? this.putCount / this.batchCount : 0L);
        }
    }

    public class ShardPutTask
    implements Runnable {
        final RepGroupId rgId;
        public long putCount;
        private final ArrayBlockingQueue<PartitionBatch> queuedKVPairs;
        private long batchCount = 0L;
        private long batchQueueUnderflow = 0L;
        private long batchQueueOverflow = 0L;
        private long existingKeyCount;

        public ShardPutTask(RepGroupId rgId, int numTaskPartitions) {
            this.rgId = rgId;
            this.queuedKVPairs = new ArrayBlockingQueue(numTaskPartitions * 2);
        }

        void add(PartitionBatch partBatch) throws InterruptedException {
            if (!this.queuedKVPairs.offer(partBatch)) {
                ++this.batchQueueOverflow;
                while (!BulkPut.this.isTerminated() && !this.queuedKVPairs.offer(partBatch, 10L, TimeUnit.SECONDS)) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            sfmt = "Starting RG thread. Shard:%s";
            streamIds = null;
            BulkPut.access$1300(BulkPut.this).info(String.format("Starting RG thread. Shard:%s", new Object[]{this.rgId}));
            while (true) {
                try {
                    pbatch = this.queuedKVPairs.poll();
                    if (pbatch == null) {
                        ++this.batchQueueUnderflow;
                        pbatch = this.queuedKVPairs.take();
                    }
                    if (pbatch == BulkPut.access$1400()) {
                        fmt = "Exiting RG thread. Shard:%s";
                    }
                    ** GOTO lbl-1000
                }
                catch (InterruptedException ie) {
                    BulkPut.access$1300(BulkPut.this).info(Thread.currentThread() + " caught " + ie);
                    BulkPut.access$2100(BulkPut.this, new RuntimeException(ie));
                    fmt = "Exiting RG thread. Shard:%s";
                    BulkPut.access$1300(BulkPut.this).info(String.format("Exiting RG thread. Shard:%s", new Object[]{this.rgId}));
                    return;
                }
                catch (Throwable var9_12) {
                    fmt = "Exiting RG thread. Shard:%s";
                    BulkPut.access$1300(BulkPut.this).info(String.format("Exiting RG thread. Shard:%s", new Object[]{this.rgId}));
                    throw var9_12;
                }
                BulkPut.access$1300(BulkPut.this).info(String.format("Exiting RG thread. Shard:%s", new Object[]{this.rgId}));
                return;
lbl-1000:
                // 1 sources

                {
                    streamIds = pbatch.getStreamIds();
                    ++this.batchCount;
                    try {
                        existing = BulkPut.access$1600(BulkPut.this).putBatch(pbatch.pid, pbatch.kvPairs, pbatch.getTableIds(), BulkPut.access$1500(BulkPut.this).getDurability(), BulkPut.access$1500(BulkPut.this).getTimeout(), BulkPut.access$1500(BulkPut.this).getTimeoutUnit());
                        this.putCount += (long)pbatch.kvPairs.size();
                        for (int pos : existing) {
                            kvPair = pbatch.kvPairs.get(pos);
                            entry = BulkPut.access$1700(BulkPut.this, kvPair);
                            BulkPut.access$1800(BulkPut.this)[kvPair.getStreamId() - 1].keyExists(entry);
                            ++this.existingKeyCount;
                            BulkPut.access$1300(BulkPut.this).info("Existing key at sub-batch pos:" + pos);
                        }
                    }
                    catch (RuntimeException re) {
                        BulkPut.access$1300(BulkPut.this).info(Thread.currentThread() + " caught " + re);
                        if (re.getCause() != null && (e = re.getCause()) instanceof InterruptedException) {
                            throw (InterruptedException)e;
                        }
                        BulkPut.access$1900(BulkPut.this, pbatch, re);
                    }
                    BulkPut.access$2000(BulkPut.this, streamIds, pbatch);
                    continue;
                }
                break;
            }
        }
    }

    private static class PartitionBatch {
        final PartitionId pid;
        final List<KVPair> kvPairs;
        final Set<Long> tableIds;
        final Map<Integer, Integer> perStreamCount;

        PartitionBatch() {
            this(null, null, null, null);
        }

        PartitionBatch(PartitionId pid, List<KVPair> kvPairs, Set<Long> tableIds, Map<Integer, Integer> perStreamCount) {
            this.pid = pid;
            this.kvPairs = kvPairs;
            this.tableIds = tableIds;
            this.perStreamCount = perStreamCount;
        }

        public Integer[] getStreamIds() {
            Set<Integer> streamIds = this.perStreamCount.keySet();
            return streamIds.toArray(new Integer[streamIds.size()]);
        }

        public int getStreamEntryCount(int streamId) {
            return this.perStreamCount.get(streamId);
        }

        public long[] getTableIds() {
            if (this.tableIds == null) {
                return null;
            }
            long[] tids = new long[this.tableIds.size()];
            int i = 0;
            for (Long id : this.tableIds) {
                tids[i++] = id;
            }
            return tids;
        }
    }
}

