/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Depth;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.util.SerializationUtil;

public class MultiDelete
extends MultiKeyOperation {
    private static final short LOB_SERIAL_VERSION = 2;
    private final byte[] lobSuffixBytes;

    public MultiDelete(byte[] parentKey, KeyRange subRange, Depth depth, byte[] lobSuffixBytes) {
        super(InternalOperation.OpCode.MULTI_DELETE, parentKey, subRange, depth);
        this.lobSuffixBytes = lobSuffixBytes;
    }

    MultiDelete(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_DELETE, in, serialVersion);
        if (serialVersion >= 14) {
            this.lobSuffixBytes = SerializationUtil.readByteArray(in);
        } else if (serialVersion >= 2) {
            short suffixLen = in.readShort();
            if (suffixLen == 0) {
                this.lobSuffixBytes = null;
            } else {
                this.lobSuffixBytes = new byte[suffixLen];
                in.readFully(this.lobSuffixBytes);
            }
        } else {
            this.lobSuffixBytes = null;
        }
    }

    byte[] getLobSuffixBytes() {
        return this.lobSuffixBytes;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 14) {
            SerializationUtil.writeByteArray(out, this.lobSuffixBytes);
        } else if (serialVersion >= 2) {
            if (this.lobSuffixBytes != null && this.lobSuffixBytes.length > 0) {
                out.writeShort(this.lobSuffixBytes.length);
                out.write(this.lobSuffixBytes);
            } else {
                out.writeShort(0);
            }
        }
    }
}

