/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.bulk.BulkPut;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class PutBatch
extends MultiKeyOperation {
    private final List<BulkPut.KVPair> kvPairs;
    private final long[] tableIds;

    public PutBatch(List<BulkPut.KVPair> le, long[] tableIds) {
        super(InternalOperation.OpCode.PUT_BATCH, null, null, null);
        ObjectUtil.checkNull("le", le);
        for (BulkPut.KVPair element : le) {
            ObjectUtil.checkNull("le element", element);
        }
        this.kvPairs = le;
        this.tableIds = tableIds;
    }

    PutBatch(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.PUT_BATCH, in, serialVersion);
        int tableIdCount;
        int kvPairCount = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : in.readInt();
        this.kvPairs = new ArrayList<BulkPut.KVPair>(kvPairCount);
        for (int i = 0; i < kvPairCount; ++i) {
            this.kvPairs.add(new BulkPut.KVPair(in, serialVersion));
        }
        int n = tableIdCount = serialVersion >= 14 ? SerializationUtil.readSequenceLength(in) : in.readInt();
        if (tableIdCount == -1) {
            this.tableIds = null;
        } else {
            this.tableIds = new long[tableIdCount];
            for (int i = 0; i < tableIdCount; ++i) {
                this.tableIds[i] = in.readLong();
            }
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 14) {
            SerializationUtil.writeNonNullCollection(out, serialVersion, this.kvPairs);
        } else {
            out.writeInt(this.kvPairs.size());
            for (BulkPut.KVPair e : this.kvPairs) {
                e.writeFastExternal(out, serialVersion);
            }
        }
        if (serialVersion >= 14) {
            SerializationUtil.writeArrayLength(out, this.tableIds);
        } else {
            out.writeInt(this.tableIds != null ? this.tableIds.length : -1);
        }
        if (this.tableIds != null) {
            for (Object tableId : (Object)this.tableIds) {
                out.writeLong((long)tableId);
            }
        }
    }

    List<BulkPut.KVPair> getKvPairs() {
        return this.kvPairs;
    }

    long[] getTableIds() {
        return this.tableIds;
    }
}

