/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

abstract class TableIterateOperation
extends MultiTableOperation {
    private final boolean majorComplete;
    private final Direction direction;
    private final int batchSize;
    private final byte[] resumeKey;

    protected TableIterateOperation(InternalOperation.OpCode opCode, StoreIteratorParams sip, TargetTables targetTables, boolean majorComplete, byte[] resumeKey) {
        super(opCode, sip.getParentKeyBytes(), targetTables, sip.getSubRange());
        this.majorComplete = majorComplete;
        this.direction = sip.getPartitionDirection();
        this.batchSize = sip.getBatchSize();
        this.resumeKey = resumeKey;
        ObjectUtil.checkNull("direction", this.direction);
    }

    protected TableIterateOperation(InternalOperation.OpCode opCode, byte[] parentKeyBytes, TargetTables targetTables, Direction direction, KeyRange range, boolean majorComplete, int batchSize, byte[] resumeKey) {
        super(opCode, parentKeyBytes, targetTables, range);
        ObjectUtil.checkNull("direction", direction);
        this.majorComplete = majorComplete;
        this.direction = direction;
        this.batchSize = batchSize;
        this.resumeKey = resumeKey;
    }

    TableIterateOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.majorComplete = in.readBoolean();
        this.direction = Direction.readFastExternal(in, serialVersion);
        int tmpBatchSize = in.readInt();
        this.batchSize = this.getResumeKey() == null && tmpBatchSize == 1 ? 2 : tmpBatchSize;
        this.resumeKey = SerializationUtil.readByteArrayOldShortLength(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeBoolean(this.majorComplete);
        this.direction.writeFastExternal(out, serialVersion);
        out.writeInt(this.batchSize);
        SerializationUtil.writeByteArrayOldShortLength(out, serialVersion, this.resumeKey);
    }

    Direction getDirection() {
        return this.direction;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }

    boolean getMajorComplete() {
        return this.majorComplete;
    }
}

