/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.kv.StatementResult;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.query.BoundStatementImpl;
import oracle.kv.impl.api.query.InternalStatement;
import oracle.kv.impl.api.query.QueryStatementResultImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.query.BoundStatement;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PreparedStatement;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordDef;

public class PreparedStatementImpl
implements PreparedStatement,
InternalStatement {
    private final PlanIter queryPlan;
    private final RecordDef resultDef;
    private final int numRegisters;
    private final int numIterators;
    private final Map<String, StaticContext.VarInfo> externalVars;
    private final DistributionKind distributionKind;
    private final PartitionId partitionId;
    private final PrimaryKeyImpl shardKey;
    private QueryControlBlock qcb;

    public PreparedStatementImpl(PlanIter queryPlan, FieldDefImpl resultDef, int numRegisters, int numIterators, Map<String, StaticContext.VarInfo> externalVars, QueryControlBlock qcb) {
        this.queryPlan = queryPlan;
        this.numRegisters = numRegisters;
        this.numIterators = numIterators;
        this.externalVars = externalVars;
        this.qcb = qcb;
        this.distributionKind = qcb.getPushedDistributionKind();
        PrimaryKeyImpl pkey = qcb.getPushedPrimaryKey();
        this.shardKey = pkey != null && pkey.isEmpty() ? null : pkey;
        this.partitionId = this.shardKey != null && this.distributionKind == DistributionKind.SINGLE_PARTITION ? this.shardKey.getPartitionId(qcb.getStore()) : PartitionId.NULL_ID;
        if (!resultDef.isRecord()) {
            String fname = qcb.getResultColumnName();
            if (fname == null) {
                fname = "Column_1";
            }
            FieldMap fieldMap = new FieldMap();
            fieldMap.put(fname, resultDef, true, null);
            this.resultDef = FieldDefFactory.createRecordDef(fieldMap, null);
        } else {
            this.resultDef = resultDef.asRecord();
        }
    }

    @Override
    public RecordDef getResultDef() {
        return this.resultDef;
    }

    @Override
    public Map<String, FieldDef> getVariableTypes() {
        return this.getExternalVarsTypes();
    }

    @Override
    public FieldDef getVariableType(String variableName) {
        return this.getExternalVarType(variableName);
    }

    @Override
    public BoundStatement createBoundStatement() {
        return new BoundStatementImpl(this);
    }

    public QueryControlBlock getQCB() {
        return this.qcb;
    }

    public PlanIter getQueryPlan() {
        return this.queryPlan;
    }

    public int getNumRegisters() {
        return this.numRegisters;
    }

    public int getNumIterators() {
        return this.numIterators;
    }

    public Map<String, FieldDef> getExternalVarsTypes() {
        HashMap<String, FieldDef> varsMap = new HashMap<String, FieldDef>();
        if (this.externalVars == null) {
            return varsMap;
        }
        for (Map.Entry<String, StaticContext.VarInfo> entry : this.externalVars.entrySet()) {
            String varName = entry.getKey();
            StaticContext.VarInfo vi = entry.getValue();
            varsMap.put(varName, vi.getType().getDef());
        }
        return varsMap;
    }

    boolean hasExternalVars() {
        return this.externalVars != null && !this.externalVars.isEmpty();
    }

    public FieldDef getExternalVarType(String name) {
        if (this.externalVars == null) {
            return null;
        }
        StaticContext.VarInfo vi = this.externalVars.get(name);
        if (vi != null) {
            return vi.getType().getDef();
        }
        return null;
    }

    public FieldValue[] getExternalVarsArray(Map<String, FieldValue> vars) {
        if (this.externalVars == null) {
            assert (vars.isEmpty());
            return null;
        }
        int count = 0;
        for (Map.Entry<String, StaticContext.VarInfo> entry : this.externalVars.entrySet()) {
            String name = entry.getKey();
            ++count;
            if (vars.get(name) != null) continue;
            throw new IllegalArgumentException("Variable " + name + " has not been bound");
        }
        FieldValue[] array = new FieldValue[count];
        count = 0;
        for (Map.Entry<String, FieldValue> entry : vars.entrySet()) {
            String name = entry.getKey();
            FieldValue value = entry.getValue();
            StaticContext.VarInfo vi = this.externalVars.get(name);
            if (vi == null) {
                throw new IllegalStateException("Variable " + name + " does not appear in query");
            }
            array[vi.getId()] = value;
            ++count;
        }
        assert (count == array.length);
        return array;
    }

    public String toString() {
        return this.queryPlan.display();
    }

    @Override
    public StatementResult executeSync(KVStoreImpl store, ExecuteOptions options) {
        return new QueryStatementResultImpl(store.getTableAPIImpl(), options, this);
    }

    public DistributionKind getDistributionKind() {
        return this.distributionKind;
    }

    public PrimaryKey getShardKey() {
        return this.shardKey;
    }

    public PartitionId getPartitionId() {
        return this.partitionId;
    }

    public StatementResult executeSyncPartitions(KVStoreImpl store, ExecuteOptions options, Set<Integer> partitions) {
        return new QueryStatementResultImpl(store.getTableAPIImpl(), options, this, partitions, null);
    }

    public StatementResult executeSyncShards(KVStoreImpl store, ExecuteOptions options, Set<RepGroupId> shards) {
        return new QueryStatementResultImpl(store.getTableAPIImpl(), options, this, null, shards);
    }

    public static enum DistributionKind {
        SINGLE_PARTITION,
        ALL_PARTITIONS,
        ALL_SHARDS,
        UNKNOWN;

    }
}

