/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FixedBinaryValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordValue;

public class FieldValueSerialization {
    public static final int NULL_VALUE = -1;
    public static final int NULL_REFERENCE = -2;
    public static final int NULL_JSON_VALUE = -3;
    public static final int EMPTY_VALUE = -4;

    public static void writeFieldValue(FieldValue val, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        if (val == null) {
            out.writeByte(-2);
        } else if (val.isNull()) {
            out.writeByte(-1);
        } else if (val.isJsonNull()) {
            out.writeByte(-3);
        } else if (((FieldValueImpl)val).isEMPTY()) {
            out.writeByte(-4);
        } else {
            val.getType().writeFastExternal(out, serialVersion);
            FieldValueSerialization.writeNonNullFieldValue(val, writeValDef, false, out, serialVersion);
        }
    }

    public static void writeNonNullFieldValue(FieldValue val, boolean writeValDef, boolean writeValKind, DataOutput out, short serialVersion) throws IOException {
        if (val == null || val.isNull() || ((FieldValueImpl)val).isEMPTY()) {
            throw new IllegalStateException("Unexpected value: " + val);
        }
        FieldValueImpl value = (FieldValueImpl)val;
        FieldDefImpl valDef = (FieldDefImpl)val.getDefinition();
        if (valDef.isWildcard() && !val.isJsonNull()) {
            throw new IllegalStateException("An item cannot have a wildcard type\n" + val);
        }
        if (valDef.getType() != value.getType()) {
            throw new IllegalStateException("Mismatch between value kind and associated type\nValue kind : " + val.getType() + "\n" + "Type : " + valDef);
        }
        if (writeValDef && writeValKind) {
            if (val.isJsonNull()) {
                out.writeByte(-3);
                return;
            }
            val.getType().writeFastExternal(out, serialVersion);
        }
        switch (val.getType()) {
            case INTEGER: {
                SerializationUtil.writePackedInt(out, value.getInt());
                break;
            }
            case LONG: {
                SerializationUtil.writePackedLong(out, value.getLong());
                break;
            }
            case DOUBLE: {
                out.writeDouble(value.getDouble());
                break;
            }
            case FLOAT: {
                out.writeFloat(value.getFloat());
                break;
            }
            case STRING: {
                if (serialVersion >= 14) {
                    SerializationUtil.writeNonNullString(out, serialVersion, value.getString());
                    break;
                }
                out.writeUTF(value.getString());
                break;
            }
            case BOOLEAN: {
                out.writeBoolean(value.getBoolean());
                break;
            }
            case NUMBER: {
                SerializationUtil.writeNonNullByteArray(out, value.getBytes());
                break;
            }
            case BINARY: {
                SerializationUtil.writeNonNullByteArray(out, value.getBytes());
                break;
            }
            case FIXED_BINARY: {
                byte[] bytes = value.getBytes();
                int size = ((FixedBinaryValueImpl)value).getDefinition().getSize();
                if (size != bytes.length) {
                    throw new IllegalStateException("Definition size " + size + " is different from bytes length " + bytes.length);
                }
                SerializationUtil.writeNonNullByteArray(out, bytes);
                break;
            }
            case ENUM: {
                FieldValueSerialization.writeEnum((EnumValueImpl)value, writeValDef, out, serialVersion);
                break;
            }
            case TIMESTAMP: {
                FieldValueSerialization.writeTimestamp((TimestampValueImpl)value, writeValDef, out, serialVersion);
                break;
            }
            case RECORD: {
                FieldValueSerialization.writeRecord((RecordValueImpl)value, writeValDef, out, serialVersion);
                break;
            }
            case MAP: {
                FieldValueSerialization.writeMap((MapValueImpl)value, writeValDef, out, serialVersion);
                break;
            }
            case ARRAY: {
                FieldValueSerialization.writeArray((ArrayValueImpl)value, writeValDef, out, serialVersion);
                break;
            }
            case ANY: 
            case ANY_ATOMIC: 
            case ANY_JSON_ATOMIC: 
            case ANY_RECORD: {
                throw new IllegalStateException("ANY* types cannot be materialized as values");
            }
            case JSON: {
                throw new IllegalStateException("JSON cannot be materialized as a value");
            }
            case EMPTY: {
                throw new IllegalStateException("EMPTY type does not contain any values");
            }
        }
    }

    public static void writeEnum(EnumValueImpl value, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        if (writeValDef) {
            EnumDefImpl def = value.getDefinition();
            FieldDefSerialization.writeEnum(def, out, serialVersion);
        }
        out.writeShort(value.asEnum().getIndex());
    }

    public static void writeTimestamp(TimestampValueImpl value, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        byte[] bytes;
        if (writeValDef) {
            TimestampDefImpl def = value.getDefinition();
            FieldDefSerialization.writeTimestamp(def, out, serialVersion);
        }
        if ((bytes = value.getBytes()).length == 0) {
            throw new IllegalStateException("Bytes must not be empty");
        }
        if (bytes.length > 127) {
            throw new IllegalStateException("Too many bytes in timestamp: " + bytes.length);
        }
        out.writeByte(bytes.length);
        out.write(bytes);
    }

    public static void writeRecord(RecordValueImpl record, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        RecordDefImpl recordDef = record.getDefinition();
        if (writeValDef) {
            FieldDefSerialization.writeRecord(recordDef, out, serialVersion);
        }
        for (int pos = 0; pos < recordDef.getNumFields(); ++pos) {
            FieldDefImpl fdef = recordDef.getFieldDef(pos);
            FieldValueImpl fval = record.get(pos);
            if (!recordDef.isNullable(pos)) {
                FieldValueSerialization.writeNonNullFieldValue(fval, fdef.isWildcard(), true, out, serialVersion);
                continue;
            }
            FieldValueSerialization.writeFieldValue(fval, fdef.isWildcard(), out, serialVersion);
        }
    }

    public static void writeMap(MapValueImpl map, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        MapDefImpl mapDef = map.getDefinition();
        FieldDefImpl elemDef = (FieldDefImpl)mapDef.getElement();
        boolean wildcard = elemDef.isWildcard();
        if (writeValDef) {
            FieldDefSerialization.writeFieldDef(elemDef, out, serialVersion);
        }
        int size = map.size();
        SerializationUtil.writeNonNullSequenceLength(out, size);
        if (size == 0) {
            return;
        }
        for (Map.Entry<String, FieldValue> entry : map.getFieldsInternal().entrySet()) {
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullString(out, serialVersion, entry.getKey());
            } else {
                out.writeUTF(entry.getKey());
            }
            FieldValueSerialization.writeNonNullFieldValue(entry.getValue(), wildcard, true, out, serialVersion);
        }
    }

    public static void writeArray(ArrayValueImpl array, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        boolean homogeneous;
        FieldDefImpl elemDef = array.getElementDef();
        FieldDefImpl homogeneousType = array.getHomogeneousType();
        boolean wildcard = elemDef.isWildcard();
        boolean bl = homogeneous = homogeneousType != null;
        if (writeValDef) {
            FieldDefSerialization.writeFieldDef(elemDef, out, serialVersion);
        }
        if (serialVersion >= 12 && wildcard) {
            out.writeBoolean(homogeneous);
            if (homogeneous) {
                FieldDefSerialization.writeFieldDef(homogeneousType, out, serialVersion);
                wildcard = false;
            }
        }
        int size = array.size();
        SerializationUtil.writeNonNullSequenceLength(out, size);
        if (size == 0) {
            return;
        }
        for (FieldValue fieldVal : array.getArrayInternal()) {
            FieldValueSerialization.writeNonNullFieldValue(fieldVal, wildcard, true, out, serialVersion);
        }
    }

    public static FieldValue readFieldValue(FieldDef def, DataInput in, short serialVersion) throws IOException {
        byte ordinal = in.readByte();
        if (ordinal == -2) {
            return null;
        }
        if (ordinal == -1) {
            return NullValueImpl.getInstance();
        }
        if (ordinal == -3) {
            return NullJsonValueImpl.getInstance();
        }
        if (ordinal == -4) {
            return EmptyValueImpl.getInstance();
        }
        FieldDef.Type valKind = FieldDef.Type.valueOf(ordinal);
        return FieldValueSerialization.readNonNullFieldValue(def, valKind, in, serialVersion);
    }

    public static FieldValue readNonNullFieldValue(FieldDef def, FieldDef.Type valKind, DataInput in, short serialVersion) throws IOException {
        if (def == null) {
            if (valKind == null) {
                byte ordinal = in.readByte();
                if (ordinal == -3) {
                    return NullJsonValueImpl.getInstance();
                }
                valKind = FieldDef.Type.valueOf(ordinal);
            }
        } else if (valKind == null) {
            valKind = def.getType();
        }
        switch (valKind) {
            case INTEGER: {
                int val = SerializationUtil.readPackedInt(in);
                return FieldDefImpl.integerDef.createInteger(val);
            }
            case LONG: {
                long val = SerializationUtil.readPackedLong(in);
                return FieldDefImpl.longDef.createLong(val);
            }
            case DOUBLE: {
                double val = in.readDouble();
                return FieldDefImpl.doubleDef.createDouble(val);
            }
            case FLOAT: {
                float val = in.readFloat();
                return FieldDefImpl.floatDef.createFloat(val);
            }
            case STRING: {
                String val = serialVersion >= 14 ? SerializationUtil.readNonNullString(in, serialVersion) : in.readUTF();
                return FieldDefImpl.stringDef.createString(val);
            }
            case BOOLEAN: {
                return FieldDefImpl.booleanDef.createBoolean(in.readBoolean());
            }
            case NUMBER: {
                byte[] bytes = SerializationUtil.readNonNullByteArray(in);
                if (bytes.length == 0) {
                    throw new IllegalStateException("Invalid zero length for number");
                }
                return FieldDefImpl.numberDef.createNumber(bytes);
            }
            case BINARY: {
                byte[] bytes = SerializationUtil.readNonNullByteArray(in);
                return FieldDefImpl.binaryDef.createBinary(bytes);
            }
            case FIXED_BINARY: {
                byte[] bytes = SerializationUtil.readNonNullByteArray(in);
                return new FixedBinaryDefImpl(bytes.length, null).createFixedBinary(bytes);
            }
            case ENUM: {
                EnumDefImpl enumDef;
                EnumDefImpl enumDefImpl = enumDef = def == null ? FieldDefSerialization.readEnum(in, serialVersion) : (EnumDefImpl)def;
                assert (enumDef != null);
                short index = in.readShort();
                return enumDef.createEnum(index);
            }
            case TIMESTAMP: {
                TimestampDefImpl timestampDef;
                TimestampDefImpl timestampDefImpl = timestampDef = def == null ? FieldDefSerialization.readTimestamp(in, serialVersion) : (TimestampDefImpl)def;
                assert (timestampDef != null);
                byte len = in.readByte();
                if (len <= 0) {
                    throw new IOException("Invalid timestamp def length: " + len);
                }
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                return timestampDef.createTimestamp(bytes);
            }
            case RECORD: {
                return FieldValueSerialization.readRecord(def, in, serialVersion);
            }
            case MAP: {
                return FieldValueSerialization.readMap(def, in, serialVersion);
            }
            case ARRAY: {
                return FieldValueSerialization.readArray(def, in, serialVersion);
            }
        }
        throw new IllegalStateException("Type not supported: " + valKind);
    }

    static RecordValue readRecord(FieldDef def, DataInput in, short serialVersion) throws IOException {
        RecordDefImpl recordDef = def == null ? FieldDefSerialization.readRecord(in, serialVersion) : (RecordDefImpl)def;
        RecordValueImpl record = recordDef.createRecord();
        for (int pos = 0; pos < recordDef.getNumFields(); ++pos) {
            FieldDefImpl fdef = recordDef.getFieldDef(pos);
            if (fdef.isWildcard()) {
                fdef = null;
            }
            FieldValue fval = null;
            fval = fdef != null && !recordDef.isNullable(pos) ? FieldValueSerialization.readNonNullFieldValue(fdef, fdef.getType(), in, serialVersion) : FieldValueSerialization.readFieldValue(fdef, in, serialVersion);
            if (fval == null) continue;
            record.putInternal(pos, fval);
        }
        return record;
    }

    static MapValue readMap(FieldDef def, DataInput in, short serialVersion) throws IOException {
        FieldDefImpl elemDef = null;
        MapDef mapDef = null;
        if (def != null) {
            mapDef = def.asMap();
            elemDef = (FieldDefImpl)mapDef.getElement();
        } else {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            mapDef = FieldDefFactory.createMapDef(elemDef);
        }
        MapValueImpl map = (MapValueImpl)mapDef.createMap();
        boolean wildcard = elemDef.isWildcard();
        if (wildcard) {
            elemDef = null;
        }
        int size = SerializationUtil.readNonNullSequenceLength(in);
        for (int i = 0; i < size; ++i) {
            String fname = serialVersion >= 14 ? SerializationUtil.readNonNullString(in, serialVersion) : in.readUTF();
            FieldValue fval = FieldValueSerialization.readNonNullFieldValue(elemDef, null, in, serialVersion);
            assert (fval.isNull() || elemDef == null || fval.getType() == elemDef.getType());
            assert (!fval.isNull());
            map.put(fname, fval);
        }
        return map;
    }

    static ArrayValue readArray(FieldDef def, DataInput in, short serialVersion) throws IOException {
        boolean homogeneous;
        boolean wildcard;
        ArrayDefImpl arrayDef = null;
        FieldDefImpl elemDef = null;
        if (def != null) {
            arrayDef = (ArrayDefImpl)def;
            elemDef = arrayDef.getElement();
            wildcard = elemDef.isWildcard();
        } else {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            arrayDef = FieldDefFactory.createArrayDef(elemDef);
            wildcard = elemDef.isWildcard();
        }
        ArrayValueImpl array = arrayDef.createArray();
        if (serialVersion >= 12 && wildcard && (homogeneous = in.readBoolean())) {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            array.setHomogeneousType(elemDef);
            wildcard = false;
        }
        if (wildcard) {
            elemDef = null;
        }
        int size = SerializationUtil.readNonNullSequenceLength(in);
        for (int i = 0; i < size; ++i) {
            FieldValue fval = FieldValueSerialization.readNonNullFieldValue(elemDef, null, in, serialVersion);
            assert (elemDef == null || fval.getType() == elemDef.getType());
            array.add(fval);
        }
        return array;
    }
}

