/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.api.table.TabularFormatter;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Table;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class IndexImpl
implements Index,
Serializable {
    private static final String KEY_TAG = "_key";
    private static final String DOT_BRACKETS = ".[]";
    private static final long serialVersionUID = 1L;
    static final int INDEX_VERSION_V0 = 0;
    static final int INDEX_VERSION_V1 = 1;
    static final int INDEX_VERSION_CURRENT = 1;
    static final byte NORMAL_VALUE_INDICATOR = 0;
    static final byte EMPTY_INDICATOR = 125;
    static final byte JSON_NULL_INDICATOR = 126;
    static final byte NULL_INDICATOR_V1 = 127;
    static final byte NULL_INDICATOR_V0 = 1;
    private final String name;
    private final String description;
    private final TableImpl table;
    private final List<String> fields;
    private IndexStatus status;
    private final Map<String, String> annotations;
    private final Map<String, String> properties;
    private final boolean isNullSupported;
    private final int indexVersion;
    private List<String> newFields;
    private final List<FieldDef.Type> types;
    private Map<String, String> newAnnotations;
    private transient List<IndexField> indexFields;
    private transient boolean isMultiKeyMapIndex;
    private transient RecordDefImpl indexKeyDef;
    static final String INDEX_NULL_DISABLE = "test.index.null.disable";
    static final String INDEX_SERIAL_VERSION = "test.index.serial.version";

    public IndexImpl(String name, TableImpl table, List<String> fields, List<FieldDef.Type> types, String description) {
        this(name, table, fields, types, null, null, description);
    }

    public IndexImpl(String name, TableImpl table, List<String> fields, String description) {
        this(name, table, fields, null, null, null, description);
    }

    public IndexImpl(String name, TableImpl table, List<String> fields, List<FieldDef.Type> types, Map<String, String> annotations, Map<String, String> properties, String description) {
        this.name = name;
        this.table = table;
        this.newFields = fields;
        this.types = types;
        this.newAnnotations = annotations;
        this.properties = properties;
        this.description = description;
        this.status = IndexStatus.TRANSIENT;
        this.isNullSupported = this.areIndicatorBytesEnabled();
        this.indexVersion = this.getIndexVersion();
        this.validate();
        this.fields = new ArrayList<String>(this.newFields.size());
        this.annotations = this.newAnnotations != null ? new HashMap<String, String>() : null;
        this.translateToOldFields();
    }

    private void translateToOldFields() {
        StringBuilder sb = new StringBuilder();
        for (IndexField field : this.indexFields) {
            String annotation;
            for (int s = 0; s < field.numSteps(); ++s) {
                TablePath.StepInfo si = field.getStepInfo(s);
                String step = si.step;
                if (si.kind == TablePath.StepKind.BRACKETS) {
                    sb.append("[]");
                } else if (si.kind == TablePath.StepKind.VALUES) {
                    sb.append("[]");
                } else if (si.kind == TablePath.StepKind.KEYS) {
                    sb.append(KEY_TAG);
                } else {
                    sb.append(step);
                }
                if (s >= field.numSteps() - 1) continue;
                sb.append(".");
            }
            String oldField = sb.toString();
            sb.delete(0, sb.length());
            this.fields.add(oldField);
            if (this.newAnnotations == null || (annotation = this.newAnnotations.get(field)) == null) continue;
            this.annotations.put(oldField, annotation);
        }
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isMapBothIndex() {
        List<IndexField> ipaths = this.getIndexFields();
        boolean haveMapKey = false;
        boolean haveMapValue = false;
        if (!this.isMultiKeyMapIndex) {
            return false;
        }
        for (IndexField ipath : ipaths) {
            if (ipath.isMapKeys()) {
                haveMapKey = true;
                if (!haveMapValue) continue;
                return false;
            }
            if (!ipath.isMapValues()) continue;
            haveMapValue = true;
            if (!haveMapKey) continue;
            break;
        }
        return haveMapKey && haveMapValue;
    }

    @Override
    public List<String> getFields() {
        if (this.newFields == null) {
            this.initTransientState();
        }
        return this.newFields;
    }

    public IndexField getIndexPath(int pos) {
        return this.getIndexFields().get(pos);
    }

    public IndexField getIndexPath(String fieldName) {
        return this.getIndexFields().get(this.getIndexKeyDef().getFieldPos(fieldName));
    }

    boolean fieldMayHaveSpecialValue(int pos) {
        return this.getIndexPath(pos).mayHaveSpecialValue();
    }

    public List<AnnotatedField> getFieldsWithAnnotations() {
        if (!this.isTextIndex()) {
            throw new IllegalStateException("getFieldsWithAnnotations called on non-text index");
        }
        ArrayList<AnnotatedField> fieldsWithAnnotations = new ArrayList<AnnotatedField>(this.getFields().size());
        Map<String, String> anns = this.getAnnotationsInternal();
        for (String field : this.getFields()) {
            fieldsWithAnnotations.add(new AnnotatedField(field, anns.get(field)));
        }
        return fieldsWithAnnotations;
    }

    Map<String, String> getAnnotations() {
        if (this.isTextIndex()) {
            if (this.annotations != null && this.newAnnotations == null) {
                this.initTransientState();
            }
            return Collections.unmodifiableMap(this.newAnnotations);
        }
        return Collections.emptyMap();
    }

    Map<String, String> getAnnotationsInternal() {
        if (this.annotations != null && this.newAnnotations == null) {
            this.initTransientState();
        }
        return this.newAnnotations;
    }

    public Map<String, String> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        return Collections.emptyMap();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IndexKeyImpl createIndexKey() {
        return new IndexKeyImpl(this, this.getIndexKeyDef());
    }

    public IndexKeyImpl createIndexKeyFromFlattenedRecord(RecordValue value) {
        IndexKeyImpl ikey = this.createIndexKey();
        ikey.copyFrom(value);
        return ikey;
    }

    @Override
    public IndexKeyImpl createIndexKey(RecordValue value) {
        if (value instanceof IndexKey) {
            throw new IllegalArgumentException("Cannot call createIndexKey with IndexKey argument");
        }
        IndexKeyImpl ikey = this.createIndexKey();
        this.populateIndexRecord(ikey, (RecordValueImpl)value);
        return ikey;
    }

    @Override
    public IndexKey createIndexKeyFromJson(String jsonInput, boolean exact) {
        return this.createIndexKeyFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public IndexKey createIndexKeyFromJson(InputStream jsonInput, boolean exact) {
        IndexKeyImpl key = this.createIndexKey();
        ComplexValueImpl.createFromJson((ComplexValueImpl)key, jsonInput, exact, false);
        return key;
    }

    @Override
    public FieldRange createFieldRange(String path) {
        FieldDefImpl ifieldDef = this.getIndexKeyDef().getField(path);
        if (ifieldDef == null) {
            throw new IllegalArgumentException("Field does not exist in index: " + path);
        }
        return new FieldRange(path, ifieldDef, 0);
    }

    private void populateIndexRecord(IndexKeyImpl indexKey, RecordValueImpl value) {
        assert (!(value instanceof IndexKey));
        int i = 0;
        for (IndexField field : this.getIndexFields()) {
            FieldValueImpl v = value.findFieldValue(field, -1, null);
            if (v != null) {
                indexKey.put(i, (FieldValue)v);
            }
            ++i;
        }
        indexKey.validate();
    }

    public int numFields() {
        return this.getFields().size();
    }

    public boolean isKeyOnly() {
        for (IndexField ifield : this.getIndexFields()) {
            if (ifield.isComplex()) {
                return false;
            }
            if (this.table.isKeyComponent(ifield.getStep(0))) continue;
            return false;
        }
        return true;
    }

    public boolean isMultiKey() {
        if (!this.isTextIndex()) {
            for (IndexField field : this.getIndexFields()) {
                if (!field.isMultiKey()) continue;
                return true;
            }
        }
        return false;
    }

    public IndexStatus getStatus() {
        return this.status;
    }

    public void setStatus(IndexStatus status) {
        this.status = status;
    }

    public TableImpl getTableImpl() {
        return this.table;
    }

    public List<FieldDef.Type> getTypes() {
        return this.types;
    }

    public List<IndexField> getIndexFields() {
        if (this.indexFields == null) {
            this.initTransientState();
        }
        return this.indexFields;
    }

    RecordDefImpl getIndexKeyDef() {
        if (this.indexKeyDef == null) {
            this.initTransientState();
        }
        return this.indexKeyDef;
    }

    public String getFieldName(int i) {
        return this.getIndexKeyDef().getFieldName(i);
    }

    public FieldDefImpl getFieldDef(int i) {
        return this.getIndexKeyDef().getFieldDef(i);
    }

    public boolean compareIndexFields(List<String> fieldNames) {
        if (fieldNames == null || fieldNames.size() != this.getFields().size()) {
            return false;
        }
        for (int i = 0; i < fieldNames.size(); ++i) {
            String field = fieldNames.get(i);
            IndexField ifield = new IndexField(this.table, field, this.getFieldType(i), i);
            this.validateIndexField(ifield, true);
            if (ifield.equals(this.getIndexFields().get(i))) continue;
            return false;
        }
        return true;
    }

    private void initTransientState() {
        int numFields;
        assert (this.indexFields == null && this.indexKeyDef == null);
        boolean convertOldPathFormat = false;
        if (this.newFields == null) {
            convertOldPathFormat = true;
            numFields = this.fields.size();
            this.newFields = new ArrayList<String>(numFields);
            if (this.annotations != null) {
                this.newAnnotations = new HashMap<String, String>();
            }
        } else {
            numFields = this.newFields.size();
        }
        this.indexFields = new ArrayList<IndexField>(numFields);
        for (int i = 0; i < numFields; ++i) {
            String newField;
            if (convertOldPathFormat) {
                String field = this.fields.get(i);
                newField = this.convertOldIndexPath(field);
            } else {
                newField = this.newFields.get(i);
            }
            IndexField indexField = new IndexField(this.table, newField, this.getFieldType(i), i);
            this.validateIndexField(indexField, false);
            if (convertOldPathFormat) {
                String ann;
                this.newFields.add(newField);
                if (this.annotations != null && (ann = this.annotations.get(this.fields.get(i))) != null) {
                    this.newAnnotations.put(newField, ann);
                }
            }
            this.indexFields.add(indexField);
        }
        this.indexKeyDef = this.createRecordDef();
    }

    private String convertOldIndexPath(String field) {
        if (field.contains(KEY_TAG)) {
            return field.replace(KEY_TAG, "keys()");
        }
        if (field.contains(DOT_BRACKETS)) {
            int bracketsIdx = field.indexOf(DOT_BRACKETS);
            String mapOrArrayPath = field.substring(0, bracketsIdx);
            FieldDefImpl def = this.table.findTableField(mapOrArrayPath);
            if (def.isArray()) {
                return field.replace(DOT_BRACKETS, "[]");
            }
            if (!def.isMap()) {
                throw new IllegalArgumentException("Multikey index path does not contain an array or map. mapOrArrayPath = " + mapOrArrayPath);
            }
            return field.replace("[]", "values()");
        }
        return field;
    }

    private IndexField findMultiKeyField() {
        for (IndexField field : this.getIndexFields()) {
            if (!field.isMultiKey()) continue;
            return field.getMultiKeyField();
        }
        throw new IllegalStateException("Could not find any multiKeyField in index " + this.name);
    }

    public boolean isMultiKeyMapIndex() {
        return this.isMultiKeyMapIndex;
    }

    public byte[] extractIndexKey(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        if (row != null) {
            return this.serializeIndexKey((RecordValueImpl)row, -1);
        }
        return null;
    }

    public List<byte[]> extractIndexKeys(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        return this.extractIndexKeys(row);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<byte[]> extractIndexKeys(RowImpl row) {
        ArrayList<Object> returnList;
        if (row == null) {
            return null;
        }
        EmptyValueImpl empty = EmptyValueImpl.getInstance();
        IndexField arrayOrMapPath = this.findMultiKeyField();
        FieldValueImpl mapOrArrayVal = row.findFieldValue(arrayOrMapPath, -1, null);
        if (this.isMultiKeyMapIndex) {
            if (mapOrArrayVal.isMap()) {
                MapValueImpl map = (MapValueImpl)mapOrArrayVal;
                if (map.size() == 0) {
                    byte[] serKey = this.serializeIndexKey(row, -1, empty);
                    returnList = new ArrayList(1);
                    if (serKey == null) return returnList;
                    returnList.add(serKey);
                    return returnList;
                } else {
                    returnList = new ArrayList(map.size());
                    for (String mapKey : map.getFieldsInternal().keySet()) {
                        byte[] serKey = this.serializeIndexKey((RecordValueImpl)row, mapKey);
                        if (serKey == null) continue;
                        returnList.add(serKey);
                    }
                }
                return returnList;
            } else {
                if (!mapOrArrayVal.isNull() && !mapOrArrayVal.isAtomic()) throw new IllegalArgumentException("Cannot create index entry for index " + this.getName() + " on row\n" + row + "\nThe row does not contain a map " + "at path " + this.findMultiKeyField());
                if (!mapOrArrayVal.isNull()) {
                    mapOrArrayVal = empty;
                }
                byte[] serKey = this.serializeIndexKey(row, -1, mapOrArrayVal);
                returnList = new ArrayList(1);
                if (serKey == null) return returnList;
                returnList.add(serKey);
            }
            return returnList;
        } else if (mapOrArrayVal.isArray()) {
            ArrayValueImpl array = (ArrayValueImpl)mapOrArrayVal;
            if (array.size() == 0) {
                byte[] serKey = this.serializeIndexKey(row, -1, empty);
                returnList = new ArrayList(1);
                if (serKey == null) return returnList;
                returnList.add(serKey);
                return returnList;
            } else {
                int size = array.size();
                returnList = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    byte[] serKey = this.serializeIndexKey(row, i, null);
                    if (serKey == null) continue;
                    returnList.add(serKey);
                }
            }
            return returnList;
        } else {
            returnList = new ArrayList<byte[]>(1);
            byte[] serKey = this.serializeIndexKey(row, -1, null);
            if (serKey == null) return returnList;
            returnList.add(serKey);
        }
        return returnList;
    }

    public void toJsonNode(ObjectNode node) {
        node.put("name", this.name);
        if (this.table.getNamespace() != null) {
            node.put("namespace", this.table.getNamespace());
        }
        node.put("table", this.table.getFullName());
        node.put("type", this.getType().toString().toLowerCase());
        if (this.description != null) {
            node.put("comment", this.description);
        }
        if (this.isMultiKey()) {
            node.put("multi_key", "true");
        }
        ArrayNode fieldArray = node.putArray("fields");
        for (String field : this.getFields()) {
            fieldArray.add(field);
        }
        if (this.types != null && this.types.size() != 0) {
            ArrayNode typesArray = node.putArray("types");
            for (FieldDef.Type type : this.types) {
                if (type == null) {
                    typesArray.addNull();
                    continue;
                }
                typesArray.add(type.toString());
            }
        }
        if (this.annotations != null) {
            IndexImpl.putMapAsJson(node, "annotations", this.getAnnotationsInternal());
        }
        if (this.properties != null) {
            IndexImpl.putMapAsJson(node, "properties", this.properties);
        }
    }

    private static void putMapAsJson(ObjectNode node, String mapName, Map<String, String> map) {
        ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mapNode.put(entry.getKey(), entry.getValue());
        }
        node.put(mapName, mapNode);
    }

    public FieldDef.Type getFieldType(int position) {
        if (this.types == null) {
            return null;
        }
        return this.types.get(position);
    }

    private void validate() {
        TableImpl.validateIdentifier(this.name, 64, "Index names");
        IndexField multiKeyField = null;
        if (this.getFields().isEmpty()) {
            throw new IllegalCommandException("Index requires at least one field");
        }
        assert (this.indexFields == null);
        this.indexFields = new ArrayList<IndexField>(this.getFields().size());
        int position = 0;
        for (String field : this.getFields()) {
            if (field == null || field.length() == 0) {
                throw new IllegalCommandException("Invalid (null or empty) index field name");
            }
            IndexField ifield = new IndexField(this.table, field, this.getFieldType(position), position++);
            this.validateIndexField(ifield, true);
            if (ifield.isMultiKey() && !this.isTextIndex()) {
                IndexField mkey = ifield.getMultiKeyField();
                if (multiKeyField != null && !mkey.equals(multiKeyField)) {
                    throw new IllegalCommandException("Indexes may contain only one multiKey field");
                }
                multiKeyField = mkey;
            }
            if (this.indexFields.contains(ifield)) {
                throw new IllegalCommandException("Index already contains the field: " + field);
            }
            this.indexFields.add(ifield);
        }
        assert (this.newFields.size() == this.indexFields.size());
        this.indexKeyDef = this.createRecordDef();
        this.table.checkForDuplicateIndex(this);
    }

    private void validateIndexField(IndexField ipath, boolean isNewIndex) {
        int numSteps = ipath.numSteps();
        int stepIdx = 0;
        String step = ipath.getStep(stepIdx);
        FieldDef stepDef = ipath.getFirstDef();
        if (stepDef == null) {
            throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "There is no field named " + step);
        }
        while (stepIdx < numSteps) {
            if (this.isTextIndex() && (stepDef.isBinary() || stepDef.isFixedBinary() || stepDef.isEnum())) {
                throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "Fields of type " + stepDef.getType() + " cannot participate in a FULLTEXT index.");
            }
            if (stepDef.isJson()) {
                ipath.setIsJson();
                ++stepIdx;
                if (ipath.getJsonFieldPath() == null) {
                    ipath.setJsonFieldPath(stepIdx);
                }
                if (stepIdx >= numSteps) break;
                if (ipath.isBracketsStep(stepIdx) || ipath.isKeysStep(stepIdx) || ipath.isValuesStep(stepIdx)) {
                    ipath.setIsJsonMultiKey();
                    ipath.setMultiKeyPath(stepIdx);
                    if (ipath.isKeysStep(stepIdx)) {
                        ipath.setIsMapKeys();
                        ipath.declaredType = FieldDefImpl.stringDef;
                        this.isMultiKeyMapIndex = true;
                        continue;
                    }
                    if (!ipath.isValuesStep(stepIdx)) continue;
                    ipath.setIsMapValues();
                    this.isMultiKeyMapIndex = true;
                    continue;
                }
                ipath.setIsMapKeyStep(stepIdx);
                continue;
            }
            if (stepDef.isRecord()) {
                if (++stepIdx >= numSteps) break;
                step = ipath.getStep(stepIdx);
                if ((stepDef = stepDef.asRecord().getFieldDef(step)) != null) continue;
                throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "There is no field named \"" + step + "\" after " + "path " + ipath.getPathName(stepIdx - 1));
            }
            if (stepDef.isArray()) {
                if (ipath.isMultiKey()) {
                    throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "The definition contains more than one multi-key " + "fields. The second multi-key field is " + step);
                }
                if (stepIdx + 1 < numSteps && ipath.getStep(stepIdx + 1).equals("[]")) {
                    ++stepIdx;
                } else {
                    if (isNewIndex) {
                        throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "Can not index an array as a whole; use " + step + "[]  to index the elements of the array");
                    }
                    ++numSteps;
                    ipath.add(++stepIdx, "[]", false);
                }
                ipath.setMultiKeyPath(stepIdx);
                step = "[]";
                stepDef = stepDef.asArray().getElement();
                continue;
            }
            if (stepDef.isMap()) {
                if (++stepIdx >= numSteps) {
                    throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "Can not index a map as a whole; use " + ".values() to index the elements of the map or " + ".keys() to index the keys of the map");
                }
                step = ipath.getStep(stepIdx);
                if (ipath.isValuesStep(stepIdx) || ipath.isBracketsStep(stepIdx)) {
                    if (ipath.isMultiKey()) {
                        throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "The definition contains more than one multi-key " + "fields. The second multi-key field is " + step);
                    }
                    if (ipath.isBracketsStep(stepIdx)) {
                        ipath.setIsValuesStep(stepIdx);
                    }
                    ipath.setMultiKeyPath(stepIdx);
                    ipath.setIsMapValues();
                    this.isMultiKeyMapIndex = true;
                    stepDef = stepDef.asMap().getElement();
                    continue;
                }
                if (ipath.isKeysStep(stepIdx)) {
                    if (ipath.isMultiKey()) {
                        throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "The definition contains more than one multi-key " + "fields. The second multi-key field is " + step);
                    }
                    ipath.setMultiKeyPath(stepIdx);
                    ipath.setIsMapKeys();
                    this.isMultiKeyMapIndex = true;
                    stepDef = FieldDefImpl.stringDef;
                    continue;
                }
                ipath.setIsMapKeyStep(stepIdx);
                stepDef = stepDef.asMap().getElement();
                continue;
            }
            if (++stepIdx >= numSteps) break;
            step = ipath.getStep(stepIdx);
            throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "There is no field named \"" + step + "\" after " + "path " + ipath.getPathName(stepIdx - 1));
        }
        if (!stepDef.isValidIndexField()) {
            throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "Cannot index values of type " + stepDef);
        }
        boolean nullable = (ipath.isComplex() || !this.table.isKeyComponent(ipath.getStep(0)) && ipath.getFieldMap().getFieldMapEntry(ipath.getStep(0)).isNullable()) && this.supportsSpecialValues();
        ipath.setNullable(nullable);
        if (ipath.getDeclaredType() != null) {
            if (!stepDef.isJson()) {
                throw new IllegalCommandException("Invalid index field definition: " + ipath + "\n" + "Specific types are only allowed for JSON data types.");
            }
            ipath.type = ipath.getDeclaredType();
            return;
        }
        if (stepDef.isJson()) {
            throw new IllegalCommandException("Invalid index field definition: " + ipath + "\n" + "Please specify data type for JSON index field.");
        }
        ipath.type = (FieldDefImpl)stepDef;
    }

    public String toString() {
        return "Index[" + this.name + ", " + this.table.getId() + ", " + (Object)((Object)this.status) + "]";
    }

    public byte[] serializeIndexKey(IndexKeyImpl indexKey) {
        return this.serializeIndexKey(indexKey, SerialVersion.CURRENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeIndexKey(IndexKeyImpl indexKey, short opSerialVersion) {
        FieldValueImpl val;
        TupleOutput out = null;
        out = new TupleOutput();
        int numFields = this.getIndexKeyDef().getNumFields();
        boolean keyHasIndicators = opSerialVersion >= 12;
        for (int i = 0; i < numFields && (val = indexKey.get(i)) != null; ++i) {
            if (!(!FieldValueImpl.isSpecialValue(val) || this.supportsSpecialValues() && keyHasIndicators)) {
                byte[] byArray = null;
                return byArray;
            }
            this.serializeValue(out, val, this.indexFields.get(i), opSerialVersion);
        }
        byte[] byArray = out.size() != 0 ? out.toByteArray() : null;
        return byArray;
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] serializeIndexKey(RecordValueImpl record, int arrayIndex) {
        return this.serializeIndexKey(record, arrayIndex, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeIndexKey(RecordValueImpl record, int arrayIndex, FieldValueImpl nullOrEmptyMapArray) {
        if (nullOrEmptyMapArray != null && !this.supportsSpecialValues()) {
            return null;
        }
        if (this.isMultiKeyMapIndex() && nullOrEmptyMapArray == null) {
            throw new IllegalStateException("Wrong serializer for map index");
        }
        TupleOutput out = null;
        out = new TupleOutput();
        for (IndexField field : this.getIndexFields()) {
            FieldValueImpl val;
            FieldValueImpl fieldValueImpl = val = field.isMultiKey() && nullOrEmptyMapArray != null ? nullOrEmptyMapArray : record.findFieldValue(field, arrayIndex, null);
            if (FieldValueImpl.isSpecialValue(val) && !this.supportsSpecialValues()) {
                byte[] byArray = null;
                return byArray;
            }
            this.serializeValue(out, val, field);
        }
        Object object = out.size() != 0 ? out.toByteArray() : null;
        return object;
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] serializeIndexKey(RecordValueImpl record, String mapKey) {
        assert (this.isMultiKeyMapIndex());
        TupleOutput out = null;
        out = new TupleOutput();
        for (IndexField field : this.getIndexFields()) {
            FieldValueImpl val = record.findFieldValue(field, -1, mapKey);
            if (FieldValueImpl.isSpecialValue(val) && !this.supportsSpecialValues()) {
                byte[] byArray = null;
                return byArray;
            }
            this.serializeValue(out, val, field);
        }
        Object object = out.size() != 0 ? out.toByteArray() : null;
        return object;
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void serializeValue(TupleOutput out, FieldValueImpl val, IndexField indexField) {
        this.serializeValue(out, val, indexField, SerialVersion.CURRENT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serializeValue(TupleOutput out, FieldValueImpl val, IndexField indexField, short opSerialVersion) {
        if (indexField.isNullable() && opSerialVersion >= 12) {
            byte indicator = this.getSerializeIndicator(val, opSerialVersion);
            out.writeByte(indicator);
            if (indicator != 0) {
                return;
            }
        }
        if (indexField.isJson()) {
            FieldDefImpl declaredType = indexField.getDeclaredType();
            if (declaredType != null && declaredType.isPrecise()) {
                FieldDefImpl valDef = val.getDefinition();
                FieldValueImpl castVal = null;
                if (valDef.isSubtype(declaredType)) {
                    castVal = (FieldValueImpl)val.castToSuperType(declaredType);
                }
                if (castVal == null) throw new IllegalArgumentException("Invalid type for JSON index field: " + indexField + ". Type is " + val.getType() + ", expected type is " + declaredType.getType() + "\nvalue = " + val);
                val = castVal;
            } else {
                val = IndexImpl.convertToJsonValue(val);
                out.writeByte(val.getType().ordinal());
            }
        }
        switch (val.getType()) {
            case INTEGER: {
                out.writeSortedPackedInt(val.asInteger().get());
                return;
            }
            case STRING: {
                out.writeString(val.asString().get());
                return;
            }
            case LONG: {
                out.writeSortedPackedLong(val.asLong().get());
                return;
            }
            case DOUBLE: {
                out.writeSortedDouble(val.asDouble().get());
                return;
            }
            case FLOAT: {
                out.writeSortedFloat(val.asFloat().get());
                return;
            }
            case NUMBER: {
                out.write(((NumberValueImpl)val).getBytes());
                return;
            }
            case ENUM: {
                out.writeSortedPackedInt(val.asEnum().getIndex());
                return;
            }
            case BOOLEAN: {
                out.writeBoolean(val.asBoolean().get());
                return;
            }
            case TIMESTAMP: {
                out.write(((TimestampValueImpl)val).getBytes(true));
                return;
            }
            default: {
                throw new IllegalStateException("Type not supported in indexes: " + val.getType());
            }
        }
    }

    public boolean supportsSpecialValues() {
        return this.isNullSupported;
    }

    private byte getSerializeIndicator(FieldValue val, short opSerialVersion) {
        if (val.isNull()) {
            return this.getNullIndicator(opSerialVersion);
        }
        if (((FieldValueImpl)val).isEMPTY()) {
            return opSerialVersion < 14 ? this.getNullIndicator(opSerialVersion) : this.getEmptyIndicator();
        }
        if (val.isJsonNull()) {
            return 126;
        }
        return 0;
    }

    private FieldValueImpl getSpecialValue(byte indicator, short opSerialVersion) {
        return indicator == this.getNullIndicator(opSerialVersion) ? NullValueImpl.getInstance() : (indicator == 125 ? EmptyValueImpl.getInstance() : (indicator == 126 ? NullJsonValueImpl.getInstance() : null));
    }

    private byte getNullIndicator(short opSerialVersion) {
        return (byte)(this.indexVersion >= 1 && opSerialVersion >= 14 ? 127 : 1);
    }

    private byte getEmptyIndicator() {
        return this.indexVersion >= 1 ? (byte)125 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowFromIndexKey(byte[] data, RowImpl row) {
        TupleInput input = null;
        try {
            input = new TupleInput(data);
            String keyForKeysField = null;
            block10: for (IndexField ifield : this.getIndexFields()) {
                byte in;
                FieldValueImpl specialVal;
                int jsonArrayPathPos;
                if (input.available() <= 0) {
                    break;
                }
                int n = jsonArrayPathPos = ifield.isJsonAsArray() ? ifield.getMultiKeyField().numSteps() - 1 : -1;
                if (ifield.mayHaveSpecialValue() && (specialVal = this.getSpecialValue(in = input.readByte(), SerialVersion.CURRENT)) != null) {
                    row.putComplex(ifield, specialVal, keyForKeysField, jsonArrayPathPos);
                    continue;
                }
                FieldDefImpl def = ifield.getType();
                FieldDef.Type type = ifield.isJson() ? ifield.getDeclaredType().getType() : def.getType();
                switch (type) {
                    case INTEGER: 
                    case STRING: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case NUMBER: 
                    case ENUM: 
                    case BOOLEAN: 
                    case TIMESTAMP: {
                        FieldValueImpl val = (FieldValueImpl)def.createValue(type, FieldValueImpl.readTuple(type, def, input));
                        if (ifield.isMapKeys()) {
                            keyForKeysField = ((StringValueImpl)val).get();
                        }
                        row.putComplex(ifield, val, keyForKeysField, jsonArrayPathPos);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Type not supported in indexes: " + type);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public IndexKeyImpl deserializeIndexKey(byte[] data, boolean partialOK) {
        return this.deserializeIndexKey(data, partialOK, SerialVersion.CURRENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexKeyImpl deserializeIndexKey(byte[] data, boolean partialOK, short opSerialVersion) {
        TupleInput input = null;
        RecordDefImpl idxKeyDef = this.getIndexKeyDef();
        IndexKeyImpl indexKey = new IndexKeyImpl(this, idxKeyDef);
        boolean keyHasIndicators = opSerialVersion >= 12;
        try {
            input = new TupleInput(data);
            int numFields = idxKeyDef.getNumFields();
            block10: for (int i = 0; i < numFields && input.available() > 0; ++i) {
                byte in;
                FieldValueImpl specialVal;
                IndexField ifield = this.getIndexPath(i);
                if (keyHasIndicators && ifield.mayHaveSpecialValue() && (specialVal = this.getSpecialValue(in = input.readByte(), opSerialVersion)) != null) {
                    indexKey.put(i, (FieldValue)specialVal);
                    continue;
                }
                FieldDefImpl def = idxKeyDef.getFieldDef(i);
                FieldDef.Type type = def.getType();
                switch (type) {
                    case INTEGER: 
                    case STRING: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case NUMBER: 
                    case ENUM: 
                    case BOOLEAN: 
                    case TIMESTAMP: {
                        FieldValue val = def.createValue(type, FieldValueImpl.readTuple(type, def, input));
                        indexKey.put(i, val);
                        continue block10;
                    }
                    default: {
                        throw new IllegalStateException("Type not supported in indexes: " + type);
                    }
                }
            }
            if (!partialOK && !indexKey.isComplete()) {
                throw new IllegalStateException("Missing fields from index data for index " + this.getName() + ", expected " + numFields + ", received " + indexKey.size());
            }
            IndexKeyImpl indexKeyImpl = indexKey;
            return indexKeyImpl;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    byte[] reserializeOldKey(byte[] key, short opVersion) {
        IndexKeyImpl ikey = this.deserializeIndexKey(key, true, opVersion);
        return this.serializeIndexKey(ikey);
    }

    public byte[] reserializeToOldKey(byte[] indexKey, short opVersion) {
        IndexKeyImpl ikey = this.deserializeIndexKey(indexKey, false, SerialVersion.CURRENT);
        return this.serializeIndexKey(ikey, opVersion);
    }

    boolean isIndexPath(TablePath tablePath) {
        for (IndexField indexField : this.getIndexFields()) {
            if (!indexField.equals(tablePath)) continue;
            return true;
        }
        return false;
    }

    private RecordDefImpl createRecordDef() {
        FieldMap fieldMap = new FieldMap();
        for (int i = 0; i < this.numFields(); ++i) {
            IndexField indexField = this.getIndexPath(i);
            FieldDefImpl fdef = indexField.getType();
            String fname = this.newFields.get(i);
            FieldMapEntry fme = new FieldMapEntry(fname, fdef);
            fieldMap.put(fme);
        }
        return new RecordDefImpl(fieldMap, null);
    }

    @Override
    public Index.IndexType getType() {
        if (this.getAnnotationsInternal() == null) {
            return Index.IndexType.SECONDARY;
        }
        return Index.IndexType.TEXT;
    }

    private boolean isTextIndex() {
        return this.getType() == Index.IndexType.TEXT;
    }

    public static void populateMapFromAnnotatedFields(List<AnnotatedField> fields, List<String> fieldNames, Map<String, String> annotations) {
        for (AnnotatedField f : fields) {
            String fieldName = f.getFieldName();
            fieldNames.add(fieldName);
            annotations.put(fieldName, f.getAnnotation());
        }
    }

    @Override
    public String getAnnotationForField(String fieldName) {
        if (!this.isTextIndex()) {
            return null;
        }
        return this.getAnnotationsInternal().get(fieldName);
    }

    public RowImpl deserializeRow(byte[] keyBytes, byte[] valueBytes) {
        return this.table.createRowFromBytes(keyBytes, valueBytes, false);
    }

    public String formatIndex(boolean asJson) {
        if (asJson) {
            ObjectWriter writer = JsonUtils.createWriter(true);
            ObjectNode o = JsonUtils.createObjectNode();
            this.toJsonNode(o);
            try {
                return writer.writeValueAsString(o);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to serialize index description: " + ioe.getMessage());
            }
        }
        return TabularFormatter.formatIndex(this);
    }

    private boolean areIndicatorBytesEnabled() {
        return !Boolean.getBoolean(INDEX_NULL_DISABLE);
    }

    public int getIndexVersion() {
        return Integer.getInteger(INDEX_SERIAL_VERSION, 1);
    }

    private static FieldValueImpl convertToJsonValue(FieldValueImpl val) {
        return val;
    }

    static int compareUnsignedBytes(byte[] key1, int off1, int len1, byte[] key2, int off2, int len2) {
        int limit = Math.min(len1, len2);
        for (int i = 0; i < limit; ++i) {
            byte b1 = key1[i + off1];
            byte b2 = key2[i + off2];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return len1 - len2;
    }

    static int compareUnsignedBytes(byte[] key1, byte[] key2) {
        return IndexImpl.compareUnsignedBytes(key1, 0, key1.length, key2, 0, key2.length);
    }

    public static class AnnotatedField
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final String annotation;

        public AnnotatedField(String fieldName, String annotation) {
            assert (fieldName != null);
            this.fieldName = fieldName;
            this.annotation = annotation;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotatedField other = (AnnotatedField)obj;
            if (!this.fieldName.equals(other.fieldName)) {
                return false;
            }
            return this.annotation == null ? other.annotation == null : JsonUtils.jsonStringsEqual(this.annotation, other.annotation);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fieldName.hashCode();
            if (this.annotation != null) {
                result = 31 * result + this.annotation.hashCode();
            }
            return result;
        }
    }

    public static class IndexField
    extends TablePath {
        private IndexField multiKeyField;
        private MultiKeyType multiKeyType = MultiKeyType.NONE;
        private boolean isJson;
        private boolean isJsonMultiKey;
        private TablePath jsonFieldPath;
        private final int position;
        private FieldDefImpl declaredType;
        private FieldDefImpl type;
        private boolean nullable;

        public IndexField(TableImpl table, String field, FieldDef.Type typecode, int position) {
            super(table, field);
            this.position = position;
            this.declaredType = typecode == null ? null : IndexField.getFieldDefForTypecode(typecode);
            this.jsonFieldPath = null;
        }

        private IndexField(FieldMap fieldMap, String field, int position) {
            super(fieldMap, field);
            this.position = position;
            this.declaredType = null;
            this.jsonFieldPath = null;
        }

        IndexField getMultiKeyField() {
            return this.multiKeyField;
        }

        public boolean isMultiKey() {
            return this.multiKeyField != null;
        }

        private void setIsJson() {
            this.isJson = true;
        }

        public boolean isJson() {
            return this.isJson;
        }

        void setIsJsonMultiKey() {
            this.isJsonMultiKey = true;
        }

        boolean isJsonMultiKey() {
            return this.isJsonMultiKey;
        }

        boolean isJsonAsArray() {
            if (this.isJsonMultiKey()) {
                return !this.isMapKeys() && !this.isMapValues();
            }
            return false;
        }

        public int getPosition() {
            return this.position;
        }

        public FieldDefImpl getType() {
            return this.type;
        }

        public void setType(FieldDefImpl def) {
            this.type = def;
        }

        public FieldDefImpl getDeclaredType() {
            return this.declaredType;
        }

        boolean hasPreciseType() {
            return this.type.isPrecise();
        }

        boolean isNullable() {
            return this.nullable;
        }

        boolean mayHaveSpecialValue() {
            return this.nullable;
        }

        private void setMultiKeyPath(int pos) {
            this.multiKeyField = new IndexField(this.getFieldMap(), null, this.position);
            for (int i = 0; i < pos; ++i) {
                TablePath.StepInfo si = this.getStepInfo(i);
                this.multiKeyField.addStepInfo(new TablePath.StepInfo(si));
            }
        }

        public boolean isMapKeys() {
            return this.multiKeyType == MultiKeyType.MAPKEY;
        }

        private void setIsMapKeys() {
            this.multiKeyType = MultiKeyType.MAPKEY;
        }

        public boolean isMapValues() {
            return this.multiKeyType == MultiKeyType.MAPVALUE;
        }

        private void setIsMapValues() {
            this.multiKeyType = MultiKeyType.MAPVALUE;
        }

        private void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        private void setJsonFieldPath(int pos) {
            this.jsonFieldPath = new TablePath(this.getFieldMap(), (String)null);
            for (int i = 0; i < pos; ++i) {
                TablePath.StepInfo si = this.getStepInfo(i);
                this.jsonFieldPath.addStepInfo(new TablePath.StepInfo(si));
            }
        }

        TablePath getJsonFieldPath() {
            return this.jsonFieldPath;
        }

        private static FieldDefImpl getFieldDefForTypecode(FieldDef.Type code) {
            switch (code) {
                case INTEGER: {
                    return FieldDefImpl.integerDef;
                }
                case LONG: {
                    return FieldDefImpl.longDef;
                }
                case DOUBLE: {
                    return FieldDefImpl.doubleDef;
                }
                case BOOLEAN: {
                    return FieldDefImpl.booleanDef;
                }
                case STRING: {
                    return FieldDefImpl.stringDef;
                }
                case NUMBER: {
                    return FieldDefImpl.numberDef;
                }
            }
            throw new IllegalArgumentException("Invalid type for JSON index field: " + code);
        }

        private static enum MultiKeyType {
            NONE,
            MAPKEY,
            MAPVALUE;

        }
    }

    public static enum IndexStatus {
        TRANSIENT{

            @Override
            public boolean isTransient() {
                return true;
            }
        }
        ,
        POPULATING{

            @Override
            public boolean isPopulating() {
                return true;
            }
        }
        ,
        READY{

            @Override
            public boolean isReady() {
                return true;
            }
        };


        public boolean isTransient() {
            return false;
        }

        public boolean isPopulating() {
            return false;
        }

        public boolean isReady() {
            return false;
        }
    }
}

