/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import oracle.kv.Direction;
import oracle.kv.Key;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.ops.IndexIterate;
import oracle.kv.impl.api.ops.IndexKeysIterate;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultIndexKeys;
import oracle.kv.impl.api.ops.ResultIndexRows;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.ShardScanIterator;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.table.KeyPair;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.Row;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;

public class IndexScan {
    static final Comparator<byte[]> KEY_BYTES_COMPARATOR = new Key.BytesComparator();

    private IndexScan() {
    }

    static TableIterator<Row> createTableIterator(TableAPIImpl tableAPI, IndexKeyImpl indexKey, MultiRowOptions mro, TableIteratorOptions tio) {
        return IndexScan.createTableIterator(tableAPI, indexKey, mro, tio, null);
    }

    static TableIterator<Row> createTableIterator(final TableAPIImpl tableAPI, IndexKeyImpl indexKey, MultiRowOptions mro, TableIteratorOptions tio, Set<RepGroupId> shardSet) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(indexKey.getTable(), mro);
        final IndexImpl index = (IndexImpl)indexKey.getIndex();
        final TableImpl table = (TableImpl)index.getTable();
        final IndexRange range = new IndexRange(indexKey, mro, tio);
        final boolean needDupElim = IndexScan.needDupElimination(indexKey);
        return new ShardScanIterator<Row>(tableAPI.getStore(), tio, shardSet){

            @Override
            protected ShardScanIterator.ShardStream createStream(RepGroupId groupId) {
                return new IndexRowScanStream(groupId);
            }

            @Override
            protected InternalOperation createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                return new IndexIterate(index.getName(), targetTables, range, resumeSecondaryKey, resumePrimaryKey, this.batchSize);
            }

            @Override
            protected void convertResult(Result result, List<Row> rows) {
                List<ResultIndexRows> indexRowList = result.getIndexRowList();
                for (ResultIndexRows indexRow : indexRowList) {
                    Row converted = this.convert(indexRow);
                    rows.add(converted);
                }
            }

            private Row convert(ResultIndexRows rowResult) {
                TableImpl startingTable = targetTables.hasAncestorTables() ? table.getTopLevelTable() : table;
                RowImpl fullKey = startingTable.createRowFromKeyBytes(rowResult.getKeyBytes());
                if (fullKey == null) {
                    throw new IllegalStateException("Unable to deserialize a row from an index result");
                }
                ValueVersion vv = new ValueVersion(rowResult.getValue(), rowResult.getVersion());
                RowImpl row = tableAPI.getRowFromValueVersion(vv, fullKey, rowResult.getExpirationTime(), false);
                return row;
            }

            @Override
            protected byte[] extractResumeSecondaryKey(Result result) {
                byte[] bytes = result.getSecondaryResumeKey();
                if (bytes != null || !result.hasMoreElements()) {
                    return bytes;
                }
                ArrayList<Row> rowList = new ArrayList<Row>();
                this.convertResult(result, (List<Row>)rowList);
                Row lastRow = (Row)rowList.get(rowList.size() - 1);
                return index.serializeIndexKey(index.createIndexKey(lastRow));
            }

            @Override
            protected int compare(Row one, Row two) {
                throw new IllegalStateException("Unexpected call");
            }

            class IndexRowScanStream
            extends ShardScanIterator.ShardStream {
                HashSet<BinaryValueImpl> thePrimKeysSet;

                IndexRowScanStream(RepGroupId groupId) {
                    super(groupId, null, null);
                    if (needDupElim) {
                        this.thePrimKeysSet = new HashSet(1000);
                    }
                }

                @Override
                protected void setResumeKey(Result result) {
                    super.setResumeKey(result);
                    if (!needDupElim) {
                        return;
                    }
                    ListIterator<ResultIndexRows> listIter = result.getIndexRowList().listIterator();
                    while (listIter.hasNext()) {
                        ResultIndexRows indexRow = listIter.next();
                        BinaryValueImpl binPrimKey = FieldDefImpl.binaryDef.createBinary(indexRow.getKeyBytes());
                        boolean added = this.thePrimKeysSet.add(binPrimKey);
                        if (added) continue;
                        listIter.remove();
                    }
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    byte[] key2;
                    IndexRowScanStream other = (IndexRowScanStream)o;
                    ResultIndexRows res1 = this.currentResultSet.getIndexRowList().get(this.currentResultPos);
                    ResultIndexRows res2 = other.currentResultSet.getIndexRowList().get(other.currentResultPos);
                    byte[] key1 = res1.getIndexKeyBytes();
                    int cmp = IndexImpl.compareUnsignedBytes(key1, key2 = res2.getIndexKeyBytes());
                    if (cmp == 0) {
                        cmp = KEY_BYTES_COMPARATOR.compare(res1.getKeyBytes(), res2.getKeyBytes());
                    }
                    return itrDirection == Direction.FORWARD ? cmp : cmp * -1;
                }
            }
        };
    }

    private static boolean needDupElimination(IndexKeyImpl key) {
        int i;
        IndexImpl index = (IndexImpl)key.getIndex();
        if (!index.isMultiKey() || key.isComplete()) {
            return false;
        }
        if (key.size() == 0) {
            return true;
        }
        List<IndexImpl.IndexField> ipaths = index.getIndexFields();
        if (index.isMapBothIndex()) {
            for (i = 0; i < key.size(); ++i) {
                if (!ipaths.get(i).isMapKeys()) continue;
                return false;
            }
        }
        for (i = key.size(); i < index.numFields(); ++i) {
            if (!ipaths.get(i).isMultiKey()) continue;
            return true;
        }
        return false;
    }

    static TableIterator<KeyPair> createTableKeysIterator(TableAPIImpl apiImpl, IndexKeyImpl indexKey, MultiRowOptions mro, TableIteratorOptions iterateOptions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(indexKey.getTable(), mro);
        final IndexImpl index = (IndexImpl)indexKey.getIndex();
        final TableImpl table = (TableImpl)index.getTable();
        final IndexRange range = new IndexRange(indexKey, mro, iterateOptions);
        return new ShardScanIterator<KeyPair>(apiImpl.getStore(), iterateOptions, null){

            @Override
            protected ShardScanIterator.ShardStream createStream(RepGroupId groupId) {
                return new IndexKeyScanStream(groupId);
            }

            @Override
            protected InternalOperation createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                return new IndexKeysIterate(index.getName(), targetTables, range, resumeSecondaryKey, resumePrimaryKey, this.batchSize);
            }

            @Override
            protected void convertResult(Result result, List<KeyPair> elementList) {
                List<ResultIndexKeys> results = result.getIndexKeyList();
                for (ResultIndexKeys res : results) {
                    IndexKeyImpl indexKeyImpl = this.convertIndexKey(res.getIndexKeyBytes());
                    PrimaryKeyImpl pkey = this.convertPrimaryKey(res);
                    if (indexKeyImpl != null && pkey != null) {
                        elementList.add(new KeyPair(pkey, indexKeyImpl));
                        continue;
                    }
                    elementList.add(null);
                }
            }

            @Override
            protected int compare(KeyPair one, KeyPair two) {
                throw new IllegalStateException("Unexpected call");
            }

            private IndexKeyImpl convertIndexKey(byte[] bytes) {
                return index.deserializeIndexKey(bytes, false);
            }

            private PrimaryKeyImpl convertPrimaryKey(ResultIndexKeys res) {
                TableImpl startingTable = targetTables.hasAncestorTables() ? table.getTopLevelTable() : table;
                PrimaryKeyImpl pkey = startingTable.createPrimaryKeyFromKeyBytes(res.getPrimaryKeyBytes());
                pkey.setExpirationTime(res.getExpirationTime());
                return pkey;
            }

            class IndexKeyScanStream
            extends ShardScanIterator.ShardStream {
                IndexKeyScanStream(RepGroupId groupId) {
                    super(groupId, null, null);
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    byte[] key2;
                    IndexKeyScanStream other = (IndexKeyScanStream)o;
                    ResultIndexKeys res1 = this.currentResultSet.getIndexKeyList().get(this.currentResultPos);
                    ResultIndexKeys res2 = other.currentResultSet.getIndexKeyList().get(other.currentResultPos);
                    byte[] key1 = res1.getIndexKeyBytes();
                    int cmp = IndexImpl.compareUnsignedBytes(key1, key2 = res2.getIndexKeyBytes());
                    if (cmp == 0) {
                        cmp = KEY_BYTES_COMPARATOR.compare(res1.getPrimaryKeyBytes(), res2.getPrimaryKeyBytes());
                    }
                    return itrDirection == Direction.FORWARD ? cmp : cmp * -1;
                }
            }
        };
    }
}

