/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordValue;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.util.CharTypes;

@Persistent(version=1)
public class MapValueImpl
extends ComplexValueImpl
implements MapValue {
    private static final long serialVersionUID = 1L;
    private final Map<String, FieldValue> fields;

    MapValueImpl(MapDef def) {
        super(def);
        this.fields = new TreeMap<String, FieldValue>();
    }

    private MapValueImpl() {
        super(null);
        this.fields = null;
    }

    @Override
    public MapValueImpl clone() {
        MapValueImpl map = new MapValueImpl(this.getDefinition());
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            map.put(entry.getKey(), entry.getValue().clone());
        }
        return map;
    }

    public int hashCode() {
        int code = this.size();
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            code += entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        return code;
    }

    public boolean equals(Object other) {
        if (other instanceof MapValueImpl) {
            MapValueImpl otherValue = (MapValueImpl)other;
            if (this == otherValue) {
                return true;
            }
            if (this.size() == otherValue.size() && this.getElementDef().equals(otherValue.getElementDef()) && this.getDefinition().equals(otherValue.getDefinition())) {
                for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
                    if (entry.getValue().equals(otherValue.get(entry.getKey()))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof MapValueImpl) {
            MapValueImpl otherImpl = (MapValueImpl)other;
            if (!this.getDefinition().equals(otherImpl.getDefinition())) {
                throw new IllegalArgumentException("Cannot compare MapValues with different definitions");
            }
            assert (this.fields instanceof TreeMap);
            assert (otherImpl.fields instanceof TreeMap);
            Iterator<String> keyIter = this.fields.keySet().iterator();
            Iterator<String> otherIter = otherImpl.fields.keySet().iterator();
            while (keyIter.hasNext() && otherIter.hasNext()) {
                FieldValue otherVal;
                String otherKey;
                String key = keyIter.next();
                int keyCompare = key.compareTo(otherKey = otherIter.next());
                if (keyCompare != 0) {
                    return keyCompare;
                }
                FieldValue val = this.fields.get(key);
                int valCompare = val.compareTo(otherVal = otherImpl.fields.get(key));
                if (valCompare == 0) continue;
                return valCompare;
            }
            if (keyIter.hasNext()) {
                return 1;
            }
            if (otherIter.hasNext()) {
                return -1;
            }
            return 0;
        }
        throw new ClassCastException("Object is not a MapValue");
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.MAP;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public MapValue asMap() {
        return this;
    }

    @Override
    public MapDefImpl getDefinition() {
        return (MapDefImpl)this.fieldDef;
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public Map<String, FieldValue> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    public FieldValue remove(String fieldName) {
        return this.fields.remove(fieldName);
    }

    @Override
    public FieldValueImpl get(String fieldName) {
        return (FieldValueImpl)this.fields.get(fieldName);
    }

    @Override
    public MapValue put(String name, int value) {
        this.putScalar(name, this.getElementDef().createInteger(value));
        return this;
    }

    @Override
    public MapValue put(String name, long value) {
        this.putScalar(name, this.getElementDef().createLong(value));
        return this;
    }

    @Override
    public MapValue put(String name, String value) {
        this.putScalar(name, this.getElementDef().createString(value));
        return this;
    }

    @Override
    public MapValue put(String name, double value) {
        this.putScalar(name, this.getElementDef().createDouble(value));
        return this;
    }

    @Override
    public MapValue put(String name, float value) {
        this.putScalar(name, this.getElementDef().createFloat(value));
        return this;
    }

    @Override
    public MapValue putNumber(String name, int value) {
        this.putScalar(name, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public MapValue putNumber(String name, long value) {
        this.putScalar(name, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public MapValue putNumber(String name, float value) {
        this.putScalar(name, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public MapValue putNumber(String name, double value) {
        this.putScalar(name, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public MapValue putNumber(String name, BigDecimal value) {
        this.putScalar(name, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public MapValue put(String name, boolean value) {
        this.putScalar(name, this.getElementDef().createBoolean(value));
        return this;
    }

    @Override
    public MapValue put(String name, byte[] value) {
        this.putScalar(name, this.getElementDef().createBinary(value));
        return this;
    }

    @Override
    public MapValue putJsonNull(String name) {
        if (!this.getElementDef().isJson()) {
            throw new IllegalArgumentException("Cannot insert a JSON null into a non-JSON map");
        }
        this.fields.put(name, NullJsonValueImpl.getInstance());
        return this;
    }

    MapValue putNull(String name) {
        this.fields.put(name, NullValueImpl.getInstance());
        return this;
    }

    @Override
    public MapValue putFixed(String name, byte[] value) {
        this.putScalar(name, this.getElementDef().createFixedBinary(value));
        return this;
    }

    @Override
    public MapValue putEnum(String name, String value) {
        this.putScalar(name, this.getElementDef().createEnum(value));
        return this;
    }

    @Override
    public MapValue put(String name, Timestamp value) {
        this.putScalar(name, this.getElementDef().createTimestamp(value));
        return this;
    }

    @Override
    public MapValue put(String fieldName, FieldValue value) {
        value = this.validate(value, this.getElementDef());
        this.fields.put(fieldName, value);
        return this;
    }

    @Override
    public RecordValueImpl putRecord(String fieldName) {
        RecordValue val = this.getElementDef().createRecord();
        this.fields.put(fieldName, val);
        return (RecordValueImpl)val;
    }

    @Override
    public MapValueImpl putMap(String fieldName) {
        MapValue val = this.getElementDef().createMap();
        this.fields.put(fieldName, val);
        return (MapValueImpl)val;
    }

    @Override
    public ArrayValueImpl putArray(String fieldName) {
        ArrayValue val = this.getElementDef().createArray();
        this.fields.put(fieldName, val);
        return (ArrayValueImpl)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapValue putJson(String fieldName, String jsonInput) {
        StringReader reader = new StringReader(jsonInput);
        try {
            MapValue mapValue = this.putJson(fieldName, reader);
            return mapValue;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public MapValue putJson(String fieldName, Reader jsonReader) {
        this.put(fieldName, JsonDefImpl.createFromReader(jsonReader));
        return this;
    }

    @Override
    public Map<String, FieldValue> getMap() {
        return this.fields;
    }

    @Override
    public void addJsonFields(JsonParser jp, String currentFieldName, boolean exact, boolean addMissingFields) {
        try {
            FieldDefImpl element = this.getElementDef();
            JsonToken t = jp.getCurrentToken();
            JsonLocation location = jp.getCurrentLocation();
            if (t != JsonToken.START_OBJECT) {
                MapValueImpl.jsonParseException("Expected { token to start map, instead found " + (Object)((Object)t), location);
            }
            while ((t = jp.nextToken()) != JsonToken.END_OBJECT) {
                if (t == null || t == JsonToken.END_ARRAY) {
                    MapValueImpl.jsonParseException("Did not find end of object", location);
                }
                String fieldname = jp.getCurrentName();
                JsonToken token = jp.nextToken();
                if (token == JsonToken.VALUE_NULL && !element.isJson()) {
                    throw new IllegalArgumentException("Invalid null value in JSON input for field " + fieldname);
                }
                switch (element.getType()) {
                    case INTEGER: {
                        MapValueImpl.checkNumberType(fieldname, JsonParser.NumberType.INT, jp);
                        this.put(fieldname, jp.getIntValue());
                        break;
                    }
                    case LONG: {
                        MapValueImpl.checkNumberType(fieldname, JsonParser.NumberType.LONG, jp);
                        this.put(fieldname, jp.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        MapValueImpl.checkNumberType(fieldname, JsonParser.NumberType.DOUBLE, jp);
                        this.put(fieldname, jp.getDoubleValue());
                        break;
                    }
                    case FLOAT: {
                        MapValueImpl.checkNumberType(fieldname, JsonParser.NumberType.FLOAT, jp);
                        this.put(fieldname, jp.getFloatValue());
                        break;
                    }
                    case NUMBER: {
                        MapValueImpl.checkNumberType(fieldname, JsonParser.NumberType.BIG_DECIMAL, jp);
                        this.putNumber(fieldname, TableJsonUtils.jsonParserGetDecimalValue(jp));
                        break;
                    }
                    case STRING: {
                        this.put(fieldname, jp.getText());
                        break;
                    }
                    case BINARY: {
                        this.put(fieldname, jp.getBinaryValue());
                        break;
                    }
                    case FIXED_BINARY: {
                        this.putFixed(fieldname, jp.getBinaryValue());
                        break;
                    }
                    case BOOLEAN: {
                        this.put(fieldname, jp.getBooleanValue());
                        break;
                    }
                    case TIMESTAMP: {
                        this.put(fieldname, element.asTimestamp().fromString(jp.getText()));
                        break;
                    }
                    case ARRAY: {
                        ArrayValueImpl array = this.putArray(fieldname);
                        array.addJsonFields(jp, null, exact, addMissingFields);
                        break;
                    }
                    case MAP: {
                        MapValueImpl map = this.putMap(fieldname);
                        map.addJsonFields(jp, null, exact, addMissingFields);
                        break;
                    }
                    case RECORD: {
                        RecordValueImpl record = this.putRecord(fieldname);
                        record.addJsonFields(jp, null, exact, addMissingFields);
                        break;
                    }
                    case ENUM: {
                        this.putEnum(fieldname, jp.getText());
                        break;
                    }
                    case JSON: 
                    case ANY_JSON_ATOMIC: {
                        this.put(fieldname, JsonDefImpl.createFromJson(jp, false));
                        break;
                    }
                    case ANY: {
                        throw new IllegalArgumentException("MAP(ANY) not suported yet");
                    }
                    case ANY_ATOMIC: {
                        throw new IllegalArgumentException("MAP(ANY_ATOMIC) not suported yet");
                    }
                    case ANY_RECORD: {
                        throw new IllegalStateException("A map type cannot have ANY_RECORD as its element type");
                    }
                    case EMPTY: {
                        throw new IllegalStateException("A map type cannot have EMPTY as its element type");
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        catch (RuntimeException re) {
            if (re instanceof IllegalArgumentException) {
                throw re;
            }
            throw new IllegalArgumentException("Failed to parse JSON input: " + re.toString(), re);
        }
    }

    @Override
    public FieldValueImpl getFieldValue(String fieldName) {
        return (FieldValueImpl)this.fields.get(fieldName);
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            node.put(entry.getKey(), ((FieldValueImpl)entry.getValue()).toJsonNode());
        }
        return node;
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append('{');
        int i = 0;
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            String key = entry.getKey();
            FieldValueImpl val = (FieldValueImpl)entry.getValue();
            if (val == null) continue;
            if (i > 0) {
                sb.append(',');
            }
            sb.append('\"');
            CharTypes.appendQuoted(sb, key);
            sb.append('\"');
            sb.append(':');
            val.toStringBuilder(sb);
            ++i;
        }
        sb.append('}');
    }

    static MapValueImpl fromJavaObjectValue(FieldDef def, Object o) {
        Map javaMap = (Map)o;
        MapValue map = def.createMap();
        for (Map.Entry entry : javaMap.entrySet()) {
            String key = ((String)entry.getKey()).toString();
            map.put(key, FieldValueImpl.fromJavaObjectValue(map.getDefinition().getElement(), entry.getValue()));
        }
        return (MapValueImpl)map;
    }

    void clearMap() {
        this.fields.clear();
    }

    private MapValueImpl putScalar(String fieldName, FieldValue value) {
        if (this.getDefinition().getType() != value.getType()) {
            value = this.validate(value, this.getElementDef());
        }
        this.fields.put(fieldName, value);
        return this;
    }

    FieldDefImpl getElementDef() {
        return this.getDefinition().getElement();
    }

    public Map<String, FieldValue> getFieldsInternal() {
        return this.fields;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    MapValue putEnum(String name, int index) {
        this.fields.put(name, ((EnumDefImpl)this.getElementDef()).createEnum(index));
        return this;
    }
}

