/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordDef;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TimeToLive;

public class RowImpl
extends RecordValueImpl
implements Row {
    private static final long serialVersionUID = 1L;
    protected final TableImpl table;
    private Version version;
    private int tableVersion;
    private long expirationTime;
    private TimeToLive ttl;

    public RowImpl() {
        this.table = null;
    }

    RowImpl(RecordDef field, TableImpl table) {
        super(field);
        assert (field != null && table != null);
        this.table = table;
        this.version = null;
        this.tableVersion = 0;
        this.expirationTime = -1L;
    }

    RowImpl(RowImpl other) {
        super(other);
        this.table = other.table;
        this.version = other.version;
        this.tableVersion = other.tableVersion;
        this.expirationTime = other.expirationTime;
        this.ttl = other.ttl;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public boolean isRow() {
        return true;
    }

    @Override
    public Row asRow() {
        return this;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public int getTableVersion() {
        return this.tableVersion;
    }

    void setTableVersion(int tableVersion) {
        this.tableVersion = tableVersion;
    }

    void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public RowImpl clone() {
        return new RowImpl(this);
    }

    @Override
    public PrimaryKey createPrimaryKey() {
        return this.getTableImpl().createPrimaryKey(this);
    }

    public int getDataSize() {
        return this.table.getDataSize(this);
    }

    public int getKeySize() {
        return this.table.getKeySize(this);
    }

    public Key getPrimaryKey(boolean allowPartial) {
        return this.table.createKey(this, allowPartial);
    }

    public TableImpl getTableImpl() {
        return this.table;
    }

    public boolean rowFromValueVersion(ValueVersion vv, boolean keyOnly) {
        if (keyOnly) {
            this.removeValueFields();
        }
        return this.table.rowFromValueVersion(vv, this);
    }

    void copyKeyFields(RowImpl row) {
        for (String keyField : this.table.getPrimaryKeyInternal()) {
            FieldValueImpl val = row.get(keyField);
            if (val == null) continue;
            this.put(keyField, (FieldValue)val);
        }
    }

    public Value createValue() {
        return this.table.createValue(this);
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof RowImpl) {
            RowImpl otherImpl = (RowImpl)other;
            if (this.table.getId() == otherImpl.table.getId()) {
                return super.compareTo(otherImpl);
            }
            return RowImpl.compare(this.table.getId(), otherImpl.table.getId());
        }
        throw new IllegalArgumentException("Cannot compare Row to another type");
    }

    private static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof RowImpl) {
            return this.table.nameEquals(((RowImpl)other).table);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.table.getFullName().hashCode();
    }

    @Override
    public void setTTL(TimeToLive ttl) {
        if (ttl != null && ttl.getValue() < 0L) {
            throw new IllegalArgumentException("Row.setTTL() does not support negative time periods");
        }
        this.ttl = ttl;
    }

    @Override
    public TimeToLive getTTL() {
        return this.ttl;
    }

    @Override
    public long getExpirationTime() {
        if (this.expirationTime >= 0L) {
            return this.expirationTime;
        }
        throw new IllegalStateException("Row expiration time is not defined for this instance");
    }

    void setExpirationTime(long t) {
        this.expirationTime = t;
    }

    TimeToLive getTTLAndClearExpiration() {
        TimeToLive retVal = this.ttl;
        this.expirationTime = -1L;
        return retVal;
    }

    private void removeValueFields() {
        if (this.table.hasValueFields()) {
            for (int i = 0; i < this.getNumFields(); ++i) {
                if (this.table.isPrimKeyAtPos(i)) continue;
                this.removeInternal(i);
            }
        }
    }

    @Override
    protected String getClassNameForError() {
        return "Row";
    }
}

