/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprReceive;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.ExprVisitor;
import oracle.kv.impl.query.compiler.ExprWalker;
import oracle.kv.impl.query.compiler.FuncArithOp;
import oracle.kv.impl.query.compiler.QueryControlBlock;

class Distributer
extends ExprVisitor {
    QueryControlBlock theQCB;
    private final ExprWalker theWalker;

    Distributer(QueryControlBlock qcb) {
        this.theQCB = qcb;
        this.theWalker = new ExprWalker(this, false);
    }

    void distributeQuery() {
        this.theWalker.walk(this.theQCB.getRootExpr());
    }

    @Override
    void exit(ExprBaseTable e) {
        ExprReceive recv = new ExprReceive(this.theQCB, this.theQCB.getInitSctx());
        e.replace(recv, false);
        recv.setInput(e, false);
        recv.setEliminateIndexDups(e.getEliminateIndexDups());
    }

    @Override
    boolean enter(ExprSFW sfw) {
        boolean isSinglePartition;
        this.theWalker.walk(sfw.getDomainExpr(0));
        if (sfw.getDomainExpr(0).getKind() != Expr.ExprKind.RECEIVE) {
            return false;
        }
        ExprReceive rcv = (ExprReceive)sfw.getDomainExpr(0);
        sfw.setDomainExpr(0, rcv.getInput(), false);
        sfw.replace(rcv, false);
        rcv.setInput(sfw, false);
        Expr offset = sfw.getOffset();
        Expr limit = sfw.getLimit();
        boolean hasSort = sfw.getNumSortExprs() != 0;
        boolean hasOffset = offset != null;
        boolean hasLimit = limit != null;
        boolean eliminateIndexDups = rcv.getEliminateIndexDups();
        boolean bl = isSinglePartition = rcv.getDistributionKind() == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION;
        if (sfw.getNumVars() > 1) {
            eliminateIndexDups = false;
            rcv.setEliminateIndexDups(false);
        }
        if (isSinglePartition) {
            return false;
        }
        if (!(hasSort || eliminateIndexDups || hasOffset || hasLimit)) {
            return false;
        }
        int numFields = sfw.getNumFields();
        if (hasSort) {
            int[] sortExprPositions = sfw.addSortExprsToSelect();
            rcv.addSort(sortExprPositions, sfw.getSortSpecs());
            sfw.setDoNullOnEmpty(false);
        }
        if (eliminateIndexDups) {
            int[] primKeyPositions = sfw.addPrimKeyToSelect();
            rcv.addPrimKeyPositions(primKeyPositions);
        }
        if (numFields == sfw.getNumFields() && !hasOffset && !hasLimit) {
            return false;
        }
        ExprSFW clientSFW = new ExprSFW(this.theQCB, sfw.getSctx(), sfw.getLocation());
        rcv.replace(clientSFW, false);
        ExprSFW.FromClause fc = clientSFW.addFromClause(rcv, this.theQCB.createInternalVarName("from"));
        ExprVar fromVar = fc.getVar();
        ArrayList<Expr> fieldExprs = new ArrayList<Expr>(numFields);
        ArrayList<String> fieldNames = new ArrayList<String>(numFields);
        if (sfw.getConstructsSelectRecord()) {
            for (int i = 0; i < numFields; ++i) {
                ExprFieldStep fieldExpr = new ExprFieldStep(this.theQCB, sfw.getSctx(), sfw.getFieldExpr(i).getLocation(), fromVar, sfw.getFieldName(i));
                fieldExprs.add(fieldExpr);
                fieldNames.add(sfw.getFieldName(i));
            }
        } else {
            fieldExprs.add(fromVar);
            fieldNames.add(sfw.getFieldName(0));
        }
        clientSFW.addSelectClause(fieldNames, fieldExprs, sfw.hasSelectASclauses());
        if (hasOffset || hasLimit) {
            if (hasLimit && hasOffset) {
                sfw.removeOffset(false);
                Expr newLimit = FuncArithOp.createArithExpr(offset, limit, "+");
                sfw.setLimit(newLimit, false);
            } else if (hasOffset) {
                sfw.removeOffset(false);
            }
            clientSFW.addOffsetLimit(offset, limit);
        }
        return false;
    }
}

