/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprCase;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprIsOfType;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprReceive;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.IndexExpr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;

public abstract class Expr {
    private static int FILTERING_PRED = 1;
    final QueryControlBlock theQCB;
    final StaticContext theSctx;
    final ExprKind theKind;
    final ArrayList<Expr> theParents = new ArrayList(1);
    private final ExprIter theChildren;
    QueryException.Location theLocation;
    ExprType theType = null;
    int theFlags;
    IndexExpr theIndexExpr = null;
    boolean theIsIndexExprComputed;

    public Expr(QueryControlBlock qcb, StaticContext sctx, ExprKind kind, QueryException.Location location) {
        this.theQCB = qcb;
        this.theSctx = sctx;
        this.theKind = kind;
        this.theChildren = new ExprIter(this, false);
        this.theLocation = location;
    }

    public final QueryControlBlock getQCB() {
        return this.theQCB;
    }

    public final StaticContext getSctx() {
        return this.theSctx;
    }

    final ExprKind getKind() {
        return this.theKind;
    }

    IndexExpr getIndexExpr() {
        if (!this.theIsIndexExprComputed) {
            this.theIsIndexExprComputed = true;
            this.theIndexExpr = IndexExpr.create(this);
        }
        return this.theIndexExpr;
    }

    final void setType(ExprType t) {
        this.theType = t;
    }

    final ExprType getTypeInternal() {
        return this.theType;
    }

    public final ExprType getType() {
        if (this.theType != null) {
            return this.theType;
        }
        this.computeType(false);
        return this.theType;
    }

    final boolean isScalar() {
        return this.getType().getQuantifier() == ExprType.Quantifier.ONE;
    }

    final boolean isMultiValued() {
        ExprType.Quantifier q = this.getType().getQuantifier();
        return q == ExprType.Quantifier.STAR || q == ExprType.Quantifier.PLUS;
    }

    final boolean computeType(boolean deep) {
        ExprType newType;
        boolean modified = false;
        if (deep) {
            ExprIter iter = new ExprIter(this);
            while (iter.hasNext()) {
                modified |= iter.next().computeType(deep);
            }
        }
        if (!(newType = this.computeType()).equals(this.theType)) {
            modified = true;
            this.theType = newType;
        }
        return modified;
    }

    abstract ExprType computeType();

    abstract boolean mayReturnNULL();

    final boolean hasParents() {
        return !this.theParents.isEmpty();
    }

    final int getNumParents() {
        return this.theParents.size();
    }

    final Expr getParent(int idx) {
        return this.theParents.get(idx);
    }

    final void addParent(Expr parent) {
        assert (parent != null);
        this.theParents.add(parent);
    }

    final void removeParent(Expr parent, boolean destroy) {
        if (parent != null) {
            boolean found = this.theParents.remove(parent);
            assert (found);
        }
        if (destroy && !this.hasParents()) {
            ExprIter children = this.getChildren();
            while (children.hasNext()) {
                Expr child = (Expr)children.next();
                child.removeParent(this, destroy);
            }
        }
    }

    final void removeChild(Expr child, boolean destroy) {
        ExprIter children = this.getChildren();
        while (children.hasNext()) {
            Expr currChild = children.next();
            if (currChild != child) continue;
            children.remove(destroy);
            children.reset();
            break;
        }
    }

    final void replaceChild(Expr child, Expr newChild, boolean destroy) {
        ExprIter children = this.getChildren();
        while (children.hasNext()) {
            Expr currChild = children.next();
            if (currChild != child) continue;
            children.replace(newChild, destroy);
            children.reset();
            break;
        }
    }

    final void replace(Expr other, boolean destroy) {
        block5: {
            block4: {
                if (this != this.theQCB.getRootExpr()) break block4;
                this.theQCB.setRootExpr(other);
                assert (!this.hasParents());
                if (!destroy) break block5;
                ExprIter children = this.getChildren();
                while (children.hasNext()) {
                    Expr child = (Expr)children.next();
                    child.removeParent(this, true);
                }
                break block5;
            }
            while (this.getNumParents() > 0) {
                assert (this.getParent(0) != other);
                this.getParent(0).replaceChild(this, other, destroy);
            }
        }
    }

    abstract int getNumChildren();

    public final ExprIter getChildren() {
        if (this.theChildren.isOpen()) {
            throw new QueryStateException("Attempt to reuse an already open ExprIter");
        }
        this.theChildren.reset();
        return this.theChildren;
    }

    public final ExprIter getChildrenIter() {
        ExprIter iter = new ExprIter(this);
        return iter;
    }

    Expr getInput() {
        throw new ClassCastException("Expression does not have a single input: " + this.getClass());
    }

    void setFilteringPredFlag() {
        this.theFlags |= FILTERING_PRED;
    }

    void clearFilteringPredFlag() {
        this.theFlags &= ~FILTERING_PRED;
    }

    boolean getFilteringPredFlag() {
        return (this.theFlags & FILTERING_PRED) != 0;
    }

    final Function getFunction(FunctionLib.FuncCode fcode) {
        if (this.getKind() != ExprKind.FUNC_CALL) {
            return null;
        }
        Function func = ((ExprFuncCall)this).getFunction();
        if (fcode == null || fcode.equals((Object)func.getCode())) {
            return func;
        }
        return null;
    }

    final boolean isStepExpr() {
        return this.theKind == ExprKind.ARRAY_FILTER || this.theKind == ExprKind.ARRAY_SLICE || this.theKind == ExprKind.MAP_FILTER || this.theKind == ExprKind.FIELD_STEP;
    }

    boolean isConstant() {
        if (this.getKind() == ExprKind.CONST) {
            return true;
        }
        if (this.getKind() == ExprKind.VAR) {
            return ((ExprVar)this).isExternal();
        }
        if (this.getKind() == ExprKind.BASE_TABLE) {
            return false;
        }
        ExprIter children = this.getChildren();
        while (children.hasNext()) {
            Expr child = children.next();
            if (child.isConstant()) continue;
            children.reset();
            return false;
        }
        return true;
    }

    public final String display() {
        StringBuilder sb = new StringBuilder();
        this.display(sb, new QueryFormatter());
        return sb.toString();
    }

    public final QueryException.Location getLocation() {
        return this.theLocation;
    }

    final void setLocation(QueryException.Location loc) {
        this.theLocation = loc;
    }

    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append((Object)this.theKind).append("\n");
        formatter.indent(sb);
        sb.append("[\n");
        formatter.incIndent();
        this.displayContent(sb, formatter);
        formatter.decIndent();
        sb.append("\n");
        formatter.indent(sb);
        sb.append("]");
    }

    abstract void displayContent(StringBuilder var1, QueryFormatter var2);

    static class ExprIter
    implements Iterator<Expr> {
        Expr theExpr;
        int theNumChildren = 0;
        int theCurrentChild = -1;
        boolean theHasNext = false;

        ExprIter(Expr e) {
            this(e, true);
        }

        ExprIter(Expr e, boolean reset) {
            this.theExpr = e;
            if (reset) {
                this.reset();
            }
        }

        public void reset() {
            this.theNumChildren = this.theExpr.getNumChildren();
            this.theCurrentChild = -1;
            this.theHasNext = this.theNumChildren > 0;
        }

        public boolean isOpen() {
            return this.theCurrentChild != -1 && this.theHasNext;
        }

        @Override
        public boolean hasNext() {
            return this.theHasNext;
        }

        @Override
        public Expr next() {
            if (!this.theHasNext) {
                return null;
            }
            ++this.theCurrentChild;
            if (this.theCurrentChild == this.theNumChildren - 1) {
                this.theHasNext = false;
            }
            switch (this.theExpr.getKind()) {
                case SFW: {
                    ExprSFW sfw = (ExprSFW)this.theExpr;
                    assert (this.theNumChildren == sfw.computeNumChildren());
                    int currentChild = this.theCurrentChild;
                    if (currentChild < sfw.getNumVars()) {
                        return sfw.getDomainExpr(currentChild);
                    }
                    currentChild -= sfw.getNumVars();
                    if (sfw.getWhereExpr() != null) {
                        if (currentChild == 0) {
                            return sfw.getWhereExpr();
                        }
                        --currentChild;
                    }
                    if (currentChild < sfw.getNumSortExprs()) {
                        return sfw.getSortExpr(currentChild);
                    }
                    if ((currentChild -= sfw.getNumSortExprs()) < sfw.getNumFields()) {
                        return sfw.getFieldExpr(currentChild);
                    }
                    currentChild -= sfw.getNumFields();
                    if (sfw.getOffset() != null) {
                        if (currentChild == 0) {
                            return sfw.getOffset();
                        }
                        --currentChild;
                    }
                    assert (currentChild == 0);
                    assert (sfw.getLimit() != null);
                    assert (!this.theHasNext);
                    return sfw.getLimit();
                }
                case FIELD_STEP: {
                    ExprFieldStep step = (ExprFieldStep)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        return step.getInput();
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getFieldNameExpr() != null);
                    return step.getFieldNameExpr();
                }
                case MAP_FILTER: {
                    ExprMapFilter step = (ExprMapFilter)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        return step.getInput();
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getPredExpr() != null);
                    return step.getPredExpr();
                }
                case ARRAY_FILTER: {
                    ExprArrayFilter step = (ExprArrayFilter)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        return step.getInput();
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getPredExpr() != null);
                    return step.getPredExpr();
                }
                case ARRAY_SLICE: {
                    ExprArraySlice step = (ExprArraySlice)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        return step.getInput();
                    }
                    if (this.theCurrentChild == 1) {
                        if (step.getLowExpr() != null) {
                            return step.getLowExpr();
                        }
                        assert (step.getHighExpr() != null);
                        return step.getHighExpr();
                    }
                    assert (this.theCurrentChild == 2);
                    assert (step.getHighExpr() != null);
                    return step.getHighExpr();
                }
                case CASE: {
                    ExprCase caseExpr = (ExprCase)this.theExpr;
                    return caseExpr.getExpr(this.theCurrentChild);
                }
                case FUNC_CALL: {
                    return ((ExprFuncCall)this.theExpr).getArg(this.theCurrentChild);
                }
                case ARRAY_CONSTR: {
                    return ((ExprArrayConstr)this.theExpr).getArg(this.theCurrentChild);
                }
                case MAP_CONSTR: {
                    return ((ExprMapConstr)this.theExpr).getArg(this.theCurrentChild);
                }
                case PROMOTE: 
                case RECEIVE: 
                case IS_OF_TYPE: 
                case CAST: {
                    assert (this.theCurrentChild == 0);
                    return this.theExpr.getInput();
                }
                case BASE_TABLE: {
                    ExprBaseTable tableExpr = (ExprBaseTable)this.theExpr;
                    assert (this.theCurrentChild == 0);
                    assert (tableExpr.getFilteringPred() != null);
                    return tableExpr.getFilteringPred();
                }
            }
            throw new QueryStateException("Unexpected expression kind: " + (Object)((Object)this.theExpr.getKind()));
        }

        @Override
        public void remove() {
            this.remove(true);
        }

        void remove(boolean destroy) {
            switch (this.theExpr.getKind()) {
                case SFW: {
                    ExprSFW sfw = (ExprSFW)this.theExpr;
                    int currentChild = this.theCurrentChild--;
                    if (currentChild == 0) {
                        throw new QueryStateException("Cannot remove table from FROM clause");
                    }
                    if (currentChild < sfw.getNumVars()) {
                        sfw.removeFromClause(currentChild, destroy);
                        --this.theNumChildren;
                        break;
                    }
                    currentChild -= sfw.getNumVars();
                    if (sfw.getWhereExpr() != null) {
                        if (currentChild == 0) {
                            sfw.removeWhereExpr(destroy);
                            --this.theNumChildren;
                            --this.theCurrentChild;
                            break;
                        }
                        --currentChild;
                    }
                    if (currentChild < sfw.getNumSortExprs()) {
                        sfw.removeSortExpr(currentChild, destroy);
                        --this.theNumChildren;
                        --this.theCurrentChild;
                        break;
                    }
                    if ((currentChild -= sfw.getNumSortExprs()) < sfw.getNumFields()) {
                        sfw.removeField(currentChild, destroy);
                        --this.theNumChildren;
                        --this.theCurrentChild;
                        break;
                    }
                    currentChild -= sfw.getNumFields();
                    if (sfw.getOffset() != null) {
                        if (currentChild == 0) {
                            sfw.removeOffset(destroy);
                            --this.theNumChildren;
                            --this.theCurrentChild;
                            break;
                        }
                        --currentChild;
                    }
                    assert (currentChild == 0);
                    if (sfw.getLimit() == null) break;
                    sfw.removeLimit(destroy);
                    --this.theNumChildren;
                    --this.theCurrentChild;
                    break;
                }
                case FIELD_STEP: {
                    ExprFieldStep step = (ExprFieldStep)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        throw new QueryStateException("Cannot remove input expr from field step");
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getFieldNameExpr() != null);
                    throw new QueryStateException("Cannot remove name expr from field step");
                }
                case MAP_FILTER: {
                    ExprMapFilter step = (ExprMapFilter)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        throw new QueryStateException("Cannot remove input expr from map filter step");
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getPredExpr() != null);
                    throw new QueryStateException("Cannot remove predicate expr from map filter step");
                }
                case ARRAY_FILTER: {
                    ExprArrayFilter step = (ExprArrayFilter)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        throw new QueryStateException("Cannot remove input expr from array filter step");
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getPredExpr() != null);
                    throw new QueryStateException("Cannot remove predicate expr from array filter step");
                }
                case ARRAY_SLICE: {
                    ExprArraySlice step = (ExprArraySlice)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        throw new QueryStateException("Cannot remove input expr from slice step");
                    }
                    if (this.theCurrentChild == 1) {
                        if (step.getLowExpr() != null) {
                            step.removeLowExpr(destroy);
                            --this.theNumChildren;
                            --this.theCurrentChild;
                            break;
                        }
                        assert (step.getHighExpr() != null);
                        step.removeHighExpr(destroy);
                        --this.theNumChildren;
                        --this.theCurrentChild;
                        break;
                    }
                    assert (this.theCurrentChild == 2);
                    assert (step.getHighExpr() != null);
                    step.removeHighExpr(destroy);
                    --this.theNumChildren;
                    --this.theCurrentChild;
                    break;
                }
                case CASE: {
                    ExprCase caseExpr = (ExprCase)this.theExpr;
                    if (this.theCurrentChild % 2 != 0) {
                        throw new QueryStateException("Cannot remove a THEN expr from a CASE expr");
                    }
                    if (this.theCurrentChild == caseExpr.getNumChildren() - 1) {
                        assert (caseExpr.hasElseClause());
                        caseExpr.removeElseClause(destroy);
                        break;
                    }
                    caseExpr.removeWhenClause(this.theCurrentChild / 2, destroy);
                    break;
                }
                case FUNC_CALL: {
                    ((ExprFuncCall)this.theExpr).removeArg(this.theCurrentChild, destroy);
                    --this.theNumChildren;
                    --this.theCurrentChild;
                    break;
                }
                case ARRAY_CONSTR: {
                    ((ExprArrayConstr)this.theExpr).removeArg(this.theCurrentChild, destroy);
                    --this.theNumChildren;
                    --this.theCurrentChild;
                    break;
                }
                case MAP_CONSTR: {
                    ((ExprMapConstr)this.theExpr).removeArg(this.theCurrentChild, destroy);
                    --this.theNumChildren;
                    --this.theCurrentChild;
                    break;
                }
                case PROMOTE: {
                    assert (this.theCurrentChild == 0);
                    throw new QueryStateException("Cannot remove input expr from promote expr");
                }
                case IS_OF_TYPE: {
                    assert (this.theCurrentChild == 0);
                    throw new QueryStateException("Cannot remove input expr from is_of_type expr");
                }
                case CAST: {
                    assert (this.theCurrentChild == 0);
                    throw new QueryStateException("Cannot remove input expr from cast expr");
                }
                case RECEIVE: {
                    assert (this.theCurrentChild == 0);
                    throw new QueryStateException("Cannot remove input expr from receive expr");
                }
                case BASE_TABLE: {
                    assert (this.theCurrentChild == 0);
                    ((ExprBaseTable)this.theExpr).removeFilteringPred(destroy);
                    --this.theNumChildren;
                    --this.theCurrentChild;
                    break;
                }
                default: {
                    throw new QueryStateException("Unexpected expression kind: " + (Object)((Object)this.theExpr.getKind()));
                }
            }
            if (this.theCurrentChild >= this.theNumChildren) {
                this.theHasNext = false;
            }
        }

        void replace(Expr newChild, boolean destroy) {
            switch (this.theExpr.getKind()) {
                case SFW: {
                    ExprSFW sfw = (ExprSFW)this.theExpr;
                    int currentChild = this.theCurrentChild;
                    if (currentChild < sfw.getNumVars()) {
                        sfw.setDomainExpr(currentChild, newChild, destroy);
                        break;
                    }
                    currentChild -= sfw.getNumVars();
                    if (sfw.getWhereExpr() != null) {
                        if (currentChild == 0) {
                            sfw.setWhereExpr(newChild, destroy);
                            break;
                        }
                        --currentChild;
                    }
                    if (currentChild < sfw.getNumSortExprs()) {
                        sfw.setSortExpr(currentChild, newChild, destroy);
                        break;
                    }
                    if ((currentChild -= sfw.getNumSortExprs()) < sfw.getNumFields()) {
                        sfw.setFieldExpr(currentChild, newChild, destroy);
                        break;
                    }
                    currentChild -= sfw.getNumFields();
                    if (sfw.getOffset() != null) {
                        if (currentChild == 0) {
                            sfw.setOffset(newChild, destroy);
                            break;
                        }
                        --currentChild;
                    }
                    assert (currentChild == 0);
                    if (sfw.getLimit() == null) break;
                    sfw.setLimit(newChild, destroy);
                    break;
                }
                case FIELD_STEP: {
                    ExprFieldStep step = (ExprFieldStep)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        step.setInput(newChild, destroy);
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getFieldNameExpr() != null);
                    step.setFieldNameExpr(newChild, destroy);
                    break;
                }
                case MAP_FILTER: {
                    ExprMapFilter step = (ExprMapFilter)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        step.setInput(newChild, destroy);
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getPredExpr() != null);
                    step.setPredExpr(newChild, destroy);
                    break;
                }
                case ARRAY_FILTER: {
                    ExprArrayFilter step = (ExprArrayFilter)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        step.setInput(newChild, destroy);
                    }
                    assert (this.theCurrentChild == 1);
                    assert (step.getPredExpr() != null);
                    step.setPredExpr(newChild, destroy);
                    break;
                }
                case ARRAY_SLICE: {
                    ExprArraySlice step = (ExprArraySlice)this.theExpr;
                    if (this.theCurrentChild == 0) {
                        step.setInput(newChild, destroy);
                        break;
                    }
                    if (this.theCurrentChild == 1) {
                        if (step.getLowExpr() != null) {
                            step.setLowExpr(newChild, destroy);
                            break;
                        }
                        assert (step.getHighExpr() != null);
                        step.setHighExpr(newChild, destroy);
                        break;
                    }
                    assert (this.theCurrentChild == 2);
                    assert (step.getHighExpr() != null);
                    step.setHighExpr(newChild, destroy);
                    break;
                }
                case CASE: {
                    ExprCase caseExpr = (ExprCase)this.theExpr;
                    caseExpr.setExpr(this.theCurrentChild, newChild, destroy);
                    break;
                }
                case FUNC_CALL: {
                    ((ExprFuncCall)this.theExpr).setArg(this.theCurrentChild, newChild, destroy);
                    break;
                }
                case ARRAY_CONSTR: {
                    ((ExprArrayConstr)this.theExpr).setArg(this.theCurrentChild, newChild, destroy);
                    break;
                }
                case MAP_CONSTR: {
                    ((ExprMapConstr)this.theExpr).setArg(this.theCurrentChild, newChild, destroy);
                    break;
                }
                case PROMOTE: {
                    assert (this.theCurrentChild == 0);
                    ((ExprPromote)this.theExpr).setInput(newChild, destroy);
                    break;
                }
                case IS_OF_TYPE: {
                    assert (this.theCurrentChild == 0);
                    ((ExprIsOfType)this.theExpr).setInput(newChild, destroy);
                    break;
                }
                case CAST: {
                    assert (this.theCurrentChild == 0);
                    ((ExprCast)this.theExpr).setInput(newChild, destroy);
                    break;
                }
                case RECEIVE: {
                    assert (this.theCurrentChild == 0);
                    ((ExprReceive)this.theExpr).setInput(newChild, destroy);
                    break;
                }
                case BASE_TABLE: {
                    assert (this.theCurrentChild == 0);
                    ((ExprBaseTable)this.theExpr).setFilteringPred(newChild, destroy);
                    break;
                }
                default: {
                    throw new QueryStateException("Unexpected expression kind: " + (Object)((Object)this.theExpr.getKind()));
                }
            }
        }
    }

    static enum ExprKind {
        CONST,
        BASE_TABLE,
        FUNC_CALL,
        PROMOTE,
        ARRAY_CONSTR,
        MAP_CONSTR,
        FIELD_STEP,
        MAP_FILTER,
        ARRAY_SLICE,
        ARRAY_FILTER,
        VAR,
        SFW,
        IS_OF_TYPE,
        CAST,
        RECEIVE,
        CASE;

    }
}

