/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;

class ExprReceive
extends Expr {
    private Expr theInput;
    private int[] theSortFieldPositions;
    private SortSpec[] theSortSpecs;
    private PreparedStatementImpl.DistributionKind theDistributionKind;
    private PrimaryKeyImpl thePrimaryKey;
    private ArrayList<Expr> thePushedExternals;
    private boolean theEliminateIndexDups;
    private int[] thePrimKeyPositions;

    ExprReceive(QueryControlBlock qcb, StaticContext sctx) {
        super(qcb, sctx, Expr.ExprKind.RECEIVE, null);
    }

    @Override
    int getNumChildren() {
        return 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        if (this.theInput != null) {
            this.theInput.removeParent(this, destroy);
        }
        this.theInput = newExpr;
        this.theInput.addParent(this);
        this.theType = this.computeType();
        this.computeDistributionKind();
        this.setLocation(newExpr.getLocation());
    }

    void computeDistributionKind() {
        if (this.theInput.getKind() != Expr.ExprKind.BASE_TABLE) {
            return;
        }
        ExprBaseTable tableExpr = (ExprBaseTable)this.theInput;
        this.thePrimaryKey = tableExpr.getPrimaryKey();
        IndexKeyImpl secKey = tableExpr.getSecondaryKey();
        if (secKey != null) {
            this.theDistributionKind = PreparedStatementImpl.DistributionKind.ALL_SHARDS;
        } else if (this.thePrimaryKey != null && this.thePrimaryKey.hasShardKey()) {
            this.theDistributionKind = PreparedStatementImpl.DistributionKind.SINGLE_PARTITION;
            if (tableExpr.getPushedExternals() != null) {
                this.thePushedExternals = new ArrayList<Expr>(tableExpr.getPushedExternals());
                if (this.thePushedExternals != null && tableExpr.getRange() != null) {
                    this.thePushedExternals.remove(this.thePushedExternals.size() - 1);
                    this.thePushedExternals.remove(this.thePushedExternals.size() - 1);
                }
            }
        } else {
            this.theDistributionKind = PreparedStatementImpl.DistributionKind.ALL_PARTITIONS;
        }
    }

    PreparedStatementImpl.DistributionKind getDistributionKind() {
        return this.theDistributionKind;
    }

    PrimaryKeyImpl getPrimaryKey() {
        return this.thePrimaryKey;
    }

    ArrayList<Expr> getPushedExternals() {
        return this.thePushedExternals;
    }

    void addSort(int[] sortExprPositions, SortSpec[] specs) {
        this.theSortFieldPositions = sortExprPositions;
        this.theSortSpecs = specs;
        this.theType = this.computeType();
    }

    int[] getSortFieldPositions() {
        return this.theSortFieldPositions;
    }

    SortSpec[] getSortSpecs() {
        return this.theSortSpecs;
    }

    void setEliminateIndexDups(boolean v) {
        this.theEliminateIndexDups = v;
    }

    boolean getEliminateIndexDups() {
        return this.theEliminateIndexDups;
    }

    void addPrimKeyPositions(int[] positions) {
        this.thePrimKeyPositions = positions;
        this.theType = this.computeType();
    }

    int[] getPrimKeyPositions() {
        return this.thePrimKeyPositions;
    }

    @Override
    ExprType computeType() {
        return this.theInput.getType();
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theInput.mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("DistributionKind : ").append((Object)this.theDistributionKind);
        sb.append(",\n");
        if (this.thePrimaryKey != null) {
            formatter.indent(sb);
            sb.append("PrimaryKey :").append(this.thePrimaryKey);
            sb.append(",\n");
        }
        if (this.theSortFieldPositions != null) {
            formatter.indent(sb);
            sb.append("Sort Field Positions : ").append(this.theSortFieldPositions);
            sb.append(",\n");
        }
        if (this.thePrimKeyPositions != null) {
            formatter.indent(sb);
            sb.append("Primary Key Positions : ");
            for (int i = 0; i < this.thePrimKeyPositions.length; ++i) {
                sb.append(this.thePrimKeyPositions[i]);
                if (i >= this.thePrimKeyPositions.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        formatter.indent(sb);
        this.theInput.display(sb, formatter);
    }
}

