/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprUtils;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.IndexExpr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.Index;

class ExprSFW
extends Expr {
    private int theNumChildren;
    private ArrayList<FromClause> theFromClauses = new ArrayList(8);
    private Expr theWhereExpr;
    private ArrayList<String> theFieldNames;
    private ArrayList<Expr> theFieldExprs;
    private boolean theHasSelectASclauses = true;
    private boolean theDoNullOnEmpty = true;
    private ArrayList<Expr> theSortExprs;
    private ArrayList<SortSpec> theSortSpecs;
    private boolean theUsePrimaryIndexForSort = false;
    private ArrayList<IndexImpl> theSortingIndexes = null;
    private Expr theOffsetExpr;
    private Expr theLimitExpr;

    ExprSFW(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location) {
        super(qcb, sctx, Expr.ExprKind.SFW, location);
    }

    FromClause addFromClause(Expr domainExpr, String varName) {
        FromClause fc = new FromClause(domainExpr, varName);
        this.theFromClauses.add(fc);
        ++this.theNumChildren;
        return fc;
    }

    void removeFromClause(int i, boolean destroy) {
        FromClause fc = this.theFromClauses.get(i);
        this.theFromClauses.remove(i);
        --this.theNumChildren;
        fc.getDomainExpr().removeParent(this, destroy);
        assert (!fc.getVar().hasParents());
    }

    FromClause getFromClause(int i) {
        return this.theFromClauses.get(i);
    }

    int getNumVars() {
        return this.theFromClauses.size();
    }

    ExprVar getVar(int i) {
        return this.theFromClauses.get(i).getVar();
    }

    Expr getDomainExpr(int i) {
        return this.theFromClauses.get(i).getDomainExpr();
    }

    void setDomainExpr(int i, Expr newExpr, boolean destroy) {
        FromClause fc = this.theFromClauses.get(i);
        fc.theDomainExpr.removeParent(this, destroy);
        fc.theDomainExpr = newExpr;
        newExpr.addParent(this);
    }

    ExprVar findVarForExpr(Expr expr) {
        int numVars = this.getNumVars();
        for (int i = 0; i < numVars; ++i) {
            if (this.getVar(i).getDomainExpr() != expr) continue;
            return this.getVar(i);
        }
        return null;
    }

    ExprVar getTableVar() {
        return this.theFromClauses.get(0).getVar();
    }

    TableImpl getTable() {
        assert (this.getDomainExpr(0).getKind() == Expr.ExprKind.BASE_TABLE);
        if (this.getDomainExpr(0).getKind() == Expr.ExprKind.BASE_TABLE) {
            ExprBaseTable tableExpr = (ExprBaseTable)this.getDomainExpr(0);
            return tableExpr.getTable();
        }
        return null;
    }

    ExprBaseTable getTableExpr() {
        assert (this.getDomainExpr(0).getKind() == Expr.ExprKind.BASE_TABLE);
        if (this.getDomainExpr(0).getKind() == Expr.ExprKind.BASE_TABLE) {
            return (ExprBaseTable)this.getDomainExpr(0);
        }
        return null;
    }

    void removeUnusedVars() {
        for (int i = this.theFromClauses.size() - 1; i >= 0; --i) {
            FromClause fc = this.theFromClauses.get(i);
            ExprVar var = fc.getVar();
            Expr domExpr = fc.getDomainExpr();
            if (var.getNumParents() != 0 || !domExpr.isScalar()) continue;
            this.removeFromClause(i, true);
        }
    }

    void addWhereClause(Expr condExpr) {
        assert (this.theWhereExpr == null);
        this.theWhereExpr = ExprPromote.create(null, condExpr, TypeManager.BOOLEAN_QSTN());
        this.theWhereExpr.addParent(this);
        ++this.theNumChildren;
    }

    Expr getWhereExpr() {
        return this.theWhereExpr;
    }

    void setWhereExpr(Expr newExpr, boolean destroy) {
        this.theWhereExpr.removeParent(this, destroy);
        this.theWhereExpr = null;
        this.addWhereClause(newExpr);
    }

    void removeWhereExpr(boolean destroy) {
        this.theWhereExpr.removeParent(this, destroy);
        this.theWhereExpr = null;
        --this.theNumChildren;
    }

    void addSelectClause(ArrayList<String> fieldNames, ArrayList<Expr> fieldExprs, boolean hasAS) {
        assert (fieldNames.size() == fieldExprs.size());
        this.theFieldNames = fieldNames;
        this.theFieldExprs = fieldExprs;
        this.theHasSelectASclauses = hasAS;
        for (int i = 0; i < fieldExprs.size(); ++i) {
            Expr expr = fieldExprs.get(i);
            if (expr.isMultiValued()) {
                ArrayList<Expr> args = new ArrayList<Expr>(1);
                args.add(expr);
                expr = new ExprArrayConstr(this.theQCB, this.theSctx, expr.getLocation(), args, true);
            }
            expr.addParent(this);
            this.theFieldExprs.set(i, expr);
        }
        this.theNumChildren += fieldExprs.size();
    }

    boolean getConstructsSelectRecord() {
        if (this.theFieldExprs.size() > 1) {
            return true;
        }
        return this.theHasSelectASclauses;
    }

    boolean hasSelectASclauses() {
        return this.theHasSelectASclauses;
    }

    Expr getFieldExpr(int i) {
        return this.theFieldExprs.get(i);
    }

    void setFieldExpr(int i, Expr newExpr, boolean destroy) {
        this.theFieldExprs.get(i).removeParent(this, destroy);
        if (newExpr.isMultiValued()) {
            ArrayList<Expr> args = new ArrayList<Expr>(1);
            args.add(newExpr);
            newExpr = new ExprArrayConstr(this.theQCB, this.theSctx, newExpr.theLocation, args, true);
        }
        this.theFieldExprs.set(i, newExpr);
        newExpr.addParent(this);
    }

    void removeField(int i, boolean destroy) {
        this.theFieldExprs.get(i).removeParent(this, destroy);
        this.theFieldExprs.remove(i);
        this.theFieldNames.remove(i);
        this.theType = this.computeType();
        --this.theNumChildren;
    }

    void addField(String name, Expr expr) {
        expr = ExprPromote.create(null, expr, TypeManager.ANY_QSTN());
        this.theFieldExprs.add(expr);
        this.theFieldNames.add(name);
        expr.addParent(this);
        this.theType = this.computeType();
        ++this.theNumChildren;
    }

    String getFieldName(int i) {
        return this.theFieldNames.get(i);
    }

    int getNumFields() {
        return this.theFieldExprs.size();
    }

    ArrayList<String> getFieldNames() {
        return this.theFieldNames;
    }

    String[] getFieldNamesArray() {
        String[] arr = new String[this.theFieldNames.size()];
        return this.theFieldNames.toArray(arr);
    }

    boolean doNullOnEmpty() {
        return this.theDoNullOnEmpty;
    }

    void setDoNullOnEmpty(boolean v) {
        this.theDoNullOnEmpty = v;
    }

    void addSortClause(ArrayList<Expr> sortExprs, ArrayList<SortSpec> sortSpecs) {
        for (int i = 0; i < sortExprs.size(); ++i) {
            Expr expr = sortExprs.get(i);
            expr = ExprPromote.create(null, expr, TypeManager.ANY_ATOMIC_QSTN());
            expr.addParent(this);
            sortExprs.set(i, expr);
        }
        this.theSortExprs = sortExprs;
        this.theSortSpecs = sortSpecs;
        this.theNumChildren += this.theSortExprs.size();
    }

    void removeSort() {
        if (!this.hasSort()) {
            return;
        }
        while (!this.theSortExprs.isEmpty()) {
            this.removeSortExpr(0, true);
        }
        this.theSortExprs = null;
        this.theSortSpecs = null;
        this.theSortingIndexes = null;
        this.theUsePrimaryIndexForSort = false;
    }

    boolean hasSort() {
        return this.theSortExprs != null && !this.theSortExprs.isEmpty();
    }

    boolean hasPrimaryIndexBasedSort() {
        return this.theUsePrimaryIndexForSort;
    }

    boolean hasSecondaryIndexBasedSort() {
        return this.theSortingIndexes != null && !this.theSortingIndexes.isEmpty();
    }

    ArrayList<IndexImpl> getSortingIndexes() {
        return this.theSortingIndexes;
    }

    int getNumSortExprs() {
        return this.theSortExprs == null ? 0 : this.theSortExprs.size();
    }

    Expr getSortExpr(int i) {
        return this.theSortExprs.get(i);
    }

    void setSortExpr(int i, Expr newExpr, boolean destroy) {
        this.theSortExprs.get(i).removeParent(this, destroy);
        this.theSortExprs.set(i, newExpr);
        newExpr.addParent(this);
    }

    void removeSortExpr(int i, boolean destroy) {
        Expr sortExpr = this.theSortExprs.remove(i);
        sortExpr.removeParent(this, destroy);
        this.theSortSpecs.remove(i);
        --this.theNumChildren;
    }

    SortSpec[] getSortSpecs() {
        SortSpec[] arr = new SortSpec[this.theSortSpecs.size()];
        return this.theSortSpecs.toArray(arr);
    }

    void analyseSort() {
        Expr sortExpr;
        if (this.theSortExprs == null || this.theSortExprs.isEmpty()) {
            return;
        }
        TableImpl table = this.getTable();
        if (table == null) {
            throw new QueryException("Order-by cannot be performed because the order-by expressions are not consecutive columns of any index", this.getSortExpr(0).getLocation());
        }
        ExprBaseTable tableExpr = this.getTableExpr();
        IndexImpl.IndexField ipath = null;
        int i = 0;
        SortSpec spec = this.theSortSpecs.get(0);
        boolean desc = spec.theIsDesc;
        boolean nullsLast = !spec.theNullsFirst;
        Direction direction = desc ? Direction.REVERSE : Direction.FORWARD;
        for (i = 1; i < this.theSortSpecs.size(); ++i) {
            spec = this.theSortSpecs.get(i);
            if (desc == spec.theIsDesc && nullsLast == !spec.theNullsFirst) continue;
            throw new QueryException("In the current implementation, all order-by specs must have the same ordering direction and the same relative order for NULLs", this.getSortExpr(i).getLocation());
        }
        tableExpr.setDirection(direction);
        int[] pkPositions = table.getPrimKeyPositions();
        for (i = 0; i < pkPositions.length && i < this.theSortExprs.size() && ExprUtils.isPrimKeyColumnRef(table, pkPositions[i], sortExpr = this.getSortExpr(i)); ++i) {
        }
        if (i == this.theSortExprs.size()) {
            this.theUsePrimaryIndexForSort = true;
            int numShardKeys = table.getShardKeySize();
            if (i > numShardKeys) {
                while (this.theSortExprs.size() > numShardKeys) {
                    this.removeSortExpr(this.theSortExprs.size() - 1, true);
                }
            }
            return;
        }
        if (desc && nullsLast || !desc && !nullsLast) {
            throw new QueryException("NULLs ordering is not compatible with the way NULLs are ordered in indexes.");
        }
        this.theSortingIndexes = new ArrayList();
        Map<String, Index> indexes = table.getIndexes();
        for (Map.Entry<String, Index> entry : indexes.entrySet()) {
            Expr sortExpr2;
            IndexImpl index = (IndexImpl)entry.getValue();
            List<IndexImpl.IndexField> indexPaths = index.getIndexFields();
            for (i = 0; i < indexPaths.size() && i < this.theSortExprs.size(); ++i) {
                IndexExpr iexpr;
                ipath = indexPaths.get(i);
                Expr sortExpr3 = this.getSortExpr(i);
                if (ipath.isMultiKey() || (iexpr = sortExpr3.getIndexExpr()) == null || !iexpr.matchToIndexPath(index, ipath)) break;
            }
            if (i == this.theSortExprs.size()) {
                this.theSortingIndexes.add(index);
                continue;
            }
            if (i != indexPaths.size()) continue;
            for (int j = 0; j < pkPositions.length && i < this.theSortExprs.size() && ExprUtils.isPrimKeyColumnRef(table, pkPositions[j], sortExpr2 = this.getSortExpr(i)); ++i, ++j) {
            }
            if (i != this.theSortExprs.size()) continue;
            this.theSortingIndexes.add(index);
        }
        if (this.theSortingIndexes.isEmpty()) {
            throw new QueryException("Order-by cannot be performed because there is no index that orders the table rows in the desired order (in the current implementation sorting is possible only if the ORDER BY clause contains N expressions that match the first N fields on an index, and these fields are not multi-key", this.getSortExpr(0).getLocation());
        }
    }

    int[] addSortExprsToSelect() {
        int numFieldExprs = this.theFieldExprs.size();
        int numSortExprs = this.theSortExprs.size();
        int[] sortPositions = new int[numSortExprs];
        for (int i = 0; i < numSortExprs; ++i) {
            Expr fieldExpr;
            int j;
            Expr sortExpr = this.theSortExprs.get(i);
            for (j = 0; j < numFieldExprs && !ExprUtils.matchExprs(sortExpr, fieldExpr = this.theFieldExprs.get(j)); ++j) {
            }
            if (j == numFieldExprs) {
                this.theFieldExprs.add(sortExpr);
                this.theFieldNames.add(this.theQCB.generateFieldName("sort"));
                sortPositions[i] = this.theFieldExprs.size() - 1;
                ++this.theNumChildren;
                continue;
            }
            sortPositions[i] = j;
            sortExpr.removeParent(this, true);
        }
        this.theNumChildren -= this.theSortExprs.size();
        this.theSortExprs = null;
        this.theType = this.computeType();
        return sortPositions;
    }

    void addOffsetLimit(Expr offset, Expr limit) {
        if (offset != null) {
            this.addOffset(offset);
        }
        if (limit != null) {
            this.addLimit(limit);
        }
    }

    Expr getOffset() {
        return this.theOffsetExpr;
    }

    void addOffset(Expr expr) {
        FieldValueImpl val;
        assert (this.theOffsetExpr == null);
        if (!expr.isConstant()) {
            throw new QueryException("Offset expression is not constant");
        }
        if (expr.getKind() == Expr.ExprKind.CONST && (val = ((ExprConst)expr).getValue()).getLong() == 0L) {
            return;
        }
        this.theOffsetExpr = ExprPromote.create(null, expr, TypeManager.LONG_ONE());
        this.theOffsetExpr.addParent(this);
        ++this.theNumChildren;
    }

    void removeOffset(boolean destroy) {
        this.theOffsetExpr.removeParent(this, destroy);
        this.theOffsetExpr = null;
        --this.theNumChildren;
    }

    void setOffset(Expr newExpr, boolean destroy) {
        this.theOffsetExpr.removeParent(this, destroy);
        this.theOffsetExpr = null;
        --this.theNumChildren;
        this.addOffset(newExpr);
    }

    Expr getLimit() {
        return this.theLimitExpr;
    }

    void addLimit(Expr expr) {
        assert (this.theLimitExpr == null);
        if (!expr.isConstant()) {
            throw new QueryException("Limit expression is not constant");
        }
        this.theLimitExpr = ExprPromote.create(null, expr, TypeManager.LONG_ONE());
        this.theLimitExpr.addParent(this);
        ++this.theNumChildren;
    }

    void removeLimit(boolean destroy) {
        this.theLimitExpr.removeParent(this, destroy);
        this.theLimitExpr = null;
        --this.theNumChildren;
    }

    void setLimit(Expr newExpr, boolean destroy) {
        this.theLimitExpr.removeParent(this, destroy);
        this.theLimitExpr = null;
        --this.theNumChildren;
        this.addLimit(newExpr);
    }

    @Override
    int getNumChildren() {
        return this.theNumChildren;
    }

    int computeNumChildren() {
        return this.theFromClauses.size() + (this.theWhereExpr != null ? 1 : 0) + this.theFieldExprs.size() + (this.theSortExprs != null ? this.theSortExprs.size() : 0) + (this.theOffsetExpr != null ? 1 : 0) + (this.theLimitExpr != null ? 1 : 0);
    }

    int[] addPrimKeyToSelect() {
        TableImpl table = this.getTable();
        int[] pkPositions = table.getPrimKeyPositions();
        int numPrimKeyCols = pkPositions.length;
        int numFieldExprs = this.theFieldExprs.size();
        int[] pkPositionsInSelect = new int[numPrimKeyCols];
        for (int i = 0; i < numPrimKeyCols; ++i) {
            Expr fieldExpr;
            int j;
            for (j = 0; j < numFieldExprs && !ExprUtils.isPrimKeyColumnRef(table, pkPositions[i], fieldExpr = this.theFieldExprs.get(j)); ++j) {
            }
            if (j == numFieldExprs) {
                String pkColName = table.getPrimaryKeyColumnName(i);
                ExprFieldStep primKeyExpr = new ExprFieldStep(this.getQCB(), this.getSctx(), this.getLocation(), this.getTableVar(), pkColName);
                this.theFieldExprs.add(primKeyExpr);
                this.theFieldNames.add(this.theQCB.generateFieldName(pkColName));
                pkPositionsInSelect[i] = this.theFieldExprs.size() - 1;
                ++this.theNumChildren;
                continue;
            }
            pkPositionsInSelect[i] = j;
        }
        this.theType = this.computeType();
        return pkPositionsInSelect;
    }

    @Override
    ExprType computeType() {
        ExprType.Quantifier q1;
        ExprType.Quantifier q = this.getDomainExpr(0).getType().getQuantifier();
        for (int i = 1; i < this.theFromClauses.size() && (q = TypeManager.getUnionQuant(q, q1 = this.getDomainExpr(i).getType().getQuantifier())) != ExprType.Quantifier.STAR; ++i) {
        }
        if (this.theWhereExpr != null) {
            q = TypeManager.getUnionQuant(q, ExprType.Quantifier.QSTN);
        }
        if (!this.getConstructsSelectRecord()) {
            ExprType type = TypeManager.createType(this.getFieldExpr(0).getType(), q);
            if (type.isAnyJson()) {
                this.theQCB.theHaveJsonConstructors = true;
            }
            return type;
        }
        FieldMap fieldMap = new FieldMap();
        for (int i = 0; i < this.theFieldNames.size(); ++i) {
            FieldDefImpl fieldDef = this.theFieldExprs.get(i).getType().getDef();
            if (fieldDef.isJson()) {
                this.theQCB.theHaveJsonConstructors = true;
            }
            fieldMap.put(this.theFieldNames.get(i), fieldDef, true, null);
        }
        RecordDefImpl recDef = FieldDefFactory.createRecordDef(fieldMap, null);
        return TypeManager.createType(recDef, q);
    }

    @Override
    public boolean mayReturnNULL() {
        if (this.getConstructsSelectRecord()) {
            return false;
        }
        return this.theFieldExprs.get(0).mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        formatter.indent(sb);
        for (i = 0; i < this.theFromClauses.size(); ++i) {
            FromClause fc = this.theFromClauses.get(i);
            sb.append("FROM-" + i + " :\n");
            fc.getDomainExpr().display(sb, formatter);
            sb.append(" as " + fc.getVar().getName() + "\n\n");
        }
        if (this.theWhereExpr != null) {
            formatter.indent(sb);
            sb.append("WHERE:\n");
            this.theWhereExpr.display(sb, formatter);
            sb.append("\n\n");
        }
        formatter.indent(sb);
        sb.append("SELECT:\n");
        for (i = 0; i < this.theFieldExprs.size(); ++i) {
            formatter.indent(sb);
            sb.append(this.theFieldNames.get(i)).append(": \n");
            this.theFieldExprs.get(i).display(sb, formatter);
            if (i >= this.theFieldExprs.size() - 1) continue;
            sb.append(",\n");
        }
    }

    class FromClause {
        private final ExprVar theVar;
        private Expr theDomainExpr;

        FromClause(Expr domainExpr, String varName) {
            this.theDomainExpr = domainExpr;
            this.theDomainExpr.addParent(ExprSFW.this);
            this.theVar = new ExprVar(ExprSFW.this.theQCB, ExprSFW.this.theSctx, domainExpr.getLocation(), varName, this);
        }

        Expr getDomainExpr() {
            return this.theDomainExpr;
        }

        ExprVar getVar() {
            return this.theVar;
        }
    }
}

