/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.query.compiler.FuncAndOr;
import oracle.kv.impl.query.compiler.FuncAnyOp;
import oracle.kv.impl.query.compiler.FuncArithOp;
import oracle.kv.impl.query.compiler.FuncArithUnaryOp;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.FuncConcat;
import oracle.kv.impl.query.compiler.FuncExists;
import oracle.kv.impl.query.compiler.FuncIsNull;
import oracle.kv.impl.query.compiler.FuncNot;
import oracle.kv.impl.query.compiler.FuncSize;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.StaticContext;

public class FunctionLib {
    ArrayList<Function> theFunctions = new ArrayList(20);

    FunctionLib(StaticContext sctx) {
        this.theFunctions.add(new FuncAndOr(FuncCode.OP_AND, "AND"));
        this.theFunctions.add(new FuncAndOr(FuncCode.OP_OR, "OR"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_EQ, "EQ"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_NEQ, "NEQ"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_GT, "GT"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_GE, "GE"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_LT, "LT"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_LE, "LE"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_EQ_ANY, "EQ_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_NEQ_ANY, "NEQ_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_GT_ANY, "GT_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_GE_ANY, "GE_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_LT_ANY, "LT_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_LE_ANY, "LE_ANY"));
        this.theFunctions.add(new FuncArithOp(FuncCode.OP_ADD_SUB, "+-"));
        this.theFunctions.add(new FuncArithOp(FuncCode.OP_MULT_DIV, "*/"));
        this.theFunctions.add(new FuncArithUnaryOp(FuncCode.OP_ARITH_UNARY, "-"));
        this.theFunctions.add(new FuncConcat());
        this.theFunctions.add(new FuncExists(FuncCode.OP_EXISTS, "EXISTS"));
        this.theFunctions.add(new FuncExists(FuncCode.OP_NOT_EXISTS, "NOT_EXISTS"));
        this.theFunctions.add(new FuncNot());
        this.theFunctions.add(new FuncSize());
        this.theFunctions.add(new FuncIsNull(FuncCode.OP_IS_NULL, "IS_NULL"));
        this.theFunctions.add(new FuncIsNull(FuncCode.OP_IS_NOT_NULL, "IS_NOT_NULL"));
        for (Function func : this.theFunctions) {
            sctx.addFunction(func);
        }
    }

    Function getFunc(FuncCode c) {
        return this.theFunctions.get(c.ordinal());
    }

    public static enum FuncCode {
        OP_AND,
        OP_OR,
        OP_EQ,
        OP_NEQ,
        OP_GT,
        OP_GE,
        OP_LT,
        OP_LE,
        OP_EQ_ANY,
        OP_NEQ_ANY,
        OP_GT_ANY,
        OP_GE_ANY,
        OP_LT_ANY,
        OP_LE_ANY,
        OP_ADD_SUB,
        OP_MULT_DIV,
        OP_ARITH_UNARY,
        OP_CONCAT,
        OP_EXISTS,
        OP_NOT_EXISTS,
        OP_NOT,
        FN_SIZE,
        OP_IS_NULL,
        OP_IS_NOT_NULL;

    }
}

