/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.FuncAnyOp;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.IndexExpr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;

class IndexAnalyzer
implements Comparable<IndexAnalyzer> {
    static final int eqValue = 32;
    static final int vrangeValue = 16;
    static final int arangeValue = 8;
    static final int filterEqValue = 16;
    static final int filterOtherValue = 8;
    private final QueryControlBlock theQCB;
    private final StaticContext theSctx;
    ExprSFW theSFW;
    private final TableImpl theTable;
    private final IndexImpl theIndex;
    private final boolean theIsPrimary;
    private final boolean theIsMapBothIndex;
    private final int theNumFields;
    private final boolean theIsHintIndex;
    private final ArrayList<ArrayList<PredInfo>> theStartStopPreds;
    private final ArrayList<Expr> theFilteringPreds;
    private final ArrayList<Expr> theAlwaysTruePreds;
    private boolean theHaveMapBothPreds;
    private Map<String, MapBothKeyInfo> theMapBothKeys;
    private MapBothKeyInfo theMapBothKey;
    private boolean theHaveMapKeyEqPred;
    private boolean thePushedAnyPred;
    PrimaryKeyImpl thePrimaryKey;
    private IndexKeyImpl theSecondaryKey;
    private FieldRange theRange;
    private final ArrayList<Expr> thePushedPreds;
    private final ArrayList<Expr> thePushedExternals;
    private boolean theHavePushedExternals;
    private boolean theIsMultiKeyRange;
    private boolean theIsCovering;
    private boolean theEliminateDups;
    private final IndexExpr thePath;
    private int theScore = -1;
    private int theScore2 = -1;
    private int theNumEqPredsPushed = 0;

    IndexAnalyzer(ExprSFW sfw, TableImpl table, IndexImpl index) {
        this.theSFW = sfw;
        this.theQCB = this.theSFW.getQCB();
        this.theSctx = this.theSFW.getSctx();
        this.theTable = table;
        this.theIndex = index;
        this.theIsPrimary = this.theIndex == null;
        this.theNumFields = this.theIsPrimary ? this.theTable.getPrimaryKeySize() : this.theIndex.numFields();
        ExprBaseTable tableExpr = sfw.getTableExpr();
        this.theIsHintIndex = tableExpr.isIndexHint(this.theIndex);
        this.theStartStopPreds = new ArrayList(this.theNumFields);
        this.theFilteringPreds = new ArrayList();
        this.theAlwaysTruePreds = new ArrayList();
        this.thePushedPreds = new ArrayList();
        for (int i = 0; i < this.theNumFields; ++i) {
            this.theStartStopPreds.add(null);
        }
        if (this.theIndex != null) {
            if (this.theIndex.isMapBothIndex()) {
                this.theIsMapBothIndex = true;
                this.theMapBothKeys = new HashMap<String, MapBothKeyInfo>();
            } else {
                this.theIsMapBothIndex = false;
            }
        } else {
            this.theIsMapBothIndex = false;
        }
        this.thePushedExternals = new ArrayList();
        this.thePath = new IndexExpr();
        this.thePath.theTable = table;
    }

    private void reset() {
        this.theStartStopPreds.clear();
        this.theFilteringPreds.clear();
        this.thePushedPreds.clear();
        for (int i = 0; i < this.theNumFields; ++i) {
            this.theStartStopPreds.add(null);
        }
        if (this.theIsMapBothIndex) {
            this.theMapBothKeys.clear();
        }
        this.thePushedExternals.clear();
        this.theHavePushedExternals = false;
        this.theMapBothKey = null;
        this.theHaveMapBothPreds = false;
        this.theHaveMapKeyEqPred = false;
        this.thePushedAnyPred = false;
        this.thePrimaryKey = null;
        this.theSecondaryKey = null;
        this.theRange = null;
        this.theIsMultiKeyRange = false;
        this.theIsCovering = false;
        this.theEliminateDups = false;
    }

    private String getIndexName() {
        return this.theIsPrimary ? "primary" : this.theIndex.getName();
    }

    boolean hasShardKey() {
        return this.theIsPrimary && this.thePrimaryKey != null && this.thePrimaryKey.hasShardKey();
    }

    private void removePred(Expr pred) {
        Expr whereExpr = this.theSFW.getWhereExpr();
        if (pred == whereExpr) {
            this.theSFW.removeWhereExpr(true);
        } else {
            whereExpr.removeChild(pred, true);
            if (whereExpr.getNumChildren() == 0) {
                this.theSFW.removeWhereExpr(true);
            }
        }
    }

    private void processAlwaysFalse(Expr pred) {
        this.reset();
        Function empty = Function.getFunction(FunctionLib.FuncCode.OP_CONCAT);
        Expr emptyExpr = ExprFuncCall.create(this.theQCB, this.theSctx, pred.getLocation(), empty, new ArrayList<Expr>());
        if (this.theQCB.getRootExpr() == this.theSFW) {
            this.theQCB.setRootExpr(emptyExpr);
        } else {
            this.theSFW.replace(emptyExpr, true);
        }
        this.theSFW = null;
    }

    @Override
    public int compareTo(IndexAnalyzer other) {
        int numFields1 = this.theNumFields;
        int numFields2 = other.theNumFields;
        boolean multiKey1 = this.theIsPrimary ? false : this.theIndex.isMultiKey();
        boolean multiKey2 = other.theIsPrimary ? false : other.theIndex.isMultiKey();
        this.getScore();
        other.getScore();
        if (this.theIsCovering != other.theIsCovering) {
            if (this.theIsCovering) {
                if (!this.theIsHintIndex && other.theIsHintIndex) {
                    return this.theNumEqPredsPushed > 0 || this.thePushedPreds.size() > 1 ? -1 : 1;
                }
                if (other.theScore != Integer.MAX_VALUE) {
                    return -1;
                }
                return this.theScore >= other.theScore2 ? -1 : 1;
            }
            if (other.theIsCovering) {
                if (!other.theIsHintIndex && this.theIsHintIndex) {
                    return other.theNumEqPredsPushed > 0 || other.thePushedPreds.size() > 1 ? 1 : -1;
                }
                if (this.theScore != Integer.MAX_VALUE) {
                    return 1;
                }
                return other.theScore >= this.theScore2 ? 1 : -1;
            }
        }
        if (this.theScore == other.theScore) {
            if (this.theScore == 0) {
                if (this.theIsPrimary || other.theIsPrimary) {
                    return this.theIsPrimary ? -1 : 1;
                }
                if (multiKey1 != multiKey2) {
                    return multiKey1 ? 1 : -1;
                }
            }
            if (this.theIsHintIndex != other.theIsHintIndex) {
                return this.theIsHintIndex ? -1 : 1;
            }
            if (multiKey1 != multiKey2) {
                return multiKey1 ? 1 : -1;
            }
            if (this.theIsPrimary || other.theIsPrimary) {
                return this.theIsPrimary ? -1 : 1;
            }
            if (numFields1 != numFields2) {
                return numFields1 < numFields2 ? -1 : 1;
            }
            return 0;
        }
        if (this.theScore == Integer.MAX_VALUE || other.theScore == Integer.MAX_VALUE) {
            return this.theScore == Integer.MAX_VALUE ? -1 : 1;
        }
        if (this.theIsHintIndex != other.theIsHintIndex) {
            return this.theIsHintIndex ? -1 : 1;
        }
        return this.theScore > other.theScore ? -1 : 1;
    }

    private int getScore() {
        if (this.theScore >= 0) {
            return this.theScore;
        }
        this.theScore = 0;
        this.theScore2 = 0;
        int numIndexFields = this.theIndex != null ? this.theIndex.numFields() : this.theTable.getNumKeyComponents();
        this.theScore += this.theNumEqPredsPushed * 32;
        if (this.theRange != null) {
            if (this.theRange.getStart() != null) {
                this.theScore += this.theIsMultiKeyRange ? 8 : 16;
            }
            if (this.theRange.getEnd() != null) {
                this.theScore += this.theIsMultiKeyRange ? 8 : 16;
            }
        }
        for (Expr pred : this.theFilteringPreds) {
            Function func = pred.getFunction(null);
            if (func != null && func.getCode() == FunctionLib.FuncCode.OP_EQ) {
                this.theScore += 16;
                continue;
            }
            this.theScore += 8;
        }
        this.theScore2 = this.theScore;
        if (this.theNumEqPredsPushed == numIndexFields) {
            this.theScore = Integer.MAX_VALUE;
            return this.theScore;
        }
        return this.theScore;
    }

    void apply() {
        ExprBaseTable tableExpr = this.theSFW.getTableExpr();
        int numVars = this.theSFW.getNumVars();
        int[] varRefsCounts = new int[numVars];
        for (int i = 0; i < numVars; ++i) {
            varRefsCounts[i] = this.theSFW.getVar(i).getNumParents();
        }
        if (this.theRange != null) {
            assert (this.thePrimaryKey != null || this.theSecondaryKey != null);
            tableExpr.addRange(this.theRange);
            this.theQCB.setPushedRange(this.theRange);
        }
        if (this.theIsPrimary) {
            if (this.thePrimaryKey == null) {
                this.thePrimaryKey = this.theTable.createPrimaryKey();
            }
            tableExpr.addPrimaryKey(this.thePrimaryKey, this.theIsCovering);
            this.theQCB.setPushedPrimaryKey(this.thePrimaryKey);
        } else {
            if (this.theSecondaryKey == null) {
                this.theSecondaryKey = this.theIndex.createIndexKey();
            }
            tableExpr.addSecondaryKey(this.theSecondaryKey, this.theIsCovering);
            this.theQCB.setPushedSecondaryKey(this.theSecondaryKey);
        }
        if (this.theHavePushedExternals) {
            tableExpr.setPushedExternals(this.thePushedExternals);
        }
        for (Expr pred : this.thePushedPreds) {
            this.removePred(pred);
        }
        for (Expr pred : this.theAlwaysTruePreds) {
            this.removePred(pred);
        }
        if (this.theFilteringPreds.size() > 1) {
            FunctionLib fnlib = CompilerAPI.getFuncLib();
            Function andFunc = fnlib.getFunc(FunctionLib.FuncCode.OP_AND);
            Expr pred = ExprFuncCall.create(this.theQCB, this.theSctx, tableExpr.getLocation(), andFunc, this.theFilteringPreds);
            tableExpr.setFilteringPred(pred, false);
            for (Expr pred2 : this.theFilteringPreds) {
                this.removePred(pred2);
            }
        } else if (this.theFilteringPreds.size() == 1) {
            Expr pred = this.theFilteringPreds.get(0);
            tableExpr.setFilteringPred(pred, false);
            this.removePred(pred);
        }
        if (this.theEliminateDups) {
            tableExpr.setEliminateIndexDups();
        }
        for (int i = numVars - 1; i >= 0; --i) {
            ExprVar var = this.theSFW.getVar(i);
            if (var.getNumParents() != 0) continue;
            if (this.theSFW.getDomainExpr(i).isScalar()) {
                this.theSFW.removeFromClause(i, true);
                continue;
            }
            if (varRefsCounts[i] == 0 || var.getTable() != null) continue;
            if (this.theSFW.getDomainExpr(i).isMultiValued() && (this.theIndex == null || !this.theIndex.isMultiKey())) {
                throw new QueryStateException("Attempt to remove a multi-valued variable when a non-multikey index is being applied.\nvar name = " + var.getName() + " index name = " + this.theIndex.getName());
            }
            this.theSFW.removeFromClause(i, true);
        }
    }

    void analyze() {
        if (this.theIsPrimary) {
            this.analyzePrimaryIndex();
        } else {
            this.analyzeSecondaryIndex();
        }
    }

    private void analyzePrimaryIndex() {
        boolean foundPreds = this.collectIndexPreds();
        if (this.theSFW == null) {
            return;
        }
        this.thePrimaryKey = this.theTable.createPrimaryKey();
        if (foundPreds) {
            List<String> pkColumnNames = this.theTable.getPrimaryKeyInternal();
            IndexImpl.IndexField ipath = null;
            for (int i = 0; i < this.theNumFields; ++i) {
                String name = pkColumnNames.get(i);
                ipath = new IndexImpl.IndexField(this.theTable, name, null, i);
                ipath.setType(this.theTable.getPrimKeyColumnDef(i));
                boolean done = this.processIndexColumn(ipath, i);
                if (done) break;
            }
        }
        this.checkIsCovering();
    }

    private void analyzeSecondaryIndex() {
        IndexImpl.IndexField ipath;
        boolean foundPreds = this.collectIndexPreds();
        if (this.theSFW == null) {
            return;
        }
        this.theSecondaryKey = this.theIndex.createIndexKey();
        List<IndexImpl.IndexField> indexPaths = this.theIndex.getIndexFields();
        int i = 0;
        if (foundPreds) {
            boolean done;
            for (i = 0; i < indexPaths.size() && !(done = this.processIndexColumn(ipath = indexPaths.get(i), i)); ++i) {
            }
        }
        if (this.theIndex.isMultiKey() && this.theMapBothKey == null) {
            if (!this.thePushedAnyPred) {
                this.theEliminateDups = true;
            } else if (i < indexPaths.size() && !this.theHaveMapKeyEqPred) {
                while (i < indexPaths.size()) {
                    ipath = indexPaths.get(i);
                    if (ipath.isMultiKey()) {
                        this.theEliminateDups = true;
                    }
                    ++i;
                }
            }
        }
        this.checkIsCovering();
    }

    private void checkIsCovering() {
        int numIndexPreds = this.thePushedPreds.size() + this.theFilteringPreds.size() + this.theAlwaysTruePreds.size();
        int numPreds = this.getNumPreds();
        assert (numIndexPreds <= numPreds);
        if (this.theSFW != null && this.theTable.getRowDef().getNumFields() == this.theTable.getPrimKeyDef().getNumFields()) {
            assert (this.theIsPrimary || !this.theIndex.isMultiKey());
            assert (numIndexPreds == numPreds);
            assert (!this.theSFW.hasSort() || this.theSFW.hasPrimaryIndexBasedSort() && this.theIsPrimary || this.theSFW.getSortingIndexes().contains(this.theIndex));
            this.theIsCovering = true;
            return;
        }
        boolean bl = this.theIsCovering = this.theSFW != null && numIndexPreds == numPreds;
        if (!this.theIsCovering) {
            return;
        }
        int numFields = this.theSFW.getNumFields();
        for (int i = 0; i < numFields; ++i) {
            Expr expr = this.theSFW.getFieldExpr(i);
            if (this.isIndexOnlyExpr(expr)) continue;
            this.theIsCovering = false;
            return;
        }
        int numSortExprs = this.theSFW.getNumSortExprs();
        for (int i = 0; i < numSortExprs; ++i) {
            Expr expr = this.theSFW.getSortExpr(i);
            if (this.isIndexOnlyExpr(expr)) continue;
            this.theIsCovering = false;
            return;
        }
        int numVars = this.theSFW.getNumVars();
        for (int i = 0; i < numVars; ++i) {
            ExprVar var = this.theSFW.getVar(i);
            Expr domExpr = this.theSFW.getDomainExpr(i);
            if (var.getNumParents() != 0 || domExpr.isScalar() || this.isIndexOnlyExpr(domExpr)) continue;
            this.theIsCovering = false;
            return;
        }
    }

    private boolean processIndexColumn(IndexImpl.IndexField ipath, int pos) {
        PredInfo pi2;
        ArrayList<PredInfo> preds = this.theStartStopPreds.get(pos);
        if (this.theHaveMapBothPreds && ipath.isMapKeys()) {
            StringValueImpl keyVal = FieldDefImpl.stringDef.createString(this.theMapBothKey.theKey);
            this.theSecondaryKey.put(pos, (FieldValue)keyVal);
            this.thePushedExternals.add(null);
            ++this.theNumEqPredsPushed;
            this.theHaveMapKeyEqPred = true;
            return false;
        }
        if (preds == null || preds.isEmpty()) {
            return true;
        }
        assert (preds.size() <= 2);
        PredInfo pi1 = preds.get(0);
        PredInfo predInfo = pi2 = preds.size() > 1 ? preds.get(1) : null;
        if (this.thePushedAnyPred && (pi1.theIsAnyOp || pi2 != null && pi2.theIsAnyOp)) {
            return true;
        }
        if (pi1.isEq()) {
            FieldValueImpl constVal;
            assert (preds.size() == 1);
            if (!pi1.isPartial()) {
                this.thePushedPreds.add(pi1.thePred);
            }
            this.theFilteringPreds.remove(pi1.thePred);
            if (ipath.isMapKeys()) {
                this.theHaveMapKeyEqPred = true;
            }
            boolean bl = this.thePushedAnyPred = this.thePushedAnyPred || pi1.theIsAnyOp;
            if (pi1.theConstVal != null) {
                this.thePushedExternals.add(null);
                constVal = pi1.theConstVal;
            } else {
                this.theHavePushedExternals = true;
                this.thePushedExternals.add(pi1.theConstExpr);
                constVal = IndexAnalyzer.createPlaceHolderValue(ipath.getType());
            }
            if (this.theIsPrimary) {
                this.thePrimaryKey.put(ipath.getStep(0), (FieldValue)constVal);
            } else {
                this.theSecondaryKey.put(pos, (FieldValue)constVal);
            }
            ++this.theNumEqPredsPushed;
            return false;
        }
        PredInfo minpi = null;
        PredInfo maxpi = null;
        if (pi1.isMin()) {
            minpi = pi1;
            boolean bl = this.thePushedAnyPred = this.thePushedAnyPred || minpi.theIsAnyOp;
            if (pi2 != null) {
                assert (pi2.isMax());
                maxpi = pi2;
                this.thePushedAnyPred = this.thePushedAnyPred || maxpi.theIsAnyOp;
            }
        } else {
            assert (pi1.isMax());
            maxpi = pi1;
            boolean bl = this.thePushedAnyPred = this.thePushedAnyPred || maxpi.theIsAnyOp;
            if (pi2 != null) {
                assert (pi2.isMin());
                minpi = pi2;
                this.thePushedAnyPred = this.thePushedAnyPred || minpi.theIsAnyOp;
            }
        }
        this.createRange(ipath, minpi, maxpi);
        return true;
    }

    private void createRange(IndexImpl.IndexField ipath, PredInfo minpi, PredInfo maxpi) {
        FieldValueImpl val;
        int storageSize = this.theIsPrimary ? this.theTable.getPrimaryKeySize(ipath.getStep(0)) : 0;
        FieldDefImpl rangeDef = ipath.getType();
        String pathName = this.theIsPrimary ? ipath.getStep(0) : this.theIndex.getFieldName(ipath.getPosition());
        this.theRange = new FieldRange(pathName, rangeDef, storageSize);
        if (minpi != null) {
            if (minpi.theConstVal == null) {
                this.theHavePushedExternals = true;
                this.thePushedExternals.add(minpi.theConstExpr);
                val = IndexAnalyzer.createPlaceHolderValue(rangeDef);
                this.theRange.setStart(val, minpi.isInclusive(), false);
            } else {
                this.thePushedExternals.add(null);
                this.theRange.setStart(minpi.theConstVal, minpi.isInclusive());
            }
            if (minpi.isMultiKey()) {
                this.theIsMultiKeyRange = true;
                if (!this.theHaveMapKeyEqPred) {
                    this.theEliminateDups = true;
                }
            }
            if (!minpi.isPartial()) {
                this.thePushedPreds.add(minpi.thePred);
            }
            this.theFilteringPreds.remove(minpi.thePred);
        } else {
            this.thePushedExternals.add(null);
        }
        if (maxpi != null) {
            if (maxpi.theConstVal == null) {
                this.theHavePushedExternals = true;
                this.thePushedExternals.add(maxpi.theConstExpr);
                val = IndexAnalyzer.createPlaceHolderValue(rangeDef);
                this.theRange.setEnd(val, maxpi.isInclusive(), false);
            } else {
                this.thePushedExternals.add(null);
                this.theRange.setEnd(maxpi.theConstVal, maxpi.isInclusive());
            }
            if (maxpi.isMultiKey()) {
                this.theIsMultiKeyRange = true;
                if (!this.theHaveMapKeyEqPred) {
                    this.theEliminateDups = true;
                }
            }
            if (!maxpi.isPartial()) {
                this.thePushedPreds.add(maxpi.thePred);
            }
            this.theFilteringPreds.remove(maxpi.thePred);
        } else {
            this.thePushedExternals.add(null);
        }
    }

    private boolean collectIndexPreds() {
        Expr whereExpr = this.theSFW.getWhereExpr();
        if (whereExpr == null) {
            return false;
        }
        Function andOp = whereExpr.getFunction(FunctionLib.FuncCode.OP_AND);
        if (andOp != null) {
            Expr child;
            Expr.ExprIter children = whereExpr.getChildren();
            while (children.hasNext()) {
                child = children.next();
                PredInfo pi = this.collectStartStopPred(child);
                if (pi == null) continue;
                if (pi.theStatus == PredicateStatus.ALWAYS_FALSE) {
                    this.processAlwaysFalse(pi.thePred);
                    return true;
                }
                if (pi.theStatus != PredicateStatus.ALWAYS_TRUE || pi.theDoesFiltering) continue;
                this.theAlwaysTruePreds.add(child);
                child.setFilteringPredFlag();
            }
            if (this.theHaveMapBothPreds) {
                this.chooseMapBothKey();
            }
            children.reset();
            while (children.hasNext()) {
                child = children.next();
                if (child.getFilteringPredFlag() || !this.isIndexOnlyExpr(child)) continue;
                this.theFilteringPreds.add(child);
            }
        } else {
            PredInfo pi = this.collectStartStopPred(whereExpr);
            if (pi == null) {
                if (this.isIndexOnlyExpr(whereExpr)) {
                    this.theFilteringPreds.add(whereExpr);
                    return true;
                }
                return false;
            }
            if (pi.theStatus == PredicateStatus.ALWAYS_FALSE) {
                this.processAlwaysFalse(pi.thePred);
                return false;
            }
            if (pi.theStatus == PredicateStatus.ALWAYS_TRUE && !pi.theDoesFiltering) {
                this.theAlwaysTruePreds.add(whereExpr);
                whereExpr.setFilteringPredFlag();
            }
            if (this.theHaveMapBothPreds) {
                this.chooseMapBothKey();
            }
        }
        int numPreds = 0;
        for (int i = 0; i < this.theNumFields; ++i) {
            ArrayList<PredInfo> preds = this.theStartStopPreds.get(i);
            if (preds == null) continue;
            for (int j = 0; j < preds.size(); ++j) {
                PredInfo pi = preds.get(j);
                if (pi.theStatus == PredicateStatus.ALWAYS_TRUE) {
                    preds.remove(j);
                    --j;
                    this.theFilteringPreds.remove(pi.thePred);
                    if (pi.theDoesFiltering) continue;
                    this.theAlwaysTruePreds.add(pi.thePred);
                    continue;
                }
                ++numPreds;
            }
        }
        return numPreds != 0 || !this.theFilteringPreds.isEmpty();
    }

    private PredInfo collectStartStopPred(Expr pred) {
        Expr constArg;
        Expr varArg;
        pred.clearFilteringPredFlag();
        Function func = pred.getFunction(null);
        FunctionLib.FuncCode op = func != null ? func.getCode() : null;
        boolean isNullOp = false;
        if (op == FunctionLib.FuncCode.OP_IS_NULL) {
            isNullOp = true;
            op = FunctionLib.FuncCode.OP_EQ;
        } else if (op == FunctionLib.FuncCode.OP_IS_NOT_NULL) {
            isNullOp = true;
            op = FunctionLib.FuncCode.OP_LT;
        }
        if (func == null || !func.isComparison() || op == FunctionLib.FuncCode.OP_NEQ || op == FunctionLib.FuncCode.OP_NEQ_ANY) {
            return null;
        }
        if (func.isAnyComparison()) {
            if (this.theIsPrimary || !this.theIndex.isMultiKey()) {
                return null;
            }
            op = FuncAnyOp.anyToComp(op);
        }
        ExprFuncCall compExpr = (ExprFuncCall)pred;
        FieldValueImpl constVal = null;
        if (isNullOp) {
            varArg = compExpr.getArg(0);
            constArg = null;
            constVal = NullValueImpl.getInstance();
        } else {
            Expr arg0 = compExpr.getArg(0);
            Expr arg1 = compExpr.getArg(1);
            if (arg0.isConstant()) {
                constArg = arg0;
                varArg = arg1;
                op = FuncCompOp.swapCompOp(op);
            } else if (arg1.isConstant()) {
                constArg = arg1;
                varArg = arg0;
            } else {
                return null;
            }
            if (constArg.getKind() == Expr.ExprKind.CONST) {
                constVal = ((ExprConst)constArg).getValue();
            }
        }
        IndexExpr epath = this.matchExprToIndexPath(varArg);
        if (epath == null) {
            return null;
        }
        if (varArg.isMultiValued() && func.isValueComparison()) {
            return null;
        }
        int ipathPos = epath.thePosition;
        boolean mapBothIndex = this.theIndex != null && this.theIndex.isMapBothIndex();
        String mapKey = epath.theMapBothKey;
        boolean isMultikeyPath = this.theIndex != null && this.theIndex.getIndexPath(ipathPos).isMultiKey();
        ArrayList<PredInfo> preds = this.theStartStopPreds.get(ipathPos);
        if (preds == null) {
            preds = new ArrayList();
            this.theStartStopPreds.set(ipathPos, preds);
        }
        PredInfo pi = new PredInfo(pred);
        pi.theCompOp = op;
        pi.theIsAnyOp = func.isAnyComparison();
        pi.theConstExpr = constArg;
        pi.theConstVal = constVal;
        pi.theIPathPos = epath.thePosition;
        pi.theDoesFiltering = epath.theDoesFiltering;
        pi.theMapKey = mapKey;
        pi.theStatus = PredicateStatus.KEEP;
        pi.theIsDirect = epath.theIsDirect;
        if (constArg != null && constVal != null && !constVal.isNull()) {
            FieldValueImpl newConstVal;
            FieldDefImpl targetType;
            assert (constArg != null);
            FieldDefImpl fieldDefImpl = targetType = epath.theJsonDeclaredType != null ? epath.theJsonDeclaredType : varArg.getType().getDef();
            if (!TypeManager.areTypesComparable(targetType, constVal.getDefinition())) {
                if (this.theQCB.strictMode()) {
                    throw new QueryException("Incompatible types for comparison operator: \nType1: " + varArg.getType() + "\nType2: " + constArg.getType(), pred.getLocation());
                }
                newConstVal = BooleanValueImpl.falseValue;
            } else {
                newConstVal = FuncCompOp.castConstInCompOp(targetType, epath.theIsJson, false, varArg.isScalar(), constVal, op, this.theQCB.strictMode());
            }
            if (newConstVal != constVal) {
                if (newConstVal == BooleanValueImpl.falseValue) {
                    pi.theStatus = PredicateStatus.ALWAYS_FALSE;
                    return pi;
                }
                if (newConstVal == BooleanValueImpl.trueValue) {
                    pi.theStatus = PredicateStatus.ALWAYS_TRUE;
                    return pi;
                }
                pi.theConstVal = constVal = newConstVal;
            }
        }
        if (constArg != null && !this.checkTypes(varArg, constArg, epath)) {
            return null;
        }
        if (mapKey != null && mapBothIndex) {
            this.theHaveMapBothPreds = true;
            MapBothKeyInfo mki = this.theMapBothKeys.get(mapKey);
            if (mki == null) {
                mki = new MapBothKeyInfo(mapKey);
                this.theMapBothKeys.put(mapKey, mki);
            }
        } else if (this.theIndex != null && this.theIndex.isMultiKey()) {
            pi.theIsUnnested = epath.theIsUnnested;
        }
        for (int i = 0; i < preds.size(); ++i) {
            PredInfo opi = preds.get(i);
            if (mapKey != null) {
                if (opi.theMapKey == null) {
                    preds.remove(i);
                    --i;
                    continue;
                }
                if (!mapKey.equals(opi.theMapKey)) {
                    continue;
                }
            } else if (opi.theMapKey != null) {
                pi.theStatus = PredicateStatus.SKIP;
                return pi;
            }
            if (pi.isEq()) {
                if (opi.isEq()) {
                    this.checkEqEq(pi, opi, isMultikeyPath);
                } else if (opi.isMin()) {
                    this.checkEqMin(pi, opi, isMultikeyPath);
                } else {
                    assert (opi.isMax());
                    this.checkEqMax(pi, opi, isMultikeyPath);
                }
            } else if (pi.isMin()) {
                if (opi.isEq()) {
                    this.checkEqMin(opi, pi, isMultikeyPath);
                } else if (opi.isMin()) {
                    this.checkMinMin(pi, opi, isMultikeyPath);
                } else {
                    assert (opi.isMax());
                    this.checkMinMax(pi, opi, pi, isMultikeyPath);
                }
            } else {
                assert (pi.isMax());
                if (opi.isEq()) {
                    this.checkEqMax(opi, pi, isMultikeyPath);
                } else if (opi.isMin()) {
                    this.checkMinMax(opi, pi, pi, isMultikeyPath);
                } else {
                    assert (opi.isMax());
                    this.checkMaxMax(pi, opi, isMultikeyPath);
                }
            }
            if (pi.theStatus == PredicateStatus.ALWAYS_TRUE || pi.theStatus == PredicateStatus.ALWAYS_FALSE) {
                return pi;
            }
            if (pi.theStatus == PredicateStatus.SKIP) break;
            if (opi.theStatus != PredicateStatus.SKIP) continue;
            preds.remove(i);
            --i;
        }
        if (pi.theStatus == PredicateStatus.KEEP) {
            preds.add(pi);
        }
        if (!pi.isMultiKey() && pi.theIsDirect) {
            this.theFilteringPreds.add(pred);
            pred.setFilteringPredFlag();
        }
        return pi;
    }

    private boolean checkTypes(Expr varArg, Expr constArg, IndexExpr epath) {
        boolean varIsScalar;
        FieldDefImpl varType;
        if (!constArg.isScalar()) {
            return false;
        }
        FieldDefImpl constType = constArg.getType().getDef();
        FieldDef.Type constTypeCode = constType.getType();
        if (epath.theJsonDeclaredType != null) {
            varType = epath.theJsonDeclaredType;
            boolean bl = varIsScalar = !epath.theIsMultiKey || epath.theMapBothKey != null;
            if (constTypeCode == FieldDef.Type.JSON) {
                return true;
            }
        } else {
            varType = varArg.getType().getDef();
            varIsScalar = varArg.isScalar();
        }
        FieldDef.Type varTypeCode = varType.getType();
        switch (varTypeCode) {
            case INTEGER: {
                return constTypeCode == FieldDef.Type.INTEGER || varIsScalar && constTypeCode == FieldDef.Type.LONG;
            }
            case LONG: {
                return constTypeCode == FieldDef.Type.LONG || constTypeCode == FieldDef.Type.INTEGER;
            }
            case FLOAT: {
                return constTypeCode == FieldDef.Type.FLOAT || varIsScalar && constTypeCode == FieldDef.Type.DOUBLE || constTypeCode == FieldDef.Type.INTEGER || constTypeCode == FieldDef.Type.LONG;
            }
            case DOUBLE: {
                return constTypeCode == FieldDef.Type.DOUBLE || constTypeCode == FieldDef.Type.FLOAT || constTypeCode == FieldDef.Type.INTEGER || constTypeCode == FieldDef.Type.LONG;
            }
            case NUMBER: {
                return constType.isNumeric();
            }
            case ENUM: {
                return constTypeCode == FieldDef.Type.STRING || constTypeCode == FieldDef.Type.ENUM;
            }
            case STRING: 
            case BOOLEAN: {
                return varTypeCode == constTypeCode;
            }
            case TIMESTAMP: {
                return varTypeCode == constTypeCode && ((TimestampDefImpl)varType).getPrecision() == ((TimestampDefImpl)constType).getPrecision();
            }
        }
        return false;
    }

    private void checkEqEq(PredInfo p1, PredInfo p2, boolean multikey) {
        if (p1.theConstVal != null && p1.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp == 0) {
                if (p1.theIsUnnested != p2.theIsUnnested) {
                    if (p1.theIsUnnested) {
                        p2.theStatus = PredicateStatus.ALWAYS_TRUE;
                    } else {
                        p1.theStatus = PredicateStatus.ALWAYS_TRUE;
                    }
                } else {
                    p1.theStatus = PredicateStatus.ALWAYS_TRUE;
                }
            } else if (!(!multikey || p1.theIsUnnested && p2.theIsUnnested)) {
                p1.theStatus = PredicateStatus.SKIP;
            } else {
                p1.theStatus = PredicateStatus.ALWAYS_FALSE;
                p2.theStatus = PredicateStatus.ALWAYS_FALSE;
            }
        } else if (p1.theIsUnnested != p2.theIsUnnested) {
            if (p1.theIsUnnested) {
                p2.theStatus = PredicateStatus.SKIP;
            } else {
                p1.theStatus = PredicateStatus.SKIP;
            }
        } else if (p1.theConstVal != null) {
            p2.theStatus = PredicateStatus.SKIP;
        } else {
            p1.theStatus = PredicateStatus.SKIP;
        }
    }

    private void checkEqMin(PredInfo p1, PredInfo p2, boolean multikey) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp < 0 || cmp == 0 && !p2.isInclusive()) {
                if (!(!multikey || p1.theIsUnnested && p2.theIsUnnested)) {
                    p2.theStatus = PredicateStatus.SKIP;
                } else {
                    p1.theStatus = PredicateStatus.ALWAYS_FALSE;
                    p2.theStatus = PredicateStatus.ALWAYS_FALSE;
                }
            } else {
                p2.theStatus = p2.theIsUnnested && !p1.theIsUnnested ? PredicateStatus.SKIP : PredicateStatus.ALWAYS_TRUE;
            }
        } else {
            p2.theStatus = PredicateStatus.SKIP;
        }
    }

    private void checkEqMax(PredInfo p1, PredInfo p2, boolean multikey) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp > 0 || cmp == 0 && !p2.isInclusive()) {
                if (!(!multikey || p1.theIsUnnested && p2.theIsUnnested)) {
                    p2.theStatus = PredicateStatus.SKIP;
                } else {
                    p1.theStatus = PredicateStatus.ALWAYS_FALSE;
                    p2.theStatus = PredicateStatus.ALWAYS_FALSE;
                }
            } else {
                p2.theStatus = p2.theIsUnnested && !p1.theIsUnnested ? PredicateStatus.SKIP : PredicateStatus.ALWAYS_TRUE;
            }
        } else {
            p2.theStatus = PredicateStatus.SKIP;
        }
    }

    private void checkMinMin(PredInfo p1, PredInfo p2, boolean multikey) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp < 0 || cmp == 0 && p1.isInclusive()) {
                p1.theStatus = p1.theIsUnnested == p2.theIsUnnested || p2.theIsUnnested ? PredicateStatus.ALWAYS_TRUE : PredicateStatus.SKIP;
            } else {
                p2.theStatus = p1.theIsUnnested == p2.theIsUnnested || p1.theIsUnnested ? PredicateStatus.ALWAYS_TRUE : PredicateStatus.SKIP;
            }
        } else if (multikey) {
            if (p1.theIsUnnested != p2.theIsUnnested) {
                if (p1.theIsUnnested) {
                    p2.theStatus = PredicateStatus.SKIP;
                } else {
                    p1.theStatus = PredicateStatus.SKIP;
                }
            } else if (p1.theDoesFiltering != p2.theDoesFiltering) {
                if (p1.theDoesFiltering) {
                    p1.theStatus = PredicateStatus.SKIP;
                } else {
                    p2.theStatus = PredicateStatus.SKIP;
                }
            } else if (p1.theConstVal != null) {
                p2.theStatus = PredicateStatus.SKIP;
            } else {
                p1.theStatus = PredicateStatus.SKIP;
            }
        } else if (p1.theConstVal != null) {
            p2.theStatus = PredicateStatus.SKIP;
        } else {
            p1.theStatus = PredicateStatus.SKIP;
        }
    }

    private void checkMaxMax(PredInfo p1, PredInfo p2, boolean multikey) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp < 0 || cmp == 0 && p2.isInclusive()) {
                p2.theStatus = p1.theIsUnnested == p2.theIsUnnested || p1.theIsUnnested ? PredicateStatus.ALWAYS_TRUE : PredicateStatus.SKIP;
            } else {
                p1.theStatus = p1.theIsUnnested == p2.theIsUnnested || p2.theIsUnnested ? PredicateStatus.ALWAYS_TRUE : PredicateStatus.SKIP;
            }
        } else if (multikey) {
            if (p1.theIsUnnested != p2.theIsUnnested) {
                if (p1.theIsUnnested) {
                    p2.theStatus = PredicateStatus.SKIP;
                } else {
                    p1.theStatus = PredicateStatus.SKIP;
                }
            } else if (p1.theDoesFiltering != p2.theDoesFiltering) {
                if (p1.theDoesFiltering) {
                    p1.theStatus = PredicateStatus.SKIP;
                } else {
                    p2.theStatus = PredicateStatus.SKIP;
                }
            } else if (p1.theConstVal != null) {
                p2.theStatus = PredicateStatus.SKIP;
            } else {
                p1.theStatus = PredicateStatus.SKIP;
            }
        } else if (p1.theConstVal != null) {
            p2.theStatus = PredicateStatus.SKIP;
        } else {
            p1.theStatus = PredicateStatus.SKIP;
        }
    }

    private void checkMinMax(PredInfo p1, PredInfo p2, PredInfo current, boolean multikey) {
        if (multikey) {
            if (!p1.theIsUnnested && !p2.theIsUnnested) {
                if (current == p1) {
                    p1.theStatus = PredicateStatus.SKIP;
                } else {
                    p2.theStatus = PredicateStatus.SKIP;
                }
                return;
            }
            if (!p1.theIsUnnested) {
                p1.theStatus = PredicateStatus.SKIP;
                return;
            }
            if (!p2.theIsUnnested) {
                p2.theStatus = PredicateStatus.SKIP;
                return;
            }
        }
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = p1.theConstVal.compareTo(p2.theConstVal);
            if (cmp > 0 || cmp == 0 && (!p2.isInclusive() || !p1.isInclusive())) {
                p1.theStatus = PredicateStatus.ALWAYS_FALSE;
                p2.theStatus = PredicateStatus.ALWAYS_FALSE;
            } else if (cmp == 0) {
                p1.theCompOp = FunctionLib.FuncCode.OP_EQ;
                p2.theStatus = PredicateStatus.ALWAYS_TRUE;
            }
        }
    }

    private void chooseMapBothKey() {
        if (!this.theHaveMapBothPreds) {
            return;
        }
        for (MapBothKeyInfo mki : this.theMapBothKeys.values()) {
            String mapKey = mki.theKey;
            boolean filteringOnly = false;
            boolean eqPredPushed = false;
            for (int i = 0; i < this.theNumFields; ++i) {
                ArrayList<PredInfo> preds = this.theStartStopPreds.get(i);
                if (preds == null || !this.theIndex.getIndexPath(i).isMapValues()) continue;
                for (PredInfo pi : preds) {
                    if (!mapKey.equals(pi.theMapKey)) continue;
                    if (filteringOnly) {
                        if (pi.isEq()) {
                            mki.theScore += 16;
                            continue;
                        }
                        mki.theScore += 8;
                        continue;
                    }
                    if (pi.isEq()) {
                        mki.theScore += 32;
                        eqPredPushed = true;
                        continue;
                    }
                    mki.theScore += 16;
                }
                if (eqPredPushed) continue;
                filteringOnly = true;
            }
        }
        for (MapBothKeyInfo mki : this.theMapBothKeys.values()) {
            if (this.theMapBothKey == null) {
                this.theMapBothKey = mki;
                continue;
            }
            if (mki.theScore <= this.theMapBothKey.theScore) continue;
            this.theMapBothKey = mki;
        }
        for (int i = 0; i < this.theNumFields; ++i) {
            ArrayList<PredInfo> preds = this.theStartStopPreds.get(i);
            if (preds == null) continue;
            for (int j = 0; j < preds.size(); ++j) {
                PredInfo pi = preds.get(j);
                if (!pi.isMapBoth() || pi.theMapKey.equals(this.theMapBothKey.theKey)) continue;
                preds.remove(j);
                this.theFilteringPreds.remove(pi.thePred);
                --j;
            }
        }
    }

    private IndexExpr matchExprToIndexPath(Expr expr) {
        IndexExpr epath = expr.getIndexExpr();
        if (epath == null || epath.theTable != this.theTable) {
            return null;
        }
        epath.reset();
        IndexAnalyzer.matchPathExprToIndexPath(this.theTable, this.theIndex, epath);
        if (!epath.matched()) {
            return null;
        }
        return epath;
    }

    private static boolean matchPathExprToIndexPath(TableImpl table, IndexImpl index, IndexExpr epath) {
        if (index == null) {
            if (epath.numSteps() > 1) {
                return false;
            }
            int ipathPos = table.findKeyComponent(epath.getLastStep());
            if (ipathPos >= 0) {
                epath.thePosition = ipathPos;
                return true;
            }
            return false;
        }
        int numFields = index.numFields();
        for (int ipathPos = 0; ipathPos < numFields; ++ipathPos) {
            IndexImpl.IndexField ipath = index.getIndexPath(ipathPos);
            if (!epath.matchToIndexPath(index, ipath)) continue;
            return true;
        }
        return false;
    }

    private boolean isIndexOnlyExpr(Expr expr) {
        if (expr.isStepExpr()) {
            this.thePath.clear();
            do {
                if (expr.getKind() == Expr.ExprKind.FIELD_STEP) {
                    ExprFieldStep stepExpr = (ExprFieldStep)expr;
                    String fieldName = stepExpr.getFieldName();
                    Expr fieldNameExpr = stepExpr.getFieldNameExpr();
                    Expr inputExpr = stepExpr.getInput();
                    if (fieldName == null) {
                        if (!this.isIndexOnlyExpr(fieldNameExpr)) {
                            return false;
                        }
                        return this.isIndexOnlyExpr(inputExpr);
                    }
                    if (expr.getType().isAnyJson() || expr.getType().isAnyJsonAtomic()) {
                        this.thePath.theIsJson = true;
                    }
                    if (inputExpr.getType().isArray()) {
                        return false;
                    }
                    if (inputExpr.getType().isRecord()) {
                        this.thePath.add(fieldName, TablePath.StepKind.REC_FIELD);
                    } else {
                        this.thePath.add(fieldName, TablePath.StepKind.MAP_FIELD);
                    }
                } else {
                    return false;
                }
                expr = expr.getInput();
                if (expr.getKind() != Expr.ExprKind.VAR) continue;
                ExprVar varExpr = (ExprVar)expr;
                if (varExpr.isExternal() || varExpr.isContext()) {
                    return true;
                }
                expr = varExpr.getDomainExpr();
                if (expr.getKind() == Expr.ExprKind.BASE_TABLE) continue;
                return false;
            } while (expr.isStepExpr());
            if (expr.getKind() == Expr.ExprKind.BASE_TABLE) {
                ExprBaseTable tableExpr = (ExprBaseTable)expr;
                TableImpl table = tableExpr.getTable();
                if (table != this.theTable) {
                    return false;
                }
                if (this.thePath.numSteps() == 1 && this.theTable.isKeyComponent(this.thePath.getLastStep())) {
                    return true;
                }
                if (!this.theIsPrimary) {
                    this.thePath.reverseSteps();
                    if (!IndexAnalyzer.matchPathExprToIndexPath(this.theTable, this.theIndex, this.thePath)) {
                        return false;
                    }
                    if (this.thePath.theIsMultiKey && this.thePath.theMapBothKey == null) {
                        return false;
                    }
                    return !this.theHaveMapBothPreds || this.theMapBothKey != null && this.theMapBothKey.theKey.equals(this.thePath.theMapBothKey);
                }
                return false;
            }
            return this.isIndexOnlyExpr(expr);
        }
        if (expr.getKind() == Expr.ExprKind.VAR) {
            ExprVar var = (ExprVar)expr;
            return var.isExternal() || var.isContext();
        }
        Expr.ExprIter children = expr.getChildren();
        while (children.hasNext()) {
            Expr child = children.next();
            if (this.isIndexOnlyExpr(child)) continue;
            children.reset();
            return false;
        }
        return true;
    }

    private static FieldValueImpl createPlaceHolderValue(FieldDefImpl type) {
        switch (type.getType()) {
            case INTEGER: {
                return FieldDefImpl.integerDef.createInteger(0);
            }
            case LONG: {
                return FieldDefImpl.longDef.createLong(0L);
            }
            case FLOAT: {
                return FieldDefImpl.floatDef.createFloat(0.0f);
            }
            case DOUBLE: {
                return FieldDefImpl.doubleDef.createDouble(0.0);
            }
            case NUMBER: {
                return FieldDefImpl.numberDef.createNumber(0);
            }
            case STRING: {
                return FieldDefImpl.stringDef.createString("");
            }
            case ENUM: {
                return ((EnumDefImpl)type).createEnum(1);
            }
        }
        throw new QueryStateException("Unexpected type for index key: " + type);
    }

    private int getNumPreds() {
        if (this.theSFW == null) {
            return 0;
        }
        Expr whereExpr = this.theSFW.getWhereExpr();
        if (whereExpr == null) {
            return 0;
        }
        Function andOp = whereExpr.getFunction(FunctionLib.FuncCode.OP_AND);
        if (andOp != null) {
            return whereExpr.getNumChildren();
        }
        return 1;
    }

    private static class MapBothKeyInfo {
        String theKey;
        int theScore;

        MapBothKeyInfo(String key) {
            this.theKey = key;
        }
    }

    static enum PredicateStatus {
        KEEP,
        SKIP,
        ALWAYS_FALSE,
        ALWAYS_TRUE;

    }

    private class PredInfo {
        Expr thePred;
        FunctionLib.FuncCode theCompOp;
        boolean theIsAnyOp;
        Expr theConstExpr;
        FieldValueImpl theConstVal;
        boolean theDoesFiltering;
        boolean theIsDirect;
        boolean theIsUnnested;
        int theIPathPos = -1;
        String theMapKey;
        PredicateStatus theStatus;

        PredInfo(Expr pred) {
            this.thePred = pred;
        }

        boolean isEq() {
            return this.theCompOp == FunctionLib.FuncCode.OP_EQ;
        }

        boolean isMin() {
            return this.theCompOp == FunctionLib.FuncCode.OP_GT || this.theCompOp == FunctionLib.FuncCode.OP_GE;
        }

        boolean isMax() {
            return this.theCompOp == FunctionLib.FuncCode.OP_LT || this.theCompOp == FunctionLib.FuncCode.OP_LE;
        }

        boolean isMapBoth() {
            return this.theMapKey != null;
        }

        boolean isMultiKey() {
            return IndexAnalyzer.this.theIndex != null && this.theMapKey == null && IndexAnalyzer.this.theIndex.getIndexPath(this.theIPathPos).isMultiKey();
        }

        boolean isInclusive() {
            return this.theCompOp == FunctionLib.FuncCode.OP_GE || this.theCompOp == FunctionLib.FuncCode.OP_LE;
        }

        boolean isPartial() {
            return this.theDoesFiltering || this.theIsUnnested;
        }
    }
}

