/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.IndexAnalyzer;
import oracle.kv.table.Index;

class OptRulePushIndexPreds {
    private RuntimeException theException = null;
    private ArrayList<IndexAnalyzer> theAnalyzers;

    OptRulePushIndexPreds() {
    }

    RuntimeException getException() {
        return this.theException;
    }

    void apply(ExprSFW sfw) {
        try {
            Expr whereExpr = sfw.getWhereExpr();
            if (whereExpr == null && !sfw.hasSort()) {
                return;
            }
            TableImpl table = sfw.getTable();
            if (table == null) {
                return;
            }
            ExprBaseTable tableExpr = sfw.getTableExpr();
            ExprBaseTable.IndexHint forceIndexHint = tableExpr.getForceIndexHint();
            Map<String, Index> indexes = table.getIndexes();
            this.theAnalyzers = new ArrayList(1 + indexes.size());
            IndexAnalyzer primaryAnalyzer = null;
            boolean completePrimaryKey = false;
            primaryAnalyzer = new IndexAnalyzer(sfw, table, null);
            primaryAnalyzer.analyze();
            boolean bl = completePrimaryKey = primaryAnalyzer.thePrimaryKey != null && primaryAnalyzer.thePrimaryKey.isComplete();
            if (primaryAnalyzer.theSFW == null) {
                return;
            }
            if (completePrimaryKey) {
                sfw.removeSort();
            }
            if (!sfw.hasSort() || sfw.hasPrimaryIndexBasedSort()) {
                this.theAnalyzers.add(primaryAnalyzer);
            }
            if (forceIndexHint != null) {
                IndexAnalyzer analyzer;
                IndexImpl forcedIndex = forceIndexHint.theIndex;
                if (sfw.hasSort() && (sfw.hasPrimaryIndexBasedSort() && forcedIndex != null || !sfw.getSortingIndexes().contains(forcedIndex))) {
                    String hintIndex = forcedIndex == null ? "primary" : forcedIndex.getName();
                    throw new QueryException("Cannot perform order-by because the index forced via a hint is not one of the sorting indexes.\nHint index    : " + hintIndex + "\n", sfw.getLocation());
                }
                IndexAnalyzer indexAnalyzer = analyzer = forcedIndex == null ? primaryAnalyzer : new IndexAnalyzer(sfw, table, forcedIndex);
                if (analyzer != primaryAnalyzer) {
                    analyzer.analyze();
                }
                if (analyzer.theSFW == null) {
                    return;
                }
                analyzer.apply();
                return;
            }
            if (completePrimaryKey) {
                primaryAnalyzer.apply();
                return;
            }
            if (primaryAnalyzer.hasShardKey()) {
                if (sfw.hasSort() && !sfw.hasPrimaryIndexBasedSort()) {
                    throw new QueryException("Cannot perform order-by because the query specifies a complete shard key, but the sort cannot be done via the primary index", sfw.getLocation());
                }
                primaryAnalyzer.apply();
                return;
            }
            if (sfw.hasPrimaryIndexBasedSort()) {
                primaryAnalyzer.apply();
                return;
            }
            boolean alwaysFalse = false;
            if (sfw.hasSecondaryIndexBasedSort()) {
                for (IndexImpl index : sfw.getSortingIndexes()) {
                    IndexAnalyzer analyzer = new IndexAnalyzer(sfw, table, index);
                    this.theAnalyzers.add(analyzer);
                    analyzer.analyze();
                    if (analyzer.theSFW != null) continue;
                    alwaysFalse = true;
                    break;
                }
            } else {
                for (Map.Entry<String, Index> entry : indexes.entrySet()) {
                    IndexImpl index = (IndexImpl)entry.getValue();
                    IndexAnalyzer analyzer = new IndexAnalyzer(sfw, table, index);
                    this.theAnalyzers.add(analyzer);
                    analyzer.analyze();
                    if (analyzer.theSFW != null) continue;
                    alwaysFalse = true;
                    break;
                }
            }
            if (!alwaysFalse) {
                this.chooseIndex();
            }
        }
        catch (RuntimeException e) {
            this.theException = e;
        }
    }

    void chooseIndex() {
        IndexAnalyzer bestIndex = Collections.min(this.theAnalyzers);
        bestIndex.apply();
    }
}

