/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.HashSet;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Distributer;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprReceive;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.OptRulePushIndexPreds;
import oracle.kv.impl.query.compiler.StatementFactory;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.compiler.Translator;
import oracle.kv.impl.query.compiler.parser.KVParser;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.util.CommonLoggerUtils;
import oracle.kv.table.FieldRange;

public class QueryControlBlock {
    private final TableAPIImpl theTableAPI;
    private final String theQueryString;
    private final TableMetadataHelper theTableMetaHelper;
    private final StatementFactory theStatementFactory;
    private final StaticContext theInitSctx;
    private final String theNamespace;
    private boolean theStrictMode;
    private int theInternalVarCounter = 0;
    private int theNumRegs = 0;
    private int theNumPlanIters = 0;
    private FieldDefImpl theResultDef;
    private Expr theRootExpr;
    private PlanIter theRootPlanIter;
    private RuntimeException theException = null;
    private final HashSet<String> generatedNames = new HashSet();
    PrimaryKeyImpl thePushedPrimaryKey;
    IndexKeyImpl thePushedSecondaryKey;
    PreparedStatementImpl.DistributionKind thePushedDistributionKind;
    FieldRange thePushedRange;
    boolean theHaveJsonConstructors;

    QueryControlBlock(TableAPIImpl tableAPI, String queryString, StaticContext sctx, String namespace) {
        this.theTableAPI = tableAPI;
        this.theQueryString = queryString;
        this.theTableMetaHelper = tableAPI.getTableMetadataHelper();
        this.theInitSctx = sctx;
        this.theStatementFactory = null;
        this.theNamespace = namespace;
    }

    QueryControlBlock(TableMetadataHelper metadataHelper, StatementFactory statementFactory, String queryString, StaticContext sctx, String namespace) {
        this.theTableAPI = null;
        this.theQueryString = queryString;
        this.theTableMetaHelper = metadataHelper;
        this.theInitSctx = sctx;
        this.theStatementFactory = statementFactory;
        this.theNamespace = namespace;
    }

    public KVStoreImpl getStore() {
        return this.theTableAPI.getStore();
    }

    TableMetadataHelper getTableMetaHelper() {
        return this.theTableMetaHelper;
    }

    public StaticContext getInitSctx() {
        return this.theInitSctx;
    }

    public String getNamespace() {
        return this.theNamespace;
    }

    boolean strictMode() {
        return this.theStrictMode;
    }

    StatementFactory getStatementFactory() {
        return this.theStatementFactory;
    }

    public RuntimeException getException() {
        return this.theException;
    }

    public boolean succeeded() {
        return this.theException == null;
    }

    public String getErrorMessage() {
        return CommonLoggerUtils.getStackTrace(this.theException);
    }

    Expr getRootExpr() {
        return this.theRootExpr;
    }

    void setRootExpr(Expr e) {
        this.theRootExpr = e;
    }

    public PrimaryKeyImpl getPushedPrimaryKey() {
        return this.thePushedPrimaryKey;
    }

    public IndexKeyImpl getPushedSecondaryKey() {
        return this.thePushedSecondaryKey;
    }

    public FieldRange getPushedRange() {
        return this.thePushedRange;
    }

    public PreparedStatementImpl.DistributionKind getPushedDistributionKind() {
        return this.thePushedDistributionKind;
    }

    public void setPushedPrimaryKey(PrimaryKeyImpl key) {
        this.thePushedPrimaryKey = key;
    }

    public void setPushedSecondaryKey(IndexKeyImpl key) {
        this.thePushedSecondaryKey = key;
    }

    public void setPushedRange(FieldRange range) {
        this.thePushedRange = range;
    }

    public void setPushedDistributionKind(PreparedStatementImpl.DistributionKind kind) {
        this.thePushedDistributionKind = kind;
    }

    public FieldDefImpl getResultDef() {
        return this.theResultDef;
    }

    public String getResultColumnName() {
        ExprReceive rcv;
        assert (!this.theResultDef.isRecord());
        if (this.theRootExpr.getKind() == Expr.ExprKind.SFW) {
            ExprSFW sfw = (ExprSFW)this.theRootExpr;
            return sfw.getFieldName(0);
        }
        if (this.theRootExpr.getKind() == Expr.ExprKind.RECEIVE && (rcv = (ExprReceive)this.theRootExpr).getInput().getKind() == Expr.ExprKind.SFW) {
            ExprSFW sfw = (ExprSFW)rcv.getInput();
            return sfw.getFieldName(0);
        }
        return null;
    }

    void compile() {
        KVParser parser = new KVParser();
        parser.parse(this.theQueryString);
        if (!parser.succeeded()) {
            this.theException = parser.getParseException();
            return;
        }
        Translator translator = new Translator(this);
        translator.translate(parser.getParseTree());
        this.theException = translator.getException();
        if (this.theException != null) {
            return;
        }
        if (translator.isQuery()) {
            this.theRootExpr = translator.getRootExpr();
            OptRulePushIndexPreds rule = new OptRulePushIndexPreds();
            rule.apply((ExprSFW)this.theRootExpr);
            this.theException = rule.getException();
            if (this.theException != null) {
                return;
            }
            Distributer distributer = new Distributer(this);
            distributer.distributeQuery();
            CodeGenerator codegen = new CodeGenerator(this);
            codegen.generatePlan(this.theRootExpr);
            this.theException = codegen.getException();
            if (this.theException == null) {
                this.theRootPlanIter = codegen.getRootIter();
                this.theResultDef = this.theRootExpr.getType().getDef();
            }
        }
    }

    void parse() {
        KVParser parser = new KVParser();
        parser.parse(this.theQueryString);
        if (!parser.succeeded()) {
            this.theException = parser.getParseException();
            return;
        }
        Translator translator = new Translator(this);
        translator.translate(parser.getParseTree());
        this.theException = translator.getException();
        if (this.theException != null) {
            return;
        }
        if (translator.isQuery()) {
            this.theRootExpr = translator.getRootExpr();
            OptRulePushIndexPreds rule = new OptRulePushIndexPreds();
            rule.apply((ExprSFW)this.theRootExpr);
            this.theException = rule.getException();
        }
    }

    String createInternalVarName(String prefix) {
        if (prefix == null) {
            return "$internVar-" + this.theInternalVarCounter++;
        }
        return "$" + prefix + "-" + this.theInternalVarCounter++;
    }

    void incNumRegs(int num) {
        this.theNumRegs += num;
    }

    public int getNumRegs() {
        return this.theNumRegs;
    }

    public int incNumPlanIters() {
        return this.theNumPlanIters++;
    }

    public int getNumIterators() {
        return this.theNumPlanIters;
    }

    public PlanIter getQueryPlan() {
        return this.theRootPlanIter;
    }

    public String displayExprTree() {
        return this.theRootExpr.display();
    }

    public String displayQueryPlan() {
        return this.theRootPlanIter.display();
    }

    String generateFieldName(String prefix) {
        String gen = "_gen";
        int num = 0;
        StringBuilder sb = new StringBuilder(prefix);
        sb.append("_gen");
        String name = sb.toString();
        while (this.generatedNames.contains(name)) {
            sb.append(num++);
            name = sb.toString();
        }
        this.generatedNames.add(name);
        return name;
    }
}

